function R=rot_mat(theta,phi)
%creates rotation matrix from lab frame to principal frame of crystal -
%rotates a vector along the crystal axis to be parallel to z axis.

% phi - azimuthal angle of optical axis, measured from the y axis
% theta - polar angle of optical axis, measured from x axis (in xz plane)
%
% Original code: Jordan Gill
% 06/11/20
%
% If you use this code you are requested to reference this paper:
%
% J.R. Gill, E. Perivolari, M. Kaczmarek and G. D'Alessandro
% Efficient scattering model of multi-layer systems with anisotropic films
% J. Opt. Soc. Am. A (2021)
% DOI: https://doi.org/10.1364/JOSAA.416265
%
% Licensing
% =========
%
% **License**: CC BY-NC-SA
%
% This program is free software: you can redistribute it and/or modify it
% under the terms of the CC BY-NC-SA license.  This license lets you remix,
% tweak, and build upon this work non-commercially, as long as you credit
% us  and license your new creations under the identical terms.
%
% More info on the license type is available at:
%
% https://creativecommons.org/licenses/by-nc-sa/4.0/
%
% Please contact dales@soton.ac.uk if you want to use this code commercially.
%
% This program is distributed in the hope that it will be useful, but
% WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

%First rotate around y to align projection of c with the z axis (yaw rotation)
r1=[cos(pi/2-theta) ,0,-sin(pi/2-theta) ;    
          0         ,1,      0         ;    
     sin(pi/2-theta),0,cos(pi/2-theta)];

%rotate new vector around x axis to align with z axis (pitch rotation)
r2=[1,      0       ,      0       ;        
    0, cos(pi/2-phi),-sin(pi/2-phi);
    0, sin(pi/2-phi),cos(pi/2-phi)];

%make composite rotation from xyz to x'y'z' 
R=r2*r1;

