# -*- coding: utf-8 -*-
"""
Created on Thu Apr 12 11:48:09 2018

Joshua Steer
Joshua.Steer@soton.ac.uk

To run this script, open ScanIP, click the small scripting tab, open the .py file 
and press play 
Remember to set the path correctly 
"""
from scanip_api import *
import random
#Number of samples
N = 3
#Array of sample data
samples = []
for i in range(N):
    # Choose value of skew for cross section of cylinder
    skew = 1
    # Generate random values for rotations frin -90 deg -> 90 deg
    yRot = random.randrange(-9000, 9001) / 100.0
    xRot = random.randrange(-9000, 9001) / 100.0
    zRot = random.randrange(-9000, 9001) / 100.0
    samples.append([skew, yRot, xRot, zRot])
# Define path for saving .raw files 
path = 'Z:\\cylinders\\RandomCylinder\\'
# Generate 500x500x500 blank space
App.GetInstance().ImportBlankImage(500, 500, 500, 1.0, 1.0, 1.0)
# Iterate through each row of samples
for s in samples:
    #Create cylinder of diameter 10 and length 400
    App.GetDocument().CreateCylinder(10.0, 400.0)
    #Create skew matrix
    MS = Matrix.FromScale(1, 1, 1/s[0])
    #Create Rotation matrix, y in long axis of cylinder
    MR = Matrix.FromEulerAngles(s[2], s[1], s[3])
    # Translate into centre of space
    MT = Matrix.FromTranslation(250, 250, 250)
    # Construct full transformation matrix from M = MT*MR*MS
    M = Matrix.Multiply(MT, Matrix.Multiply(MR, MS))
    # Apply transformation
    App.GetDocument().GetSurfaceByName("Cylinder").SetMatrix(M)
    # Convert from surface to mask
    App.GetDocument().GetActiveSurface().CopyToMask(Doc.AccurateManifold, False)
    # Create file name from 4 variables
    fh = '%.2f_%.2f_%.2f_%.2f.raw' % tuple(s)
    # Export as a 8-bit raw file
    App.GetDocument().GetMaskByName("Cylinder (from surface)").RawExport('%s%s' % (path, fh))
    # Delete mask and surface
    App.GetDocument().RemoveMask(App.GetDocument().GetActiveGenericMask())
    App.GetDocument().RemoveSurface(App.GetDocument().GetSurfaceByName("Cylinder"))