while (fitCircles()==1){
	fitCircles();
}

function fitCircles(){
// run("Clear Results"); 
roiManager("reset"); 

//Open stack
dir=getDirectory("Choose a folder containing your segmented images");
list = getFileList(dir);
splitDir1= dir + "Results";
File.makeDirectory(splitDir1);

x=list.length-4;
print(x);

path=dir + list[0];
run("Image Sequence...", "open=["+path+"] number=2 increment=x sort");

image=getTitle();
run("Set Scale...", "distance=0");

//Set correct measurements in SET MEASUREMENTS
run("Set Measurements...", "area centroid bounding fit shape nan redirect=None decimal=3");

//Go to top slice
setSlice(1);

//Ask user to choose 5 points
setTool("multipoint");
waitForUser("Choose points along the outside edge of the bone");
if (getBoolean("Are you happy with the selection?")==0){
	run("Select None");
	waitForUser("Choose points along the outside edge of the bone");
}

//Fit circle
run("Fit Circle");

//Save circle to ROI - need x, y, diameter
roiManager("Add");

//Go to last slice
setSlice(2);

waitForUser("Move the circle so that it best fits the new edge then click ok");

//Add to  ROI
roiManager("Add");


//List and save circle and line ROIs
roiManager("List");

waitForUser("Don't forget to save the 'overlay elements' file! Click ok when you have saved it.");

if (getBoolean("Are you sure you saved it?")==0){
	waitForUser("Don't forget to save the 'overlay elements' file! Click ok when you have saved it.");
}

while (nImages>0) { 
     selectImage(nImages); 
       close(); 
      } 



return getBoolean("Do you want to process any more files?")

}