start = getTime();

dir=getDirectory("Choose a folder containing your images");
//outdir=getDirectory("Choose a folder to save your segmented images to");
//exceldir=getDirectory("Choose a folder to save your particle analysis to"); 
//list = getFileList(dir);

setBatchMode(true);


find(dir); 


 
function find(dir) { 
      list = getFileList(dir); 
      //for (i=0; i<2; i++) { 
		for (i=0; i<list.length; i++) { 
          showProgress(i, list.length); 
          canals(dir, list[i]); 
          
      } 
  } 

function canals(dir,list){

//Open stack
//dir=getDirectory("Choose a folder containing your segmented images");
list1 = getFileList(dir+list); 
splitDir1= dir + list + "Results";
File.makeDirectory(splitDir1);

splitDir2= dir + list + "Skeleton";
File.makeDirectory(splitDir2);

path=dir + list+list1[0];
run("Image Sequence...", "open=["+path+"] sort");

image=getTitle();
run("Set Scale...", "distance=0");

//Set correct measurements in SET MEASUREMENTS
run("Set Measurements...", "area centroid bounding fit shape nan redirect=None decimal=3");

/*
//Go to midslice
slices=nSlices;
midslice=round(nSlices/2);
setSlice(midslice);

//Ask user to choose 5 points
setTool("multipoint");
waitForUser("Choose points along the outside edge of the bone then click ok");

//Fit circle
run("Fit Circle");

//Save circle to ROI - need x, y, diameter
roiManager("Add");

//Go to top slice
setSlice(1);

//Reslice in z
run("Select None");
run("Reslice [/]...", "output=1.000 start=Top avoid");

//Ask user to choose a line
setTool("line");
waitForUser("Draw a line parallel with the interior bone surface then click ok");

//Add to  ROI
roiManager("Add");

//Close reslice window
selectWindow("Reslice of "+image);
close();

//List and save circle and line ROIs
roiManager("List");
saveAs("Results", splitDir1+"/Overlay Elements.csv");
*/

//Go to original stack
selectWindow(image);

run("Z Project...", "projection=[Max Intensity]");
	run("Select Bounding Box");
	run("Enlarge...", "enlarge=50");
	getSelectionBounds(x,y,width,height);
	
selectWindow(image);
makeRectangle(x,y,width,height);
run("Crop");

//Particle analysis 3D to remove cells
run("Particle Analyser", "  min=1000 max=Infinity surface_resampling=2 show_particle surface=Gradient split=0.000 volume_resampling=2 labelling=Mapped slices=2");
setThreshold(1, 255);
setOption("BlackBackground", false);
run("Convert to Mask", "method=Default background=Dark");
run("Invert LUT");

//Apply Gaussian blur 3D 2 voxels
run("Gaussian Blur 3D...", "x=1 y=1 z=1");

//Threshold
run("Convert to Mask", "method=Default background=Dark");
run("Invert LUT");


//Create virtual section near midslice
//run("Duplicate...", "duplicate range=midslice-(midslice+13)");

stack=getTitle();

//run("Duplicate...", "duplicate range=75-75");
//run("Z Project...", "projection=[Max Intensity]");
//run("Invert");

//Particle analysis 2D, fit ellipses, need maj and min axes, centroids, length, width, maj axis angle
//run("Analyze Particles...", "size=0-Infinity display");

//close();

//selectWindow(stack);
//run("Duplicate...", "duplicate range=1-1");
//run("Z Project...", "projection=[Max Intensity]");
//run("Invert");

//Particle analysis 2D, fit ellipses, need maj and min axes, centroids, length, width, maj axis angle
//run("Analyze Particles...", "size=0-Infinity display");

//close();

selectWindow(stack);
run("Duplicate...", "duplicate range=500-500");
//run("Z Project...", "projection=[Max Intensity]");
run("Invert");

//Particle analysis 2D, fit ellipses, need maj and min axes, centroids, length, width, maj axis angle
run("Analyze Particles...", "size=0-Infinity display");

close();


//Save particle analysis
saveAs("Results", splitDir1+"/2Dellipses.csv");

//Go back to stack
selectWindow(stack);

//Skeleton 3D
run("Skeletonize (2D/3D)");
run("Image Sequence... ", "format=TIFF use save=splitDir2"); 

//Analyse skeleton (show detailed information)
run("Analyse Skeleton", "prune=none show");

//Save output
saveAs("Results", splitDir1+"/Branch information.csv");

windows = getList("window.titles"); 
     for (i=0; i<windows.length; i++){ 
     winame = windows[i]; 
      selectWindow(winame); 
     run("Close"); 
     } 

	//close windows
	while (nImages>0) { 
	    selectImage(nImages); 
	    close(); 
	      } 
	


}
