// Performs segmentation and analysis of particles
// Open a file on the list by double clicking on it.

//time macro execution time
start = getTime();

dir=getDirectory("Choose a folder containing your images");

splitDir1= dir + "Results";
File.makeDirectory(splitDir1);

splitDir2=dir + "SegmentedImages";
File.makeDirectory(splitDir2);

splitDir3=dir + "Mask";
File.makeDirectory(splitDir3);

find(dir); 

 function find(dir) { 
      list = getFileList(dir); 
      //for (i=0; i<2; i++) { 
		for (i=0; i<list.length; i++) { 
          showProgress(i, list.length); 
          if (startsWith(list[i], "9")) { 
              segmentPores(dir, list[i]); 
          } 
      } 
  } 



  function segmentPores(input,filename) {
  	list1 = getFileList(input+filename); 
	file0=list1[0];
	path=input + filename + file0;
	
	//create new folders for segmented images and mask
	splitDir= splitDir2 + "\\" + file0 + "_Segmented"; 
	File.makeDirectory(splitDir); 

	splitDir4= splitDir3 + "\\" + file0 + "_Mask"; 
	File.makeDirectory(splitDir4); 

	//suppress output to increase speed
	setBatchMode(true);

	//open image sequence
	run("Image Sequence...", "open=["+path+"] sort");
	run("Set Scale...", "distance=0 known=0 pixel=1 unit=pixel");

	run("Enhance Contrast...", "saturated=2 normalize process_all");

	makeOval(0, 0, 1284, 1280);
	setBackgroundColor(0, 0, 0);
	run("Clear Outside", "stack");
	run("Canvas Size...", "width=1500 height=1500 position=Center zero");

	image=getTitle();
	run("Gaussian Blur 3D...", "x=1 y=1 z=1");
	//setThreshold(37570,65535);
  	run("Convert to Mask", "method=Li background=Dark");
	run("Invert LUT");
	
	run("Duplicate...", "title=NewStack duplicate");

	//remove small particles
	for (i = 0; i < 2; i++) {
	        run("Dilate", "stack");
	}
	run("Set Scale...", "distance=0 known=0 pixel=1 unit=pixel");
	for (i = 0; i < 2; i++) {
	        run("Erode", "stack");
	}
	
	//remove all particles except bone volume (largest)
	run("Keep Largest Region");
	//run("Image Sequence... ", "format=TIFF use save=splitDir2"); 
	
	//fill holes to create mask
	for (i = 0; i < 50; i++) {
	        run("Erode", "stack");
	}
	
	for (i = 0; i < 51; i++) {
	        run("Dilate", "stack");
	}

	
	//segment pores using mask
	selectWindow(image);
	run("Invert", "stack");
	imageCalculator("AND create stack", image,"NewStack-largest");

	selectWindow("Result of " + image);
	
	run("Invert", "stack");
	run("Fill Holes", "stack");
	run("Invert", "stack");

	//save outputs to directories created earlier
	selectWindow("Result of " + image);
	run("Image Sequence... ", "format=TIFF use save=splitDir"); 
	
	selectWindow("NewStack-largest");
	run("Set Scale...", "distance=0 known=0 pixel=1 unit=pixel");
	run("Image Sequence... ", "format=TIFF use save=splitDir4"); 
	
	selectWindow("Result of " + image);
	run("Particle Analyser", "min=0.000 max=Infinity surface_resampling=2 surface=Gradient split=0.000 volume_resampling=2 labelling=Mapped slices=2");
	saveAs("Results", splitDir1 + "\\" + file0 + "PoreAnalysis.csv");
	
	selectWindow("NewStack-largest");
	run("Particle Analyser", "min=0.000 max=Infinity surface_resampling=2 surface=Gradient split=0.000 volume_resampling=2 labelling=Mapped slices=2");
	saveAs("Results", splitDir1 + "\\" + file0 + "BoneVolume.csv");
	
	//close windows
	while (nImages>0) { 
	    selectImage(nImages); 
	    close(); 
	      } 
	
	setBatchMode(false);

  }

write("Completed in");
print((getTime()-start)/60000);
write("minutes");