# -*- coding: utf-8 -*-
"""
Created on Mon Feb 26 11:48:51 2018

@author: kaw1g15
"""


import pandas as pd
import numpy as np
import matplotlib.pyplot as plt
from matplotlib import cm
from mpl_toolkits.mplot3d import Axes3D

import os

def findangles(cX,cY,R):
        
        #Read X and Y coordinates for the centroid of each fitted ellipse
        pX=(ellipses["X"])
        pY=ellipses["Y"]
    
        #Read the angle of the major axis relative to the X axis
        angleellipse=ellipses["Angle"]
    
        #Calculate the gradient and angle of a line running through the centre of the circle and the centroid of the ellipse
        m=(cY-pY)/(cX-pX)
        anglerad=-(np.arctan(m))
    
        #Calculate the coordinates of the nearest point on the outer circle to the centroid of the ellipse
        aX=cX+R*(np.cos(anglerad))
        aY=cY-R*(np.sin(anglerad))
        
        #Calculate the distance between  the centroid of the ellipse and the outer surface of the bone
        Xdistance=(aX-pX)
        Ydistance=(aY-pY)
        distance=((Xdistance**2+Ydistance**2)**0.5)/1.6
    
        
        #Calculate the angle of a tangent to the circle         
        mt=1/m
    
        angletangent=(np.degrees(np.arctan(mt)))
        angletangent[angletangent>0]=180-angletangent
        angletangent[angletangent<0]=(angletangent**2)**0.5
        
        #Normalise the angle of the major axis of the ellipse to the angle of the tangent
        
        radindex=((angleellipse-angletangent)**2)**0.5
        radindex[radindex>90] = 180-radindex
        radindex=90-radindex
        
        #Calculate the shape of the ellipse (b/a)
        shape=ellipses["Minor"]/ellipses["Major"]
        
        
        #Calculate the longitudinal index (a measure of the angle relative to the long axis of the bone)
        longindex=np.degrees(np.arcsin(shape))
        
        canals=pd.concat([radindex,longindex,shape,distance], axis=1)
        
        return canals
    
def findangles3D(magC,R,cX,cY):
        
    #read Vertices of each branch
        
        vX1=ellipses3D["V1 x"]
        vY1=ellipses3D["V1 y"]
        vZ1=ellipses3D["V1 z"]
        vX2=ellipses3D["V2 x"]
        vY2=ellipses3D["V2 y"]
        vZ2=ellipses3D["V2 z"]
        
    #    euc=
        
    #    length=
        
    #    ID=
    
        magCan=((vX2-vX1)**2+(vY2-vY1)**2+(vZ1-vZ2)**2)**0.5
        dotprod=(X1-X2)*(vX1-vX2)+(Y1-Y2)*(vY1-vY2)+(Z1-Z2)*(vZ1-vZ2)
        phi=abs(90-(np.degrees(np.arccos(dotprod/(magC*magCan)))))
    
    #    
        phitan=90-(np.degrees(np.arctan((((vX2-vX1)**2+(vY2-vY1)**2)**0.5)/abs(vZ2-vZ1))))
    #    phi.replace(["inf", "-inf"], 0)    
    #    phitan.loc[(~np.isfinite(phitan)) & phitan.notnull()] = 0
        dfphitan=pd.DataFrame(phitan)
        #pd.DataFrame.hist(dfphitan)
               
                     
        dfphi=pd.DataFrame(phi)      
        #pd.DataFrame.hist(dfphi)
        
        
        mX=(vX1+vX2)/2
        mY=(vY1+vY2)/2
        mZ=(vZ1+vZ2)/2
           
           
        #line equation for particular z
        cXcor=(X1-((Z1-mZ)*(cX-cX2))/(Z1-Z2))+R
        cYcor=(Y1-((Z1-mZ)*(cY-cY2))/(Z1-Z2))+R
    
    #             
    #    a=cX-vX1
    #    b=cY-vY1
    #    c=mX-vX1
    #    d=mY-vY1
    #    e=cX-mX
    #    f=cY-mY
        
        a=cXcor-vX1
        b=cYcor-vY1
        c=mX-vX1
        d=mY-vY1
        e=cXcor-mX
        f=cYcor-mY
        
        intval=pd.concat((a,b,c,d,e,f), axis=1)
    
        intval1=(a**2+b**2-c**2-d**2-e**2-f**2)/(2*((c**2+d**2)**0.5)*((e**2+f**2)**0.5))
        
        intval2=2*((c**2+d**2)**0.5)*((e**2+f**2)**0.5)
           
        theta=np.degrees(np.arccos((a**2+b**2-c**2-d**2-e**2-f**2)/(2*((c**2+d**2)**0.5)*((e**2+f**2)**0.5))))
        theta[theta>90] = 180-theta
    #    theta=90-theta
        
        euc=ellipses3D["Euclidean distance"]
    
        dist=ellipses3D["Branch length"]    
        
        
        canal3D=pd.concat((theta,phi,phitan,mX,mY,euc,dist), axis=1)
        canal3D.columns=["theta","phi","phitan","mpX","mpY","Euclidean distance","Branch length"]
    
        
        return canal3D
    
def plotcanals(path):
    
        dataset = pd.read_csv(path, encoding = "ISO-8859-1")
        
        data = dataset[~pd.isnull(dataset).any(axis=1)]
        
        x=data["theta"]
        x=(x*1)
        
        y=data["phi"]
        y=(y*1)
        
        
        histogram=np.histogram2d(x, y, bins=10)[0]
        
        
        # Create figure
        fig = plt.figure()
        ax = fig.gca(projection='3d')
        
        # Select mesh density
        n = 11
        
        # Generate points between pi/2 in theta and phi
        theta = np.linspace(0, np.pi/2, n) # Elevation
        phi = np.linspace(0, np.pi/2, n) # Azimuth
        r = np.ones([n])
        
        # Create the mesh grid 
        theta, phi = np.meshgrid(theta, phi)
        
        # Convert to cartesian co-ordinates
        xc = r * np.cos(theta) * np.cos(phi)
        yc = r * np.cos(theta) * np.sin(phi)
        zc = r * np.sin(theta) 
        
        # Set value of each individual face
        histnorm=histogram/histogram.max()
        histnorm=histnorm/0.75
        histnorm[histnorm>1] = 1
        
        color = histnorm
        
        # Hide grid lines
        ax.grid(False)
        
        # Hide axes ticks
        ax.set_xticks([])
        ax.set_yticks([])
        ax.set_zticks([])    
        
        # Get current rotation angle
        print (ax.azim)
     
    # Set rotation angle to 45 degrees
        ax.view_init(azim=45)
    
        
        # Plot results
        surf = ax.plot_surface(xc, yc, zc, facecolors=cm.viridis(color),
                               linewidth=0, antialiased=False)
    
        return surf
    
    
    

filedirectory = "Y:/DLS2017DATA/16bit/16Bit/FossilAnalysis/"


files = os.listdir(filedirectory)

for i in files:
 
    #path="//soton.ac.uk/home/windows/kaw1g15/mydocuments/DLS scan/D18T2/D18T/Results/"
    path=filedirectory+i+"/Results/"
    
    anglefile=pd.read_csv(path+"Overlay Elements.csv")
    
    
    #Input X and Y values (top left of circle) and diameter for a circle fitting the outer curve of the bone from ImageJ
    X1=anglefile.loc[:, 'X'].iloc[0]
    Y1=anglefile.loc[:, 'Y'].iloc[0]
    Z1=0
    
    X2=anglefile.loc[:, 'X'].iloc[1]
    Y2=anglefile.loc[:, 'Y'].iloc[1]
    Z2=300
    
    magC=((X1-X2)**2+(Y1-Y2)**2+(Z1-Z2)**2)**0.5

    Diameter=anglefile.loc[:, 'Width'].iloc[0]
    
    
    R=Diameter/2
    
    cX=X1+R
    cY=Y1+R
    
    cX2=X2+R
    cY2=Y2+R
    
 
    #Open ellipse fit file
    ellipses=pd.read_csv(path+"2Dellipses.csv")
    
         
    canals=findangles(cX,cY,R)
    canals.columns=["theta","phi","Shape","Distance to surface (um)"]
    
    #If a is within 5% of b then radial index should be 0
    
    canals.to_csv(path+"2Dangles.csv")   
    
    #3D method
    
    ellipses3D=pd.read_csv(path+"Branch information.csv")
    
    #Angle of line running down interior edge of resliced data

    
    angles3D=findangles3D(magC,R,cX,cY)
    
    angles3D.to_csv(path+"3Dangles.csv")   
    
#    path2D = path+"2Dangles.csv"
#    path3D = path + "3Dangles.csv"
    
    #path = path+"2Dangles.csv"
    
   
    
    #plotcanals(path2D)
    
    #plotcanals(path3D)
