# -*- coding: utf-8 -*-
"""
Created on Fri Apr 20 13:47:47 2018

@author: kaw1g15
"""


import pandas as pd
import numpy as np
import matplotlib.pyplot as plt
from matplotlib import cm
from mpl_toolkits.mplot3d import Axes3D
import os


def findangles(X1,X2,Y1,Y2,Z1,Z2,Diameter):
    
    
    magC=((X1-X2)**2+(Y1-Y2)**2+(Z1-Z2)**2)**0.5
     
    R=Diameter/2

    cX=X1+R
    cY=Y1+R

    cX2=X2+R
    cY2=Y2+R
    
    ellipses=pd.read_csv(path+"2Dellipses.csv")
    
    #Read X and Y coordinates for the centroid of each fitted ellipse
    pX=(ellipses["X"])
    pY=ellipses["Y"]

    #Read the angle of the major axis relative to the X axis
    angleellipse=ellipses["Angle"]

    #Calculate the gradient and angle of a line running through the centre of the circle and the centroid of the ellipse
    m=(cY-pY)/(cX-pX)
    anglerad=-(np.arctan(m))

    #Calculate the coordinates of the nearest point on the outer circle to the centroid of the ellipse
    aX=cX+R*(np.cos(anglerad))
    aY=cY-R*(np.sin(anglerad))
    
    #Calculate the distance between  the centroid of the ellipse and the outer surface of the bone
    Xdistance=(aX-pX)
    Ydistance=(aY-pY)
    distance=((Xdistance**2+Ydistance**2)**0.5)/1.6

    
    #Calculate the angle of a tangent to the circle         
    mt=1/m

    angletangent=(np.degrees(np.arctan(mt)))
    angletangent[angletangent>0]=180-angletangent
    angletangent[angletangent<0]=(angletangent**2)**0.5
    
    #Normalise the angle of the major axis of the ellipse to the angle of the tangent
    
    radindex=((angleellipse-angletangent)**2)**0.5
    radindex[radindex>90] = 180-radindex
    radindex=90-radindex
    
    #Calculate the shape of the ellipse (b/a)
    shape=ellipses["Minor"]/ellipses["Major"]
    
    
    #Calculate the longitudinal index (a measure of the angle relative to the long axis of the bone)
    longindex=np.degrees(np.arcsin(shape))
    
    canals=pd.concat([radindex,longindex,shape,distance], axis=1)
    canals.columns=["theta","phi","Shape","Distance to surface (um)"]

    
    return canals


def findangles3D(X1,X2,Y1,Y2,Z1,Z2,Diameter):
    
#read Vertices of each branch
    
    magC=((X1-X2)**2+(Y1-Y2)**2+(Z1-Z2)**2)**0.5
     
    R=Diameter/2

    cX=X1+R
    cY=Y1+R

    cX2=X2+R
    cY2=Y2+R

    ellipses3D=pd.read_csv(path+"Branch information.csv")
    

    vX1=ellipses3D["V1 x"]
    vY1=ellipses3D["V1 y"]
    vZ1=ellipses3D["V1 z"]
    vX2=ellipses3D["V2 x"]
    vY2=ellipses3D["V2 y"]
    vZ2=ellipses3D["V2 z"]
    
#    euc=
    
#    length=
    
#    ID=

    magCan=((vX2-vX1)**2+(vY2-vY1)**2+(vZ1-vZ2)**2)**0.5
    dotprod=(X1-X2)*(vX1-vX2)+(Y1-Y2)*(vY1-vY2)+(Z1-Z2)*(vZ1-vZ2)
    phi=abs(90-(np.degrees(np.arccos(dotprod/(magC*magCan)))))

#    
    phitan=90-(np.degrees(np.arctan((((vX2-vX1)**2+(vY2-vY1)**2)**0.5)/abs(vZ2-vZ1))))
#    phi.replace(["inf", "-inf"], 0)    
#    phitan.loc[(~np.isfinite(phitan)) & phitan.notnull()] = 0
    dfphitan=pd.DataFrame(phitan)
    pd.DataFrame.hist(dfphitan)
           
                 
    dfphi=pd.DataFrame(phi)      
    pd.DataFrame.hist(dfphi)
    
    
    mX=(vX1+vX2)/2
    mY=(vY1+vY2)/2
    mZ=(vZ1+vZ2)/2
       
       
    #line equation for particular z
    cXcor=(X1-((Z1-mZ)*(cX-cX2))/(Z1-Z2))+R
    cYcor=(Y1-((Z1-mZ)*(cY-cY2))/(Z1-Z2))+R

#             
#    a=cX-vX1
#    b=cY-vY1
#    c=mX-vX1
#    d=mY-vY1
#    e=cX-mX
#    f=cY-mY
    
    a=cXcor-vX1
    b=cYcor-vY1
    c=mX-vX1
    d=mY-vY1
    e=cXcor-mX
    f=cYcor-mY
    
    intval=pd.concat((a,b,c,d,e,f), axis=1)

    intval1=(a**2+b**2-c**2-d**2-e**2-f**2)/(2*((c**2+d**2)**0.5)*((e**2+f**2)**0.5))
    
    intval2=2*((c**2+d**2)**0.5)*((e**2+f**2)**0.5)
       
    theta=np.degrees(np.arccos((a**2+b**2-c**2-d**2-e**2-f**2)/(2*((c**2+d**2)**0.5)*((e**2+f**2)**0.5))))
    theta[theta>90] = 180-theta
#    theta=90-theta
    
    
    canal3D=pd.concat((theta,phi,phitan,mX,mY), axis=1)
    canal3D.columns=["theta","phi","phitan","mpX","mpY"]

    
    return canal3D



#path="//soton.ac.uk/home/windows/kaw1g15/mydocuments/DLS scan/D18T2/D18T/Results/"

#Input X and Y values (top left of circle) and diameter for a circle fitting the outer curve of the bone from ImageJ
X1=0
Y1=0
Z1=0

X2=0
Y2=0
Z2=500

Diameter=500

filedirectory = "//soton.ac.uk/home/windows/kaw1g15/mydocuments/Katy Cylinder Generation/Results/"

files = os.listdir(filedirectory)

ellipsefiles = []

for i in files:
    if "ellipse" in i:
        ellipsefiles.append(i)
        
for i in ellipsefiles:
    file=i.split("raw")
    file=file[0]
    filesplit=i.split("_")
    s=filesplit[0]
    x=filesplit[1]
    y=filesplit[2]
    z=filesplit[3]

    path=filedirectory+file


#2D method

canals=findangles(X1,X2,Y1,Y2,Z1,Z2,Diameter)
canals.to_csv(path+"2Dangles.csv")

#If a is within 5% of b then radial index should be 0

#3D method

angles3D=findangles3D(X1,X2,Y1,Y2,Z1,Z2,Diameter)
angles3D.to_csv(path+"3Dangles.csv")   

#plot results

path2D = path+"2Dangles.csv"
path3D = path + "3Dangles.csv"
#path = path+"2Dangles.csv"

plotcanals(path2D)
plotcanals(path3D)
