# -*- coding: utf-8 -*-
"""
Created on Thu Apr 12 11:48:09 2018

Joshua Steer
Joshua.Steer@soton.ac.uk

To run this script, open ScanIP, click the small scripting tab, open the .py file 
and press play 
Remember to set the path correctly 
"""
from scanip_api import *
import random
#Number of samples
N = 100
#Array of sample data
samples = []
for i in range(N):
    # Generate random values
    # Skew from 1 -> 5
    skew1 = random.randrange(600, 601) / 200.0
    skew2 = random.randrange(600, 601) / 200.0
    skew3 = random.randrange(200, 201) / 200.0

    # Rotations frin -90 deg -> 90 deg (currently limited to between -22.5 and 22.5, change values to remove limit of rotations)
    yRot = random.randrange(-2250, 2251) / 100.0
    xRot = random.randrange(-2250, 2251) / 100.0
    zRot = random.randrange(-2250, 2251) / 100.0
    samples.append([skew1,skew2,skew3, yRot, xRot, zRot])
# Define path for saving .raw files 
path = 'Z:\\cylinders\\EllipsoidsFinal\\Ellipsoid0.8limited\\'
# Generate 250x250x250 blank space
App.GetInstance().ImportBlankImage(50, 50, 50, 1.0, 1.0, 1.0)
# Iterate through each row of samples
for s in samples:
    #Create sphere of radius 5
    App.GetDocument().CreateSphere(9.4)
    #Create skew matrix
    MS = Matrix.FromScale(1/s[0], 1/s[1], 1/s[2])
    #Create Rotation matrix, y in long axis of cylinder
    MR = Matrix.FromEulerAngles(s[3], s[4], s[5])
    # Translate into centre of space
    MT = Matrix.FromTranslation(25, 25, 25)
    # Construct full transformation matrix from M = MT*MR*MS
    M = Matrix.Multiply(MT, Matrix.Multiply(MR, MS))
    # Apply transformation
    App.GetDocument().GetSurfaceByName("Sphere").SetMatrix(M)
    # Convert from surface to mask
    App.GetDocument().GetActiveSurface().CopyToMask(Doc.AccurateManifold, False)
    # Create file name from 4 variables
    fh = '%.2f_%.2f_%.2f_%.2f_%.2f_%.2f.raw' % tuple(s)
    # Export as a 8-bit raw file
    App.GetDocument().GetMaskByName("Sphere (from surface)").RawExport('%s%s' % (path, fh))
    # Delete mask and surface
    App.GetDocument().RemoveMask(App.GetDocument().GetActiveGenericMask())
    App.GetDocument().RemoveSurface(App.GetDocument().GetSurfaceByName("Sphere"))