##Plotting results
library(mgcv)
library(ggplot2)
library(dplyr)
library(RColorBrewer)
library(boot)
windowsFonts(Calibri=windowsFont("Calibri"))
source("chap3/scripts/X+Q+XQ_uncertainty.r") # To compute uncertainty for sum of main effects and their interaction

#Factor variables
qualf4imp_0 <- as.factor(qualf4imp_0)
qualf2bimp_1 <- as.factor(qualf2bimp_1)
qualf3bimp_2 <- as.factor(qualf3bimp_2)

#Grouping data function
groupfuncw <- function(wts,bir,covs, FUN=sum) {
  f     <- as.formula(paste(wts, "~", bir, "+", paste(covs,collapse="+"), sep=""))
  agg1  <- aggregate(f, FUN=function(x) succ=FUN(x))
  join1 <- dplyr::full_join(x=agg1[agg1[,bir]==0,],
                            y=agg1[agg1[,bir]==1,],
                            by=covs)[,c(covs,paste(wts,".x",sep=""),paste(wts,".y",sep=""))]
  join1[which(is.na(join1[,paste(wts,".x",sep="")])),paste(wts,".x",sep="")] <- 0
  join1[which(is.na(join1[,paste(wts,".y",sep="")])),paste(wts,".y",sep="")] <- 0
  join1$n  <- join1[,paste(wts,".x",sep="")] + join1[,paste(wts,".y",sep="")]
  join1$s  <- join1[,paste(wts,".y",sep="")]
  join1$p  <- join1$s / join1$n
  join1    <- join1[which(join1$n>0),]
  join1    <- join1[,c(covs,"n","s","p")] #,"nr","sr","pr")]
  join1
}

groupfuncw2 <- function(wt,covs) {
  f     <- as.formula(paste(wt, "~", paste(covs,collapse="+"), sep=""))
  agg1  <- aggregate(f, FUN=function(x) c(n=length(x), nw = sum(x)))
  dat1  <- data.frame(agg1[,covs], n=agg1[[wt]][,"n"], nw=agg1[[wt]][,"nw"])
  dat1
}

#Knots function
knotsfunc <- function(x,k)
  seq(min(x)-3*(max(x)-min(x))/(k-3),max(x)+3*(max(x)-min(x))/(k-3),by=(max(x)-min(x))/(k-3))

kfunc <- function(ind,dgw) {
  out <- list()
  for (i in ind)
    out[[names(dgw)[i]]] <- knotsfunc(dgw[,i],k)
  out
}
k <- 9

#Refitting chosen GAMs and extracting relevant components
#Parity 0
dgw <- groupfuncw("weights_0st", "birth.bin_0", c("age_0", "coh_0", "qualf4imp_0"))[,-5]
dgw2 <- groupfuncw("weights_0st", "birth.bin_0", c("age_0", "coh_0", "qualf4imp_0"), FUN=length)[,-5]
dgw2 <- left_join(dgw[,1:4],dgw2[,-4],by=c("age_0","coh_0","qualf4imp_0"))
dgw <- dgw[order(dgw$qualf4imp_0,dgw$coh_0,dgw$age_0),]
dgw2 <- dgw2[order(dgw2$qualf4imp_0,dgw2$coh_0,dgw2$age_0),]
load("chap3/results/p0_model_selection.RData")
gamch0w <- gam(gam19$formula, family=binomial, method="REML", weights=n, data=dgw2, knots=kfunc(c(1,2),dgw))
gamch <- gamch0w

Afit <- predict(gamch, newdata = data.frame(age_0=15:44,coh_0=1945,qualf4imp_0=1), type="terms", se.fit = T)
Adat0 <- data.frame(cov=15:44,fit=Afit$fit[,"s(age_0)"],lower=Afit$fit[,"s(age_0)"]-2*Afit$se.fit[,"s(age_0)"],upper=Afit$fit[,"s(age_0)"]+2*Afit$se.fit[,"s(age_0)"])
Cfit <- predict(gamch, newdata = data.frame(age_0=15,coh_0=1945:1992,qualf4imp_0=1), type="terms", se.fit = T)
Cdat0 <- data.frame(cov=1945:1992,fit=Cfit$fit[,"s(coh_0)"],lower=Cfit$fit[,"s(coh_0)"]-2*Cfit$se.fit[,"s(coh_0)"],upper=Cfit$fit[,"s(coh_0)"]+2*Cfit$se.fit[,"s(coh_0)"])
AQAQdat <- xqxq(gamch,"age_0","qualf4imp_0",15:44,1:4,dgw,k-1,"a","q")
AQAQdat0 <- data.frame(Q=rep(1:4,each=30),cov=rep(15:44,4),fit=as.vector(AQAQdat$fit),lower=as.vector(AQAQdat$lower),upper=as.vector(AQAQdat$upper))
ACACfit <- apply(predict(gamch, newdata = data.frame(age_0=rep(15:44,48),coh_0=rep(1945:1992,each=30),qualf4imp_0=1,HDIc2a_0=1), type="terms")[,c("s(age_0)","s(coh_0)","ti(age_0,coh_0)")],1,sum)
ACACdat0 <- data.frame(age=rep(15:44,48), coh=rep(1945:1992,each=30), fit=ACACfit)
ACfit <- predict(gamch, newdata = data.frame(age_0=rep(15:44,48),coh_0=rep(1945:1992,each=30),qualf4imp_0=1,HDIc2a_0=1), type="terms")[,"ti(age_0,coh_0)"]
ACdat0 <- data.frame(age=rep(15:44,48), coh=rep(1945:1992,each=30), fit=ACfit)
probfit <- predict(gamch,newdata=data.frame(age_0=rep(rep(15:44,48),4),coh_0=rep(rep(1945:1992,each=30),4),qualf4imp_0=rep(1:4,each=48*30)))
probdat0 <- data.frame(age=rep(rep(15:44,48),4), coh=rep(rep(1945:1992,each=30),4), qualf=rep(1:4,each=48*30),fit=inv.logit(probfit))
ACQtab0 <- data.frame(age=dgw2$age_0,coh=dgw2$coh_0,qualf=as.numeric(dgw2$qualf4imp_0),prob=dgw2$p)
dgw <- groupfuncw("weights_0st", "birth.bin_0", c("age_0", "coh_0"))[,-4]
dgw2 <- groupfuncw("weights_0st", "birth.bin_0", c("age_0", "coh_0"), FUN=length)[,-4]
dgw2 <- left_join(dgw[,1:3],dgw2[,-3],by=c("age_0","coh_0"))
ACtab0 <- data.frame(age=dgw2$age_0,coh=dgw2$coh_0,prob=dgw2$p)

#Parity 1
dgw <- groupfuncw("weights_1st", "birth.bin_1", c("age_1", "coh_1", "gapc_1", "qualf2bimp_1"))[,-6]
dgw2 <- groupfuncw("weights_1st", "birth.bin_1", c("age_1", "coh_1", "gapc_1", "qualf2bimp_1"), FUN=length)[,-6]
dgw2 <- left_join(dgw[,1:5],dgw2[,-5],by=c("age_1","coh_1","gapc_1", "qualf2bimp_1"))
dgw <- dgw[order(dgw$qualf2bimp_1,dgw$gapc_1,dgw$coh_1,dgw$age_1),]
dgw2 <- dgw2[order(dgw2$qualf2bimp_1,dgw2$gapc_1,dgw2$coh_1,dgw2$age_1),]
load("chap3/results/p1_model_selection.RData")
gamch1w <- gam(gam15$formula, family=binomial, method="REML", weights=n, data=dgw2, knots=kfunc(c(1,2,3),dgw))
gamch <- gamch1w

Afit <- predict(gamch, newdata = data.frame(age_1=15:44,coh_1=1945,gapc_1=1,qualf2bimp_1=1), type="terms", se.fit = T)
Adat1 <- data.frame(cov=15:44,fit=Afit$fit[,"s(age_1)"],lower=Afit$fit[,"s(age_1)"]-2*Afit$se.fit[,"s(age_1)"],upper=Afit$fit[,"s(age_1)"]+2*Afit$se.fit[,"s(age_1)"])
Cfit <- predict(gamch, newdata = data.frame(age_1=15,coh_1=1945:1992,gapc_1=1,qualf2bimp_1=1), type="terms", se.fit = T)
Cdat1 <- data.frame(cov=1945:1992,fit=Cfit$fit[,"s(coh_1)"],lower=Cfit$fit[,"s(coh_1)"]-2*Cfit$se.fit[,"s(coh_1)"],upper=Cfit$fit[,"s(coh_1)"]+2*Cfit$se.fit[,"s(coh_1)"])
Tfit <- predict(gamch, newdata = data.frame(age_1=15,coh_1=1945,gapc_1=1:11,qualf2bimp_1=1), type="terms", se.fit = T)
Tdat1 <- data.frame(cov=1:11,fit=Tfit$fit[,"s(gapc_1)"],lower=Tfit$fit[,"s(gapc_1)"]-2*Tfit$se.fit[,"s(gapc_1)"],upper=Tfit$fit[,"s(gapc_1)"]+2*Tfit$se.fit[,"s(gapc_1)"])
AQAQdat <- xqxq(gamch,"age_1","qualf2bimp_1",15:44,1:2,dgw,k-1,"a","q")
AQAQdat1 <- data.frame(Q=rep(1:2,each=30),cov=rep(15:44,2),fit=as.vector(AQAQdat$fit),lower=as.vector(AQAQdat$lower),upper=as.vector(AQAQdat$upper))
ACACfit <- apply(predict(gamch, newdata = data.frame(age_1=rep(15:44,48),coh_1=rep(1945:1992,each=30),gapc_1=1,qualf2bimp_1=1), type="terms")[,c("s(age_1)","s(coh_1)","ti(age_1,coh_1)")],1,sum)
ACACdat1 <- data.frame(age=rep(15:44,48), coh=rep(1945:1992,each=30), fit=ACACfit)
ACfit <- predict(gamch, newdata = data.frame(age_1=rep(15:44,48),coh_1=rep(1945:1992,each=30),gapc_1=1,qualf2bimp_1=1), type="terms")[,"ti(age_1,coh_1)"]
ACdat1 <- data.frame(age=rep(15:44,48), coh=rep(1945:1992,each=30), fit=ACfit)
#Age at first birth = 19
probfit <- predict(gamch,newdata=data.frame(age_1=rep(rep(20:44,48),2),
                                             coh_1=rep(rep(1945:1992,each=25),2),
                                             gapc_1=rep(c(1:11,rep(11,14)),2*48),
                                             qualf2bimp_1=rep(1:2,each=48*25)),type="response")
probdat1 <- data.frame(age=rep(rep(20:44,48),2), coh=rep(rep(1945:1992,each=25),2),
                        qualf=rep(1:2,each=48*25),fit=probfit)
ACTQtab1 <- data.frame(age=dgw2$age_1[dgw2$age_1-dgw2$gapc_1==19|dgw2$gapc_1==11&dgw2$age_1>30],
                       coh=dgw2$coh_1[dgw2$age_1-dgw2$gapc_1==19|dgw2$gapc_1==11&dgw2$age_1>30],
                       qualf=as.numeric(dgw2$qualf2bimp_1[dgw2$age_1-dgw2$gapc_1==19|dgw2$gapc_1==11&dgw2$age_1>30]),
                       prob=dgw2$p[dgw2$age_1-dgw2$gapc_1==19|dgw2$gapc_1==11&dgw2$age_1>30])

dgw <- groupfuncw("weights_1st", "birth.bin_1", c("age_1", "coh_1"))[,-4]
dgw2 <- groupfuncw("weights_1st", "birth.bin_1", c("age_1", "coh_1"), FUN=length)[,-4]
dgw2 <- left_join(dgw[,1:3],dgw2[,-3],by=c("age_1","coh_1"))
ACtab1 <- data.frame(age=dgw2$age_1,coh=dgw2$coh_1,prob=dgw2$p)

#Parity 2
dgw <- groupfuncw("weights_2st", "birth.bin_2", c("age_2", "coh_2", "gapc_2", "qualf3bimp_2"))[,-6]
dgw2 <- groupfuncw("weights_2st", "birth.bin_2", c("age_2", "coh_2", "gapc_2", "qualf3bimp_2"), FUN=length)[,-6]
dgw2 <- left_join(dgw[,1:5],dgw2[,-5],by=c("age_2","coh_2","gapc_2", "qualf3bimp_2"))
dgw <- dgw[order(dgw$qualf3bimp_2,dgw$gapc_2,dgw$coh_2,dgw$age_2),]
dgw2 <- dgw2[order(dgw2$qualf3bimp_2,dgw2$gapc_2,dgw2$coh_2,dgw2$age_2),]
load("chap3/results/p2_model_selection.RData")
gamch2w <- gam(gam11$formula, family=binomial, method="REML", weights=n, data=dgw2, knots=kfunc(c(1,2,3),dgw))
gamch <- gamch2w

Afit <- predict(gamch, newdata = data.frame(age_2=15:44,coh_2=1945,gapc_2=1,qualf3bimp_2=1), type="terms", se.fit = T)
Adat2 <- data.frame(cov=15:44,fit=Afit$fit[,"s(age_2)"],lower=Afit$fit[,"s(age_2)"]-2*Afit$se.fit[,"s(age_2)"],upper=Afit$fit[,"s(age_2)"]+2*Afit$se.fit[,"s(age_2)"])
Cfit <- predict(gamch, newdata = data.frame(age_2=15,coh_2=1945:1992,gapc_2=1,qualf3bimp_2=1), type="terms", se.fit = T)
Cdat2 <- data.frame(cov=1945:1992,fit=Cfit$fit[,"s(coh_2)"],lower=Cfit$fit[,"s(coh_2)"]-2*Cfit$se.fit[,"s(coh_2)"],upper=Cfit$fit[,"s(coh_2)"]+2*Cfit$se.fit[,"s(coh_2)"])
Tfit <- predict(gamch, newdata = data.frame(age_2=15,coh_2=1945,gapc_2=1:11,qualf3bimp_2=1), type="terms", se.fit = T)
Tdat2 <- data.frame(cov=1:11,fit=Tfit$fit[,"s(gapc_2)"],lower=Tfit$fit[,"s(gapc_2)"]-2*Tfit$se.fit[,"s(gapc_2)"],upper=Tfit$fit[,"s(gapc_2)"]+2*Tfit$se.fit[,"s(gapc_2)"])
ACACfit <- apply(predict(gamch, newdata = data.frame(age_2=rep(15:44,48),coh_2=rep(1945:1992,each=30),gapc_2=1,qualf3bimp_2=1), type="terms")[,c("s(age_2)","s(coh_2)","ti(age_2,coh_2)")],1,sum)
ACACdat2 <- data.frame(age=rep(15:44,48), coh=rep(1945:1992,each=30), fit=ACACfit)
ACfit <- predict(gamch, newdata = data.frame(age_2=rep(15:44,48),coh_2=rep(1945:1992,each=30),gapc_2=1,qualf3bimp_2=1), type="terms")[,"ti(age_2,coh_2)"]
ACdat2 <- data.frame(age=rep(15:44,48), coh=rep(1945:1992,each=30), fit=ACfit)
dgw <- groupfuncw("weights_2st", "birth.bin_2", c("age_2", "coh_2"))[,-4]
dgw2 <- groupfuncw("weights_2st", "birth.bin_2", c("age_2", "coh_2"), FUN=length)[,-4]
dgw2 <- left_join(dgw[,1:3],dgw2[,-3],by=c("age_2","coh_2"))
ACtab2 <- data.frame(age=dgw2$age_2,coh=dgw2$coh_2,prob=dgw2$p)

#Parity 3+
dgw <- groupfuncw("weights_3st", "birth.bin_3", c("age_3", "coh_3", "gapc_3"))[,-5]
dgw2 <- groupfuncw("weights_3st", "birth.bin_3", c("age_3", "coh_3", "gapc_3"), FUN=length)[,-5]
dgw2 <- left_join(dgw[,1:4],dgw2[,-4],by=c("age_3","coh_3","gapc_3"))
dgw <- dgw[order(dgw$gapc_3,dgw$coh_3,dgw$age_3),]
dgw2 <- dgw2[order(dgw2$gapc_3,dgw2$coh_3,dgw2$age_3),]
load("chap3/results/p3_model_selection.RData")
gamch3w <- gam(gam3$formula, family=binomial, method="REML", weights=n, data=dgw2, knots=kfunc(c(1,2,3),dgw))
gamch <- gamch3w

Afit <- predict(gamch, newdata = data.frame(age_3=15:44,coh_3=1945,gapc_3=1), type="terms", se.fit = T)
Adat3 <- data.frame(cov=15:44,fit=Afit$fit[,"s(age_3)"],lower=Afit$fit[,"s(age_3)"]-2*Afit$se.fit[,"s(age_3)"],upper=Afit$fit[,"s(age_3)"]+2*Afit$se.fit[,"s(age_3)"])
Cfit <- predict(gamch, newdata = data.frame(age_3=15,coh_3=1945:1992,gapc_3=1), type="terms", se.fit = T)
Cdat3 <- data.frame(cov=1945:1992,fit=Cfit$fit[,"s(coh_3)"],lower=Cfit$fit[,"s(coh_3)"]-2*Cfit$se.fit[,"s(coh_3)"],upper=Cfit$fit[,"s(coh_3)"]+2*Cfit$se.fit[,"s(coh_3)"])
Tfit <- predict(gamch, newdata = data.frame(age_3=15,coh_3=1945,gapc_3=1:11), type="terms", se.fit = T)
Tdat3 <- data.frame(cov=1:11,fit=Tfit$fit[,"s(gapc_3)"],lower=Tfit$fit[,"s(gapc_3)"]-2*Tfit$se.fit[,"s(gapc_3)"],upper=Tfit$fit[,"s(gapc_3)"]+2*Tfit$se.fit[,"s(gapc_3)"])
ACACfit <- apply(predict(gamch, newdata = data.frame(age_3=rep(15:44,48),coh_3=rep(1945:1992,each=30),gapc_3=1), type="terms")[,c("s(age_3)","s(coh_3)","ti(age_3,coh_3)")],1,sum)
ACACdat3 <- data.frame(age=rep(15:44,48), coh=rep(1945:1992,each=30), fit=ACACfit)
ACfit <- predict(gamch, newdata = data.frame(age_3=rep(15:44,48),coh_3=rep(1945:1992,each=30),gapc_3=1), type="terms")[,"ti(age_3,coh_3)"]
ACdat3 <- data.frame(age=rep(15:44,48), coh=rep(1945:1992,each=30), fit=ACfit)
dgw <- groupfuncw("weights_3st", "birth.bin_3", c("age_3", "coh_3"))[,-4]
dgw2 <- groupfuncw("weights_3st", "birth.bin_3", c("age_3", "coh_3"), FUN=length)[,-4]
dgw2 <- left_join(dgw[,1:3],dgw2[,-3],by=c("age_3","coh_3"))
ACtab3 <- data.frame(age=dgw2$age_3,coh=dgw2$coh_3,prob=dgw2$p)

#Plots
#Labels
supp.labsq4 <- c("< GCSE","GCSE","A Level","Degree")
names(supp.labsq4) <- c(1,2,3,4)
supp.labsq4q <- c("q = < GCSE","q = GCSE","q = A Level","q = Degree")
names(supp.labsq4q) <- c(1,2,3,4)
supp.labsq2b <- c("< A Level","At least A Level")
names(supp.labsq2b) <- c(1,2)
supp.labsq2bq <- c("q = < A Level","q = At least A Level")
names(supp.labsq2bq) <- c(1,2)
supp.labsq3b <- c("< GCSE","GCSE/A Level","Degree")
names(supp.labsq3b) <- c(1,2,3)
supp.labsp <- c("Parity 0","Parity 1","Parity 2","Parity 3+")
names(supp.labsp) <- c(0,1,2,3)
supp.labst <- paste0("T = ",1:11)
names(supp.labst) <- 1:11

#A main effects (Figure 3.16)
Adat <- data.frame(p=rep(0:3,c(30,30,30,30)),rbind(Adat0,Adat1,Adat2,Adat3))
Adat[Adat$p==3 & Adat$cov<min(age_3),c("fit","lower","upper")] <- NA
png(file="chap3/plots/fig16.png",width=20,height=8,units="cm",res=400)
print({ggplot(Adat, aes(x=cov, y=fit)) +
    geom_line(size=1) +
    geom_line(aes(y=lower), size=0.5) +
    geom_line(aes(y=upper), size=0.5) +
    labs(x = "Age (a)", y = expression(paste(f[A],"(a)",sep="")))+
    scale_y_continuous(breaks=seq(-4,4,1)) +
    scale_x_continuous(limits=c(15,44), breaks=seq(15,44,5), minor_breaks=setdiff(15:44,seq(15,44,5)), expand=c(0.02,0.02)) +
    coord_cartesian(ylim=c(-4,3)) +
    theme_gray() + theme(text = element_text("Calibri")) +
    facet_grid(cols=vars(p), labeller = labeller(p=supp.labsp))
})
dev.off()

#C main effects (Figure 3.17)
Cdat <- data.frame(p=rep(0:3,c(48,48,48,48)),rbind(Cdat0,Cdat1,Cdat2,Cdat3))
Cdat[Cdat$p==2 & Cdat$cov>max(coh_2),c("fit","lower","upper")] <- NA
Cdat[Cdat$p==3 & Cdat$cov>max(coh_3),c("fit","lower","upper")] <- NA
png(file="chap3/plots/fig17.png",width=20,height=8,units="cm",res=400)
print({ggplot(Cdat, aes(x=cov, y=fit)) +
  geom_line(size=1) +
  geom_line(aes(y=lower), size=0.5) +
  geom_line(aes(y=upper), size=0.5) +
  labs(x = "Cohort (c)", y = expression(paste(f[C],"(c)",sep="")))+
  scale_y_continuous(breaks=seq(-4,4,1)) +
  scale_x_continuous(limits=c(1945,1992), breaks=seq(1950,1990,10), minor_breaks=seq(1945,1985,10), expand=c(0.02,0.02)) +
  coord_cartesian(ylim=c(-4,3)) +
  theme_gray() + theme(text = element_text("Calibri")) +
  facet_grid(cols=vars(p), labeller = labeller(p=supp.labsp))
})
dev.off()

#T main effects (Figure 3.18)
Tdat <- data.frame(p=rep(1:3,each=11), rbind(Tdat1,Tdat2,Tdat3))
png(file="chap3/plots/fig18.png",width=15.27,height=8,units="cm",res=400)
print({ggplot(Tdat, aes(x=cov, y=fit)) +
  geom_line(size=1) +
  geom_line(aes(y=lower), size=0.5) +
  geom_line(aes(y=upper), size=0.5) +
  labs(x = "Time since last birth (t)", y = expression(paste(f[T],"(t)",sep="")))+
  scale_y_continuous(limits=c(-4,4), breaks=seq(-4,4,1)) +
  scale_x_continuous(limits=c(1,11), breaks=seq(1,11,2), minor_breaks=seq(2,10,2), expand=c(0.02,0.02)) +
  coord_cartesian(ylim=c(-4,3)) +
  theme_gray() + theme(text = element_text("Calibri")) +
  facet_grid(cols=vars(p), labeller = labeller(p=supp.labsp))
})
dev.off()

#AC interaction effects (Figure 3.19)
ACdat <- data.frame(p=rep(0:3,c(48*30,48*30,48*30,48*30)),
                    rbind(ACdat0,ACdat1,ACdat2,ACdat3))
ACdatall <- rbind(data.frame(p=0,ACtab0),
                  data.frame(p=1,ACtab1),
                  data.frame(p=2,ACtab2),
                  data.frame(p=3,ACtab3))
ACdatobs <- right_join(ACdat,ACdatall,by=c("p","age","coh"))

png(file="chap3/plots/fig19.png",width=20,height=8,units="cm",res=400)
print({ggplot(ACdatobs, aes(x=age, y=fit, color=coh)) +
  geom_line(aes(group=coh),lwd=0.3) +
  labs(x = "Age (a)", y = expression(paste(f["AC"],"(a,c)",sep="")), color="Cohort (c)") +
  scale_color_gradientn(colours=rainbow(100, start=0.3, end=1), limits=c(1945,1992),guide = guide_colorbar(barheight = 10,frame.colour="black",ticks.colour="black"), breaks = seq(1945,2000,5)) +
  scale_y_continuous(breaks=seq(-4,4,0.5)) +
  scale_x_continuous(limits=c(15,44), breaks=seq(15,44,5), minor_breaks=setdiff(15:44,seq(15,44,5)), expand=c(0.02,0.02)) +
  coord_cartesian(ylim=c(-0.75,0.75)) +
  theme_bw() + theme(text = element_text("Calibri")) +
  facet_grid(cols=vars(p), labeller = labeller(p=supp.labsp))
})
dev.off()

#A+C+AC combined effects (Figure 3.20)
ACACdat <- data.frame(p=rep(0:3,c(48*30,48*30,48*30,48*30)),
                      rbind(ACACdat0,ACACdat1,ACACdat2,ACACdat3))
ACACdatobs <- right_join(ACACdat,ACdatall,by=c("p","age","coh"))

png(file="chap3/plots/fig20.png",width=20,height=8,units="cm",res=400)
print({ggplot(ACACdatobs, aes(x=age, y=fit, color=coh)) +
  geom_line(aes(group=coh), lwd=0.3) +
  labs(x = "Age (a)", y = expression(paste(f[A],"(a) + ",f[C],"(c) + ",f["AC"],"(a,c)",sep="")), color="Cohort (c)") +
  scale_color_gradientn(colours=rainbow(100, start=0.3, end=1), limits=c(1945,1992),guide = guide_colorbar(barheight = 10,frame.colour="black",ticks.colour="black"), breaks = seq(1945,2000,5)) +
  scale_y_continuous(breaks=seq(-4,4,1)) +
  scale_x_continuous(limits=c(15,44), breaks=seq(15,44,5), minor_breaks=setdiff(15:44,seq(15,44,5)), expand=c(0.02,0.02)) +
  coord_cartesian(ylim=c(-4,3)) +
  theme_bw() + theme(text = element_text("Calibri")) +
  facet_grid(cols=vars(p), labeller = labeller(p=supp.labsp))
})
dev.off()

#A+Q+AQ parity 0 combined effects (Figure 3.21)
png(file="chap3/plots/fig21.png",width=20,height=8,units="cm",res=400)
print({ggplot(AQAQdat0, aes(x=cov, y=fit)) +
  geom_line(size=1) +
  geom_line(aes(y=lower), size=0.5) +
  geom_line(aes(y=upper), size=0.5) +
  labs(x = "Age (a)", y = expression(paste(f[A],"(a) + ",f[Q],"(q) + ",f["AQ"],"(a,q)",sep="")))+
  scale_y_continuous(breaks=seq(-4,4,1)) +
  scale_x_continuous(limits=c(15,44), breaks=seq(15,44,5), minor_breaks=setdiff(15:44,seq(15,44,5)), expand=c(0.02,0.02)) +
  coord_cartesian(ylim=c(-4,3)) +
  theme_gray() + theme(text = element_text("Calibri")) +
  facet_grid(cols=vars(Q), labeller = labeller(Q=supp.labsq4q))
})
dev.off()

#A+Q+AQ parity 1 combined effects (Figure 3.22)
png(file="chap3/plots/fig22.png",width=10.57,height=8,units="cm",res=400)
print({ggplot(AQAQdat1, aes(x=cov, y=fit)) +
  geom_line(size=1) +
  geom_line(aes(y=lower), size=0.5) +
  geom_line(aes(y=upper), size=0.5) +
  labs(x = "Age (a)", y = expression(paste(f[A],"(a) + ",f[Q],"(q) + ",f["AQ"],"(a,q)",sep="")))+
  scale_y_continuous(limits=c(-4,4), breaks=seq(-4,4,1)) +
  scale_x_continuous(limits=c(15,44), breaks=seq(15,44,5), minor_breaks=setdiff(15:44,seq(15,44,5)), expand=c(0.02,0.02)) +
  coord_cartesian(ylim=c(-4,3)) +
  theme_gray() + theme(text = element_text("Calibri")) +
  facet_grid(cols=vars(Q), labeller = labeller(Q=supp.labsq2bq))
})
dev.off()

#Parity 0 and 1 fitted probabilities
probdat0$p <- 0
probdat0$qualft <- supp.labsq4[probdat0$qualf]
probdat0p  <- probdat0f <- probdat0
probdat0p[which(probdat0p$age+probdat0p$coh>2007),] <- NA
probdat0f[which(probdat0f$age+probdat0f$coh<=2007),] <- NA

probdat1$p <- 1
probdat1$qualft <- supp.labsq2b[probdat1$qualf]
probdat1p  <- probdat1f <- probdat1
probdat1p[which(probdat1p$age+probdat1p$coh>2007),] <- NA
probdat1f[which(probdat1f$age+probdat1f$coh<=2007),] <- NA

probdatall <- rbind(probdat0,probdat1)
probdatall$qualft <- factor(probdatall$qualft, levels=c("< GCSE","< A Level","GCSE","GCSE/A Level","A Level","< Degree","At least A Level","Degree","All"))
probdatallp <- rbind(probdat0p,probdat1p)
probdatallf <- rbind(probdat0f,probdat1f)

ACQdatall <- rbind(data.frame(p=0,ACQtab0),
                   data.frame(p=1,ACTQtab1))
probdatall <- left_join(probdatall,ACQdatall,by=c("age","coh","qualf","p"))
probdatall$fit[which(is.na(probdatall$prob))] <- NA

#Parity 0 fitted probabilities (Figure 3.23)
png(file="chap3/plots/fig23.png",width=20,height=7,units="cm",res=400)
print({ggplot(probdatall[probdatall$p==0,], aes(x=age, y=fit, color=coh)) +
  geom_line(aes(group=coh),lwd=0.3) +
  labs(x = "Age", y = "Fitted probability", color="Cohort")+
  scale_color_gradientn(colours=rainbow(100, start=0.3, end=1), guide = guide_colorbar(barheight = 12,frame.colour="black",ticks.colour="black"), breaks = seq(1945,2000,5), limits=c(1945,1992)) +
  scale_x_continuous(limits=c(15,44), breaks=seq(15,44,5), minor_breaks=setdiff(15:44,seq(15,44,5)), expand=c(0.02,0.02)) +
  theme_bw() + theme(text = element_text("Calibri")) +
  facet_wrap(~qualft,labeller=labeller(p=supp.labsp),nrow=2,ncol=4)
})
dev.off()

#Parity 1 fitted probabilities, age at first birth = 19 (Figure 3.24)
png(file="chap3/plots/fig24.png",width=11.62,height=7,units="cm",res=400)
print({ggplot(probdatall[probdatall$p==1,], aes(x=age, y=fit, color=coh)) +
  geom_line(aes(group=coh),lwd=0.3) +
  labs(x = "Age", y = "Fitted probability", color="Cohort")+
  scale_color_gradientn(colours=rainbow(100, start=0.3, end=1), guide = guide_colorbar(barheight = 12,frame.colour="black",ticks.colour="black"), breaks = seq(1945,2000,5), limits=c(1945,1992)) +
  scale_x_continuous(limits=c(20,44), breaks=seq(15,44,5), minor_breaks=setdiff(15:44,seq(15,44,5)), expand=c(0.02,0.02)) +
  theme_bw() + theme(text = element_text("Calibri")) +
  facet_wrap(~qualft,labeller=labeller(p=supp.labsp),nrow=2,ncol=4)
})
dev.off()
