##Processing HDI data
library(stringr)

HDI <- read.csv("chap3/data/Human Development Index (HDI).csv",skip=5)[,c("Country","X2018")]
colnames(HDI) <- c("Country","HDI")
HDI <- HDI[which(HDI$HDI!=".."),]
class(HDI$HDI) <- "numeric"
HDI$Country <- tolower(str_trim(HDI$Country))

HDIsurv <- data.frame(Country_org=unique(factor(data$a_plbornc_all[index])),
                      Country_mod=NA,HDI=NA)

for (i in which(HDI$Country %in% HDIsurv$Country_org)) {
  j <- which(HDIsurv$Country_org == HDI$Country[i])
  HDIsurv$Country_mod[j] <- HDI$Country[i]
  HDIsurv$HDI[j] <- HDI$HDI[i]
}

HDIsurv$Country_mod[HDIsurv$Country_org %in% c("england", "inapplicable")] <- "united kingdom"
HDIsurv$Country_mod[HDIsurv$Country_org=="republic of ireland"] <- "ireland"
HDIsurv$Country_mod[HDIsurv$Country_org=="the united states of america"] <- "united states"
HDIsurv$Country_mod[HDIsurv$Country_org=="china / hong kong"] <- "hong kong, china (sar)"
HDIsurv$Country_mod[HDIsurv$Country_org=="democratic republic of congo"] <- "congo (democratic republic of the)"
HDIsurv$Country_mod[HDIsurv$Country_org=="the netherlands"] <- "netherlands"
HDIsurv$Country_mod[HDIsurv$Country_org %in% c("russia", "union of soviet socialist states")] <- "russian federation"
HDIsurv$Country_mod[HDIsurv$Country_org=="ivory coast"] <- "cte d'ivoire"
HDIsurv$Country_mod[HDIsurv$Country_org=="korea, republic of"] <- "korea (republic of)"
HDIsurv$Country_mod[HDIsurv$Country_org=="iran"] <- "iran (islamic republic of)"
HDIsurv$Country_mod[HDIsurv$Country_org=="slovinia"] <- "slovenia"
HDIsurv$Country_mod[HDIsurv$Country_org=="cape verde"] <- "cabo verde"
HDIsurv$Country_mod[HDIsurv$Country_org=="venezuela"] <- "venezuela (bolivarian republic of)"
HDIsurv$Country_mod[HDIsurv$Country_org=="kingdom of saudi arabia"] <- "saudi arabia"
HDIsurv$Country_mod[HDIsurv$Country_org=="laos"] <- "lao people's democratic republic"
HDIsurv$Country_mod[HDIsurv$Country_org=="st lucia"] <- "saint lucia"
HDIsurv$Country_mod[HDIsurv$Country_org=="palestine"] <- "palestine, state of"
HDIsurv$Country_mod[HDIsurv$Country_org=="moldova"] <- "moldova (republic of)"
HDIsurv$Country_mod[HDIsurv$Country_org=="tanzania"] <- "tanzania (united republic of)"
HDIsurv$Country_mod[HDIsurv$Country_org=="nevis"] <- "saint kitts and nevis"
HDIsurv$Country_mod[HDIsurv$Country_org=="st vincent and the grenadines"] <- "saint vincent and the grenadines"
HDIsurv$Country_mod[HDIsurv$Country_org %in% c("czech republic", "czechoslovakia")] <- "czechia"
HDIsurv$Country_mod[HDIsurv$Country_org=="aden"] <- "yemen"
HDIsurv$Country_mod[HDIsurv$Country_org=="antigua"] <- "antigua and barbuda"
HDIsurv$Country_mod[HDIsurv$Country_org %in% c("africa", "west africa", "somalia")] <- "sub-saharan africa"
HDIsurv$Country_mod[HDIsurv$Country_org=="middle east"] <- "arab states"
HDIsurv$Country_mod[HDIsurv$Country_org=="kashmir"] <- "south asia"
HDIsurv$Country_mod[HDIsurv$Country_org=="kosovo"] <- "europe and central asia"
HDIsurv$Country_mod[HDIsurv$Country_org %in% c("jersey", "guernsey", "gibraltar", "isle of man", "falkland islands", "bermuda")] <- "very high human development"
HDIsurv$Country_mod[HDIsurv$Country_org %in% c("south america", "west indies", "anguilla", "montserrat", "gaudeloupe", "martinique", "the caribbean / french caribbean")] <- "latin america and the caribbean"
HDIsurv$Country_mod[HDIsurv$Country_org %in% c("vietnam", "tuvalu", "taiwan")] <- "east asia and the pacific"
HDIsurv$Country_mod[HDIsurv$Country_org=="not elsewhere codable"] <- "world"

if(sum(is.na(HDIsurv$Country_mod))>0) stop("Need to recode some countries")
HDIsurv[which(is.na(HDIsurv$Country_mod)),]

for (i in which(is.na(HDIsurv$HDI))) {
  j <- which(HDI$Country == HDIsurv$Country_mod[i])
  HDIsurv$HDI[i] <- HDI$HDI[j]
}

if(sum(is.na(HDIsurv$HDI))>0) stop("Need to recode some countries")

#Code the following variables using the classification on p295 of the 2019 Human Development Report
#HDIc5: 1 = low, 2 = medium, 3 = high, 4 = very high, 5 = UK-born
#HDIc4a: 1 = low, 2 = medium, 3 = high, 4 = very high/UK-born
#HDIc4b: 1 = low, 2 = medium, 3 = high/very high, 4 = UK-born
#HDIc4c: 1 = low, 2 = medium/high, 3 = very high, 4 = UK-born
#HDIc4d: 1 = low/medium, 2 = high, 3 = very high, 4 = UK-born
#HDIc3a: 1 = low, 2 = medium, 3 = high/very high/UK-born
#HDIc3b: 1 = low, 2 = medium/high, 3 = very high/UK-born
#HDIc3c: 1 = low, 2 = medium/high/very high, 3 = UK-born
#HDIc3d: 1 = low/medium, 2 = high, 3 = very high/UK-born
#HDIc3e: 1 = low/medium, 2 = high/very high, 3 = UK-born
#HDIc3f: 1 = low/medium/high, 2 = very high, 3 = UK-born
#HDIc2a: 1 = low, 2 = medium/high/very high/UK-born
#HDIc2b: 1 = low/medium, 2 = high/very high/UK-born
#HDIc2c: 1 = low/medium/high, 2 = very high/UK-born
#HDIc2d: 1 = low/medium/high/very high, 2 = UK-born
HDIsurv$HDIr <- round(HDIsurv$HDI,3)
HDIsurv$HDIc5 <- ifelse(HDIsurv$Country_mod == "united kingdom", 5,
                       ifelse(HDIsurv$HDIr < 0.550, 1,
                              ifelse(HDIsurv$HDIr >= 0.550 & HDIsurv$HDIr < 0.700, 2, 
                                     ifelse(HDIsurv$HDIr >= 0.700 & HDIsurv$HDIr < 0.800, 3, 4))))
HDIsurv$HDIc4a <- ifelse(HDIsurv$HDIc5 > 4, HDIsurv$HDIc5-1, HDIsurv$HDIc5)
HDIsurv$HDIc4b <- ifelse(HDIsurv$HDIc5 > 3, HDIsurv$HDIc5-1, HDIsurv$HDIc5)
HDIsurv$HDIc4c <- ifelse(HDIsurv$HDIc5 > 2, HDIsurv$HDIc5-1, HDIsurv$HDIc5)
HDIsurv$HDIc4d <- ifelse(HDIsurv$HDIc5 > 1, HDIsurv$HDIc5-1, HDIsurv$HDIc5)
HDIsurv$HDIc3a <- ifelse(HDIsurv$HDIc5 > 3, 3, HDIsurv$HDIc5)
HDIsurv$HDIc3b <- ifelse(HDIsurv$HDIc5 > 3, 3, ifelse(HDIsurv$HDIc5 > 2, 2, HDIsurv$HDIc5))
HDIsurv$HDIc3c <- ifelse(HDIsurv$HDIc5 > 4, 3, ifelse(HDIsurv$HDIc5 > 2, 2, HDIsurv$HDIc5))
HDIsurv$HDIc3d <- ifelse(HDIsurv$HDIc5 > 3, 3, ifelse(HDIsurv$HDIc5 > 1, HDIsurv$HDIc5-1, HDIsurv$HDIc5))
HDIsurv$HDIc3e <- ifelse(HDIsurv$HDIc5 > 4, 3, ifelse(HDIsurv$HDIc5 > 2, 2, 1))
HDIsurv$HDIc3f <- ifelse(HDIsurv$HDIc5 > 3, HDIsurv$HDIc5-2, 1)
HDIsurv$HDIc2a <- ifelse(HDIsurv$HDIc5 > 1, 2, 1)
HDIsurv$HDIc2b <- ifelse(HDIsurv$HDIc5 > 2, 2, 1)
HDIsurv$HDIc2c <- ifelse(HDIsurv$HDIc5 > 3, 2, 1)
HDIsurv$HDIc2d <- ifelse(HDIsurv$HDIc5 > 4, 2, 1)
