######################################################################################
# R source code to perform analyses in Chapter 3 of the PhD thesis:                  #
# "Stochastic Modelling and Projection of Age-Specific Fertility Rates"              #
# by Joanne Ellison.                                                                 #
# Please email J.Ellison@soton.ac.uk with any queries.                               #
######################################################################################

## 1. Set-up
#This code requires the user to obtain permission to download the Special Licence version
#of Understanding Society. We use the seventh edition:
#University of Essex. Institute for Social and Economic Research, NatCen Social Research,
#Kantar Public. (2017). Understanding Society: Waves 1-7, 2009-2016: Special Licence Access.
#[data collection]. 7th Edition. UK Data Service. SN: 6931, "http://doi.org/10.5255/UKDA-SN-6931-7".

#This code also requires the user to download HDI data from the UNDP Human Developments Report website.
#Go to "http://hdr.undp.org/en/indicators/137506" and click "Download Data" (top-right of page).
#Save as "Human Development Index (HDI).csv" in "chap3/data".
#Note that the values extracted in the code are not identical to the 2018 values used in the analyses
#due to data updates, and therefore results may differ.

#Set working directory ("this.dir") to the location of the "chap2", "chap3" and "chap4" folders on your
#computer.
rm(list=ls()) # remove any objects currently in your workspace
this.dir <- c(".")
setwd(this.dir)

#Install required packages (only need to do this when running R code for first time)
source("chap3/scripts/install_packages.r")

#Data processing
#This code applies to cleaned fertility histories kindly provided by Ann Berrington and Juliet Stone,
#which form part of the dataset analysed in Berrington et al. (2015) - please see this paper for further details:
#Berrington, A., Stone, J., & Beaujouan, E. (2015). Educational differences in timing and quantum of childbearing in
#Britain: A study of cohorts born 1940-1969. Demographic Research, 33, 733-764. "https://doi.org/10.4054/DemRes.2015.33.26".
source("chap3/scripts/process_ukhlsw1.r")

## 2. Exploratory data analysis
#Generates and saves Figures 3.2-3.6 in "chap3/plots" (weighted and unweighted versions)
source("chap3/scripts/eda.r")
#Figure 3.4 different due to updates to HDI values and changes in centroid locations

## 3. Qualification imputation
#Fits chosen imputation model, performs mean imputation, and saves imputation results in "chap3/results" as 
#"Qmeanimp.RData". Also generates and saves Figures 3.12, 3.14 and 3.15 in "chap3/plots".
source("chap3/scripts/impute_Q.r")

## 4. Model selection
#Performs model selection process described in Section 3.5.5, and saves results and fitted models in
#"chap3/results" for each parity.
source("chap3/scripts/model_selection.r")

## 5. Plot results
#Refits chosen models as described at the end of Section 3.6, and generates and saves Figures 3.16-3.24
#in "chap3/plots".
source("chap3/scripts/plot_results.r")
