#Grouping data function
groupfunc <- function(bir,covs) {
  f     <- as.formula(paste(bir, "~", paste(covs,collapse="+"), sep=""))
  agg1  <- aggregate(f, FUN=function(x) c(succ = length(x[x==1]), n = length(x)))
  dat1  <- data.frame(agg1[,covs], n=agg1[[bir]][,"n"], succ=agg1[[bir]][,"succ"])
  dat1
}

groupfuncw <- function(wt,covs) {
  f     <- as.formula(paste(wt, "~", paste(covs,collapse="+"), sep=""))
  agg1  <- aggregate(f, FUN=function(x) c(n=length(x), nw = sum(x)))
  dat1  <- data.frame(agg1[,covs], n=agg1[[wt]][,"n"], nw=agg1[[wt]][,"nw"])
  dat1
}

#Knots function
knotsfunc <- function(x,k)
  seq(min(x)-3*(max(x)-min(x))/(k-3),max(x)+3*(max(x)-min(x))/(k-3),by=(max(x)-min(x))/(k-3))

kfunc <- function(ind,dgw) {
  out <- list()
  for (i in ind)
    out[[names(dgw)[i]]] <- knotsfunc(dgw[,i],k)
  out
}

#Unconstrained B-spline basis (based on a function written by Paul Eilers)
bbase <- function(x, xl = min(x), xr = max(x), n.knots = 10, deg = 3) {
  nseg <- n.knots-1
  dx <- (xr - xl) / nseg
  knots <- seq(xl - deg * dx, xr + deg * dx, len = n.knots + 2*deg )
  P <- outer(x, knots, tpower, deg)
  n <- dim(P)[2]
  D <- diff(diag(n), diff = deg + 1) / (gamma(deg + 1) * dx ^ deg)
  B <- (-1) ^ (deg + 1) * P %*% t(D)
  B
}

#Constrained B-spline basis functions
newXfunc <- function(X) {
  vec1 <- as.matrix(rep(1,dim(X)[1]),ncol=1)
  C <- t(t(vec1)%*%X)
  QR <- qr(C)
  Z <- qr.Q(QR,complete=TRUE)[,-1]
  newX <- X%*%Z
}

newXfunc2 <- function(X) {
  vec1 <- as.matrix(rep(1,dim(X)[1]),ncol=1)
  C <- t(t(vec1)%*%X)
  QR <- qr(C)
  Z <- qr.Q(QR,complete=TRUE)[,-1]
  newX <- X%*%Z
  out <- list()
  out$QR <- QR
  out$Z <- Z
  out$newX <- newX
  out
}

newXfunc3 <- function(X,ind) {
  x <- rep(0,nrow(X))
  x[ind] <- 1
  vec1 <- as.matrix(x,ncol=1)
  C <- t(t(vec1)%*%X)
  QR <- qr(C)
  Z <- qr.Q(QR,complete=TRUE)[,-1]
  newX <- X%*%Z
  out <- list()
  out$QR <- QR
  out$Z <- Z
  out$newX <- newX
  out
}

eqXfunc <- function(data, cov, No, B, ind) {
  x <- seq(min(data[[cov]]),max(data[[cov]]),length=No-1)
  X <- bbase(x, n.knots=No-2, deg=3)
  B2 <- newXfunc3(B,ind)
  Z <- B2$Z
  XZ <- X%*%Z
  sv <- svd(XZ)
  XP <- sv$v %*% (t(sv$u)/sv$d)
  newX <- B2$newX %*% XP
  out <- list()
  out$newX <- newX
  out$XP <- XP
  out
}

#Index function
indexfunc <- function(x) {
  min <- min(x)
  max <- max(x)
  a <- numeric((max-(min-1)))
  for (i in min:max)
    a[(i-(min-1))] <- which(x==i)[1]
  a
}
