##Processing ONS data
library(curl)
library(readxl)

#Download and read in ONS data
curl_download("https://www.ons.gov.uk/file?uri=/peoplepopulationandcommunity/birthsdeathsandmarriages/livebirths/adhocs/11482fertilityratesbyparity1934to2018englandandwales/cpcfertilityratesbyparity19342018.xls",
              destfile = "chap4/data/ons.xls")
ONS <- as.data.frame(read_xls("chap4/data/ons.xls", sheet = "By Parity", range = "A4:T2227",
                 col_names = c("coh", "yob", "age", "Total", paste0("par", 1:5),
                               paste0("bo",1:5),"botot",paste0("bop",1:5))))

#Process ONS data
procfunc <- function(agerange,cohrange,maxyear,filename) {
  ONStmp <- ONS[which(ONS$age %in% agerange & ONS$coh %in% cohrange & ONS$age + ONS$coh <= maxyear),]
  
  ONS_rates_mat <- list()
  ONS_rates_mat[[1]] <- tapply(ONStmp[,"bo1"]/ONStmp[,"par1"],list(ONStmp[,"age"],ONStmp[,"coh"]),sum)
  ONS_rates_mat[[2]] <- tapply(ONStmp[,"bo2"]/ONStmp[,"par2"],list(ONStmp[,"age"],ONStmp[,"coh"]),sum)
  ONS_rates_mat[[3]] <- tapply(ONStmp[,"bo3"]/ONStmp[,"par3"],list(ONStmp[,"age"],ONStmp[,"coh"]),sum)
  ONS_rates_mat[[4]] <- tapply((ONStmp[,"bo4"]+ONStmp[,"bo5"])/(ONStmp[,"par4"]+ONStmp[,"par5"]),list(ONStmp[,"age"],ONStmp[,"coh"]),sum)
  ONS_rates_mat[[5]] <- tapply(ONStmp[,"botot"]/ONStmp[,"Total"],list(ONStmp[,"age"],ONStmp[,"coh"]),sum)
  
  ONS_rates_dat <- list()
  ONS_rates_dat[[1]] <- aggregate(ONStmp[,"bo1"]/ONStmp[,"par1"],list(ONStmp[,"age"],ONStmp[,"coh"]),sum)
  ONS_rates_dat[[2]] <- aggregate(ONStmp[,"bo2"]/ONStmp[,"par2"],list(ONStmp[,"age"],ONStmp[,"coh"]),sum)
  ONS_rates_dat[[3]] <- aggregate(ONStmp[,"bo3"]/ONStmp[,"par3"],list(ONStmp[,"age"],ONStmp[,"coh"]),sum)
  ONS_rates_dat[[4]] <- aggregate((ONStmp[,"bo4"]+ONStmp[,"bo5"])/(ONStmp[,"par4"]+ONStmp[,"par5"]),list(ONStmp[,"age"],ONStmp[,"coh"]),sum)
  ONS_rates_dat[[5]] <- aggregate(ONStmp[,"botot"]/ONStmp[,"Total"],list(ONStmp[,"age"],ONStmp[,"coh"]),sum)
  
  ONS_births_mat <- list()
  ONS_births_mat[[1]] <- tapply(ONStmp[,"bo1"],list(ONStmp[,"age"],ONStmp[,"coh"]),sum)
  ONS_births_mat[[2]] <- tapply(ONStmp[,"bo2"],list(ONStmp[,"age"],ONStmp[,"coh"]),sum)
  ONS_births_mat[[3]] <- tapply(ONStmp[,"bo3"],list(ONStmp[,"age"],ONStmp[,"coh"]),sum)
  ONS_births_mat[[4]] <- tapply((ONStmp[,"bo4"]+ONStmp[,"bo5"]),list(ONStmp[,"age"],ONStmp[,"coh"]),sum)
  ONS_births_mat[[5]] <- tapply(ONStmp[,"botot"],list(ONStmp[,"age"],ONStmp[,"coh"]),sum)
  
  ONS_births_dat <- list()
  ONS_births_dat[[1]] <- aggregate(ONStmp[,"bo1"],list(ONStmp[,"age"],ONStmp[,"coh"]),sum)
  ONS_births_dat[[2]] <- aggregate(ONStmp[,"bo2"],list(ONStmp[,"age"],ONStmp[,"coh"]),sum)
  ONS_births_dat[[3]] <- aggregate(ONStmp[,"bo3"],list(ONStmp[,"age"],ONStmp[,"coh"]),sum)
  ONS_births_dat[[4]] <- aggregate((ONStmp[,"bo4"]+ONStmp[,"bo5"]),list(ONStmp[,"age"],ONStmp[,"coh"]),sum)
  ONS_births_dat[[5]] <- aggregate(ONStmp[,"botot"],list(ONStmp[,"age"],ONStmp[,"coh"]),sum)
  
  ONS_expos_mat <- list()
  ONS_expos_mat[[1]] <- tapply(ONStmp[,"par1"],list(ONStmp[,"age"],ONStmp[,"coh"]),sum)
  ONS_expos_mat[[2]] <- tapply(ONStmp[,"par2"],list(ONStmp[,"age"],ONStmp[,"coh"]),sum)
  ONS_expos_mat[[3]] <- tapply(ONStmp[,"par3"],list(ONStmp[,"age"],ONStmp[,"coh"]),sum)
  ONS_expos_mat[[4]] <- tapply((ONStmp[,"par4"]+ONStmp[,"par5"]),list(ONStmp[,"age"],ONStmp[,"coh"]),sum)
  ONS_expos_mat[[5]] <- tapply(ONStmp[,"Total"],list(ONStmp[,"age"],ONStmp[,"coh"]),sum)
  
  ONS_expos_dat <- list()
  ONS_expos_dat[[1]] <- aggregate(ONStmp[,"par1"],list(ONStmp[,"age"],ONStmp[,"coh"]),sum)
  ONS_expos_dat[[2]] <- aggregate(ONStmp[,"par2"],list(ONStmp[,"age"],ONStmp[,"coh"]),sum)
  ONS_expos_dat[[3]] <- aggregate(ONStmp[,"par3"],list(ONStmp[,"age"],ONStmp[,"coh"]),sum)
  ONS_expos_dat[[4]] <- aggregate((ONStmp[,"par4"]+ONStmp[,"par5"]),list(ONStmp[,"age"],ONStmp[,"coh"]),sum)
  ONS_expos_dat[[5]] <- aggregate(ONStmp[,"Total"],list(ONStmp[,"age"],ONStmp[,"coh"]),sum)
  
  ONS_prop_mat <- list()
  ONS_prop_mat[[1]] <- tapply(ONStmp[,"par1"]/ONStmp[,"Total"],list(ONStmp[,"age"],ONStmp[,"coh"]),sum)
  ONS_prop_mat[[2]] <- tapply(ONStmp[,"par2"]/ONStmp[,"Total"],list(ONStmp[,"age"],ONStmp[,"coh"]),sum)
  ONS_prop_mat[[3]] <- tapply(ONStmp[,"par3"]/ONStmp[,"Total"],list(ONStmp[,"age"],ONStmp[,"coh"]),sum)
  ONS_prop_mat[[4]] <- tapply((ONStmp[,"par4"]+ONStmp[,"par5"])/ONStmp[,"Total"],list(ONStmp[,"age"],ONStmp[,"coh"]),sum)
  
  ONS_prop_dat <- list()
  ONS_prop_dat[[1]] <- aggregate(ONStmp[,"par1"]/ONStmp[,"Total"],list(ONStmp[,"age"],ONStmp[,"coh"]),sum)
  ONS_prop_dat[[2]] <- aggregate(ONStmp[,"par2"]/ONStmp[,"Total"],list(ONStmp[,"age"],ONStmp[,"coh"]),sum)
  ONS_prop_dat[[3]] <- aggregate(ONStmp[,"par3"]/ONStmp[,"Total"],list(ONStmp[,"age"],ONStmp[,"coh"]),sum)
  ONS_prop_dat[[4]] <- aggregate((ONStmp[,"par4"]+ONStmp[,"par5"])/ONStmp[,"Total"],list(ONStmp[,"age"],ONStmp[,"coh"]),sum)
  
  save(ONS_rates_mat, ONS_births_mat, ONS_expos_mat, ONS_prop_mat,
       ONS_rates_dat, ONS_births_dat, ONS_expos_dat, ONS_prop_dat,
       file=paste0("chap4/data/",filename))
}

procfunc(15:44, 1945:2003, 2018, "ONS2018_allc.RData")
procfunc(15:44, 1945:1992, 2007, "ONS2018_resc.RData")
