data {
  int N;
  int y[N,4];
  vector[N] cc;
  int h[N];
}

parameters {
  vector[3] beta0;
  vector[3] betaC;
  vector[2] betaH1raw;
  vector[2] betaH2raw;
  vector[2] betaH3raw;
  vector[2] betaCH1raw;
  vector[2] betaCH2raw;
  vector[2] betaCH3raw;
}

transformed parameters {
  simplex[4] theta[N];
  matrix[N,4] Yhat;
  vector[3] betaH1;
  vector[3] betaH2;
  vector[3] betaH3;
  vector[3] betaCH1;
  vector[3] betaCH2;
  vector[3] betaCH3;
  vector[N] betaCH1cc;
  vector[N] betaCH2cc;
  vector[N] betaCH3cc;
  betaH1[1] = 0;
  betaH2[1] = 0;
  betaH3[1] = 0;
  betaCH1[1] = 0;
  betaCH2[1] = 0;
  betaCH3[1] = 0;
  betaH1[2:3] = betaH1raw;
  betaH2[2:3] = betaH2raw;
  betaH3[2:3] = betaH3raw;
  betaCH1[2:3] = betaCH1raw;
  betaCH2[2:3] = betaCH2raw;
  betaCH3[2:3] = betaCH3raw;
  for (i in 1:N) {
    betaCH1cc[i] = betaCH1[h[i]]*cc[i];
    betaCH2cc[i] = betaCH2[h[i]]*cc[i];
    betaCH3cc[i] = betaCH3[h[i]]*cc[i];
  }
  Yhat[,1] = rep_vector(0,N);
  Yhat[,2] = beta0[1] + betaC[1]*cc + betaH1[h] + betaCH1cc;
  Yhat[,3] = beta0[2] + betaC[2]*cc + betaH2[h] + betaCH2cc;
  Yhat[,4] = beta0[3] + betaC[3]*cc + betaH3[h] + betaCH3cc;
  for (i in 1:N) {
    theta[i] = softmax(to_vector(Yhat[i,]));
  }
}

model {
  beta0 ~ normal(0,10);
  betaC ~ normal(0,10);
  betaH1raw ~ normal(0,10);
  betaH2raw ~ normal(0,10);
  betaH3raw ~ normal(0,10);
  betaCH1raw ~ normal(0,10);
  betaCH2raw ~ normal(0,10);
  betaCH3raw ~ normal(0,10);  for (i in 1:N) {
    target += multinomial_lpmf(y[i,] | theta[i]);
  }
}
