data {
  int N;
  int Nm;
  int Nf;
  int Nac;
  int Nc72;
  int Na;
  int Nobs;
  int betadim;
  int succ[N];
  int tot[N];
  int ONSn[Nm];
  int ONSN[Nm];
  int y[Nac,4];
  int ccind72[Nac];
  vector[Nac] cc72;
  int aind[Nac];
  vector[Nac] a;
  int ACind[Nm];
  int yind[Nobs];
  vector[Nac] wtc;
  vector[N] wt;
  matrix[N,betadim] X;
  matrix[Nf,betadim] Xf;
  matrix[N,4] Xq;
  matrix[Nf,4] Xqf;
  matrix[betadim,betadim] S1;
  matrix[betadim,betadim] S2;
  matrix[betadim,betadim] S3;
  matrix[betadim,betadim] S4;
  matrix[betadim,betadim] S5;
  matrix[betadim,betadim] S6;
  matrix[betadim,betadim] S7;
  matrix[betadim,betadim] S8;
}

parameters {
  vector[betadim] beta;
  vector[3] betaQraw;
  real beta0;
  vector[3] beta0ACQ;
  vector[Nc72-1] betaC1raw;
  vector[Nc72-1] betaC2raw;
  vector[Nc72-1] betaC3raw;
  vector[3] betaC;
  vector[Na-1] betaA3raw;
  vector[2] betaA;
  real<lower=0> sigmaA3;
  real<lower=0> tau1;
  real<lower=0> tau2;
  real<lower=0> tau3;
  real<lower=0> tau4;
  real<lower=0> tau5;
  real<lower=0> tau6;
  real<lower=0> tau7;
  real<lower=0> tau8;
}

transformed parameters {
  vector[N] Y_hat;
  row_vector[betadim] betat;
  matrix[betadim,betadim] S;
  vector[4] betaQ;
  vector[Nf] Y_hatf;
  vector[Nf] eY_hatf;
  vector[Nm] psurv;
  vector[Nm] lpsurv;
  simplex[4] theta[Nac];
  matrix[Nac,4] Y_hatACQ;
  vector[Nc72] betaC1;
  vector[Nc72] betaC2;
  vector[Nc72] betaC3;
  vector[Na] betaA3;  
  betaQ[1] = 0;
  betaQ[2:4] = betaQraw;
  betaC1[1] = 0;
  betaC2[1] = 0;
  betaC3[1] = 0;
  betaA3[1] = 0;
  betaC1[2:Nc72] = betaC1raw;
  betaC2[2:Nc72] = betaC2raw;
  betaC3[2:Nc72] = betaC3raw;
  betaA3[2:Na] = betaA3raw;
  Y_hatACQ[,1] = rep_vector(0,Nac);
  Y_hatACQ[,2] = beta0ACQ[1] + betaC1[ccind72] + betaC[1]*cc72 + betaA[1]*a;
  Y_hatACQ[,3] = beta0ACQ[2] + betaC2[ccind72] + betaC[2]*cc72 + betaA[2]*a;
  Y_hatACQ[,4] = beta0ACQ[3] + betaC3[ccind72] + betaC[3]*cc72 + betaA3[aind];  
  for (i in 1:Nac) {
    theta[i] = softmax(to_vector(Y_hatACQ[i,]));
  }
  S = S1/tau1 + S2/tau2 + S3/tau3 + S4/tau4 + S5/tau5 + S6/tau6 + S7/tau7 + S8/tau8;
  betat = beta';
  Y_hat = beta0 + Xq*betaQ + X*beta;
  Y_hatf = beta0 + Xqf*betaQ + Xf*beta;
  eY_hatf = inv_logit(Y_hatf);
  for (i in 1:Nm) {
    psurv[i] = theta[ACind[i],1]*eY_hatf[i] +
    theta[ACind[i],2]*eY_hatf[Nm+i] +
    theta[ACind[i],3]*eY_hatf[2*Nm+i] +
    theta[ACind[i],4]*eY_hatf[3*Nm+i];
  }
  lpsurv = logit(psurv);
}

model {
  beta0 ~ normal(0,10);
  betaQraw ~ normal(0,10);
  tau1 ~ normal(0,10);
  tau2 ~ normal(0,10);
  tau3 ~ normal(0,10);
  tau4 ~ normal(0,10);
  tau5 ~ normal(0,10);
  tau6 ~ normal(0,10);
  tau7 ~ normal(0,10);
  tau8 ~ normal(0,10);
  beta0ACQ ~ normal(0,10);
  betaC ~ normal(0,10);
  betaC1raw ~ normal(0,10);
  betaC2raw ~ normal(0,10);
  betaC3raw ~ normal(0,10);
  betaA ~ normal(0,10);
  betaA3raw[1] ~ normal(0,10);
  for (i in 2:(Na-1)) {
    betaA3raw[i] ~ normal(betaA3raw[i-1],sigmaA3);
  }
  sigmaA3 ~ normal(0,0.01);
  for (i in yind) {
    target += wtc[i] * multinomial_lpmf(y[i,] | theta[i]);
  }
  for (n in 1:N) {
    target += 0.996*wt[n]*binomial_logit_lpmf(succ[n] | tot[n], Y_hat[n]);
  }
  for (m in 1:Nm) {
    target += 0.004*binomial_logit_lpmf(ONSn[m] | ONSN[m], lpsurv[m]);
  }
  target += 0.5*log_determinant(S)-0.5*betat*S*beta;
}
