##X+Q+XQ uncertainty
xqxq <- function(mod,x,q,xval,qval,data,k,sx,sq,plot=F){
 V_beta0 <- mod$Vp
 Xstar <- list()
 dat1 <- data[1,]
 dat <- dat1
 for (i in 1:(length(xval)-1)) dat <- rbind(dat,dat1)
 dat[,x] <- xval
 for (i in qval) {
   dat[,q] <- i
   Xstar[[i]] <- predict.gam(mod,newdata=dat,type="lpmatrix")
 }
 d <- matrix(0,length(qval),nrow(V_beta0))
 cols <- colnames(Xstar[[1]])
 for (i in qval) {
   ind <- numeric()
   if (i > 1) ind <- c(ind, which(cols==paste0(q,i)))
   ind <- c(ind, which(cols%in%paste0(paste("s(",x,").",sep=""),1:k)))
   ind <- c(ind, which(cols%in%paste0(paste("s(",x,"):",q,i,".",sep=""),1:k)))
   d[i,ind] <- 1
 }
 Tstar <- Xstar
 for (i in qval) {
   for (j in 1:length(xval)) Tstar[[i]][j,] <- d[i,]*Tstar[[i]][j,]
 }
 Vstar <- list()
 for (i in qval) Vstar[[i]] <- Tstar[[i]]%*%V_beta0%*%t(Tstar[[i]])
 out <- list()
 out$fit <- out$lower <- out$upper <- matrix(0,length(xval),length(qval))
 for (i in qval) {
   out$fit[,i] <- Tstar[[i]]%*%coef(mod)
   out$lower[,i] <- Tstar[[i]]%*%coef(mod)-2*sqrt(diag(Vstar[[i]]))
   out$upper[,i] <- Tstar[[i]]%*%coef(mod)+2*sqrt(diag(Vstar[[i]]))
 }
 if (plot) {
   par(mfrow=c(1,length(qval)))
   for (i in qval) {
     plot(xval,out$fit[,i],ylim=range(unlist(out)),type="l",main=paste(sq," = ",i,sep=""),xlab=sx,ylab=paste(sq,"+s(",sx,")+s(",sx,",",sq,")",sep=""))
     lines(xval,out$lower[,i],lty=2)
     lines(xval,out$upper[,i],lty=2)
   }
   }
 out
}
