##Model selection
library(mgcv)

#Set up factor covariates
qualf2aimp_0 <- as.factor(qualf2aimp_0)
qualf2aimp_1 <- as.factor(qualf2aimp_1)
qualf2aimp_2 <- as.factor(qualf2aimp_2)
qualf2aimp_3 <- as.factor(qualf2aimp_3)

qualf2bimp_0 <- as.factor(qualf2bimp_0)
qualf2bimp_1 <- as.factor(qualf2bimp_1)
qualf2bimp_2 <- as.factor(qualf2bimp_2)
qualf2bimp_3 <- as.factor(qualf2bimp_3)

qualf2cimp_0 <- as.factor(qualf2cimp_0)
qualf2cimp_1 <- as.factor(qualf2cimp_1)
qualf2cimp_2 <- as.factor(qualf2cimp_2)
qualf2cimp_3 <- as.factor(qualf2cimp_3)

qualf3aimp_0 <- as.factor(qualf3aimp_0)
qualf3aimp_1 <- as.factor(qualf3aimp_1)
qualf3aimp_2 <- as.factor(qualf3aimp_2)
qualf3aimp_3 <- as.factor(qualf3aimp_3)

qualf3bimp_0 <- as.factor(qualf3bimp_0)
qualf3bimp_1 <- as.factor(qualf3bimp_1)
qualf3bimp_2 <- as.factor(qualf3bimp_2)
qualf3bimp_3 <- as.factor(qualf3bimp_3)

qualf3cimp_0 <- as.factor(qualf3cimp_0)
qualf3cimp_1 <- as.factor(qualf3cimp_1)
qualf3cimp_2 <- as.factor(qualf3cimp_2)
qualf3cimp_3 <- as.factor(qualf3cimp_3)

qualf4imp_0 <- as.factor(qualf4imp_0)
qualf4imp_1 <- as.factor(qualf4imp_1)
qualf4imp_2 <- as.factor(qualf4imp_2)
qualf4imp_3 <- as.factor(qualf4imp_3)

HDIc2a_0 <- as.factor(HDIc2a_0)
HDIc2a_1 <- as.factor(HDIc2a_1)
HDIc2a_2 <- as.factor(HDIc2a_2)
HDIc2a_3 <- as.factor(HDIc2a_3)

HDIc2b_0 <- as.factor(HDIc2b_0)
HDIc2b_1 <- as.factor(HDIc2b_1)
HDIc2b_2 <- as.factor(HDIc2b_2)
HDIc2b_3 <- as.factor(HDIc2b_3)

HDIc2c_0 <- as.factor(HDIc2c_0)
HDIc2c_1 <- as.factor(HDIc2c_1)
HDIc2c_2 <- as.factor(HDIc2c_2)
HDIc2c_3 <- as.factor(HDIc2c_3)

HDIc2d_0 <- as.factor(HDIc2d_0)
HDIc2d_1 <- as.factor(HDIc2d_1)
HDIc2d_2 <- as.factor(HDIc2d_2)
HDIc2d_3 <- as.factor(HDIc2d_3)

HDIc3a_0 <- as.factor(HDIc3a_0)
HDIc3a_1 <- as.factor(HDIc3a_1)
HDIc3a_2 <- as.factor(HDIc3a_2)
HDIc3a_3 <- as.factor(HDIc3a_3)

HDIc3b_0 <- as.factor(HDIc3b_0)
HDIc3b_1 <- as.factor(HDIc3b_1)
HDIc3b_2 <- as.factor(HDIc3b_2)
HDIc3b_3 <- as.factor(HDIc3b_3)

HDIc3c_0 <- as.factor(HDIc3c_0)
HDIc3c_1 <- as.factor(HDIc3c_1)
HDIc3c_2 <- as.factor(HDIc3c_2)
HDIc3c_3 <- as.factor(HDIc3c_3)

HDIc3d_0 <- as.factor(HDIc3d_0)
HDIc3d_1 <- as.factor(HDIc3d_1)
HDIc3d_2 <- as.factor(HDIc3d_2)
HDIc3d_3 <- as.factor(HDIc3d_3)

HDIc3e_0 <- as.factor(HDIc3e_0)
HDIc3e_1 <- as.factor(HDIc3e_1)
HDIc3e_2 <- as.factor(HDIc3e_2)
HDIc3e_3 <- as.factor(HDIc3e_3)

HDIc3f_0 <- as.factor(HDIc3f_0)
HDIc3f_1 <- as.factor(HDIc3f_1)
HDIc3f_2 <- as.factor(HDIc3f_2)
HDIc3f_3 <- as.factor(HDIc3f_3)

HDIc4a_0 <- as.factor(HDIc4a_0)
HDIc4a_1 <- as.factor(HDIc4a_1)
HDIc4a_2 <- as.factor(HDIc4a_2)
HDIc4a_3 <- as.factor(HDIc4a_3)

HDIc4b_0 <- as.factor(HDIc4b_0)
HDIc4b_1 <- as.factor(HDIc4b_1)
HDIc4b_2 <- as.factor(HDIc4b_2)
HDIc4b_3 <- as.factor(HDIc4b_3)

HDIc4c_0 <- as.factor(HDIc4c_0)
HDIc4c_1 <- as.factor(HDIc4c_1)
HDIc4c_2 <- as.factor(HDIc4c_2)
HDIc4c_3 <- as.factor(HDIc4c_3)

HDIc4d_0 <- as.factor(HDIc4d_0)
HDIc4d_1 <- as.factor(HDIc4d_1)
HDIc4d_2 <- as.factor(HDIc4d_2)
HDIc4d_3 <- as.factor(HDIc4d_3)

HDIc5_0 <- as.factor(HDIc5_0)
HDIc5_1 <- as.factor(HDIc5_1)
HDIc5_2 <- as.factor(HDIc5_2)
HDIc5_3 <- as.factor(HDIc5_3)

#Grouping data function
groupfuncw <- function(wts,bir,covs) {
  f     <- as.formula(paste(wts, "~", bir, "+", paste(covs,collapse="+"), sep=""))
  agg1  <- aggregate(f, FUN=function(x) succ=sum(x))
  join1 <- dplyr::full_join(x=agg1[agg1[,bir]==0,],
                            y=agg1[agg1[,bir]==1,],
                            by=covs)[,c(covs,paste(wts,".x",sep=""),paste(wts,".y",sep=""))]
  join1[which(is.na(join1[,paste(wts,".x",sep="")])),paste(wts,".x",sep="")] <- 0
  join1[which(is.na(join1[,paste(wts,".y",sep="")])),paste(wts,".y",sep="")] <- 0
  join1$n  <- join1[,paste(wts,".x",sep="")] + join1[,paste(wts,".y",sep="")]
  join1$s  <- join1[,paste(wts,".y",sep="")]
  join1$p  <- join1$s / join1$n
  join1    <- join1[which(join1$n>0),]
  join1    <- join1[,c(covs,"n","s","p")] #,"nr","sr","pr")]
  join1
}

#Smooth terms functions
k <- 9 # k-1 basis functions
d <- 1  # dth order difference penalty
f_s1 <- function(cov) paste("s(",cov,",bs='ps',k=",k,",m=c(2,",d,"))", sep="")
f_s2 <- function(cov1,cov2) paste("s(",cov1,",by=",cov2,",bs='ps',k=",k,",m=c(2,",d,"))", sep="")
f_f2 <- function(cov1,cov2) paste(cov1,":",cov2, sep="")
f_ti <- function(cov1,cov2) paste("ti(",cov1,",",cov2,",bs=c('ps','ps'),k=c(",k,",",k,"),d=c(1,1),m=list(c(2,",d,"),c(2,",d,")))", sep="")

#Knots function
knotsfunc <- function(x,k)
  seq(min(x)-3*(max(x)-min(x))/(k-3),max(x)+3*(max(x)-min(x))/(k-3),by=(max(x)-min(x))/(k-3))

kfunc <- function(ind,dgw) {
  out <- list()
  for (i in ind)
    out[[names(dgw)[i]]] <- knotsfunc(dgw[,i],k)
  out
}

#Update results function
updatefunc <- function(ind,gam,dgw,results) {
  results[ind,"logLik"]   <- round(logLik(gam)[[1]],2)
  results[ind,"phat"]     <- round(attr(logLik(gam),"df"),2)
  results[ind,"BIC_npyw"] <- results[ind,"phat"]*log(sum(dgw$n))-2*results[ind,"logLik"]
  results[ind,"BIC_nbw"]  <- results[ind,"phat"]*log(sum(dgw$n*dgw$p))-2*results[ind,"logLik"]
  results[ind,"AICc"]     <- AIC(gam)
  print(paste0("Model ",ind," fitted"))
  results
}

#Parity 0
dgw <- groupfuncw("weights_0st", "birth.bin_0", c("age_0", "coh_0", "qualf2aimp_0", "qualf2bimp_0", "qualf2cimp_0",
                                                  "qualf3aimp_0", "qualf3bimp_0", "qualf3cimp_0", "qualf4imp_0",
                                                  "HDIc2a_0", "HDIc2b_0", "HDIc2c_0", "HDIc2d_0",
                                                  "HDIc3a_0", "HDIc3b_0", "HDIc3c_0", "HDIc3d_0", "HDIc3e_0", "HDIc3f_0",
                                                  "HDIc4a_0", "HDIc4b_0", "HDIc4c_0", "HDIc4d_0", "HDIc5_0"))
covs <- names(dgw)
results <- data.frame(model=c("Null","A","C","A + C","A + C + AC",
                              "Ch(1) + Q2a", "Ch(1) + Q2b", "Ch(1) + Q2c", "Ch(1) + Q3a","Ch(1) + Q3b", "Ch(1) + Q3c", "Ch(1) + Q4",
                              "Ch(1) + Q2a + AQ2a", "Ch(1) + Q2b + AQ2b", "Ch(1) + Q2c + AQ2c", "Ch(1) + Q3a + AQ3a", "Ch(1) + Q3b + AQ3b", "Ch(1) + Q3c + AQ3c", "Ch(1) + Q4 + AQ4",
                              "Ch(1) + Q2a + CQ2a", "Ch(1) + Q2b + CQ2b", "Ch(1) + Q2c + CQ2c", "Ch(1) + Q3a + CQ3a", "Ch(1) + Q3b + CQ3b", "Ch(1) + Q3c + CQ3c", "Ch(1) + Q4 + CQ4",
                              "Ch(1) + Q2a + AQ2a + CQ2a", "Ch(1) + Q2b + AQ2b + CQ2b", "Ch(1) + Q2c + AQ2c + CQ2c", "Ch(1) + Q3a + AQ3a + CQ3a", "Ch(1) + Q3b + AQ3b + CQ3b", "Ch(1) + Q3c + AQ3c + CQ3c", "Ch(1) + Q4 + AQ4 + CQ4",
                              "Ch(2) + H2a","Ch(2) + H2b","Ch(2) + H2c","Ch(2) + H2d",
                              "Ch(2) + H3a","Ch(2) + H3b","Ch(2) + H3c","Ch(2) + H3d","Ch(2) + H3e","Ch(2) + H3f",
                              "Ch(2) + H4a","Ch(2) + H4b","Ch(2) + H4c","Ch(2) + H4d","Ch(2) + H5",
                              "Ch(2) + H2a + AH2a","Ch(2) + H2b + AH2b","Ch(2) + H2c + AH2c","Ch(2) + H2d + AH2d",
                              "Ch(2) + H3a + AH3a","Ch(2) + H3b + AH3b","Ch(2) + H3c + AH3c","Ch(2) + H3d + AH3d","Ch(2) + H3e + AH3e","Ch(2) + H3f + AH3f",
                              "Ch(2) + H4a + AH4a","Ch(2) + H4b + AH4b","Ch(2) + H4c + AH4c","Ch(2) + H4d + AH4d","Ch(2) + H5 + AH5"),
                      logLik=0,phat=0,BIC_npyw=0,BIC_nbw=0,AICc=0,chosen=0)

###Stage 1
print("Parity 0 starting, 63 models to fit")
#1. Null
f1 <- as.formula(paste("p~1"))
gam1 <- gam(f1, family=binomial, method="REML", weights=n, data=dgw)
results <- updatefunc(1,gam1,dgw,results)
#2. A
f2 <- update(f1, as.formula(paste("~.+",f_s1(covs[1]),sep="")))
gam2 <- gam(f2, family=binomial, method="REML", weights=n, data=dgw, knots=kfunc(1,dgw))
results <- updatefunc(2,gam2,dgw,results)
#3. C
f3 <- update(f1, as.formula(paste("~.+",f_s1(covs[2]),sep="")))
gam3 <- gam(f3, family=binomial, method="REML", weights=n, data=dgw, knots=kfunc(2,dgw))
results <- updatefunc(3,gam3,dgw,results)
#4. A + C
f4 <- update(f2, as.formula(paste("~.+",f_s1(covs[2]),sep="")))
gam4 <- gam(f4, family=binomial, method="REML", weights=n, data=dgw, knots=kfunc(c(1,2),dgw))
results <- updatefunc(4,gam4,dgw,results)
#5. A + C + AC
f5 <- update(f4, as.formula(paste("~.+",f_ti(covs[1],covs[2]),sep="")))
gam5 <- gam(f5, family=binomial, method="REML", weights=n, data=dgw, knots=kfunc(c(1,2),dgw))
results <- updatefunc(5,gam5,dgw,results)
#Ch(1)
Ch1_npyw <- which.min(results$BIC_npyw[1:5])
Ch1_nbw  <- which.min(results$BIC_nbw[1:5])
if (Ch1_npyw==Ch1_nbw) {
  results$chosen[Ch1_npyw] <- 1
  f_1 <- c(f1,f2,f3,f4,f5)[[Ch1_npyw]]
}
if (Ch1_npyw<Ch1_nbw) {
  results$chosen[Ch1_nbw] <- 1
  f_1 <- c(f1,f2,f3,f4,f5)[[Ch1_nbw]]
}

###Stage 2
#6. Ch(1) + Q2a
f6 <- update(f_1, as.formula(paste("~.+",covs[3],sep="")))
gam6 <- gam(f6, family=binomial, method="REML", weights=n, data=dgw, knots=kfunc(c(1,2),dgw))
results <- updatefunc(6,gam6,dgw,results)
#7. Ch(1) + Q2b
f7 <- update(f_1, as.formula(paste("~.+",covs[4],sep="")))
gam7 <- gam(f7, family=binomial, method="REML", weights=n, data=dgw, knots=kfunc(c(1,2),dgw))
results <- updatefunc(7,gam7,dgw,results)
#8. Ch(1) + Q2c
f8 <- update(f_1, as.formula(paste("~.+",covs[5],sep="")))
gam8 <- gam(f8, family=binomial, method="REML", weights=n, data=dgw, knots=kfunc(c(1,2),dgw))
results <- updatefunc(8,gam8,dgw,results)
#9. Ch(1) + Q3a
f9 <- update(f_1, as.formula(paste("~.+",covs[6],sep="")))
gam9 <- gam(f9, family=binomial, method="REML", weights=n, data=dgw, knots=kfunc(c(1,2),dgw))
results <- updatefunc(9,gam9,dgw,results)
#9. Ch(1) + Q3b
f10 <- update(f_1, as.formula(paste("~.+",covs[7],sep="")))
gam10 <- gam(f10, family=binomial, method="REML", weights=n, data=dgw, knots=kfunc(c(1,2),dgw))
results <- updatefunc(10,gam10,dgw,results)
#11. Ch(1) + Q3c
f11 <- update(f_1, as.formula(paste("~.+",covs[8],sep="")))
gam11 <- gam(f11, family=binomial, method="REML", weights=n, data=dgw, knots=kfunc(c(1,2),dgw))
results <- updatefunc(11,gam11,dgw,results)
#12. Ch(1) + Q4
f12 <- update(f_1, as.formula(paste("~.+",covs[9],sep="")))
gam12 <- gam(f12, family=binomial, method="REML", weights=n, data=dgw, knots=kfunc(c(1,2),dgw))
results <- updatefunc(12,gam12,dgw,results)

#13. Ch(1) + Q2a + AQ2a
f13 <- update(f6, as.formula(paste("~.+",f_s2(covs[1],covs[3]),sep="")))
gam13 <- gam(f13, family=binomial, method="REML", weights=n, data=dgw, knots=kfunc(c(1,2),dgw))
results <- updatefunc(13,gam13,dgw,results)
#14. Ch(1) + Q2b + AQ2b
f14 <- update(f7, as.formula(paste("~.+",f_s2(covs[1],covs[4]),sep="")))
gam14 <- gam(f14, family=binomial, method="REML", weights=n, data=dgw, knots=kfunc(c(1,2),dgw))
results <- updatefunc(14,gam14,dgw,results)
#15. Ch(1) + Q2c + AQ2c
f15 <- update(f8, as.formula(paste("~.+",f_s2(covs[1],covs[5]),sep="")))
gam15 <- gam(f15, family=binomial, method="REML", weights=n, data=dgw, knots=kfunc(c(1,2),dgw))
results <- updatefunc(15,gam15,dgw,results)
#16. Ch(1) + Q3a + AQ3a
f16 <- update(f9, as.formula(paste("~.+",f_s2(covs[1],covs[6]),sep="")))
gam16 <- gam(f16, family=binomial, method="REML", weights=n, data=dgw, knots=kfunc(c(1,2),dgw))
results <- updatefunc(16,gam16,dgw,results)
#17. Ch(1) + Q3b + AQ3b
f17 <- update(f10, as.formula(paste("~.+",f_s2(covs[1],covs[7]),sep="")))
gam17 <- gam(f17, family=binomial, method="REML", weights=n, data=dgw, knots=kfunc(c(1,2),dgw))
results <- updatefunc(17,gam17,dgw,results)
#18. Ch(1) + Q3c + AQ3c
f18 <- update(f11, as.formula(paste("~.+",f_s2(covs[1],covs[8]),sep="")))
gam18 <- gam(f18, family=binomial, method="REML", weights=n, data=dgw, knots=kfunc(c(1,2),dgw))
results <- updatefunc(18,gam18,dgw,results)
#19. Ch(1) + Q4 + AQ4
f19 <- update(f12, as.formula(paste("~.+",f_s2(covs[1],covs[9]),sep="")))
gam19 <- gam(f19, family=binomial, method="REML", weights=n, data=dgw, knots=kfunc(c(1,2),dgw))
results <- updatefunc(19,gam19,dgw,results)

#20. Ch(1) + Q2a + CQ2a
f20 <- update(f6, as.formula(paste("~.+",f_s2(covs[2],covs[3]),sep="")))
gam20 <- gam(f20, family=binomial, method="REML", weights=n, data=dgw, knots=kfunc(c(1,2),dgw))
results <- updatefunc(20,gam20,dgw,results)
#21. Ch(1) + Q2b + CQ2b
f21 <- update(f7, as.formula(paste("~.+",f_s2(covs[2],covs[4]),sep="")))
gam21 <- gam(f21, family=binomial, method="REML", weights=n, data=dgw, knots=kfunc(c(1,2),dgw))
results <- updatefunc(21,gam21,dgw,results)
#22. Ch(1) + Q2c + CQ2c
f22 <- update(f8, as.formula(paste("~.+",f_s2(covs[2],covs[5]),sep="")))
gam22 <- gam(f22, family=binomial, method="REML", weights=n, data=dgw, knots=kfunc(c(1,2),dgw))
results <- updatefunc(22,gam22,dgw,results)
#23. Ch(1) + Q3a + CQ3a
f23 <- update(f9, as.formula(paste("~.+",f_s2(covs[2],covs[6]),sep="")))
gam23 <- gam(f23, family=binomial, method="REML", weights=n, data=dgw, knots=kfunc(c(1,2),dgw))
results <- updatefunc(23,gam23,dgw,results)
#24. Ch(1) + Q3b + CQ3b
f24 <- update(f10, as.formula(paste("~.+",f_s2(covs[2],covs[7]),sep="")))
gam24 <- gam(f24, family=binomial, method="REML", weights=n, data=dgw, knots=kfunc(c(1,2),dgw))
results <- updatefunc(24,gam24,dgw,results)
#25. Ch(1) + Q3c + CQ3c
f25 <- update(f11, as.formula(paste("~.+",f_s2(covs[2],covs[8]),sep="")))
gam25 <- gam(f25, family=binomial, method="REML", weights=n, data=dgw, knots=kfunc(c(1,2),dgw))
results <- updatefunc(25,gam25,dgw,results)
#26. Ch(1) + Q4 + CQ4
f26 <- update(f12, as.formula(paste("~.+",f_s2(covs[2],covs[9]),sep="")))
gam26 <- gam(f26, family=binomial, method="REML", weights=n, data=dgw, knots=kfunc(c(1,2),dgw))
results <- updatefunc(26,gam26,dgw,results)

#27. Ch(1) + Q2a + AQ2a + CQ2a
f27 <- update(f13, as.formula(paste("~.+",f_s2(covs[2],covs[3]),sep="")))
gam27 <- gam(f27, family=binomial, method="REML", weights=n, data=dgw, knots=kfunc(c(1,2),dgw))
results <- updatefunc(27,gam27,dgw,results)
#28. Ch(1) + Q2b + AQ2b + CQ2b
f28 <- update(f14, as.formula(paste("~.+",f_s2(covs[2],covs[4]),sep="")))
gam28 <- gam(f28, family=binomial, method="REML", weights=n, data=dgw, knots=kfunc(c(1,2),dgw))
results <- updatefunc(28,gam28,dgw,results)
#29. Ch(1) + Q2c + AQ2c + CQ2c
f29 <- update(f15, as.formula(paste("~.+",f_s2(covs[2],covs[5]),sep="")))
gam29 <- gam(f29, family=binomial, method="REML", weights=n, data=dgw, knots=kfunc(c(1,2),dgw))
results <- updatefunc(29,gam29,dgw,results)
#30. Ch(1) + Q3a + AQ3a + CQ3a
f30 <- update(f16, as.formula(paste("~.+",f_s2(covs[2],covs[6]),sep="")))
gam30 <- gam(f30, family=binomial, method="REML", weights=n, data=dgw, knots=kfunc(c(1,2),dgw))
results <- updatefunc(30,gam30,dgw,results)
#31. Ch(1) + Q3b + AQ3b + CQ3b
f31 <- update(f17, as.formula(paste("~.+",f_s2(covs[2],covs[7]),sep="")))
gam31 <- gam(f31, family=binomial, method="REML", weights=n, data=dgw, knots=kfunc(c(1,2),dgw))
results <- updatefunc(31,gam31,dgw,results)
#32. Ch(1) + Q3c + AQ3c + CQ3c
f32 <- update(f18, as.formula(paste("~.+",f_s2(covs[2],covs[8]),sep="")))
gam32 <- gam(f32, family=binomial, method="REML", weights=n, data=dgw, knots=kfunc(c(1,2),dgw))
results <- updatefunc(32,gam32,dgw,results)
#33. Ch(1) + Q4 + AQ4 + CQ4
f33 <- update(f19, as.formula(paste("~.+",f_s2(covs[2],covs[9]),sep="")))
gam33 <- gam(f33, family=binomial, method="REML", weights=n, data=dgw, knots=kfunc(c(1,2),dgw))
results <- updatefunc(33,gam33,dgw,results)

#Ch(2)
Ch2_npyw <- which.min(results$BIC_npyw[1:33])
Ch2_nbw  <- which.min(results$BIC_nbw[1:33])
if (Ch2_npyw==Ch2_nbw) {
  results$chosen[Ch2_npyw] <- 1
  f_2 <- c(f1,f2,f3,f4,f5,f6,f7,f8,f9,f10,f11,f12,f13,f14,f15,f16,f17,f18,f19,f20,
           f21,f22,f23,f24,f25,f26,f27,f28,f29,f30,f31,f32,f33)[[Ch2_npyw]]
}
if (Ch2_npyw<Ch2_nbw) {
  results$chosen[Ch2_nbw] <- 1
  f_2 <- c(f1,f2,f3,f4,f5,f6,f7,f8,f9,f10,f11,f12,f13,f14,f15,f16,f17,f18,f19,f20,
           f21,f22,f23,f24,f25,f26,f27,f28,f29,f30,f31,f32,f33)[[Ch2_nbw]]
}

###Stage 3
#34. Ch(2) + H2a
f34 <- update(f_2, as.formula(paste("~.+",covs[10],sep="")))
gam34 <- gam(f34, family=binomial, method="REML", weights=n, data=dgw, knots=kfunc(c(1,2),dgw))
results <- updatefunc(34,gam34,dgw,results)
#35. Ch(2) + H2b
f35 <- update(f_2, as.formula(paste("~.+",covs[11],sep="")))
gam35 <- gam(f35, family=binomial, method="REML", weights=n, data=dgw, knots=kfunc(c(1,2),dgw))
results <- updatefunc(35,gam35,dgw,results)
#36. Ch(2) + H2c
f36 <- update(f_2, as.formula(paste("~.+",covs[12],sep="")))
gam36 <- gam(f36, family=binomial, method="REML", weights=n, data=dgw, knots=kfunc(c(1,2),dgw))
results <- updatefunc(36,gam36,dgw,results)
#37. Ch(2) + H2d
f37 <- update(f_2, as.formula(paste("~.+",covs[13],sep="")))
gam37 <- gam(f37, family=binomial, method="REML", weights=n, data=dgw, knots=kfunc(c(1,2),dgw))
results <- updatefunc(37,gam37,dgw,results)
#38. Ch(2) + H3a
f38 <- update(f_2, as.formula(paste("~.+",covs[14],sep="")))
gam38 <- gam(f38, family=binomial, method="REML", weights=n, data=dgw, knots=kfunc(c(1,2),dgw))
results <- updatefunc(38,gam38,dgw,results)
#39. Ch(2) + H3b
f39 <- update(f_2, as.formula(paste("~.+",covs[15],sep="")))
gam39 <- gam(f39, family=binomial, method="REML", weights=n, data=dgw, knots=kfunc(c(1,2),dgw))
results <- updatefunc(39,gam39,dgw,results)
#40. Ch(2) + H3c
f40 <- update(f_2, as.formula(paste("~.+",covs[16],sep="")))
gam40 <- gam(f40, family=binomial, method="REML", weights=n, data=dgw, knots=kfunc(c(1,2),dgw))
results <- updatefunc(40,gam40,dgw,results)
#41. Ch(2) + H3d
f41 <- update(f_2, as.formula(paste("~.+",covs[17],sep="")))
gam41 <- gam(f41, family=binomial, method="REML", weights=n, data=dgw, knots=kfunc(c(1,2),dgw))
results <- updatefunc(41,gam41,dgw,results)
#42. Ch(2) + H3e
f42 <- update(f_2, as.formula(paste("~.+",covs[18],sep="")))
gam42 <- gam(f42, family=binomial, method="REML", weights=n, data=dgw, knots=kfunc(c(1,2),dgw))
results <- updatefunc(42,gam42,dgw,results)
#43. Ch(2) + H3f
f43 <- update(f_2, as.formula(paste("~.+",covs[19],sep="")))
gam43 <- gam(f43, family=binomial, method="REML", weights=n, data=dgw, knots=kfunc(c(1,2),dgw))
results <- updatefunc(43,gam43,dgw,results)
#44. Ch(2) + H4a
f44 <- update(f_2, as.formula(paste("~.+",covs[20],sep="")))
gam44 <- gam(f44, family=binomial, method="REML", weights=n, data=dgw, knots=kfunc(c(1,2),dgw))
results <- updatefunc(44,gam44,dgw,results)
#45. Ch(2) + H4b
f45 <- update(f_2, as.formula(paste("~.+",covs[21],sep="")))
gam45 <- gam(f45, family=binomial, method="REML", weights=n, data=dgw, knots=kfunc(c(1,2),dgw))
results <- updatefunc(45,gam45,dgw,results)
#46. Ch(2) + H4c
f46 <- update(f_2, as.formula(paste("~.+",covs[22],sep="")))
gam46 <- gam(f46, family=binomial, method="REML", weights=n, data=dgw, knots=kfunc(c(1,2),dgw))
results <- updatefunc(46,gam46,dgw,results)
#47. Ch(2) + H4d
f47 <- update(f_2, as.formula(paste("~.+",covs[23],sep="")))
gam47 <- gam(f47, family=binomial, method="REML", weights=n, data=dgw, knots=kfunc(c(1,2),dgw))
results <- updatefunc(47,gam47,dgw,results)
#48. Ch(2) + H5
f48 <- update(f_2, as.formula(paste("~.+",covs[24],sep="")))
gam48 <- gam(f48, family=binomial, method="REML", weights=n, data=dgw, knots=kfunc(c(1,2),dgw))
results <- updatefunc(48,gam48,dgw,results)

#49. Ch(2) + H2a + AH2a
f49 <- update(f34, as.formula(paste("~.+",f_s2(covs[1],covs[10]),sep="")))
gam49 <- gam(f49, family=binomial, method="REML", weights=n, data=dgw, knots=kfunc(c(1,2),dgw))
results <- updatefunc(49,gam49,dgw,results)
#50. Ch(2) + H2b + AH2b
f50 <- update(f35, as.formula(paste("~.+",f_s2(covs[1],covs[11]),sep="")))
gam50 <- gam(f50, family=binomial, method="REML", weights=n, data=dgw, knots=kfunc(c(1,2),dgw))
results <- updatefunc(50,gam50,dgw,results)
#51. Ch(2) + H2b + AH2c
f51 <- update(f36, as.formula(paste("~.+",f_s2(covs[1],covs[12]),sep="")))
gam51 <- gam(f51, family=binomial, method="REML", weights=n, data=dgw, knots=kfunc(c(1,2),dgw))
results <- updatefunc(51,gam51,dgw,results)
#52. Ch(2) + H2b + AH2d
f52 <- update(f37, as.formula(paste("~.+",f_s2(covs[1],covs[13]),sep="")))
gam52 <- gam(f52, family=binomial, method="REML", weights=n, data=dgw, knots=kfunc(c(1,2),dgw))
results <- updatefunc(52,gam52,dgw,results)
#53. Ch(2) + H3 + AH3a
f53 <- update(f38, as.formula(paste("~.+",f_s2(covs[1],covs[14]),sep="")))
gam53 <- gam(f53, family=binomial, method="REML", weights=n, data=dgw, knots=kfunc(c(1,2),dgw))
results <- updatefunc(53,gam53,dgw,results)
#54. Ch(2) + H3 + AH3b
f54 <- update(f39, as.formula(paste("~.+",f_s2(covs[1],covs[15]),sep="")))
gam54 <- gam(f54, family=binomial, method="REML", weights=n, data=dgw, knots=kfunc(c(1,2),dgw))
results <- updatefunc(54,gam54,dgw,results)
#55. Ch(2) + H3 + AH3c
f55 <- update(f40, as.formula(paste("~.+",f_s2(covs[1],covs[16]),sep="")))
gam55 <- gam(f55, family=binomial, method="REML", weights=n, data=dgw, knots=kfunc(c(1,2),dgw))
results <- updatefunc(55,gam55,dgw,results)
#56. Ch(2) + H3 + AH3d
f56 <- update(f41, as.formula(paste("~.+",f_s2(covs[1],covs[17]),sep="")))
gam56 <- gam(f56, family=binomial, method="REML", weights=n, data=dgw, knots=kfunc(c(1,2),dgw))
results <- updatefunc(56,gam56,dgw,results)
#57. Ch(2) + H3 + AH3e
f57 <- update(f42, as.formula(paste("~.+",f_s2(covs[1],covs[18]),sep="")))
gam57 <- gam(f57, family=binomial, method="REML", weights=n, data=dgw, knots=kfunc(c(1,2),dgw))
results <- updatefunc(57,gam57,dgw,results)
#58. Ch(2) + H3 + AH3f
f58 <- update(f43, as.formula(paste("~.+",f_s2(covs[1],covs[19]),sep="")))
gam58 <- gam(f58, family=binomial, method="REML", weights=n, data=dgw, knots=kfunc(c(1,2),dgw))
results <- updatefunc(58,gam58,dgw,results)
#59. Ch(2) + H4 + AH4a
f59 <- update(f44, as.formula(paste("~.+",f_s2(covs[1],covs[20]),sep="")))
gam59 <- gam(f59, family=binomial, method="REML", weights=n, data=dgw, knots=kfunc(c(1,2),dgw))
results <- updatefunc(59,gam59,dgw,results)
#60. Ch(2) + H4 + AH4b
f60 <- update(f45, as.formula(paste("~.+",f_s2(covs[1],covs[21]),sep="")))
gam60 <- gam(f60, family=binomial, method="REML", weights=n, data=dgw, knots=kfunc(c(1,2),dgw))
results <- updatefunc(60,gam60,dgw,results)
#61. Ch(2) + H4 + AH4c
f61 <- update(f46, as.formula(paste("~.+",f_s2(covs[1],covs[22]),sep="")))
gam61 <- gam(f61, family=binomial, method="REML", weights=n, data=dgw, knots=kfunc(c(1,2),dgw))
results <- updatefunc(61,gam61,dgw,results)
#62. Ch(2) + H4 + AH4d
f62 <- update(f47, as.formula(paste("~.+",f_s2(covs[1],covs[23]),sep="")))
gam62 <- gam(f62, family=binomial, method="REML", weights=n, data=dgw, knots=kfunc(c(1,2),dgw))
results <- updatefunc(62,gam62,dgw,results)
#63. Ch(2) + H5 + AH5
f63 <- update(f48, as.formula(paste("~.+",f_s2(covs[1],covs[24]),sep="")))
gam63 <- gam(f63, family=binomial, method="REML", weights=n, data=dgw, knots=kfunc(c(1,2),dgw))
results <- updatefunc(63,gam63,dgw,results)

#Ch(3)
Ch3_npyw <- which.min(results$BIC_npyw[1:63])
Ch3_nbw  <- which.min(results$BIC_nbw[1:63])
if (Ch3_npyw==Ch3_nbw) {
  results$chosen[Ch3_npyw] <- 1
  f_3 <- c(f1,f2,f3,f4,f5,f6,f7,f8,f9,f10,f11,f12,f13,f14,f15,f16,f17,f18,f19,f20,
           f21,f22,f23,f24,f25,f26,f27,f28,f29,f30,f31,f32,f33,f34,f35,f36,f37,f38,f39,f40,
           f41,f42,f43,f44,f45,f46,f47,f48,f49,f50,f51,f52,f53,f54,f55,f56,f57,f58,f59,f60,f61,f62,f63)[[Ch3_npyw]]
}
if (Ch3_npyw<Ch3_nbw) {
  results$chosen[Ch3_nbw] <- 1
  f_3 <- c(f1,f2,f3,f4,f5,f6,f7,f8,f9,f10,f11,f12,f13,f14,f15,f16,f17,f18,f19,f20,
           f21,f22,f23,f24,f25,f26,f27,f28,f29,f30,f31,f32,f33,f34,f35,f36,f37,f38,f39,f40,
           f41,f42,f43,f44,f45,f46,f47,f48,f49,f50,f51,f52,f53,f54,f55,f56,f57,f58,f59,f60,f61,f62,f63)[[Ch3_nbw]]
}

if (Ch3_nbw < 49) {
  save(results,gam1,gam2,gam3,gam4,gam5,gam6,gam7,gam8,gam9,
       gam10,gam11,gam12,gam13,gam14,gam15,gam16,gam17,gam18,
       gam19,gam20,gam21,gam22,gam23,gam24,gam25,gam26,gam27,
       gam28,gam29,gam30,gam31,gam32,gam33,gam34,gam35,gam36,
       gam37,gam38,gam39,gam40,gam41,gam42,gam43,gam44,gam45,
       gam46,gam47,gam48,gam49,gam50,gam51,gam52,gam53,gam54,
       gam55,gam56,gam57,gam58,gam59,gam60,gam61,gam62,gam63,
       file="chap3/results/p0_model_selection.RData")
} else {print("Stop - need to proceed to Stage 4")}

#Parity 1/2/3+
p123func <- function(p) {
  if (p==1)
    dgw <- groupfuncw("weights_1st", "birth.bin_1", c("age_1", "coh_1", "gapc_1", "qualf2aimp_1", "qualf2bimp_1", "qualf2cimp_1",
                                                      "qualf3aimp_1", "qualf3bimp_1", "qualf3cimp_1", "qualf4imp_1",
                                                      "HDIc2a_1", "HDIc2b_1","HDIc2c_1", "HDIc2d_1",
                                                      "HDIc3a_1", "HDIc3b_1", "HDIc3c_1", "HDIc3d_1", "HDIc3e_1", "HDIc3f_1",
                                                      "HDIc4a_1", "HDIc4b_1", "HDIc4c_1", "HDIc4d_1", "HDIc5_1"))
  if (p==2) 
    dgw <- groupfuncw("weights_2st", "birth.bin_2", c("age_2", "coh_2", "gapc_2", "qualf2aimp_2", "qualf2bimp_2", "qualf2cimp_2",
                                                      "qualf3aimp_2", "qualf3bimp_2", "qualf3cimp_2", "qualf4imp_2",
                                                      "HDIc2a_2", "HDIc2b_2","HDIc2c_2", "HDIc2d_2",
                                                      "HDIc3a_2", "HDIc3b_2", "HDIc3c_2", "HDIc3d_2", "HDIc3e_2", "HDIc3f_2",
                                                      "HDIc4a_2", "HDIc4b_2", "HDIc4c_2", "HDIc4d_2", "HDIc5_2"))
  if (p==3)
    dgw <- groupfuncw("weights_3st", "birth.bin_3", c("age_3", "coh_3", "gapc_3", "qualf2aimp_3", "qualf2bimp_3", "qualf2cimp_3",
                                                      "qualf3aimp_3", "qualf3bimp_3", "qualf3cimp_3", "qualf4imp_3",
                                                      "HDIc2a_3", "HDIc2b_3","HDIc2c_3", "HDIc2d_3",
                                                      "HDIc3a_3", "HDIc3b_3", "HDIc3c_3", "HDIc3d_3", "HDIc3e_3", "HDIc3f_3",
                                                      "HDIc4a_3", "HDIc4b_3", "HDIc4c_3", "HDIc4d_3", "HDIc5_3"))
  covs <- names(dgw)
  results <- data.frame(model=c("Null","A + C + AC","A + C + AC + T",
                                "A + C + AC + T + AT","A + C + AC + T + CT",
                                "A + C + AC + T + AT + CT",
                                "Ch(1) + Q2a", "Ch(1) + Q2b", "Ch(1) + Q2c", "Ch(1) + Q3a", "Ch(1) + Q3b", "Ch(1) + Q3c", "Ch(1) + Q4",
                                "Ch(1) + Q2a + AQ2a", "Ch(1) + Q2b + AQ2b", "Ch(1) + Q2c + AQ2c", "Ch(1) + Q3a + AQ3a", "Ch(1) + Q3b + AQ3b", "Ch(1) + Q3c + AQ3c", "Ch(1) + Q4 + AQ4",
                                "Ch(1) + Q2a + CQ2a", "Ch(1) + Q2b + CQ2b", "Ch(1) + Q2c + CQ2c", "Ch(1) + Q3a + CQ3a", "Ch(1) + Q3b + CQ3b", "Ch(1) + Q3c + CQ3c", "Ch(1) + Q4 + CQ4",
                                "Ch(1) + Q2a + TQ2a", "Ch(1) + Q2b + TQ2b", "Ch(1) + Q2c + TQ2c", "Ch(1) + Q3a + TQ3a", "Ch(1) + Q3b + TQ3b", "Ch(1) + Q3c + TQ3c", "Ch(1) + Q4 + TQ4",
                                "Ch(1) + Q2a + AQ2a + CQ2a", "Ch(1) + Q2b + AQ2b + CQ2b", "Ch(1) + Q2c + AQ2c + CQ2c", "Ch(1) + Q3a + AQ3a + CQ3a", "Ch(1) + Q3b + AQ3b + CQ3b", "Ch(1) + Q3c + AQ3c + CQ3c", "Ch(1) + Q4 + AQ4 + CQ4",
                                "Ch(1) + Q2a + AQ2a + TQ2a", "Ch(1) + Q2b + AQ2b + TQ2b", "Ch(1) + Q2c + AQ2c + TQ2c", "Ch(1) + Q3a + AQ3a + TQ3a", "Ch(1) + Q3b + AQ3b + TQ3b", "Ch(1) + Q3c + AQ3c + TQ3c", "Ch(1) + Q4 + AQ4 + TQ4",
                                "Ch(1) + Q2a + CQ2a + TQ2a", "Ch(1) + Q2b + CQ2b + TQ2b", "Ch(1) + Q2c + CQ2c + TQ2c", "Ch(1) + Q3a + CQ3a + TQ3a", "Ch(1) + Q3b + CQ3b + TQ3b", "Ch(1) + Q3c + CQ3c + TQ3c", "Ch(1) + Q4 + CQ4 + TQ4",
                                "Ch(1) + Q2a + AQ2a + CQ2a + TQ2a", "Ch(1) + Q2b + AQ2b + CQ2b + TQ2b", "Ch(1) + Q2c + AQ2c + CQ2c + TQ2c", "Ch(1) + Q3a + AQ3a + CQ3a + TQ3a", "Ch(1) + Q3b + AQ3b + CQ3b + TQ3b", "Ch(1) + Q3c + AQ3c + CQ3c + TQ3c", "Ch(1) + Q4 + AQ4 + CQ4 + TQ4",
                                "Ch(2) + H2a","Ch(2) + H2b", "Ch(2) + H2c","Ch(2) + H2d", 
                                "Ch(2) + H3a", "Ch(2) + H3b", "Ch(2) + H3c", "Ch(2) + H3d", "Ch(2) + H3e", "Ch(2) + H3f",
                                "Ch(2) + H4a","Ch(2) + H4b","Ch(2) + H4c","Ch(2) + H4d","Ch(2) + H5",
                                "Ch(2) + H2a + AH2a","Ch(2) + H2b + AH2b","Ch(2) + H2c + AH2c","Ch(2) + H2d + AH2d",
                                "Ch(2) + H3a + AH3a","Ch(2) + H3b + AH3b","Ch(2) + H3c + AH3c","Ch(2) + H3d + AH3d","Ch(2) + H3e + AH3e","Ch(2) + H3f + AH3f",
                                "Ch(2) + H4a + AH4a","Ch(2) + H4b + AH4b","Ch(2) + H4c + AH4c","Ch(2) + H4d + AH4d","Ch(2) + H5 + AH5"),
                        logLik=0,phat=0,BIC_npyw=0,BIC_nbw=0,AICc=0,chosen=0)
  
  ###Stage 1
  print(paste0("Parity ",p," starting, 92 models to fit"))
  #1. Null
  f1 <- as.formula(paste("p~1"))
  gam1 <- gam(f1, family=binomial, method="REML", weights=n, data=dgw)
  results <- updatefunc(1,gam1,dgw,results)
  #2. A + C + AC
  f2 <- as.formula(paste("p~1+",f_s1(covs[1]),"+",f_s1(covs[2]),"+",f_ti(covs[1],covs[2]),sep=""))
  gam2 <- gam(f2, family=binomial, method="REML", weights=n, data=dgw, knots=kfunc(c(1,2),dgw))
  results <- updatefunc(2,gam2,dgw,results)
  #3. A + C + AC + T
  f3 <- update(f2, as.formula(paste("~.+",f_s1(covs[3]),sep="")))
  gam3 <- gam(f3, family=binomial, method="REML", weights=n, data=dgw, knots=kfunc(c(1,2,3),dgw))
  results <- updatefunc(3,gam3,dgw,results)
  #4. A + C + AC + T + AT
  f4 <- update(f3, as.formula(paste("~.+",f_ti(covs[1],covs[3]),sep="")))
  gam4 <- gam(f4, family=binomial, method="REML", weights=n, data=dgw, knots=kfunc(c(1,2,3),dgw))
  results <- updatefunc(4,gam4,dgw,results)
  #5. A + C + AC + T + CT
  f5 <- update(f3, as.formula(paste("~.+",f_ti(covs[2],covs[3]),sep="")))
  gam5 <- gam(f5, family=binomial, method="REML", weights=n, data=dgw, knots=kfunc(c(1,2,3),dgw))
  results <- updatefunc(5,gam5,dgw,results)
  #6. A + C + AC + T + AT + CT
  f6 <- update(f4, as.formula(paste("~.+",f_ti(covs[2],covs[3]),sep="")))
  gam6 <- gam(f6, family=binomial, method="REML", weights=n, data=dgw, knots=kfunc(c(1,2,3),dgw))
  results <- updatefunc(6,gam6,dgw,results)
  #Ch(1)
  Ch1_npyw <- which.min(results$BIC_npyw[1:6])
  Ch1_nbw  <- which.min(results$BIC_nbw[1:6])
  if (Ch1_npyw==Ch1_nbw) {
    results$chosen[Ch1_npyw] <- 1
    f_1 <- c(f1,f2,f3,f4,f5,f6)[[Ch1_npyw]]
  }
  if (Ch1_npyw<Ch1_nbw) {
    results$chosen[Ch1_nbw] <- 1
    f_1 <- c(f1,f2,f3,f4,f5,f6)[[Ch1_nbw]]
  }  
  
  ###Stage 2
  #7. Ch(1) + Q2a
  f7 <- update(f_1, as.formula(paste("~.+",covs[4],sep="")))
  gam7 <- gam(f7, family=binomial, method="REML", weights=n, data=dgw, knots=kfunc(c(1,2,3),dgw))
  results <- updatefunc(7,gam7,dgw,results)
  #8. Ch(1) + Q2b
  f8 <- update(f_1, as.formula(paste("~.+",covs[5],sep="")))
  gam8 <- gam(f8, family=binomial, method="REML", weights=n, data=dgw, knots=kfunc(c(1,2,3),dgw))
  results <- updatefunc(8,gam8,dgw,results)
  #9. Ch(1) + Q2c
  f9 <- update(f_1, as.formula(paste("~.+",covs[6],sep="")))
  gam9 <- gam(f9, family=binomial, method="REML", weights=n, data=dgw, knots=kfunc(c(1,2,3),dgw))
  results <- updatefunc(9,gam9,dgw,results)
  #10. Ch(1) + Q3a
  f10 <- update(f_1, as.formula(paste("~.+",covs[7],sep="")))
  gam10 <- gam(f10, family=binomial, method="REML", weights=n, data=dgw, knots=kfunc(c(1,2,3),dgw))
  results <- updatefunc(10,gam10,dgw,results)
  #11. Ch(1) + Q3b
  f11 <- update(f_1, as.formula(paste("~.+",covs[8],sep="")))
  gam11 <- gam(f11, family=binomial, method="REML", weights=n, data=dgw, knots=kfunc(c(1,2,3),dgw))
  results <- updatefunc(11,gam11,dgw,results)
  #12. Ch(1) + Q3c
  f12 <- update(f_1, as.formula(paste("~.+",covs[9],sep="")))
  gam12 <- gam(f12, family=binomial, method="REML", weights=n, data=dgw, knots=kfunc(c(1,2,3),dgw))
  results <- updatefunc(12,gam12,dgw,results)
  #13. Ch(1) + Q4
  f13 <- update(f_1, as.formula(paste("~.+",covs[10],sep="")))
  gam13 <- gam(f13, family=binomial, method="REML", weights=n, data=dgw, knots=kfunc(c(1,2,3),dgw))
  results <- updatefunc(13,gam13,dgw,results)
  
  #14. Ch(1) + Q2a + AQ2a
  f14 <- update(f7, as.formula(paste("~.+",f_s2(covs[1],covs[4]),sep="")))
  gam14 <- gam(f14, family=binomial, method="REML", weights=n, data=dgw, knots=kfunc(c(1,2,3),dgw))
  results <- updatefunc(14,gam14,dgw,results)
  #15. Ch(1) + Q2b + AQ2b
  f15 <- update(f8, as.formula(paste("~.+",f_s2(covs[1],covs[5]),sep="")))
  gam15 <- gam(f15, family=binomial, method="REML", weights=n, data=dgw, knots=kfunc(c(1,2,3),dgw))
  results <- updatefunc(15,gam15,dgw,results)
  #16. Ch(1) + Q2c + AQ2c
  f16 <- update(f9, as.formula(paste("~.+",f_s2(covs[1],covs[6]),sep="")))
  gam16 <- gam(f16, family=binomial, method="REML", weights=n, data=dgw, knots=kfunc(c(1,2,3),dgw))
  results <- updatefunc(16,gam16,dgw,results)
  #17. Ch(1) + Q3a + AQ3a
  f17 <- update(f10, as.formula(paste("~.+",f_s2(covs[1],covs[7]),sep="")))
  gam17 <- gam(f17, family=binomial, method="REML", weights=n, data=dgw, knots=kfunc(c(1,2,3),dgw))
  results <- updatefunc(17,gam17,dgw,results)
  #18. Ch(1) + Q3b + AQ3b
  f18 <- update(f11, as.formula(paste("~.+",f_s2(covs[1],covs[8]),sep="")))
  gam18 <- gam(f18, family=binomial, method="REML", weights=n, data=dgw, knots=kfunc(c(1,2,3),dgw))
  results <- updatefunc(18,gam18,dgw,results)
  #19. Ch(1) + Q3c + AQ3c
  f19 <- update(f12, as.formula(paste("~.+",f_s2(covs[1],covs[9]),sep="")))
  gam19 <- gam(f19, family=binomial, method="REML", weights=n, data=dgw, knots=kfunc(c(1,2,3),dgw))
  results <- updatefunc(19,gam19,dgw,results)
  #20. Ch(1) + Q4 + AQ4
  f20 <- update(f13, as.formula(paste("~.+",f_s2(covs[1],covs[10]),sep="")))
  gam20 <- gam(f20, family=binomial, method="REML", weights=n, data=dgw, knots=kfunc(c(1,2,3),dgw))
  results <- updatefunc(20,gam20,dgw,results)
  
  #21. Ch(1) + Q2a + CQ2a
  f21 <- update(f7, as.formula(paste("~.+",f_s2(covs[2],covs[4]),sep="")))
  gam21 <- gam(f21, family=binomial, method="REML", weights=n, data=dgw, knots=kfunc(c(1,2,3),dgw))
  results <- updatefunc(21,gam21,dgw,results)
  #22. Ch(1) + Q2b + CQ2b
  f22 <- update(f8, as.formula(paste("~.+",f_s2(covs[2],covs[5]),sep="")))
  gam22 <- gam(f22, family=binomial, method="REML", weights=n, data=dgw, knots=kfunc(c(1,2,3),dgw))
  results <- updatefunc(22,gam22,dgw,results)
  #23. Ch(1) + Q2c + CQ2c
  f23 <- update(f9, as.formula(paste("~.+",f_s2(covs[2],covs[6]),sep="")))
  gam23 <- gam(f23, family=binomial, method="REML", weights=n, data=dgw, knots=kfunc(c(1,2,3),dgw))
  results <- updatefunc(23,gam23,dgw,results)
  #24. Ch(1) + Q3a + CQ3a
  f24 <- update(f10, as.formula(paste("~.+",f_s2(covs[2],covs[7]),sep="")))
  gam24 <- gam(f24, family=binomial, method="REML", weights=n, data=dgw, knots=kfunc(c(1,2,3),dgw))
  results <- updatefunc(24,gam24,dgw,results)
  #25. Ch(1) + Q3b + CQ3b
  f25 <- update(f11, as.formula(paste("~.+",f_s2(covs[2],covs[8]),sep="")))
  gam25 <- gam(f25, family=binomial, method="REML", weights=n, data=dgw, knots=kfunc(c(1,2,3),dgw))
  results <- updatefunc(25,gam25,dgw,results)
  #26. Ch(1) + Q3c + CQ3c
  f26 <- update(f12, as.formula(paste("~.+",f_s2(covs[2],covs[9]),sep="")))
  gam26 <- gam(f26, family=binomial, method="REML", weights=n, data=dgw, knots=kfunc(c(1,2,3),dgw))
  results <- updatefunc(26,gam26,dgw,results)
  #27. Ch(1) + Q4 + CQ4
  f27 <- update(f13, as.formula(paste("~.+",f_s2(covs[2],covs[10]),sep="")))
  gam27 <- gam(f27, family=binomial, method="REML", weights=n, data=dgw, knots=kfunc(c(1,2,3),dgw))
  results <- updatefunc(27,gam27,dgw,results)
  
  #28. Ch(1) + Q2a + TQ2a
  f28 <- update(f7, as.formula(paste("~.+",f_s2(covs[3],covs[4]),sep="")))
  gam28 <- gam(f28, family=binomial, method="REML", weights=n, data=dgw, knots=kfunc(c(1,2,3),dgw))
  results <- updatefunc(28,gam28,dgw,results)
  #29. Ch(1) + Q2b + TQ2b
  f29 <- update(f8, as.formula(paste("~.+",f_s2(covs[3],covs[5]),sep="")))
  gam29 <- gam(f29, family=binomial, method="REML", weights=n, data=dgw, knots=kfunc(c(1,2,3),dgw))
  results <- updatefunc(29,gam29,dgw,results)
  #30. Ch(1) + Q2c + TQ2c
  f30 <- update(f9, as.formula(paste("~.+",f_s2(covs[3],covs[6]),sep="")))
  gam30 <- gam(f30, family=binomial, method="REML", weights=n, data=dgw, knots=kfunc(c(1,2,3),dgw))
  results <- updatefunc(30,gam30,dgw,results)
  #31. Ch(1) + Q3a + TQ3a
  f31 <- update(f10, as.formula(paste("~.+",f_s2(covs[3],covs[7]),sep="")))
  gam31 <- gam(f31, family=binomial, method="REML", weights=n, data=dgw, knots=kfunc(c(1,2,3),dgw))
  results <- updatefunc(31,gam31,dgw,results)
  #32. Ch(1) + Q3b + TQ3b
  f32 <- update(f11, as.formula(paste("~.+",f_s2(covs[3],covs[8]),sep="")))
  gam32 <- gam(f32, family=binomial, method="REML", weights=n, data=dgw, knots=kfunc(c(1,2,3),dgw))
  results <- updatefunc(32,gam32,dgw,results)
  #33. Ch(1) + Q3c + TQ3c
  f33 <- update(f12, as.formula(paste("~.+",f_s2(covs[3],covs[9]),sep="")))
  gam33 <- gam(f33, family=binomial, method="REML", weights=n, data=dgw, knots=kfunc(c(1,2,3),dgw))
  results <- updatefunc(33,gam33,dgw,results)
  #34. Ch(1) + Q4 + TQ4
  f34 <- update(f13, as.formula(paste("~.+",f_s2(covs[3],covs[10]),sep="")))
  gam34 <- gam(f34, family=binomial, method="REML", weights=n, data=dgw, knots=kfunc(c(1,2,3),dgw))
  results <- updatefunc(34,gam34,dgw,results)
  
  #35. Ch(1) + Q2a + AQ2a + CQ2a
  f35 <- update(f14, as.formula(paste("~.+",f_s2(covs[2],covs[4]),sep="")))
  gam35 <- gam(f35, family=binomial, method="REML", weights=n, data=dgw, knots=kfunc(c(1,2,3),dgw))
  results <- updatefunc(35,gam35,dgw,results)
  #36. Ch(1) + Q2b + AQ2b + CQ2b
  f36 <- update(f15, as.formula(paste("~.+",f_s2(covs[2],covs[5]),sep="")))
  gam36 <- gam(f36, family=binomial, method="REML", weights=n, data=dgw, knots=kfunc(c(1,2,3),dgw))
  results <- updatefunc(36,gam36,dgw,results)
  #37. Ch(1) + Q2b + AQ2c + CQ2c
  f37 <- update(f16, as.formula(paste("~.+",f_s2(covs[2],covs[6]),sep="")))
  gam37 <- gam(f37, family=binomial, method="REML", weights=n, data=dgw, knots=kfunc(c(1,2,3),dgw))
  results <- updatefunc(37,gam37,dgw,results)
  #38. Ch(1) + Q3a + AQ3a + CQ3a
  f38 <- update(f17, as.formula(paste("~.+",f_s2(covs[2],covs[7]),sep="")))
  gam38 <- gam(f38, family=binomial, method="REML", weights=n, data=dgw, knots=kfunc(c(1,2,3),dgw))
  results <- updatefunc(38,gam38,dgw,results)
  #39. Ch(1) + Q3b + AQ3b + CQ3b
  f39 <- update(f18, as.formula(paste("~.+",f_s2(covs[2],covs[8]),sep="")))
  gam39 <- gam(f39, family=binomial, method="REML", weights=n, data=dgw, knots=kfunc(c(1,2,3),dgw))
  results <- updatefunc(39,gam39,dgw,results)
  #40. Ch(1) + Q3c + AQ3c + CQ3c
  f40 <- update(f19, as.formula(paste("~.+",f_s2(covs[2],covs[9]),sep="")))
  gam40 <- gam(f40, family=binomial, method="REML", weights=n, data=dgw, knots=kfunc(c(1,2,3),dgw))
  results <- updatefunc(40,gam40,dgw,results)
  #41. Ch(1) + Q4 + AQ4 + CQ4
  f41 <- update(f20, as.formula(paste("~.+",f_s2(covs[2],covs[10]),sep="")))
  gam41 <- gam(f41, family=binomial, method="REML", weights=n, data=dgw, knots=kfunc(c(1,2,3),dgw))
  results <- updatefunc(41,gam41,dgw,results)
  
  #42. Ch(1) + Q2a + AQ2a + TQ2a
  f42 <- update(f14, as.formula(paste("~.+",f_s2(covs[3],covs[4]),sep="")))
  gam42 <- gam(f42, family=binomial, method="REML", weights=n, data=dgw, knots=kfunc(c(1,2,3),dgw))
  results <- updatefunc(42,gam42,dgw,results)
  #43. Ch(1) + Q2b + AQ2b + TQ2b
  f43 <- update(f15, as.formula(paste("~.+",f_s2(covs[3],covs[5]),sep="")))
  gam43 <- gam(f43, family=binomial, method="REML", weights=n, data=dgw, knots=kfunc(c(1,2,3),dgw))
  results <- updatefunc(43,gam43,dgw,results)
  #44. Ch(1) + Q2b + AQ2c + TQ2c
  f44 <- update(f16, as.formula(paste("~.+",f_s2(covs[3],covs[6]),sep="")))
  gam44 <- gam(f44, family=binomial, method="REML", weights=n, data=dgw, knots=kfunc(c(1,2,3),dgw))
  results <- updatefunc(44,gam44,dgw,results)
  #45. Ch(1) + Q3a + AQ3a + TQ3a
  f45 <- update(f17, as.formula(paste("~.+",f_s2(covs[3],covs[7]),sep="")))
  gam45 <- gam(f45, family=binomial, method="REML", weights=n, data=dgw, knots=kfunc(c(1,2,3),dgw))
  results <- updatefunc(45,gam45,dgw,results)
  #46. Ch(1) + Q3b + AQ3b + TQ3b
  f46 <- update(f18, as.formula(paste("~.+",f_s2(covs[3],covs[8]),sep="")))
  gam46 <- gam(f46, family=binomial, method="REML", weights=n, data=dgw, knots=kfunc(c(1,2,3),dgw))
  results <- updatefunc(46,gam46,dgw,results)
  #47. Ch(1) + Q3c + AQ3c + TQ3c
  f47 <- update(f19, as.formula(paste("~.+",f_s2(covs[3],covs[9]),sep="")))
  gam47 <- gam(f47, family=binomial, method="REML", weights=n, data=dgw, knots=kfunc(c(1,2,3),dgw))
  results <- updatefunc(47,gam47,dgw,results)
  #48. Ch(1) + Q4 + AQ4 + TQ4
  f48 <- update(f20, as.formula(paste("~.+",f_s2(covs[3],covs[10]),sep="")))
  gam48 <- gam(f48, family=binomial, method="REML", weights=n, data=dgw, knots=kfunc(c(1,2,3),dgw))
  results <- updatefunc(48,gam48,dgw,results)
  
  #49. Ch(1) + Q2a + CQ2a + TQ2a
  f49 <- update(f21, as.formula(paste("~.+",f_s2(covs[3],covs[4]),sep="")))
  gam49 <- gam(f49, family=binomial, method="REML", weights=n, data=dgw, knots=kfunc(c(1,2,3),dgw))
  results <- updatefunc(49,gam49,dgw,results)
  #50. Ch(1) + Q2b + CQ2b + TQ2b
  f50 <- update(f22, as.formula(paste("~.+",f_s2(covs[3],covs[5]),sep="")))
  gam50 <- gam(f50, family=binomial, method="REML", weights=n, data=dgw, knots=kfunc(c(1,2,3),dgw))
  results <- updatefunc(50,gam50,dgw,results)
  #51. Ch(1) + Q2c + CQ2c + TQ2c
  f51 <- update(f23, as.formula(paste("~.+",f_s2(covs[3],covs[6]),sep="")))
  gam51 <- gam(f51, family=binomial, method="REML", weights=n, data=dgw, knots=kfunc(c(1,2,3),dgw))
  results <- updatefunc(51,gam51,dgw,results)
  #52. Ch(1) + Q3a + CQ3a + TQ3a
  f52 <- update(f24, as.formula(paste("~.+",f_s2(covs[3],covs[7]),sep="")))
  gam52 <- gam(f52, family=binomial, method="REML", weights=n, data=dgw, knots=kfunc(c(1,2,3),dgw))
  results <- updatefunc(52,gam52,dgw,results)
  #53. Ch(1) + Q3b + CQ3b + TQ3b
  f53 <- update(f25, as.formula(paste("~.+",f_s2(covs[3],covs[8]),sep="")))
  gam53 <- gam(f53, family=binomial, method="REML", weights=n, data=dgw, knots=kfunc(c(1,2,3),dgw))
  results <- updatefunc(53,gam53,dgw,results)
  #54. Ch(1) + Q3c + CQ3c + TQ3c
  f54 <- update(f26, as.formula(paste("~.+",f_s2(covs[3],covs[9]),sep="")))
  gam54 <- gam(f54, family=binomial, method="REML", weights=n, data=dgw, knots=kfunc(c(1,2,3),dgw))
  results <- updatefunc(54,gam54,dgw,results)
  #55. Ch(1) + Q4 + CQ4 + TQ4
  f55 <- update(f27, as.formula(paste("~.+",f_s2(covs[3],covs[10]),sep="")))
  gam55 <- gam(f55, family=binomial, method="REML", weights=n, data=dgw, knots=kfunc(c(1,2,3),dgw))
  results <- updatefunc(55,gam55,dgw,results)
  
  #56. Ch(1) + Q2a + AQ2a + CQ2a + TQ2a
  f56 <- update(f35, as.formula(paste("~.+",f_s2(covs[3],covs[4]),sep="")))
  gam56 <- gam(f56, family=binomial, method="REML", weights=n, data=dgw, knots=kfunc(c(1,2,3),dgw))
  results <- updatefunc(56,gam56,dgw,results)
  #57. Ch(1) + Q2b + AQ2b + CQ2b + TQ2b
  f57 <- update(f36, as.formula(paste("~.+",f_s2(covs[3],covs[5]),sep="")))
  gam57 <- gam(f57, family=binomial, method="REML", weights=n, data=dgw, knots=kfunc(c(1,2,3),dgw))
  results <- updatefunc(57,gam57,dgw,results)
  #58. Ch(1) + Q2c + AQ2c + CQ2c + TQ2c
  f58 <- update(f37, as.formula(paste("~.+",f_s2(covs[3],covs[6]),sep="")))
  gam58 <- gam(f58, family=binomial, method="REML", weights=n, data=dgw, knots=kfunc(c(1,2,3),dgw))
  results <- updatefunc(58,gam58,dgw,results)
  #59. Ch(1) + Q3a + AQ3a + CQ3a + TQ3a
  f59 <- update(f38, as.formula(paste("~.+",f_s2(covs[3],covs[7]),sep="")))
  gam59 <- gam(f59, family=binomial, method="REML", weights=n, data=dgw, knots=kfunc(c(1,2,3),dgw))
  results <- updatefunc(59,gam59,dgw,results)
  #60. Ch(1) + Q3b + AQ3b + CQ3b + TQ3b
  f60 <- update(f39, as.formula(paste("~.+",f_s2(covs[3],covs[8]),sep="")))
  gam60 <- gam(f60, family=binomial, method="REML", weights=n, data=dgw, knots=kfunc(c(1,2,3),dgw))
  results <- updatefunc(60,gam60,dgw,results)
  #61. Ch(1) + Q3c + AQ3c + CQ3c + TQ3c
  f61 <- update(f40, as.formula(paste("~.+",f_s2(covs[3],covs[9]),sep="")))
  gam61 <- gam(f61, family=binomial, method="REML", weights=n, data=dgw, knots=kfunc(c(1,2,3),dgw))
  results <- updatefunc(61,gam61,dgw,results)
  #62. Ch(1) + Q4 + AQ4 + CQ4 + TQ4
  f62 <- update(f41, as.formula(paste("~.+",f_s2(covs[3],covs[10]),sep="")))
  gam62 <- gam(f62, family=binomial, method="REML", weights=n, data=dgw, knots=kfunc(c(1,2,3),dgw))
  results <- updatefunc(62,gam62,dgw,results)
  
  #Ch(2)
  Ch2_npyw <- which.min(results$BIC_npyw[1:62])
  Ch2_nbw  <- which.min(results$BIC_nbw[1:62])
  if (Ch2_npyw==Ch2_nbw) {
    results$chosen[Ch2_npyw] <- 1
    f_2 <- c(f1,f2,f3,f4,f5,f6,f7,f8,f9,f10,f11,f12,f13,f14,f15,f16,f17,f18,f19,f20,
             f21,f22,f23,f24,f25,f26,f27,f28,f29,f30,f31,f32,f33,f34,f35,f36,f37,f38,f39,f40,
             f41,f42,f43,f44,f45,f46,f47,f48,f49,f50,f51,f52,f53,f54,f55,f56,f57,f58,f59,f60,
             f61,f62)[[Ch2_npyw]]
  }
  if (Ch2_npyw<Ch2_nbw) {
    results$chosen[Ch2_nbw] <- 1
    f_2 <- c(f1,f2,f3,f4,f5,f6,f7,f8,f9,f10,f11,f12,f13,f14,f15,f16,f17,f18,f19,f20,
             f21,f22,f23,f24,f25,f26,f27,f28,f29,f30,f31,f32,f33,f34,f35,f36,f37,f38,f39,f40,
             f41,f42,f43,f44,f45,f46,f47,f48,f49,f50,f51,f52,f53,f54,f55,f56,f57,f58,f59,f60,
             f61,f62)[[Ch2_nbw]]
  }
  
  ###Stage 3
  #63. Ch(2) + H2a
  f63 <- update(f_2, as.formula(paste("~.+",covs[11],sep="")))
  gam63 <- gam(f63, family=binomial, method="REML", weights=n, data=dgw, knots=kfunc(c(1,2,3),dgw))
  results <- updatefunc(63,gam63,dgw,results)
  #64. Ch(2) + H2b
  f64 <- update(f_2, as.formula(paste("~.+",covs[12],sep="")))
  gam64 <- gam(f64, family=binomial, method="REML", weights=n, data=dgw, knots=kfunc(c(1,2,3),dgw))
  results <- updatefunc(64,gam64,dgw,results)
  #65. Ch(2) + H2c
  f65 <- update(f_2, as.formula(paste("~.+",covs[13],sep="")))
  gam65 <- gam(f65, family=binomial, method="REML", weights=n, data=dgw, knots=kfunc(c(1,2,3),dgw))
  results <- updatefunc(65,gam65,dgw,results)
  #66. Ch(2) + H2d
  f66 <- update(f_2, as.formula(paste("~.+",covs[14],sep="")))
  gam66 <- gam(f66, family=binomial, method="REML", weights=n, data=dgw, knots=kfunc(c(1,2,3),dgw))
  results <- updatefunc(66,gam66,dgw,results)
  #67. Ch(2) + H3a
  f67 <- update(f_2, as.formula(paste("~.+",covs[15],sep="")))
  gam67 <- gam(f67, family=binomial, method="REML", weights=n, data=dgw, knots=kfunc(c(1,2,3),dgw))
  results <- updatefunc(67,gam67,dgw,results)
  #68. Ch(2) + H3b
  f68 <- update(f_2, as.formula(paste("~.+",covs[16],sep="")))
  gam68 <- gam(f68, family=binomial, method="REML", weights=n, data=dgw, knots=kfunc(c(1,2,3),dgw))
  results <- updatefunc(68,gam68,dgw,results)
  #69. Ch(2) + H3c
  f69 <- update(f_2, as.formula(paste("~.+",covs[17],sep="")))
  gam69 <- gam(f69, family=binomial, method="REML", weights=n, data=dgw, knots=kfunc(c(1,2,3),dgw))
  results <- updatefunc(69,gam69,dgw,results)
  #70. Ch(2) + H3d
  f70 <- update(f_2, as.formula(paste("~.+",covs[18],sep="")))
  gam70 <- gam(f70, family=binomial, method="REML", weights=n, data=dgw, knots=kfunc(c(1,2,3),dgw))
  results <- updatefunc(70,gam70,dgw,results)
  #71. Ch(2) + H3e
  f71 <- update(f_2, as.formula(paste("~.+",covs[19],sep="")))
  gam71 <- gam(f71, family=binomial, method="REML", weights=n, data=dgw, knots=kfunc(c(1,2,3),dgw))
  results <- updatefunc(71,gam71,dgw,results)
  #72. Ch(2) + H3f
  f72 <- update(f_2, as.formula(paste("~.+",covs[20],sep="")))
  gam72 <- gam(f72, family=binomial, method="REML", weights=n, data=dgw, knots=kfunc(c(1,2,3),dgw))
  results <- updatefunc(72,gam72,dgw,results)
  #73. Ch(2) + H4a
  f73 <- update(f_2, as.formula(paste("~.+",covs[21],sep="")))
  gam73 <- gam(f73, family=binomial, method="REML", weights=n, data=dgw, knots=kfunc(c(1,2,3),dgw))
  results <- updatefunc(73,gam73,dgw,results)
  #74. Ch(2) + H4b
  f74 <- update(f_2, as.formula(paste("~.+",covs[22],sep="")))
  gam74 <- gam(f74, family=binomial, method="REML", weights=n, data=dgw, knots=kfunc(c(1,2,3),dgw))
  results <- updatefunc(74,gam74,dgw,results)
  #75. Ch(2) + H4c
  f75 <- update(f_2, as.formula(paste("~.+",covs[23],sep="")))
  gam75 <- gam(f75, family=binomial, method="REML", weights=n, data=dgw, knots=kfunc(c(1,2,3),dgw))
  results <- updatefunc(75,gam75,dgw,results)
  #76. Ch(2) + H4d
  f76 <- update(f_2, as.formula(paste("~.+",covs[24],sep="")))
  gam76 <- gam(f76, family=binomial, method="REML", weights=n, data=dgw, knots=kfunc(c(1,2,3),dgw))
  results <- updatefunc(76,gam76,dgw,results)
  #77. Ch(2) + H5
  f77 <- update(f_2, as.formula(paste("~.+",covs[25],sep="")))
  gam77 <- gam(f77, family=binomial, method="REML", weights=n, data=dgw, knots=kfunc(c(1,2,3),dgw))
  results <- updatefunc(77,gam77,dgw,results)
  
  #78. Ch(2) + H2a + AH2a
  f78 <- update(f63, as.formula(paste("~.+",f_s2(covs[1],covs[11]),sep="")))
  gam78 <- gam(f78, family=binomial, method="REML", weights=n, data=dgw, knots=kfunc(c(1,2,3),dgw))
  results <- updatefunc(78,gam78,dgw,results)
  #79. Ch(2) + H2b + AH2b
  f79 <- update(f64, as.formula(paste("~.+",f_s2(covs[1],covs[12]),sep="")))
  gam79 <- gam(f79, family=binomial, method="REML", weights=n, data=dgw, knots=kfunc(c(1,2,3),dgw))
  results <- updatefunc(79,gam79,dgw,results)
  #80. Ch(2) + H2c + AH2c
  f80 <- update(f65, as.formula(paste("~.+",f_s2(covs[1],covs[13]),sep="")))
  gam80 <- gam(f80, family=binomial, method="REML", weights=n, data=dgw, knots=kfunc(c(1,2,3),dgw))
  results <- updatefunc(80,gam80,dgw,results)
  #81. Ch(2) + H2d + AH2d
  f81 <- update(f66, as.formula(paste("~.+",f_s2(covs[1],covs[14]),sep="")))
  gam81 <- gam(f81, family=binomial, method="REML", weights=n, data=dgw, knots=kfunc(c(1,2,3),dgw))
  results <- updatefunc(81,gam81,dgw,results)
  #82. Ch(2) + H3a + AH3a
  f82 <- update(f67, as.formula(paste("~.+",f_s2(covs[1],covs[15]),sep="")))
  gam82 <- gam(f82, family=binomial, method="REML", weights=n, data=dgw, knots=kfunc(c(1,2,3),dgw))
  results <- updatefunc(82,gam82,dgw,results)
  #83. Ch(2) + H3b + AH3b
  f83 <- update(f68, as.formula(paste("~.+",f_s2(covs[1],covs[16]),sep="")))
  gam83 <- gam(f83, family=binomial, method="REML", weights=n, data=dgw, knots=kfunc(c(1,2,3),dgw))
  results <- updatefunc(83,gam83,dgw,results)
  #84. Ch(2) + H3c + AH3c
  f84 <- update(f69, as.formula(paste("~.+",f_s2(covs[1],covs[17]),sep="")))
  gam84 <- gam(f84, family=binomial, method="REML", weights=n, data=dgw, knots=kfunc(c(1,2,3),dgw))
  results <- updatefunc(84,gam84,dgw,results)
  #85. Ch(2) + H3d + AH3d
  f85 <- update(f70, as.formula(paste("~.+",f_s2(covs[1],covs[18]),sep="")))
  gam85 <- gam(f85, family=binomial, method="REML", weights=n, data=dgw, knots=kfunc(c(1,2,3),dgw))
  results <- updatefunc(85,gam85,dgw,results)
  #86. Ch(2) + H3e + AH3e
  f86 <- update(f71, as.formula(paste("~.+",f_s2(covs[1],covs[19]),sep="")))
  gam86 <- gam(f86, family=binomial, method="REML", weights=n, data=dgw, knots=kfunc(c(1,2,3),dgw))
  results <- updatefunc(86,gam86,dgw,results)
  #87. Ch(2) + H3f + AH3f
  f87 <- update(f72, as.formula(paste("~.+",f_s2(covs[1],covs[20]),sep="")))
  gam87 <- gam(f87, family=binomial, method="REML", weights=n, data=dgw, knots=kfunc(c(1,2,3),dgw))
  results <- updatefunc(87,gam87,dgw,results)
  #88. Ch(2) + H4a + AH4a
  f88 <- update(f73, as.formula(paste("~.+",f_s2(covs[1],covs[21]),sep="")))
  gam88 <- gam(f88, family=binomial, method="REML", weights=n, data=dgw, knots=kfunc(c(1,2,3),dgw))
  results <- updatefunc(88,gam88,dgw,results)
  #89. Ch(2) + H4b + AH4b
  f89 <- update(f74, as.formula(paste("~.+",f_s2(covs[1],covs[22]),sep="")))
  gam89 <- gam(f89, family=binomial, method="REML", weights=n, data=dgw, knots=kfunc(c(1,2,3),dgw))
  results <- updatefunc(89,gam89,dgw,results)
  #90. Ch(2) + H4c + AH4c
  f90 <- update(f75, as.formula(paste("~.+",f_s2(covs[1],covs[23]),sep="")))
  gam90 <- gam(f90, family=binomial, method="REML", weights=n, data=dgw, knots=kfunc(c(1,2,3),dgw))
  results <- updatefunc(90,gam90,dgw,results)
  #91. Ch(2) + H4d + AH4d
  f91 <- update(f76, as.formula(paste("~.+",f_s2(covs[1],covs[24]),sep="")))
  gam91 <- gam(f91, family=binomial, method="REML", weights=n, data=dgw, knots=kfunc(c(1,2,3),dgw))
  results <- updatefunc(91,gam91,dgw,results)
  #92. Ch(2) + H5 + AH5
  f92 <- update(f77, as.formula(paste("~.+",f_s2(covs[1],covs[25]),sep="")))
  gam92 <- gam(f92, family=binomial, method="REML", weights=n, data=dgw, knots=kfunc(c(1,2,3),dgw))
  results <- updatefunc(92,gam92,dgw,results)
  
  #Ch(3)
  Ch3_npyw <- which.min(results$BIC_npyw[1:92])
  Ch3_nbw  <- which.min(results$BIC_nbw[1:92])
  if (Ch3_npyw==Ch3_nbw) {
    results$chosen[Ch3_npyw] <- 1
    f_3 <- c(f1,f2,f3,f4,f5,f6,f7,f8,f9,f10,f11,f12,f13,f14,f15,f16,f17,f18,f19,f20,f21,f22,f23,
             f24,f25,f26,f27,f28,f29,f30,f31,f32,f33,f34,f35,f36,f37,f38,f39,f40,
             f41,f42,f43,f44,f45,f46,f47,f48,f49,f50,f51,f52,f53,f54,f55,f56,f57,f58,f59,f60,
             f61,f62,f63,f64,f65,f66,f67,f68,f69,f70,f71,f72,f73,f74,f75,f76,f77,f78,f79,f80,
             f81,f82,f83,f84,f85,f86,f87,f88,f89,f90,f91,f92)[[Ch3_npyw]]
  }
  if (Ch3_npyw<Ch3_nbw) {
    results$chosen[Ch3_nbw] <- 1
    f_3 <- c(f1,f2,f3,f4,f5,f6,f7,f8,f9,f10,f11,f12,f13,f14,f15,f16,f17,f18,f19,f20,f21,f22,f23,
             f24,f25,f26,f27,f28,f29,f30,f31,f32,f33,f34,f35,f36,f37,f38,f39,f40,
             f41,f42,f43,f44,f45,f46,f47,f48,f49,f50,f51,f52,f53,f54,f55,f56,f57,f58,f59,f60,
             f61,f62,f63,f64,f65,f66,f67,f68,f69,f70,f71,f72,f73,f74,f75,f76,f77,f78,f79,f80,
             f81,f82,f83,f84,f85,f86,f87,f88,f89,f90,f91,f92)[[Ch3_nbw]]
  }
  
  if (Ch3_nbw < 78) {
    save(results,gam1,gam2,gam3,gam4,gam5,gam6,gam7,gam8,gam9,
         gam10,gam11,gam12,gam13,gam14,gam15,gam16,gam17,gam18,
         gam19,gam20,gam21,gam22,gam23,gam24,gam25,gam26,gam27,
         gam28,gam29,gam30,gam31,gam32,gam33,gam34,gam35,gam36,
         gam37,gam38,gam39,gam40,gam41,gam42,gam43,gam44,gam45,
         gam46,gam47,gam48,gam49,gam50,gam51,gam52,gam53,gam54,
         gam55,gam56,gam57,gam58,gam59,gam60,gam61,gam62,gam63,
         gam64,gam65,gam66,gam67,gam68,gam69,gam70,gam71,gam72,
         gam73,gam74,gam75,gam76,gam77,gam78,gam79,gam80,gam81,
         gam82,gam83,gam84,gam85,gam86,gam87,gam88,gam89,gam90,gam91,gam92,
         file=paste0("chap3/results/p",p,"_model_selection.RData"))
  } else {print("Stop - need to proceed to Stage 4")}
}

p123func(1)
p123func(2)
p123func(3)
