##Fitting UKHLS-only GAMs using mean Q imputation
library(rstan)
load("chap3/results/Qmeanimp.RData")

#Parity 0
source("chap4/scripts/p0_setup.r")
betadim <- 5*ncol(B_A2)+ncol(B_C2)+ncol(B_AC4)
S1 <- S2 <- S3 <- S4 <- S5 <- S6 <- S7 <- S8 <- matrix(0,betadim,betadim)
S1[1:ncol(B_A2),1:ncol(B_A2)] <- S_A2
S2[(1:ncol(B_A2)+ncol(B_A2)),(1:ncol(B_A2)+ncol(B_A2))] <- S_A2
S3[(1:ncol(B_A2)+2*ncol(B_A2)),(1:ncol(B_A2)+2*ncol(B_A2))] <- S_A2
S4[(1:ncol(B_A2)+3*ncol(B_A2)),(1:ncol(B_A2)+3*ncol(B_A2))] <- S_A2
S5[(1:ncol(B_A2)+4*ncol(B_A2)),(1:ncol(B_A2)+4*ncol(B_A2))] <- S_A2
S6[(1:ncol(B_C2)+5*ncol(B_A2)),(1:ncol(B_C2)+5*ncol(B_A2))] <- S_C2
S7[(1:ncol(B_AC4)+5*ncol(B_A2)+ncol(B_C2)),(1:ncol(B_AC4)+5*ncol(B_A2)+ncol(B_C2))] <- S_AF
S8[(1:ncol(B_AC4)+5*ncol(B_A2)+ncol(B_C2)),(1:ncol(B_AC4)+5*ncol(B_A2)+ncol(B_C2))] <- S_CF
B_A21 <- B_A22 <- B_A23 <- B_A24 <- B_A2
B_A21[which(data0$qualf4imp_0!=1),] <- 0
B_A22[which(data0$qualf4imp_0!=2),] <- 0
B_A23[which(data0$qualf4imp_0!=3),] <- 0
B_A24[which(data0$qualf4imp_0!=4),] <- 0
X <- cbind(B_A2,B_A21,B_A22,B_A23,B_A24,B_C2,B_AC4)
wt <- data0w$nw/data0w$n
Xq <- matrix(0,N,4)
for (q in 1:4) Xq[,q] <- ifelse(data0$qualf4imp_0==q,1,0)

standata <- list(N=N,betadim=betadim,succ=succ,tot=tot,X=X,Xq=Xq,wt=wt,
                 S1=S1,S2=S2,S3=S3,S4=S4,S5=S5,S6=S6,S7=S7,S8=S8)
stanout <- stan(file="chap4/stan/p0_UKHLS_only.stan",data=standata,chains=1,iter=2000)
save(stanout,file="chap4/results/p0_UKHLS_only.RData")

#Parity 1
source("chap4/scripts/p1_setup.r")
betadim <- 3*ncol(B_A2)+ncol(B_C2)+ncol(B_T2)+ncol(B_AC4)
S1 <- S2 <- S3 <- S4 <- S5 <- S6 <- S7 <- matrix(0,betadim,betadim)
S1[1:ncol(B_A2),1:ncol(B_A2)] <- S_A2
S2[(1:ncol(B_A2)+ncol(B_A2)),(1:ncol(B_A2)+ncol(B_A2))] <- S_A2
S3[(1:ncol(B_A2)+2*ncol(B_A2)),(1:ncol(B_A2)+2*ncol(B_A2))] <- S_A2
S4[(1:ncol(B_C2)+3*ncol(B_A2)),(1:ncol(B_C2)+3*ncol(B_A2))] <- S_C2
S5[(1:ncol(B_T2)+3*ncol(B_A2)+ncol(B_C2)),(1:ncol(B_T2)+3*ncol(B_A2)+ncol(B_C2))] <- S_T2
S6[(1:ncol(B_AC4)+3*ncol(B_A2)+ncol(B_C2)+ncol(B_T2)),(1:ncol(B_AC4)+3*ncol(B_A2)+ncol(B_C2)+ncol(B_T2))] <- S_AF
S7[(1:ncol(B_AC4)+3*ncol(B_A2)+ncol(B_C2)+ncol(B_T2)),(1:ncol(B_AC4)+3*ncol(B_A2)+ncol(B_C2)+ncol(B_T2))] <- S_CF
B_A21 <- B_A22 <- B_A2
B_A21[which(data1$qualf2bimp_1!=1),] <- 0
B_A22[which(data1$qualf2bimp_1!=2),] <- 0
X <- cbind(B_A2,B_A21,B_A22,B_C2,B_T2,B_AC4)
wt <- data1w$nw/data1w$n
Xq <- matrix(0,N,2)
for (q in 1:2) Xq[,q] <- ifelse(data1$qualf2bimp_1==q,1,0)

standata <- list(N=N,betadim=betadim,succ=succ,tot=tot,X=X,Xq=Xq,wt=wt,
                 S1=S1,S2=S2,S3=S3,S4=S4,S5=S5,S6=S6,S7=S7)
stanout <- stan(file="chap4/stan/p1_UKHLS_only.stan",data=standata,chains=1,iter=2000)
save(stanout,file="chap4/results/p1_UKHLS_only.RData")

#Parity 2
source("chap4/scripts/p2_setup.r")
betadim <- ncol(B_A2)+ncol(B_C2)+ncol(B_T2)+ncol(B_AC4)
S1 <- S2 <- S3 <- S4 <- S5 <- matrix(0,betadim,betadim)
S1[1:ncol(B_A2),1:ncol(B_A2)] <- S_A2
S2[(1:ncol(B_C2)+ncol(B_A2)),(1:ncol(B_C2)+ncol(B_A2))] <- S_C2
S3[(1:ncol(B_T2)+ncol(B_A2)+ncol(B_C2)),(1:ncol(B_T2)+ncol(B_A2)+ncol(B_C2))] <- S_T2
S4[(1:ncol(B_AC4)+ncol(B_A2)+ncol(B_C2)+ncol(B_T2)),(1:ncol(B_AC4)+ncol(B_A2)+ncol(B_C2)+ncol(B_T2))] <- S_AF
S5[(1:ncol(B_AC4)+ncol(B_A2)+ncol(B_C2)+ncol(B_T2)),(1:ncol(B_AC4)+ncol(B_A2)+ncol(B_C2)+ncol(B_T2))] <- S_CF
X <- cbind(B_A2,B_C2,B_T2,B_AC4)
wt <- data2w$nw/data2w$n
Xq <- matrix(0,N,3)
for (q in 1:3) Xq[,q] <- ifelse(data2$qualf3bimp_2==q,1,0)

standata <- list(N=N,betadim=betadim,succ=succ,tot=tot,X=X,Xq=Xq,wt=wt,
                 S1=S1,S2=S2,S3=S3,S4=S4,S5=S5)
stanout <- stan(file="chap4/stan/p2_UKHLS_only.stan",data=standata,chains=1,iter=2000)
save(stanout,file="chap4/results/p2_UKHLS_only.RData")

#Parity 3+
source("chap4/scripts/p3_setup.r")
betadim <- ncol(B_A2)+ncol(B_C2)+ncol(B_T2)+ncol(B_AC4)
S1 <- S2 <- S3 <- S4 <- S5 <- matrix(0,betadim,betadim)
S1[1:ncol(B_A2),1:ncol(B_A2)] <- S_A2
S2[(1:ncol(B_C2)+ncol(B_A2)),(1:ncol(B_C2)+ncol(B_A2))] <- S_C2
S3[(1:ncol(B_T2)+ncol(B_A2)+ncol(B_C2)),(1:ncol(B_T2)+ncol(B_A2)+ncol(B_C2))] <- S_T2
S4[(1:ncol(B_AC4)+ncol(B_A2)+ncol(B_C2)+ncol(B_T2)),(1:ncol(B_AC4)+ncol(B_A2)+ncol(B_C2)+ncol(B_T2))] <- S_AF
S5[(1:ncol(B_AC4)+ncol(B_A2)+ncol(B_C2)+ncol(B_T2)),(1:ncol(B_AC4)+ncol(B_A2)+ncol(B_C2)+ncol(B_T2))] <- S_CF
X <- cbind(B_A2,B_C2,B_T2,B_AC4)
wt <- data3w$nw/data3w$n

standata <- list(N=N,betadim=betadim,succ=succ,tot=tot,X=X,wt=wt,
                 S1=S1,S2=S2,S3=S3,S4=S4,S5=S5)
stanout <- stan(file="chap4/stan/p3_UKHLS_only.stan",data=standata,chains=1,iter=2000)
save(stanout,file="chap4/results/p3_UKHLS_only.RData")
