##Fitting integrated GAMs - parity 0
library(rstan)
load("chap4/data/ONS2018_allc.RData")
load("chap4/results/Qimp.RData")

back <- FALSE # change to TRUE if peforming backtesting
imp <-  FALSE # change to TRUE if using one of the Q imputations instead of the mean imputation

if (imp) {
  N.imp <- 1 # choose a number between 1 and 10
  qualf4imp_0 <- qualf4MI_0[[N.imp]]
}

if (!imp) {
  load("chap3/results/Qmeanimp.RData")
}
  
#GAM set-up
source("chap4/scripts/p0_setup.r")
betadim <- 5*ncol(B_A2)+ncol(B_C2)+ncol(B_AC4)
S1 <- S2 <- S3 <- S4 <- S5 <- S6 <- S7 <- S8 <- matrix(0,betadim,betadim)
S1[1:ncol(B_A2),1:ncol(B_A2)] <- S_A2
S2[(1:ncol(B_A2)+ncol(B_A2)),(1:ncol(B_A2)+ncol(B_A2))] <- S_A2
S3[(1:ncol(B_A2)+2*ncol(B_A2)),(1:ncol(B_A2)+2*ncol(B_A2))] <- S_A2
S4[(1:ncol(B_A2)+3*ncol(B_A2)),(1:ncol(B_A2)+3*ncol(B_A2))] <- S_A2
S5[(1:ncol(B_A2)+4*ncol(B_A2)),(1:ncol(B_A2)+4*ncol(B_A2))] <- S_A2
S6[(1:ncol(B_C2)+5*ncol(B_A2)),(1:ncol(B_C2)+5*ncol(B_A2))] <- S_C2
S7[(1:ncol(B_AC4)+5*ncol(B_A2)+ncol(B_C2)),(1:ncol(B_AC4)+5*ncol(B_A2)+ncol(B_C2))] <- S_AF
S8[(1:ncol(B_AC4)+5*ncol(B_A2)+ncol(B_C2)),(1:ncol(B_AC4)+5*ncol(B_A2)+ncol(B_C2))] <- S_CF
B_A21 <- B_A22 <- B_A23 <- B_A24 <- B_A2
B_A21[which(data0$qualf4imp_0!=1),] <- 0
B_A22[which(data0$qualf4imp_0!=2),] <- 0
B_A23[which(data0$qualf4imp_0!=3),] <- 0
B_A24[which(data0$qualf4imp_0!=4),] <- 0
X <- cbind(B_A2,B_A21,B_A22,B_A23,B_A24,B_C2,B_AC4)
wt <- data0w$nw/data0w$n
Xq <- matrix(0,N,4)
for (q in 1:4) Xq[,q] <- ifelse(data0$qualf4imp_0==q,1,0)

#ONS data set-up
data <- data.frame(age=ONS_births_dat[[1]]$Group.1,coh=ONS_births_dat[[1]]$Group.2,N=ONS_expos_dat[[1]]$x,n=ONS_births_dat[[1]]$x,x=ONS_rates_dat[[1]]$x)
data <- data[which(data$N>0 & data$n>=0 & data$n <= data$N & data$age %in% c(15:44)),]
if (back) data <- data[which(data$age + data$coh <= 2013),]
ONSN <- data$N
ONSn <- data$n
Nm <- nrow(data)
data0f <- expand.grid(age=agerange,coh=cohrange,qualf=1:4)
data0f <- right_join(data,data0f,by=c("age","coh"))
ACind <- which(!is.na(data0f$N))
ACind <- ACind[ACind <= nrow(data0f)/4]
data0f <- data0f[which(!is.na(data0f$N)),]
data0f <- data0f[,-c(3,4,5)]
B_A2f <- B_A2[A_ind[data0f$age-14],]
B_A21f <- B_A22f <- B_A23f <- B_A24f <- B_A2f
B_A21f[which(data0f$qualf!=1),] <- 0
B_A22f[which(data0f$qualf!=2),] <- 0
B_A23f[which(data0f$qualf!=3),] <- 0
B_A24f[which(data0f$qualf!=4),] <- 0
Xf <- cbind(B_A2f,B_A21f,B_A22f,B_A23f,B_A24f,
            B_C2all[C_indall[data0f$coh-1944],],
            B_ACfull3[rep(ACind,4),])
Nf <- nrow(Xf)
Xqf <- matrix(0,Nf,4)
for (q in 1:4) Xqf[,q] <- ifelse(data0f$qualf==q,1,0)

#ACQ model set-up
newdata0 <- aggregate(qualf4_0 ~ age_0 + coh_0, FUN = function(x) c(y=length(x), q1=length(x[x==1]), q2=length(x[x==2]), q3=length(x[x==3]), q4=length(x[x==4])), subset=coh_0 <= 1982)
newdata0 <- data.frame(newdata0$age_0,newdata0$coh_0,newdata0$qualf4_0)
colnames(newdata0) <- c("a","c","y","y1","y2","y3","y4")
newdata0$a <- newdata0$a - median(15:44)
newdata0$yw <- aggregate(weights_0st ~ age_0 + coh_0, FUN = sum, subset = coh_0 <= 1982)$weights_0st
newdata0$wtmult <- newdata0$yw/newdata0$y
colnames(newdata0) <- c("a","c","y",paste0(1:4),"yw","wtmult")
qmax0 <- 4

newdata02 <- expand.grid(a=agerange,c=cohrange)
newdata02$cc <- newdata02$c-median(1945:1982)
newdata02$cind72 <- ifelse(newdata02$c >= 1972, 1972, newdata02$c)
newdata02$ccind72 <- newdata02$cind72-1944
newdata02$cc72 <- ifelse(newdata02$c<=1971,0,newdata02$cc)
newdata02$aind <- newdata02$a-14
newdata02$a <- newdata02$a-median(15:44)

newdata02 <- left_join(newdata02,newdata0,by=c("a","c"))
Nac <- nrow(newdata02)
y <- newdata02[,paste0(1:qmax0)]
yind <- which(!is.na(y[,1]))
Nobs <- length(yind)
y[is.na(y)] <- 0
cc72 <- newdata02$cc72
ccind72 <- newdata02$ccind72
Nc72 <- max(ccind72)
a <- newdata02$a
aind <- newdata02$aind
Na <- max(aind)
wtc <- newdata02$wtmult
wtc[is.na(wtc)] <- 0

#Fit Stan models
standata <- list(N=N,Nm=Nm,Nf=Nf,Nac=Nac,Nc72=Nc72,Na=Na,Nobs=Nobs,
                 betadim=betadim,succ=succ,tot=tot,ONSN=ONSN,ONSn=ONSn,
                 y=y,cc72=cc72,ccind72=ccind72,aind=aind,a=a,ACind=ACind,yind=yind,wtc=wtc,wt=wt,
                 X=X,Xf=Xf,Xq=Xq,Xqf=Xqf,S1=S1,S2=S2,S3=S3,S4=S4,S5=S5,S6=S6,S7=S7,S8=S8)

#50/50
stanout <- stan(file="chap4/stan/p0_5050.stan",data=standata,chains=1,iter=2000)
if (!imp & !back) save(stanout,file="chap4/results/p0_5050.RData")
if ( imp & !back) save(stanout,file=paste0("chap4/results/p0_5050_imp",N.imp,".RData"))
if (!imp &  back) save(stanout,file="chap4/results/p0_5050_2013.RData")
if ( imp &  back) save(stanout,file=paste0("chap4/results/p0_5050_imp",N.imp,"_2013.RData"))

# #33/67
# stanout <- stan(file="chap4/stan/p0_3367.stan",data=standata,chains=1,iter=2000)
# if (!imp & !back) save(stanout,file="chap4/results/p0_3367.RData")
# if ( imp & !back) save(stanout,file=paste0("chap4/results/p0_3367_imp",N.imp,".RData"))
# if (!imp &  back) save(stanout,file="chap4/results/p0_3367_2013.RData")
# if ( imp &  back) save(stanout,file=paste0("chap4/results/p0_3367_imp",N.imp,"_2013.RData"))
# 
# #25/75
# stanout <- stan(file="chap4/stan/p0_2575.stan",data=standata,chains=1,iter=2000)
# if (!imp & !back) save(stanout,file="chap4/results/p0_2575.RData")
# if ( imp & !back) save(stanout,file=paste0("chap4/results/p0_2575_imp",N.imp,".RData"))
# if (!imp &  back) save(stanout,file="chap4/results/p0_2575_2013.RData")
# if ( imp &  back) save(stanout,file=paste0("chap4/results/p0_2575_imp",N.imp,"_2013.RData"))
# 
# #20/80
# stanout <- stan(file="chap4/stan/p0_2080.stan",data=standata,chains=1,iter=2000)
# if (!imp & !back) save(stanout,file="chap4/results/p0_2080.RData")
# if ( imp & !back) save(stanout,file=paste0("chap4/results/p0_2080_imp",N.imp,".RData"))
# if (!imp &  back) save(stanout,file="chap4/results/p0_2080_2013.RData")
# if ( imp &  back) save(stanout,file=paste0("chap4/results/p0_2080_imp",N.imp,"_2013.RData"))
# 
# #10/90
# stanout <- stan(file="chap4/stan/p0_1090.stan",data=standata,chains=1,iter=2000)
# if (!imp & !back) save(stanout,file="chap4/results/p0_1090.RData")
# if ( imp & !back) save(stanout,file=paste0("chap4/results/p0_1090_imp",N.imp,".RData"))
# if (!imp &  back) save(stanout,file="chap4/results/p0_1090_2013.RData")
# if ( imp &  back) save(stanout,file=paste0("chap4/results/p0_1090_imp",N.imp,"_2013.RData"))
