##Parity 3+ GAM set-up
#Set-up
agerange <- 15:44
cohrange <- 1945:2003
No <- 9
Nn <- No-1
Nn2 <- Nn^2
data3 <- groupfunc("birth.bin_3",c("age_3", "coh_3", "gapc_3"))
data3w <- groupfuncw("weights_3st",c("age_3", "coh_3", "gapc_3"))
N <- nrow(data3)
succ <- data3$succ
tot <- data3$n

#Indexes
A_ind <- indexfunc(data3$age_3)
A_indall <- c(A_ind,nrow(data3)+1:length(15:(min(data3$age_3)-1)))
A_indall <- A_indall[order(c(sort(unique(data3$age_3)),setdiff(agerange,unique(data3$age_3))))]
C_ind <- indexfunc(data3$coh_3)
C_indall <- c(C_ind,nrow(data3)+1:length((max(data3$coh_3)+1):2003))
T_ind <- indexfunc(data3$gapc_3)

#Basis functions
#Unconstrained
B_A1 <- bbase(c(data3$age_3,15:(min(data3$age_3)-1)), n.knots=No-2, deg=3)
B_C1 <- bbase(c(data3$coh_3,(max(data3$coh_3)+1):2003), n.knots=No-2, deg=3)
B_T1 <- bbase(data3$gapc_3, n.knots=No-2, deg=3)

#Constrained
st0ind <- 1:nrow(data3)
B_A2all <- newXfunc3(B_A1,st0ind)$newX
B_A2 <- B_A2all[st0ind,]
B_C2all <- newXfunc3(B_C1,st0ind)$newX
B_C2 <- B_C2all[st0ind,]
B_T2 <- newXfunc2(B_T1)$newX

#Reparameterised
B_A3all <- eqXfunc(data3, "age_3", No, B_A1, st0ind)$newX
B_A3 <- B_A3all[st0ind,]
B_C3all <- eqXfunc(data3, "coh_3", No, B_C1, st0ind)$newX
B_C3 <- B_C3all[st0ind,]

B_AC3 <- matrix(0,N,Nn2)
k <- 1
for (i in 1:Nn) {
  for (j in 1:Nn) {
    B_AC3[,k] <- B_A3[,j]*B_C3[,i]
    k <- k+1 
  }
}

B_Afull3 <- B_A3all[rep(A_indall,length(cohrange)),]
B_Cfull3 <- B_C3all[rep(C_indall,each=length(agerange)),]
B_ACfull3 <- matrix(0,length(cohrange)*length(agerange),Nn2)
k <- 1
for (i in 1:Nn) {
  for (j in 1:Nn) {
    B_ACfull3[,k] <- B_Afull3[,j]*B_Cfull3[,i]
    k <- k+1 
  }
}

B_AC4 <- B_AC3

#Penalties
#Unconstrained
D <- diff(diag(No),1)
S <- t(D)%*%D

#Constrained
maXX <- norm(B_A1,type="I")^2 #square of infinity norm (maximum absolute row sum)
maS <- norm(S,type="O")/maXX #divide one norm (maximum absolute column sum) by maXX
S_A1 <- S/maS #divide original penalty matrix by maS
S.scale_A1 <- maS #4
Z <- newXfunc3(B_A1,st0ind)$Z
S_A2 <- t(Z)%*%S_A1%*%Z

maXX <- norm(B_C1,type="I")^2 #square of infinity norm (maximum absolute row sum)
maS <- norm(S,type="O")/maXX #divide one norm (maximum absolute column sum) by maXX
S_C1 <- S/maS #divide original penalty matrix by maS
S.scale_C1 <- maS #4
Z <- newXfunc3(B_C1,st0ind)$Z
S_C2 <- t(Z)%*%S_C1%*%Z

maXX <- norm(B_T1,type="I")^2 #square of infinity norm (maximum absolute row sum)
maS <- norm(S,type="O")/maXX #divide one norm (maximum absolute column sum) by maXX
S_T1 <- S/maS #divide original penalty matrix by maS
S.scale_T1 <- maS #4
Z <- newXfunc2(B_T1)$Z
S_T2 <- t(Z)%*%S_T1%*%Z

#Reparameterised
XPA <- eqXfunc(data3, "age_3", No, B_A1, st0ind)$XP
XPC <- eqXfunc(data3, "coh_3", No, B_C1, st0ind)$XP
S_A3 <- t(XPA)%*%S_A2%*%XPA
S_C3 <- t(XPC)%*%S_C2%*%XPC
S_A4 <- S_A3/eigen(S_A3, symmetric = TRUE, only.values = TRUE)$values[1]
S_C4 <- S_C3/eigen(S_C3, symmetric = TRUE, only.values = TRUE)$values[1]
S_A5 <- kronecker(diag(Nn),S_A4)
S_C5 <- kronecker(S_C4,diag(Nn))

maXX <- norm(B_AC3,type="I")^2
maS <- norm(S_A5,type="O")/maXX
S_AF <- S_A5/maS
S.scale_A2 <- maS

maXX <- norm(B_AC3,type="I")^2
maS <- norm(S_C5,type="O")/maXX
S_CF <- S_C5/maS
S.scale_C2 <- maS
