##Parity 3+ processing (UKHLS-only)
betadim <- ncol(B_A2)+ncol(B_C2)+ncol(B_T2)+ncol(B_AC4)
Yhat <- extract(stanout,pars="Y_hat",permuted=F)
Yhatm3 <- apply(inv.logit(Yhat[,1,]),2,mean)
beta0 <- extract(stanout,pars="beta0",permuted=F)
beta <- extract(stanout,pars="beta",permuted=F)
XB <- B_A2all[A_indall,]%*%t(beta[,1,1:8])
Adat3 <- data.frame(parity=p,cov=agerange,fit=apply(XB,1,mean),lower=apply(XB,1,quantile,p=0.025),upper=apply(XB,1,quantile,p=0.975))
XB <- B_C2all[C_indall,]%*%t(beta[,1,9:16])
Cdat3 <- data.frame(parity=p,cov=cohrange,fit=apply(XB,1,mean),lower=apply(XB,1,quantile,p=0.025),upper=apply(XB,1,quantile,p=0.975))
XB <- B_T2[T_ind,]%*%t(beta[,1,17:24])
Tdat3 <- data.frame(parity=p,cov=1:11,fit=apply(XB,1,mean),lower=apply(XB,1,quantile,p=0.025),upper=apply(XB,1,quantile,p=0.975))
XB <- list()
for (i in 1:1000)
  XB[[i]] <- matrix(rep(B_A2all[A_indall,]%*%beta[i,1,1:8],length(cohrange)),nrow=length(agerange),byrow=F)+
  matrix(rep(B_C2all[C_indall,]%*%beta[i,1,9:16],length(agerange)),nrow=length(agerange),byrow=T)+
  matrix(B_ACfull3[,-ind]%*%beta[i,1,25:betadim],nrow=length(agerange),byrow=F)
XBl <- XBu <- XB[[1]]
for (i in 1:length(agerange)) {
  for (j in 1:length(cohrange)) {
    tmp <- numeric()
    for (k in 1:1000) tmp[k] <- XB[[k]][i,j]
    XBl[i,j] <- quantile(tmp,p=0.025)
    XBu[i,j] <- quantile(tmp,p=0.975)
  }
}
XBm <- Reduce("+",XB)/1000
ACACdat3 <- data.frame(parity=p,age=rep(agerange,length(cohrange)),
                       coh=rep(cohrange,each=length(agerange)),
                       fit=as.vector(XBm),
                       lower=as.vector(XBl),
                       upper=as.vector(XBu))
XB <- B_ACfull3[,-ind]%*%t(beta[,1,25:betadim])
ACdat3 <- data.frame(parity=p,age=rep(agerange,length(cohrange)),
                     coh=rep(cohrange,each=length(agerange)),
                     fit=apply(XB,1,mean),
                     lower=apply(XB,1,quantile,p=0.025),
                     upper=apply(XB,1,quantile,p=0.975))
wt3 <- data3w$nw/data3w$n
fdat3 <- data.frame(parity=p,age=data3$age_3[wt3>0],
                    coh=data3$coh_3[wt3>0],
                    gapc=data3$gapc_3[wt3>0],
                    stan=Yhatm3[wt3>0])
probfit <- list()
for (t in 1:11) {
  probfit[[t]] <- list()
  for (i in 1:1000) {
    probfit[[t]][[i]] <- inv.logit(matrix(rep(beta0[i,1,1],length(cohrange)*length(agerange)),nrow=length(agerange))+
                                     matrix(rep(B_A2all[A_indall,]%*%beta[i,1,1:8],length(cohrange)),nrow=length(agerange),byrow=F)+
                                     matrix(rep(B_C2all[C_indall,]%*%beta[i,1,9:16],length(agerange)),nrow=length(agerange),byrow=T)+
                                     matrix(rep(B_T2[T_ind[t],]%*%beta[i,1,17:24],length(cohrange)*length(agerange)),nrow=length(agerange))+
                                     matrix(B_ACfull3[,-ind]%*%beta[i,1,25:betadim],nrow=length(agerange),byrow=F))

  }
}
probfitm <- list()
for (i in 1:11) probfitm[[i]] <- Reduce("+",probfit[[i]])/1000
probfitlw <- probfitup <- probfitm
for (t in 1:11) {
  for (i in 1:length(agerange)) {
    for (j in 1:length(cohrange)) {
      tmp <- numeric()
      for (k in 1:1000) tmp[k] <- probfit[[t]][[k]][i,j]
      probfitlw[[t]][i,j] <- quantile(tmp,p=0.025)
      probfitup[[t]][i,j] <- quantile(tmp,p=0.975)
    }
  }
}
probdat3 <- data.frame(parity=p,age=rep(rep(agerange,length(cohrange)),11),
                       coh=rep(rep(cohrange,each=length(agerange)),11),
                       gapc=rep(1:11,each=length(cohrange)*length(agerange)),
                       fit=as.vector(unlist(probfitm)),
                       lower=as.vector(unlist(probfitlw)),
                       upper=as.vector(unlist(probfitup)))

#Extract results
results$Yhatm[[n]] <- Yhatm3
results$Adat[[n]] <- Adat3
results$Cdat[[n]] <- Cdat3
results$Tdat[[n]] <- Tdat3
results$ACACdat[[n]] <- ACACdat3
results$ACdat[[n]] <- ACdat3
results$fdat[[n]] <- fdat3
results$probdat[[n]] <- probdat3

#Marginalisation
data3f <- expand.grid(age=agerange,coh=cohrange,gapc=1:11)
Xf <- cbind(B_A2all[A_indall[data3f$age-14],],
            B_C2all[C_indall[data3f$coh-1944],],
            B_T2[T_ind[data3f$gapc],],
            B_ACfull3[rep(1:nrow(B_ACfull3),11),-ind])
Nf <- nrow(data3f)
Nm <- length(agerange)*length(cohrange)
Afind <- c(data3f$age-14)[1:Nm]

thetaf <- inv.logit(matrix(rep(beta0,Nf),ncol=1000,byrow=T)+
                      Xf%*%t(beta[,1,]))
psurvf <- matrix(0,1000,Nm)
for (j in 1:1000) {
  Tpropj <- matrix(Tprop[j,1,],ncol=11,byrow=F)
  for (i in 1:Nm) {
    psurvf[j,i] <- Tpropj[Afind[i],1]*thetaf[i,j]+
      Tpropj[Afind[i],2]*thetaf[Nm+i,j]+
      Tpropj[Afind[i],3]*thetaf[2*Nm+i,j]+
      Tpropj[Afind[i],4]*thetaf[3*Nm+i,j]+
      Tpropj[Afind[i],5]*thetaf[4*Nm+i,j]+
      Tpropj[Afind[i],6]*thetaf[5*Nm+i,j]+
      Tpropj[Afind[i],7]*thetaf[6*Nm+i,j]+
      Tpropj[Afind[i],8]*thetaf[7*Nm+i,j]+
      Tpropj[Afind[i],9]*thetaf[8*Nm+i,j]+
      Tpropj[Afind[i],10]*thetaf[9*Nm+i,j]+
      Tpropj[Afind[i],11]*thetaf[10*Nm+i,j]
  }
}
results$psurvf[[n]] <- psurvf
results$psurvfm[[n]] <- apply(psurvf,2,mean)
results$psurvfl[[n]] <- apply(psurvf,2,quantile,p=0.025)
results$psurvfu[[n]] <- apply(psurvf,2,quantile,p=0.975)
psumf <- apply(psurvf,1,function(x) aggregate(x,by=list(data3f$coh[1:Nm]),sum)$x)
results$psumfm[[n]] <- apply(psumf,1,mean)
results$psumfl[[n]] <- apply(psumf,1,quantile,p=0.025)
results$psumfu[[n]] <- apply(psumf,1,quantile,p=0.975)
wsumf <- apply(psurvf,1,function(x) aggregate(x,by=list(data3f$coh[1:Nm]),function(x) sum(15:44*x)/sum(x))$x)
results$wsumfm[[n]] <- apply(wsumf,1,mean)
results$wsumfl[[n]] <- apply(wsumf,1,quantile,p=0.025)
results$wsumfu[[n]] <- apply(wsumf,1,quantile,p=0.975)
