data {
  int Na;
  int Nab;
  int y1[Na,11];
  int y2[Na,11];
  vector[Na] a;
  vector[Na] a2;
  int ab[Na,10];
  vector[Na] wt1;
  vector[Na] wt2;
}

parameters {
  real beta0;
  vector[10] betaA1;
  vector[10] betaA2;
  vector[10] betaA_2;
  vector[Nab] betaAb1;
  vector[Nab] betaAb2;
  real<lower=0> sigmaAb;
}

transformed parameters {
  simplex[3] theta3_1;
  simplex[4] theta4_1;
  simplex[5] theta5_1;
  simplex[6] theta6_1;
  simplex[7] theta7_1;
  simplex[8] theta8_1;
  simplex[9] theta9_1;
  simplex[10] theta10_1;
  simplex[11] theta11_1[Na-8];
  simplex[3] theta3_2;
  simplex[4] theta4_2;
  simplex[5] theta5_2;
  simplex[6] theta6_2;
  simplex[7] theta7_2;
  simplex[8] theta8_2;
  simplex[9] theta9_2;
  simplex[10] theta10_2;
  simplex[11] theta11_2[Na-8];
  matrix[Na,11] Yhat_1;
  matrix[Na,11] Yhat_2;
  matrix[Na,11] Tprop1;
  matrix[Na,11] Tprop2;
  Yhat_1[,1] = rep_vector(0,Na);
  Yhat_2[,1] = rep_vector(0,Na);
  for (i in 2:10) {
    Yhat_1[,i] = betaA1[i-1]*a + betaA_2[i-1]*a2 + betaAb1[ab[,(i-1)]];
    Yhat_2[,i] = betaA2[i-1]*a + betaA_2[i-1]*a2 + betaAb2[ab[,(i-1)]];
  }
  Yhat_1[,11] = beta0 + betaA1[10]*a + betaA_2[10]*a2 + betaAb1[ab[,10]];
  Yhat_2[,11] = beta0 + betaA2[10]*a + betaA_2[10]*a2 + betaAb2[ab[,10]];
  theta3_1 = softmax(to_vector(Yhat_1[1,1:3]));
  theta4_1 = softmax(to_vector(Yhat_1[2,1:4]));
  theta5_1 = softmax(to_vector(Yhat_1[3,1:5]));
  theta6_1 = softmax(to_vector(Yhat_1[4,1:6]));
  theta7_1 = softmax(to_vector(Yhat_1[5,1:7]));
  theta8_1 = softmax(to_vector(Yhat_1[6,1:8]));
  theta9_1 = softmax(to_vector(Yhat_1[7,1:9]));
  theta10_1 = softmax(to_vector(Yhat_1[8,1:10]));
  for (i in 1:(Na-8)) {
    theta11_1[i] = softmax(to_vector(Yhat_1[(i+8),]));
  }
  theta3_2 = softmax(to_vector(Yhat_2[1,1:3]));
  theta4_2 = softmax(to_vector(Yhat_2[2,1:4]));
  theta5_2 = softmax(to_vector(Yhat_2[3,1:5]));
  theta6_2 = softmax(to_vector(Yhat_2[4,1:6]));
  theta7_2 = softmax(to_vector(Yhat_2[5,1:7]));
  theta8_2 = softmax(to_vector(Yhat_2[6,1:8]));
  theta9_2 = softmax(to_vector(Yhat_2[7,1:9]));
  theta10_2 = softmax(to_vector(Yhat_2[8,1:10]));
  for (i in 1:(Na-8)) {
    theta11_2[i] = softmax(to_vector(Yhat_2[(i+8),]));
  }
  Tprop1[1,1:3] = to_row_vector(theta3_1);
  Tprop1[1,4:11] = rep_row_vector(0,8);
  Tprop1[2,1:4] = to_row_vector(theta4_1);
  Tprop1[2,5:11] = rep_row_vector(0,7);
  Tprop1[3,1:5] = to_row_vector(theta5_1);
  Tprop1[3,6:11] = rep_row_vector(0,6);
  Tprop1[4,1:6] = to_row_vector(theta6_1);
  Tprop1[4,7:11] = rep_row_vector(0,5);
  Tprop1[5,1:7] = to_row_vector(theta7_1);
  Tprop1[5,8:11] = rep_row_vector(0,4);
  Tprop1[6,1:8] = to_row_vector(theta8_1);
  Tprop1[6,9:11] = rep_row_vector(0,3);
  Tprop1[7,1:9] = to_row_vector(theta9_1);
  Tprop1[7,10:11] = rep_row_vector(0,2);
  Tprop1[8,1:10] = to_row_vector(theta10_1);
  Tprop1[8,11] = 0;
  for (i in 1:(Na-8)) {
    Tprop1[(i+8),] = to_row_vector(theta11_1[i]);
  }
  Tprop2[1,1:3] = to_row_vector(theta3_2);
  Tprop2[1,4:11] = rep_row_vector(0,8);
  Tprop2[2,1:4] = to_row_vector(theta4_2);
  Tprop2[2,5:11] = rep_row_vector(0,7);
  Tprop2[3,1:5] = to_row_vector(theta5_2);
  Tprop2[3,6:11] = rep_row_vector(0,6);
  Tprop2[4,1:6] = to_row_vector(theta6_2);
  Tprop2[4,7:11] = rep_row_vector(0,5);
  Tprop2[5,1:7] = to_row_vector(theta7_2);
  Tprop2[5,8:11] = rep_row_vector(0,4);
  Tprop2[6,1:8] = to_row_vector(theta8_2);
  Tprop2[6,9:11] = rep_row_vector(0,3);
  Tprop2[7,1:9] = to_row_vector(theta9_2);
  Tprop2[7,10:11] = rep_row_vector(0,2);
  Tprop2[8,1:10] = to_row_vector(theta10_2);
  Tprop2[8,11] = 0;
  for (i in 1:(Na-8)) {
    Tprop2[(i+8),] = to_row_vector(theta11_2[i]);
  }
}

model {
  beta0 ~ normal(0,10);
  betaA1 ~ normal(0,10);
  betaA2 ~ normal(0,10);
  betaA_2 ~ normal(0,10);
  betaAb1[1] ~ normal(0,10);
  betaAb2[1] ~ normal(0,10);
  for (i in 2:Nab) {
    betaAb1[i] ~ normal(betaAb1[i-1], sigmaAb);
    betaAb2[i] ~ normal(betaAb2[i-1], sigmaAb);
  }
  sigmaAb ~ normal(0,0.01);
  target += wt1[1]*multinomial_lpmf(y1[1,1:3] | theta3_1);
  target += wt1[2]*multinomial_lpmf(y1[2,1:4] | theta4_1);
  target += wt1[3]*multinomial_lpmf(y1[3,1:5] | theta5_1);
  target += wt1[4]*multinomial_lpmf(y1[4,1:6] | theta6_1);
  target += wt1[5]*multinomial_lpmf(y1[5,1:7] | theta7_1);
  target += wt1[6]*multinomial_lpmf(y1[6,1:8] | theta8_1);
  target += wt1[7]*multinomial_lpmf(y1[7,1:9] | theta9_1);
  target += wt1[8]*multinomial_lpmf(y1[8,1:10] | theta10_1);
  for (i in 1:(Na-8)) {
    target += wt1[(i+8)]*multinomial_lpmf(y1[(i+8),] | theta11_1[i]);
  }
  target += wt2[1]*multinomial_lpmf(y2[1,1:3] | theta3_2);
  target += wt2[2]*multinomial_lpmf(y2[2,1:4] | theta4_2);
  target += wt2[3]*multinomial_lpmf(y2[3,1:5] | theta5_2);
  target += wt2[4]*multinomial_lpmf(y2[4,1:6] | theta6_2);
  target += wt2[5]*multinomial_lpmf(y2[5,1:7] | theta7_2);
  target += wt2[6]*multinomial_lpmf(y2[6,1:8] | theta8_2);
  target += wt2[7]*multinomial_lpmf(y2[7,1:9] | theta9_2);
  target += wt2[8]*multinomial_lpmf(y2[8,1:10] | theta10_2);
  for (i in 1:(Na-8)) {
    target += wt2[(i+8)]*multinomial_lpmf(y2[(i+8),] | theta11_2[i]);
  }
}
