data {
  int N;
  int betadim;
  int succ[N];
  int tot[N];
  vector[N] wt;
  matrix[N,betadim] X;
  matrix[N,2] Xq;
  matrix[betadim,betadim] S1;
  matrix[betadim,betadim] S2;
  matrix[betadim,betadim] S3;
  matrix[betadim,betadim] S4;
  matrix[betadim,betadim] S5;
  matrix[betadim,betadim] S6;
  matrix[betadim,betadim] S7;
}

parameters {
  vector[betadim] beta;
  real betaQraw;
  real beta0;
  real<lower=0> tau1;
  real<lower=0> tau2;
  real<lower=0> tau3;
  real<lower=0> tau4;
  real<lower=0> tau5;
  real<lower=0> tau6;
  real<lower=0> tau7;
}

transformed parameters {
  vector[N] Y_hat;
  row_vector[betadim] betat;
  matrix[betadim,betadim] S;
  vector[2] betaQ;
  betaQ[1] = 0;
  betaQ[2] = betaQraw;
  S = S1/tau1 + S2/tau2 + S3/tau3 + S4/tau4 + S5/tau5 + S6/tau6 + S7/tau7;
  betat = beta';
  Y_hat = beta0 + Xq*betaQ + X*beta;
}

model {
  beta0 ~ normal(0,10);
  betaQraw ~ normal(0,10);
  tau1 ~ normal(0,10);
  tau2 ~ normal(0,10);
  tau3 ~ normal(0,10);
  tau4 ~ normal(0,10);
  tau5 ~ normal(0,10);
  tau6 ~ normal(0,10);
  tau7 ~ normal(0,10);
  for (n in 1:N) {
    target += wt[n]*binomial_logit_lpmf(succ[n] | tot[n], Y_hat[n]);
  }
  target += 0.5*log_determinant(S)-0.5*betat*S*beta;
}
