data {
  int N;
  int Nm;
  int Nf;
  int Na;
  int Nab;
  int betadim;
  int succ[N];
  int tot[N];
  int ONSn[Nm];
  int ONSN[Nm];
  int y[Na,11];
  vector[Na] a;
  int ab[Na,10];
  int Afind[Nm];
  vector[Na] wtc;
  vector[N] wt;
  matrix[N,betadim] X;
  matrix[Nf,betadim] Xf;
  matrix[betadim,betadim] S1;
  matrix[betadim,betadim] S2;
  matrix[betadim,betadim] S3;
  matrix[betadim,betadim] S4;
  matrix[betadim,betadim] S5;
}

parameters {
  vector[betadim] beta;
  real beta0;
  vector[10] betaA;
  vector[Nab] betaAb;
  real<lower=0> sigmaAb;
  real<lower=0> tau1;
  real<lower=0> tau2;
  real<lower=0> tau3;
  real<lower=0> tau4;
  real<lower=0> tau5;
}

transformed parameters {
  vector[N] Y_hat;
  row_vector[betadim] betat;
  matrix[betadim,betadim] S;
  vector[Nf] Y_hatf;
  vector[Nf] eY_hatf;
  matrix[Na,11] Y_hatAT;
  vector[Nm] psurv;
  vector[Nm] lpsurv;
  simplex[3] theta3;
  simplex[4] theta4;
  simplex[5] theta5;
  simplex[6] theta6;
  simplex[7] theta7;
  simplex[8] theta8;
  simplex[9] theta9;
  simplex[10] theta10;
  simplex[11] theta11[Na-8];
  matrix[30,11] Tprop;
  Y_hatAT[,1] = rep_vector(0,Na);
  for (i in 2:11) {
    Y_hatAT[,i] = betaA[i-1]*a + betaAb[ab[,(i-1)]];
  }
  theta3 = softmax(to_vector(Y_hatAT[1,1:3]));
  theta4 = softmax(to_vector(Y_hatAT[2,1:4]));
  theta5 = softmax(to_vector(Y_hatAT[3,1:5]));
  theta6 = softmax(to_vector(Y_hatAT[4,1:6]));
  theta7 = softmax(to_vector(Y_hatAT[5,1:7]));
  theta8 = softmax(to_vector(Y_hatAT[6,1:8]));
  theta9 = softmax(to_vector(Y_hatAT[7,1:9]));
  theta10 = softmax(to_vector(Y_hatAT[8,1:10]));
  for (i in 1:(Na-8)) {
    theta11[i] = softmax(to_vector(Y_hatAT[(i+8),]));
  }
  Tprop[1,1:3] = to_row_vector(theta3);
  Tprop[1,4:11] = rep_row_vector(0,8);
  Tprop[2,1:4] = to_row_vector(theta4);
  Tprop[2,5:11] = rep_row_vector(0,7);
  Tprop[3,1:5] = to_row_vector(theta5);
  Tprop[3,6:11] = rep_row_vector(0,6);
  Tprop[4,1:6] = to_row_vector(theta6);
  Tprop[4,7:11] = rep_row_vector(0,5);
  Tprop[5,1:7] = to_row_vector(theta7);
  Tprop[5,8:11] = rep_row_vector(0,4);
  Tprop[6,1:8] = to_row_vector(theta8);
  Tprop[6,9:11] = rep_row_vector(0,3);
  Tprop[7,1:9] = to_row_vector(theta9);
  Tprop[7,10:11] = rep_row_vector(0,2);
  Tprop[8,1:10] = to_row_vector(theta10);
  Tprop[8,11] = 0;
  for (i in 1:(Na-8)) {
    Tprop[(i+8),] = to_row_vector(theta11[i]);
  }
  S = S1/tau1 + S2/tau2 + S3/tau3 + S4/tau4 + S5/tau5;
  betat = beta';
  Y_hat = beta0 + X*beta;
  Y_hatf = beta0 + Xf*beta;
  eY_hatf = inv_logit(Y_hatf);
  for (i in 1:Nm) {
    psurv[i] = Tprop[Afind[i],1]*eY_hatf[i]+
    Tprop[Afind[i],2]*eY_hatf[Nm+i]+
    Tprop[Afind[i],3]*eY_hatf[2*Nm+i]+
    Tprop[Afind[i],4]*eY_hatf[3*Nm+i]+
    Tprop[Afind[i],5]*eY_hatf[4*Nm+i]+
    Tprop[Afind[i],6]*eY_hatf[5*Nm+i]+
    Tprop[Afind[i],7]*eY_hatf[6*Nm+i]+
    Tprop[Afind[i],8]*eY_hatf[7*Nm+i]+
    Tprop[Afind[i],9]*eY_hatf[8*Nm+i]+
    Tprop[Afind[i],10]*eY_hatf[9*Nm+i]+
    Tprop[Afind[i],11]*eY_hatf[10*Nm+i];
  }
  lpsurv = logit(psurv);
}

model {
  beta0 ~ normal(0,10);
  tau1 ~ normal(0,10);
  tau2 ~ normal(0,10);
  tau3 ~ normal(0,10);
  tau4 ~ normal(0,10);
  tau5 ~ normal(0,10);
  betaA ~ normal(0,10);
  betaAb[1] ~ normal(0,10);
  for (i in 2:Nab) {
    betaAb[i] ~ normal(betaAb[i-1], sigmaAb);
  }
  sigmaAb ~ normal(0,0.01);
  target += wtc[4]*multinomial_lpmf(y[4,1:6] | theta6);
  target += wtc[5]*multinomial_lpmf(y[5,1:7] | theta7);
  target += wtc[6]*multinomial_lpmf(y[6,1:8] | theta8);
  target += wtc[7]*multinomial_lpmf(y[7,1:9] | theta9);
  target += wtc[8]*multinomial_lpmf(y[8,1:10] | theta10);
  for (i in 1:(Na-8)) {
    target += wtc[(i+8)]*multinomial_lpmf(y[(i+8),] | theta11[i]);
  }
  for (n in 1:N) {
    target += 0.998*wt[n]*binomial_logit_lpmf(succ[n] | tot[n], Y_hat[n]);
  }
  for (m in 1:Nm) {
    target += 0.002*binomial_logit_lpmf(ONSn[m] | ONSN[m], lpsurv[m]);
  }
  target += 0.5*log_determinant(S)-0.5*betat*S*beta;
}
