# -*- coding: utf-8 -*-
"""
Created on Fri Jul  5 16:20:08 2019

@author: Dhirendra Vaidya (dhirendra22121987@gmail.com)
"""

import numpy as np
import matplotlib.pyplot as plt
from scipy.optimize import least_squares

class ExponentialFit:
    def __init__(self, xdata, ydata):
        self.name = 'Exponential Fit'
        self.equation = 'A*e^(kx)'
        self.xdata = xdata
        self.ydata = ydata

    def analytical(self, x, A, k):
        return A*np.exp(k*x)

    def error(self, p):
        return self.ydata - self.analytical(self.xdata, p[0], p[1])

    def fit(self):
        results = least_squares(self.error, np.array([1.0, 1.0]))
        return results.x
