# -*- coding: utf-8 -*-
"""
Created on Mon Jul 29 14:12:29 2019

@author: dv1f19
"""

"""
USAGE
unzip Library.zip to Library
on linux system export this Library path in a MEM_MODEL_LIBRARY variable
for e.g.
export MEM_MODEL_LIBRARY=/home/dv1f19/Library

to run this file
ipython3
run <this file>
"""

import sys
from PyQt5 import QtWidgets
qapp = QtWidgets.QApplication(sys.argv)
import os
sys.path.append(os.environ.get('MEM_MODEL_LIBRARY'))
import numpy as np
import pandas as pd
from parameter_fit_utilities import ParameterFitData, ParameterFitDataXlsx, ExponentialModel
from static_IV_utilities import SchottkyLikeIVFit, APhiBFit, StaticIVModel
from advanced_plot import AdvancedPlot
from fitting_models import ExponentialFit
from matplotlib.pyplot import cm
from scipy.optimize import least_squares
import PyQt5.QtWidgets as QtWidgets
import pickle


parameter_fit_file = 'memristor_Ib_dataset/S1_D55_pf2.xlsx'

skip_biases = 2
PF = ParameterFitDataXlsx(parameter_fit_file, skip_biases=skip_biases)

cmap = cm.get_cmap(name='tab10', lut=len(PF.Temperatures)+1)


k = 8.617e-5
files = ['memristor_Ib_dataset/40C/iv2.csv',
         'memristor_Ib_dataset/50C/iv2.csv',
         'memristor_Ib_dataset/60C/iv2.csv',
         'memristor_Ib_dataset/70C/iv2.csv',
         'memristor_Ib_dataset/80C/iv2.csv']

c = 0.5
cT = 2.0


pltt = AdvancedPlot(2,2)
ax0_1 = pltt.ax[0].twinx()
ax1_1 = pltt.ax[2].twinx()
ax0_1.tick_params(labelsize=12)
ax1_1.tick_params(labelsize=12)

Temperatures = PF.Temperatures
APrime = np.zeros(len(Temperatures))
alpha = np.zeros(len(Temperatures))
p_init = np.array([0.001, 0.28])
for Ti, T in enumerate(Temperatures):
    data = np.array(pd.read_csv(files[Ti], header = None, skiprows=1))
    xdata = V = data[0:10, 0]
    I = data[0:10, 1]
    ydata = np.log(I)
    l = pltt.ax[0].plot(V, np.log(abs(I)), 'o', label=str(T)+' K')[0]
    p = SchottkyLikeIVFit(xdata, ydata, c=c).fit(T, p_init=p_init)
    p_init = p
    x_ = np.linspace(min(xdata), max(xdata), 100)
    y_ = SchottkyLikeIVFit(xdata, ydata, c=c).analytical(x_, p[0], p[1], T)
    pltt.ax[0].plot(x_, y_, '--', c=l.get_color())

    APrime[Ti] = p[0]
    alpha[Ti] = p[1]

p = APhiBFit(Temperatures, APrime, cT=cT).fit(p_init = np.array([0.001, 0.6]))
A = p[0]
phi_B = p[1]

T_ = np.linspace(min(Temperatures), max(Temperatures), 100)
APrime_ = APhiBFit(Temperatures, APrime, cT=cT).analytical(T_, p[0], p[1])

p = np.polyfit(Temperatures, alpha, 2)
alpha_ = np.zeros(len(T_))
for pi, p_ in enumerate(p):
    N_ = len(p)
    alpha_ = alpha_ + p_*T_**(N_-1-pi)

l1 = pltt.ax[2].plot(Temperatures, APrime, 'o')[0]
l_=ax1_1.plot([],[])[0]
l2 = ax1_1.plot(Temperatures, alpha, 'o')[0]
l_.remove()
pltt.ax[2].plot(T_, APrime_, '--', c=l1.get_color())
ax1_1.plot(T_, alpha_, '--', c=l2.get_color())

m = StaticIVModel(A, phi_B, p, c, cT)
for Ti, T in enumerate(Temperatures):
    data = np.array(pd.read_csv(files[Ti], header = None, skiprows=1))
    V = data[0:10, 0]
    I = data[0:10, 1]
    V_ = np.linspace(min(V), max(V), 100)
    I_ = m.getIV(V_, T)
    l = ax0_1.plot(V, I, 'o')[0]
    ax0_1.plot(V_, I_, '--', c=l.get_color())


pltt.ax[0].set_xlabel('bias (V)', fontsize=12)
pltt.ax[0].set_ylabel('ln(I (A))', fontsize=12)

ax0_1.set_xlabel('bias (V)', fontsize=12)
ax0_1.set_ylabel('current (mA)', fontsize=12)
for l in ax0_1.get_lines():
    l.set_ydata(l.get_ydata()*1e3)

ax0_1.set_ylim([-0.5e-3, max(l.get_ydata())*1.3])
pltt.ax[0].set_ylim([-16, -10])

a1 = pltt.ax[0].annotate("", xy=(0.04, -13), xytext=(0.12, -13), xycoords='data', arrowprops=dict(arrowstyle="->"))
a2 = ax0_1.annotate("", xy=(0.5, 0.01), xytext=(0.4, 0.01), xycoords='data', arrowprops=dict(arrowstyle="->"))

pltt.ax[2].set_xlabel('Temperature (K)', fontsize=12)
pltt.ax[2].set_ylabel('$A\'$', fontsize=12)

ax1_1.set_xlabel('Temperature (V)', fontsize=12)
ax1_1.set_ylabel(r'$\alpha$ (V$^{1/2}$)', fontsize=12)
pltt.set_yaxis_color(pltt.ax[2], l1.get_color(), spine='left')
pltt.set_yaxis_color(ax1_1, l1.get_color(), spine='left')
pltt.set_yaxis_color(ax1_1, l2.get_color(), spine='right')

a3 = pltt.ax[2].annotate("", xy=(313, -17), xytext=(319, -17), xycoords='data', arrowprops=dict(arrowstyle="->", color=l1.get_color()))
a3 = ax1_1.annotate("", xy=(353, 0.244), xytext=(345, 0.244), xycoords='data', arrowprops=dict(arrowstyle="->", color=l2.get_color()))

lgd = pltt.ax[0].legend(loc=2, fontsize=10)
lgd.set_draggable(True)

#pltt.show()

#pickle.dump(m, open('S1_D55_static_model_positive.p','wb'))

ax0_1 = pltt.ax[1].twinx()
ax1_1 = pltt.ax[3].twinx()
ax0_1.tick_params(labelsize=12)
ax1_1.tick_params(labelsize=12)

Temperatures = PF.Temperatures
APrime = np.zeros(len(Temperatures))
alpha = np.zeros(len(Temperatures))
p_init = np.array([0.001, 0.28])
for Ti, T in enumerate(Temperatures):
    data = np.array(pd.read_csv(files[Ti], header = None, skiprows=1))
    xdata = V = -data[19:29, 0]
    I = -data[19:29, 1]
    ydata = np.log(I)
    l = pltt.ax[1].plot(V, np.log(abs(I)), 'o', label=str(T)+' K')[0]
    p = SchottkyLikeIVFit(xdata, ydata, c=c).fit(T, p_init=p_init)
    p_init = p
    x_ = np.linspace(min(xdata), max(xdata), 100)
    y_ = SchottkyLikeIVFit(xdata, ydata, c=c).analytical(x_, p[0], p[1], T)
    pltt.ax[1].plot(x_, y_, '--', c=l.get_color())

    APrime[Ti] = p[0]
    alpha[Ti] = p[1]

p = APhiBFit(Temperatures, APrime, cT=cT).fit(p_init = np.array([0.001, 0.6]))
A = p[0]
phi_B = p[1]

T_ = np.linspace(min(Temperatures), max(Temperatures), 100)
APrime_ = APhiBFit(Temperatures, APrime, cT=cT).analytical(T_, p[0], p[1])

p = np.polyfit(Temperatures, alpha, 2)
alpha_ = np.zeros(len(T_))
for pi, p_ in enumerate(p):
    N_ = len(p)
    alpha_ = alpha_ + p_*T_**(N_-1-pi)

l1 = pltt.ax[3].plot(Temperatures, APrime, 'o')[0]
l_=ax1_1.plot([],[])[0]
l2 = ax1_1.plot(Temperatures, alpha, 'o')[0]
l_.remove()
pltt.ax[3].plot(T_, APrime_, '--', c=l1.get_color())
ax1_1.plot(T_, alpha_, '--', c=l2.get_color())

m = StaticIVModel(A, phi_B, p, c, cT)
for Ti, T in enumerate(Temperatures):
    data = np.array(pd.read_csv(files[Ti], header = None, skiprows=1))
    V = -data[19:29, 0]
    I = -data[19:29, 1]
    V_ = np.linspace(min(V), max(V), 100)
    I_ = m.getIV(V_, T)
    l = ax0_1.plot(V, I, 'o')[0]
    ax0_1.plot(V_, I_, '--', c=l.get_color())


pltt.ax[1].set_xlabel('bias (V)', fontsize=12)
pltt.ax[1].set_ylabel('ln(I (A))', fontsize=12)

ax0_1.set_xlabel('bias (V)', fontsize=12)
ax0_1.set_ylabel('current (mA)', fontsize=12)
for l in ax0_1.get_lines():
    l.set_ydata(l.get_ydata()*1e3)

ax0_1.set_ylim([-0.5e-3, max(l.get_ydata())*1.3])
pltt.ax[1].set_ylim([-16, -10])

a1 = pltt.ax[1].annotate("", xy=(0.04, -13), xytext=(0.12, -13), xycoords='data', arrowprops=dict(arrowstyle="->"))
a2 = ax0_1.annotate("", xy=(0.5, 0.006), xytext=(0.4, 0.006), xycoords='data', arrowprops=dict(arrowstyle="->"))

pltt.ax[3].set_xlabel('Temperature (K)', fontsize=12)
pltt.ax[3].set_ylabel('$A\'$', fontsize=12)

ax1_1.set_xlabel('Temperature (V)', fontsize=12)
ax1_1.set_ylabel(r'$\alpha$ (V$^{1/2}$)', fontsize=14)
pltt.set_yaxis_color(pltt.ax[3], l1.get_color(), spine='left')
pltt.set_yaxis_color(ax1_1, l1.get_color(), spine='left')
pltt.set_yaxis_color(ax1_1, l2.get_color(), spine='right')

a3 = pltt.ax[3].annotate("", xy=(313, -16.95), xytext=(319, -16.95), xycoords='data', arrowprops=dict(arrowstyle="->", color=l1.get_color()))
a3 = ax1_1.annotate("", xy=(353, 0.224), xytext=(345, 0.224), xycoords='data', arrowprops=dict(arrowstyle="->", color=l2.get_color()))

#lgd = pltt.ax[1].legend(loc=1)
#lgd.set_draggable(True)

pltt.show()

#pickle.dump(m, open('S1_D55_static_model_negative.p','wb'))
