# -*- coding: utf-8 -*-
"""
Created on Fri Aug 16 11:00:27 2019

@author: Dhirendra Vaidya (dhirendra22121987@gmail.com)
"""

"""
USAGE
unzip Library.zip to Library
on linux system export this Library path in a MEM_MODEL_LIBRARY variable
for e.g.
export MEM_MODEL_LIBRARY=/home/dv1f19/Library

to run this file
ipython3
run <this file>
"""
import sys
from PyQt5 import QtWidgets
qapp = QtWidgets.QApplication(sys.argv)
import os
sys.path.append(os.environ.get('MEM_MODEL_LIBRARY'))
import numpy as np
import pandas as pd
from parameter_fit_utilities import ParameterFitData, ParameterFitDataXlsx, ExponentialModel
from static_IV_utilities import SchottkyLikeIVFit, APhiBFit, StaticIVModel
from advanced_plot import AdvancedPlot
from fitting_models import ExponentialFit
from matplotlib.pyplot import cm
from scipy.optimize import least_squares
import PyQt5.QtWidgets as QtWidgets
import pickle

parameter_fit_file = 'memristor_Ib_dataset/S1_D55_pf2.xlsx'
skip_biases = 2
PF = ParameterFitDataXlsx(parameter_fit_file, skip_biases=skip_biases)

cmap = cm.get_cmap(name='tab10', lut=10)

pltt = AdvancedPlot(2,1, sharex=True)
pltt1 = AdvancedPlot(1,2,sublabels=True)
pltt2 = AdvancedPlot(2,1, sharex=True)
pltt4=AdvancedPlot(1,3,sublabels=False)

p4ax3=pltt4.ax[1]
p4ax4=pltt4.ax[2]

pltt4.ax[0].remove()
p4ax1=pltt4.canvas.figure.add_subplot(231)
p4ax2=pltt4.canvas.figure.add_subplot(234, sharex=p4ax1)

m = pickle.load(open('memristor_Ib_dataset/S1_D55_static_model.p', 'rb'),encoding='latin1')

R2byR1 = m.getR2byR1(PF.Temperatures)

for Ti, T in enumerate(PF.Temperatures):
    for Vi, V in enumerate(PF.biases[skip_biases:]):
        pltt1.ax[0].plot(PF.pulses_TV[T,V], PF.Rt_data_TV[T,V]/1e3, 'o', c=cmap(Ti), markersize=1)

T=PF.Temperatures[0]
sp = np.zeros((len(PF._biases), len(PF.Temperatures)))
Rpp = np.zeros((len(PF._biases), len(PF.Temperatures)))
sn = np.zeros((len(PF._biases), len(PF.Temperatures)))
Rpn = np.zeros((len(PF._biases), len(PF.Temperatures)))
p_init_p = np.array([-400000000.0, 1000.0])
p_init_n = np.array([400000000.0, -1000.0])
Ti=0
R_313K_fitted={}
for Vi, V in enumerate(PF.biases[skip_biases:]):
    if V > 0.0:
        bounds = ([-np.inf, 0],[0.0, np.inf])
        p = ExponentialModel(PF.pulses_TV[T, PF.biases[0]], PF.delta_Rt_data_TV[T, V], tw=100e-6, NPulse=PF.NPulse).fit(p_init=p_init_p, bounds = bounds)
        p_init_p = p
        sp[int((Vi+skip_biases)/2), Ti] = p[0]
        Rpp[int((Vi+skip_biases)/2), Ti] = p[1]
        print(p[0])
    if V < 0.0:
        bounds = ([0, -np.inf],[np.inf, 0])
        p = ExponentialModel(PF.pulses_TV[T, PF.biases[0]], PF.delta_Rt_data_TV[T, V], tw=100e-6, NPulse=PF.NPulse).fit(p_init=p_init_n, bounds = bounds)
        p_init_n = p
        sn[int((Vi+skip_biases-1)/2), Ti] = p[0]
        Rpn[int((Vi+skip_biases-1)/2), Ti] = p[1]
    delta_R_fitted = ExponentialModel(PF.pulses_TV[T, PF.biases[0]], PF.delta_Rt_data_TV[T, V], tw=100e-6, NPulse=PF.NPulse).analytical(PF.pulses_TV[T, PF.biases[0]], p[0], p[1])
    R_313K_fitted[V] = delta_R_fitted + PF.R0_TV[T, V]
    #pltt1.ax[0].plot(PF.pulses_TV[T, V], R_313K_fitted[V], '--', c='k')
    pltt.ax[0].plot(PF.pulses_TV[T,V], PF.delta_Rt_data_TV[T,V]/1000.0, 'o', c=cmap(Ti))
    pltt.ax[0].plot(PF.pulses_TV[T,V], delta_R_fitted/1000.0, '-', c='k')
    p4ax1.plot(PF.pulses_TV[T,V], PF.delta_Rt_data_TV[T,V]/1000.0, 'o', c=cmap(Ti), markersize=1)
    p4ax1.plot(PF.pulses_TV[T,V], delta_R_fitted/1000.0, '-', c='k')

#for Ti, T in enumerate(PF.Temperatures):
#    for Vi, V in enumerate(PF.biases[skip_biases:]):
#        pltt1.ax[0].plot(PF.pulses_TV[T, V], R2byR1[Ti]*R_313K_fitted[V], '--', c='k')

biases_ = np.linspace(min(PF._biases[int(skip_biases/2):]), max(PF._biases[int(skip_biases/2):]), 100)

exp_fitter = ExponentialFit(PF._biases[int(skip_biases/2):], sp[int(skip_biases/2):,0])
sp_313K_p = p = exp_fitter.fit()
sp_313K_fitted = exp_fitter.analytical(biases_, p[0], p[1])

exp_fitter = ExponentialFit(PF._biases[int(skip_biases/2):], sn[int(skip_biases/2):,0])
sn_313K_p = p = exp_fitter.fit()
sn_313K_fitted = exp_fitter.analytical(biases_, p[0], p[1])

exp_fitter = ExponentialFit(PF._biases[int(skip_biases/2):], Rpp[int(skip_biases/2):,0])
Rpp_313K_p = p = exp_fitter.fit()
Rpp_313K_fitted = exp_fitter.analytical(biases_, p[0], p[1])

exp_fitter = ExponentialFit(PF._biases[int(skip_biases/2):], Rpn[int(skip_biases/2):,0])
Rpn_313K_p = p = exp_fitter.fit()
Rpn_313K_fitted = exp_fitter.analytical(biases_, p[0], p[1])

l1=pltt2.ax[0].plot(PF._biases[int(skip_biases/2):], sp[int(skip_biases/2):,0]/1e6, 'o')[0]
l2=pltt2.ax[0].plot(PF._biases[int(skip_biases/2):], sn[int(skip_biases/2):,0]/1e6, 'o')[0]
l3=pltt2.ax[1].plot(PF._biases[int(skip_biases/2):], Rpp[int(skip_biases/2):,0]/1e3, 'o')[0]
l4=pltt2.ax[1].plot(PF._biases[int(skip_biases/2):], Rpn[int(skip_biases/2):,0]/1e3, 'o')[0]

pltt2.ax[0].plot(biases_, sp_313K_fitted/1e6, '-', c=l1.get_color())
pltt2.ax[0].plot(biases_, sn_313K_fitted/1e6, '-', c=l2.get_color())
pltt2.ax[1].plot(biases_, Rpp_313K_fitted/1e3, '-', c=l3.get_color())
pltt2.ax[1].plot(biases_, Rpn_313K_fitted/1e3, '-', c=l4.get_color())

p4l1=p4ax3.plot(PF._biases[int(skip_biases/2):], sp[int(skip_biases/2):,0]/1e6, 'o')[0]
p4l2=p4ax3.plot(PF._biases[int(skip_biases/2):], sn[int(skip_biases/2):,0]/1e6, 'o')[0]
p4l3=p4ax4.plot(PF._biases[int(skip_biases/2):], Rpp[int(skip_biases/2):,0]/1e3, 'o')[0]
p4l4=p4ax4.plot(PF._biases[int(skip_biases/2):], Rpn[int(skip_biases/2):,0]/1e3, 'o')[0]

p4ax3.plot(biases_, sp_313K_fitted/1e6, '-', c=p4l1.get_color())
p4ax3.plot(biases_, sn_313K_fitted/1e6, '-', c=p4l2.get_color())
p4ax4.plot(biases_, Rpp_313K_fitted/1e3, '-', c=p4l3.get_color())
p4ax4.plot(biases_, Rpn_313K_fitted/1e3, '-', c=p4l4.get_color())


for Ti, T in enumerate(PF.Temperatures):
    for Vi, V in enumerate(PF.biases[skip_biases:]):
        if V > 0.0:
            s = exp_fitter.analytical(V, sp_313K_p[0], sp_313K_p[1])
            Rp = exp_fitter.analytical(V, Rpp_313K_p[0], Rpp_313K_p[1])
        if V < 0.0:
            s = exp_fitter.analytical(-V, sn_313K_p[0], sn_313K_p[1])
            Rp = exp_fitter.analytical(-V, Rpn_313K_p[0], Rpn_313K_p[1])
        s = s*R2byR1[Ti]
        Rp = Rp*R2byR1[Ti]
        #pltt1.ax[0].plot(PF.pulses_TV[T, V], R2byR1[Ti]*R_313K_fitted[V], '--', c='k')
        delta_R_fitted = ExponentialModel(PF.pulses_TV[T, PF.biases[0]], PF.delta_Rt_data_TV[T, V], tw=100e-6, NPulse=PF.NPulse).analytical(PF.pulses_TV[T, PF.biases[0]], s, Rp)
        R_fitted = delta_R_fitted + PF.R0_TV[T, V]
        pltt1.ax[0].plot(PF.pulses_TV[T, V], R_fitted/1e3, '-', c='k')

T=PF.Temperatures[0]
#for Vi, V in enumerate(PF.biases[skip_biases:]):
#    pltt.ax[1].stem(PF.pulses_TV[T,V], V*np.ones(PF.NPulse), '-', linefmt='grey', markerfmt='-')

pltt.ax[0].axhline(y=0.0, ls='--', c='k', alpha=0.5)
pltt.ax[0].plot([],[],'o',c=pltt.ax[0].get_lines()[0].get_color(),alpha=pltt.ax[0].get_lines()[0].get_alpha())
pltt.ax[0].set_ylabel('$\Delta R$ (K$\Omega$)', fontsize=14)
pltt.ax[1].set_ylabel('switching bias (V)', fontsize=14)
pltt.ax[1].set_xlabel('pulses (#)', fontsize=14)

pltt2.ax[0].set_ylabel('$s_{p,n}$ (M$\Omega$/s)', fontsize=14)
pltt2.ax[1].set_ylabel('$R_{pp,n}$ (K$\Omega$)', fontsize=14)
#pltt2.ax[0].set_xlabel('switching bias (V)', fontsize=14)
pltt2.ax[1].set_xlabel('switching bias (V)', fontsize=14)

T=PF.Temperatures[0]
pltt1.ax[0].set_ylabel('$R$ (K$\Omega$)', fontsize=14)
pltt1.ax[0].set_xlabel('pulses (#)', fontsize=14)

for Ti, T in enumerate(PF.Temperatures):
    pltt1.ax[0].plot([],[],'o',c=cmap(Ti),label=str(int(T))+'K')

pltt1.ax[0].set_xlim([PF.pulses_TV[T,PF.biases[skip_biases]][0]-500, PF.pulses_TV[T,PF.biases[-1]][-1]+500])
#lgd=pltt1.ax[0].legend(ncol=len(PF.Temperatures))
#lgd.draggable(True)

p4ax1.text(0.05,1.025,'(a)', transform=p4ax1.transAxes, fontsize=14)
p4ax2.text(0.05,1.025,'(b)', transform=p4ax2.transAxes, fontsize=14)
p4ax3.text(0.05,1.025,'(c)', transform=p4ax3.transAxes, fontsize=14)
p4ax4.text(0.05,1.025,'(d)', transform=p4ax4.transAxes, fontsize=14)

p4ax1.axhline(y=0, ls='--', c='k', alpha=0.5)

# t1=p4ax3.text(0.88, -4.81, str(sp_313K_p[0])+'exp(V/'+str(sp_313K_p[1])+')', color=p4l1.get_color())
# t2=p4ax3.text(0.88, 4.81, str(sn_313K_p[0])+'exp(V/'+str(sn_313K_p[1])+')', color=p4l2.get_color())
# t3=p4ax3.text(0.88, 2.5, str(Rpp_313K_p[0])+'exp(V/'+str(Rpp_313K_p[1])+')', color=p4l3.get_color())
# t4=p4ax3.text(0.88, -2.5, str(Rpn_313K_p[0])+'exp(V/'+str(Rpn_313K_p[1])+')', color=p4l4.get_color())

t1=p4ax3.text(0.855, -3.66, '$s_p$=-9.865x$10^{-5}$ exp(%.2f $V$)'%(sp_313K_p[1]), color=p4l1.get_color())
t2=p4ax3.text(0.89, 4.81, '$s_n$=3.823x$10^{-3}$ exp(%.2f $V$)'%(sn_313K_p[1]), color=p4l2.get_color())
t3=p4ax4.text(0.88, 0.6, '$R_{pp}$=%.3f exp(%.2f $V$)'%(Rpp_313K_p[0]/1e3, Rpp_313K_p[1]), color=p4l3.get_color())
t4=p4ax4.text(0.88, -2.5, '$R_{pn}$=%.3f exp(%.2f $V$)'%(Rpn_313K_p[0]/1e3, Rpn_313K_p[1]), color=p4l4.get_color())

# t1=p4ax3.text(0.855, -3.66, '$s_p$=%.2e exp(%.2f $V$)'%(sp_313K_p[0]/1e6, sp_313K_p[1]), color=p4l1.get_color())
# t2=p4ax3.text(0.89, 4.81, '$s_n$=%.2e exp(%.2f $V$)'%(sn_313K_p[0]/1e6, sn_313K_p[1]), color=p4l2.get_color())
# t3=p4ax4.text(0.88, 0.6, '$R_{pp}$=%.3f exp(%.2f $V$)'%(Rpp_313K_p[0]/1e3, Rpp_313K_p[1]), color=p4l3.get_color())
# t4=p4ax4.text(0.88, -2.5, '$R_{pn}$=%.3f exp(%.2f $V$)'%(Rpn_313K_p[0]/1e3, Rpn_313K_p[1]), color=p4l4.get_color())

p4ax3.set_ylabel('$s_{p,n}$ (M$\Omega$/s)', fontsize=12)
p4ax4.set_ylabel('$R_{pp,n}$ (K$\Omega$)', fontsize=12)
#pltt2.ax[0].set_xlabel('switching bias (V)', fontsize=14)
p4ax3.set_xlabel('switching bias (V)', fontsize=12)
p4ax4.set_xlabel('switching bias (V)', fontsize=12)

T=PF.Temperatures[0]
p4ax1.set_ylabel('$\Delta R$ (K$\Omega$)', fontsize=10)
p4ax2.set_ylabel('Switching bias (V)', fontsize=10)
p4ax2.set_xlabel('pulses (#)', fontsize=14)

p4ax1.set_ylim([-18, 18])
p4ax1.set_xlim([0, p4ax1.get_xlim()[1]])


for Vi, V in enumerate(PF.biases[skip_biases:]):
    markerline, stemlines, baseline = p4ax2.stem(PF.pulses_TV[T,V][::100], V*np.ones(PF.NPulse)[::100], '-', linefmt='grey', markerfmt='o')
    markerline.set_markerfacecolor('grey')
    markerline.set_markeredgecolor('none')
    #for sl in stemlines:
    #    sl.set_color(cmap(0))

R2byR1=np.zeros(len(PF.Temperatures))

for Vi, V in enumerate(PF.biases[skip_biases:]):
    for Ti, T in enumerate(PF.Temperatures):
        R1 = np.sum(PF.Rt_data_TV[PF.Temperatures[0], V][0:5])/5.0
        R2 = np.sum(PF.Rt_data_TV[T, V][0:5])/5.0
        R2byR1[Ti] = R2/R1

    pltt1.ax[1].plot(PF.Temperatures, R2byR1, 'o', c=cmap(0), markersize=3, markerfacecolor='None')

for Vi, V in enumerate(PF.biases[skip_biases:]):
    for Ti, T in enumerate(PF.Temperatures):
        R1 = np.sum(PF.Rt_data_TV[PF.Temperatures[0], V][250:255])/5.0
        R2 = np.sum(PF.Rt_data_TV[T, V][250:255])/5.0
        R2byR1[Ti] = R2/R1

    pltt1.ax[1].plot(PF.Temperatures, R2byR1, 's', c=cmap(1), markersize=3, markerfacecolor='None')

for Vi, V in enumerate(PF.biases[skip_biases:]):
    for Ti, T in enumerate(PF.Temperatures):
        R1 = np.sum(PF.Rt_data_TV[PF.Temperatures[0], V][-5:])/5.0
        R2 = np.sum(PF.Rt_data_TV[T, V][-5:])/5.0
        R2byR1[Ti] = R2/R1

    pltt1.ax[1].plot(PF.Temperatures, R2byR1, '^', c=cmap(2), markersize=3, markerfacecolor='None')

m = pickle.load(open('memristor_Ib_dataset/S1_D55_static_model.p', 'rb'))
T_ = np.linspace(min(PF.Temperatures), max(PF.Temperatures), 100)
R2byR1 = m.getR2byR1(T_)
pltt1.ax[1].plot(T_, R2byR1, '-', c='k')

pltt1.ax[1].plot([],[],'o',c=cmap(0),label='pulse #1', markersize=3, markerfacecolor='None')
pltt1.ax[1].plot([],[],'s',c=cmap(1),label='pulse #250', markersize=3, markerfacecolor='None')
pltt1.ax[1].plot([],[],'^',c=cmap(2),label='pulse #500', markersize=3, markerfacecolor='None')
lgd=pltt1.ax[1].legend()
lgd.set_draggable(True)

pltt1.ax[1].set_ylabel('$R(T)/R(313\mathrm{K})$', fontsize=14)
pltt1.ax[1].set_xlabel('Temperatures (K)', fontsize=14)

#pltt.show()
pltt1.show()
#pltt2.show()



pltt4.show()


qapp.exec_()
