# -*- coding: utf-8 -*-
"""
Created on Fri Aug 16 11:00:27 2019

@author: Dhirendra Vaidya (dhirendra22121987@gmail.com)
"""

"""
USAGE
unzip Library.zip to Library
on linux system export this Library path in a MEM_MODEL_LIBRARY variable
for e.g.
export MEM_MODEL_LIBRARY=/home/dv1f19/Library

to run this file
ipython3
run <this file>
"""
import sys
from PyQt5 import QtWidgets
qapp = QtWidgets.QApplication(sys.argv)
import os
sys.path.append(os.environ.get('MEM_MODEL_LIBRARY'))
import numpy as np
import pandas as pd
from parameter_fit_utilities import ParameterFitData, ParameterFitDataXlsx, ExponentialModel
from advanced_plot import AdvancedPlot
from fitting_models import ExponentialFit
import matplotlib.pyplot as plt
from matplotlib.pyplot import cm
import pickle


def averaged_delR_parameter_fit_data(fnames, biases, skip_biases=2, R0_avg_window=5, T=300.0):
    biases = ParameterFitData(fnames[0], biases = biases, temperatures = np.array([T])).biases
    NPulse = ParameterFitData(fnames[0], biases = biases, temperatures = np.array([T])).NPulse
    delta_R_avg = {}
    for Vi, V in enumerate(biases[skip_biases:]):
        #print V
        delta_R_avg_ = np.zeros(NPulse)
        for Fi, fname in enumerate(fnames):
            PF_data = ParameterFitData(fname, biases = biases, temperatures = np.array([T]))
            #R0 = np.sum(PF_data.Rt_data_TV[T, biases[Vi-1]][-R0_avg_window:])/float(R0_avg_window)
            #R = PF_data.Rt_data_TV[T, V]
            #delta_R = R-R0
            delta_R = PF_data.delta_Rt_data_TV[T, V]
            delta_R_avg_ = (delta_R_avg_ + delta_R)
        delta_R_avg[T, V] = delta_R_avg_/len(fnames)
        #pulses = PF_data.pulses_TV[T, V]-PF_data.pulses_TV[T, V][0]
    return delta_R_avg

fl = 'memristor_II_dataset/w22_data1.xlsx'

skip_biases = 4
PF = ParameterFitDataXlsx(fl, skip_biases=skip_biases)

cmap = plt.cm.get_cmap(name='tab10', lut=len(PF.Temperatures)+1)
pltt1 = AdvancedPlot(1,2)
pltt2 = AdvancedPlot(2,2, sharex=True, sublabels=True)
pltt3 = AdvancedPlot(1,3, sharex=True, sublabels=True)
pltt4 = AdvancedPlot(2,4, sharex=True, sublabels=True)

sp = np.zeros((len(PF._biases), len(PF.Temperatures)))
Rpp = np.zeros((len(PF._biases), len(PF.Temperatures)))
sn = np.zeros((len(PF._biases), len(PF.Temperatures)))
Rpn = np.zeros((len(PF._biases), len(PF.Temperatures)))
p_init_p = np.array([-400000000.0, 1000.0])
p_init_n = np.array([400000000.0, -1000.0])
for Ti, T in enumerate(PF.Temperatures):
    for Vi, V in enumerate(PF.biases[skip_biases:]):
        # plot switching data
        pltt1.ax[0].plot(PF.pulses_TV[T, V], PF.delta_Rt_data_TV[T,V], 'o', c=cmap(Ti), alpha = 0.5)
        pltt4.ax[-1].plot(PF.pulses_TV[T, V], PF.delta_Rt_data_TV[T,V]/1000.0, 'o', c=cmap(Ti), alpha = 0.5)

        pltt1.ax[1].plot(PF.pulses_TV[T, V], PF.Rt_data_TV[T,V], 'o', c=cmap(Ti), alpha = 0.5)
        pltt4.ax[Ti].plot(PF.pulses_TV[T, V], PF.Rt_data_TV[T, V]/1000.0, 'o', c=cmap(Ti))

        # fit switching data
        if V > 0.0:
            bounds = ([-np.inf, 0],[0.0, np.inf])
            p = ExponentialModel(PF.pulses_TV[T, PF.biases[0]], PF.delta_Rt_data_TV[T, V], tw=100e-6, NPulse=PF.NPulse).fit(p_init=p_init_p, bounds = bounds)
            p_init_p = p
            sp[int((Vi+skip_biases)/2), Ti] = p[0]
            Rpp[int((Vi+skip_biases)/2), Ti] = p[1]
        if V < 0.0:
            bounds = ([0, -np.inf],[np.inf, 0])
            p = ExponentialModel(PF.pulses_TV[T, PF.biases[0]], PF.delta_Rt_data_TV[T, V], tw=100e-6, NPulse=PF.NPulse).fit(p_init=p_init_n, bounds = bounds)
            p_init_n = p
            sn[int((Vi+skip_biases-1)/2), Ti] = p[0]
            Rpn[int((Vi+skip_biases-1)/2), Ti] = p[1]
        delta_R_fitted = ExponentialModel(PF.pulses_TV[T, PF.biases[0]], PF.delta_Rt_data_TV[T, V], tw=100e-6, NPulse=PF.NPulse).analytical(PF.pulses_TV[T, PF.biases[0]], p[0], p[1])

        # plot fitted model
        pltt1.ax[0].plot(PF.pulses_TV[T, V], delta_R_fitted, '--', c='k')
        l=pltt4.ax[-1].plot(PF.pulses_TV[T, V], delta_R_fitted/1000.0, '--', c='k')[0]
        l.set_zorder(100)

# plot stage I parameters, sp, sn, Rpp, Rpn
for Ti, T in enumerate(PF.Temperatures):
    pltt2.ax[0].plot(PF._biases[int(int(skip_biases/2)):], sp[int(int(skip_biases/2)):,Ti]/1e9, 'o', c=cmap(Ti))
    pltt2.ax[1].plot(PF._biases[int(int(skip_biases/2)):], Rpp[int(int(skip_biases/2)):,Ti]/1000.0, 'o', c=cmap(Ti), label=str(int(T))+'K')
    pltt2.ax[2].plot(PF._biases[int(int(skip_biases/2)):], sn[int(int(skip_biases/2)):,Ti]/1e9, 'o', c=cmap(Ti))
    pltt2.ax[3].plot(PF._biases[int(int(skip_biases/2)):], Rpn[int(int(skip_biases/2)):,Ti]/1000.0, 'o', c=cmap(Ti))

Rpp_A = np.zeros(len(PF.Temperatures))
Rpp_k = np.zeros(len(PF.Temperatures))
Rpn_A = np.zeros(len(PF.Temperatures))
Rpn_k = np.zeros(len(PF.Temperatures))

sp_avg_T = np.zeros(len(PF.Temperatures))
sn_avg_T = np.zeros(len(PF.Temperatures))

# fit stage I parameters further
for Ti, T in enumerate(PF.Temperatures):
    _biases = PF._biases[int(int(skip_biases/2)):]
    biases_ = np.linspace(min(_biases), max(_biases), 100)
    normalizer = 1000.0

    # Rpp fitting
    exp_fitter = ExponentialFit(_biases, Rpp[int(int(skip_biases/2)):,Ti]/normalizer)
    p = exp_fitter.fit()
    Rpp_fitted=exp_fitter.analytical(biases_, p[0], p[1])

    Rpp_A[Ti] = p[0]
    Rpp_k[Ti] = p[1]

    # Rpn fitting
    exp_fitter = ExponentialFit(_biases, Rpn[int(int(skip_biases/2)):,Ti]/normalizer)
    p = exp_fitter.fit()
    Rpn_fitted=exp_fitter.analytical(biases_, p[0], p[1])

    Rpn_A[Ti] = p[0]
    Rpn_k[Ti] = p[1]

    # average sp and sn. Modelling as constants with switching bias
    sp_avg_T[Ti] = np.sum(sp[int(int(skip_biases/2)):,Ti])/len(PF._biases[int(int(skip_biases/2)):])
    sn_avg_T[Ti] = np.sum(sn[int(int(skip_biases/2)):,Ti])/len(PF._biases[int(int(skip_biases/2)):])

    # plot model fits of Rpp and Rpn
    pltt2.ax[1].plot(biases_, Rpp_fitted*normalizer/1000.0, '--', c=cmap(Ti))
    pltt2.ax[3].plot(biases_, Rpn_fitted*normalizer/1000.0, '--', c=cmap(Ti))

    pltt2.ax[0].axhline(y=sp_avg_T[Ti]/1e9, c=cmap(Ti))
    pltt2.ax[2].axhline(y=sn_avg_T[Ti]/1e9, c=cmap(Ti))

# fittings of Rpp_A(T), Rpp_k(T), Rpn_A(T), Rpn_k(T), sp_average(T), sn_average(T)
for Ti, T in enumerate(PF.Temperatures):
    for Vi, V in enumerate(PF.biases[skip_biases:]):
        model = ExponentialModel(PF.pulses_TV[T, PF.biases[0]], PF.delta_Rt_data_TV[T, V], tw=100e-6, NPulse=PF.NPulse)
        if V > 0.0:
            normalizer = 1000.0

            p = np.polyfit(PF.Temperatures, Rpp_A, 2)
            A = p[0]*T**2 + p[1]*T + p[2]

            p = np.polyfit(PF.Temperatures, Rpp_k, 2)
            k = p[0]*T**2 + p[1]*T + p[2]

            Rp = A*np.exp(k*V)*normalizer

            p = np.polyfit(PF.Temperatures, sp_avg_T, 2)
            s = p[0]*T**2 + p[1]*T + p[2]

        if V < 0.0:
            normalizer = 1000.0
            p = np.polyfit(PF.Temperatures, Rpn_A, 2)
            A = p[0]*T**2 + p[1]*T + p[2]

            p = np.polyfit(PF.Temperatures, Rpn_k, 2)
            k = p[0]*T**2 + p[1]*T + p[2]

            Rp = A*np.exp(k*(-V))*normalizer

            p = np.polyfit(PF.Temperatures, sn_avg_T, 2)
            s = p[0]*T**2 + p[1]*T + p[2]

        # model fit all the way from stage III parameters to switching data
        delta_R_stage_III_fit = model.analytical(PF.pulses_TV[T, PF.biases[0]], s, Rp)
        pltt1.ax[1].plot(PF.pulses_TV[T, V], delta_R_stage_III_fit+PF.R0_TV[T, V], '-', c='k')
        pltt4.ax[Ti].plot(PF.pulses_TV[T, V], (delta_R_stage_III_fit+PF.R0_TV[T, V])/1000.0, '-', c='k')

# plotting stage III parameters
l_sp = pltt3.ax[0].plot(PF.Temperatures, sp_avg_T/1e9, 'o', label='$s_p$')[0]
l_sn = pltt3.ax[0].plot(PF.Temperatures, sn_avg_T/1e9, 'o', label='$s_n$')[0]

l_Rpp_A = pltt3.ax[1].plot(PF.Temperatures, Rpp_A, 'o', label='$A_p$')[0]
l_Rpn_A = pltt3.ax[1].plot(PF.Temperatures, Rpn_A, 'o', label='$A_n$')[0]

l_Rpp_k = pltt3.ax[2].plot(PF.Temperatures, Rpp_k, 'o', label='$k_p$')[0]
l_Rpn_k = pltt3.ax[2].plot(PF.Temperatures, Rpn_k, 'o', label='$k_n$')[0]

# plotting fits to stage III parameters
T_ = np.linspace(PF.Temperatures[0], PF.Temperatures[-1], 100)

p = np.polyfit(PF.Temperatures, sp_avg_T, 2)
pltt3.ax[0].plot(T_, (p[0]*T_**2 + p[1]*T_ + p[2])/1e9, '-', c=l_sp.get_color())

p = np.polyfit(PF.Temperatures, sn_avg_T, 2)
pltt3.ax[0].plot(T_, (p[0]*T_**2 + p[1]*T_ + p[2])/1e9, '-', c=l_sn.get_color())

p = np.polyfit(PF.Temperatures, Rpp_A, 2)
pltt3.ax[1].plot(T_, p[0]*T_**2 + p[1]*T_ + p[2], '-', c=l_Rpp_A.get_color())

p = np.polyfit(PF.Temperatures, Rpn_A, 2)
pltt3.ax[1].plot(T_, p[0]*T_**2 + p[1]*T_ + p[2], '-', c=l_Rpn_A.get_color())

p = np.polyfit(PF.Temperatures, Rpp_k, 2)
pltt3.ax[2].plot(T_, p[0]*T_**2 + p[1]*T_ + p[2], '-', c=l_Rpp_k.get_color())

p = np.polyfit(PF.Temperatures, Rpn_k, 2)
pltt3.ax[2].plot(T_, p[0]*T_**2 + p[1]*T_ + p[2], '-', c=l_Rpn_k.get_color())

for aI, ax in enumerate(pltt4.ax[:-1]):
    ax.set_ylabel('Resistance (K$\Omega$)')
    ax.set_xlabel('switching bias (V)')
    ax.set_title(str(int(PF.Temperatures[aI]))+' K')
    ax.tick_params(labelsize=10)
    ax.set_ylim((0.985*ax.get_ylim()[0], 1.025*ax.get_ylim()[1]))

pltt4.ax[-1].set_ylabel('$\Delta R$ (K$\Omega$)')
pltt4.ax[-1].set_xlabel('switching bias (V)s')
pltt4.ax[-1].tick_params(labelsize=10)
pltt4.ax[0].plot([],[],'-', c='k',label='fit@stage III')
pltt4.ax[-1].plot([],[],'--', c='k',label='fit@stage I')
pltt4.ax[0].legend(loc=2)
pltt4.ax[-1].legend(loc=2)
# plot 2 axis labels and legends
pltt2.ax[0].set_ylabel('$s_p$ (G$\Omega/\mathrm{s}$)', fontsize=12)
pltt2.ax[2].set_ylabel('$s_n$ (G$\Omega/\mathrm{s}$)', fontsize=12)
pltt2.ax[1].set_ylabel('$R_{pp}$ (K$\Omega$)', fontsize=12)
pltt2.ax[3].set_ylabel('$R_{pn}$ (K$\Omega$)', fontsize=12)
for ax in pltt2.ax:
    ax.set_xlabel('switching bias (V)', fontsize=12)
    ax.tick_params(labelsize=12)
pltt2.ax[1].legend(ncol=2).set_draggable(True)

# plot 3 axis labels and legends
pltt3.ax[0].set_ylabel('$s_{p,n}(T)$ (G$\Omega/\mathrm{s}$)', fontsize=14)
pltt3.ax[1].set_ylabel('$A_{p,n}$ ($\Omega$)', fontsize=14)
pltt3.ax[2].set_ylabel('$k_{p,n}$ ($\mathrm{V}^{-1}$)', fontsize=14)
for ax in pltt3.ax:
    ax.set_xlabel('Temperature (K)', fontsize=14)


pltt3.ax[0].tick_params(labelsize=12)
pltt3.ax[1].tick_params(labelsize=12)
pltt3.ax[2].tick_params(labelsize=12)

lgd = pltt3.ax[0].legend(loc=1, fontsize=10)
lgd.set_draggable(True)
lgd = pltt3.ax[1].legend(loc=1, fontsize=10)
lgd.set_draggable(True)
lgd = pltt3.ax[2].legend(loc=1, fontsize=10)
lgd.set_draggable(True)


pltt5 = AdvancedPlot(1,3)
R2byR1 = np.zeros(len(PF.Temperatures))
for Vi, V in enumerate(PF.biases[skip_biases:]):
    for Ti, T in enumerate(PF.Temperatures):
        R1 = np.sum(PF.Rt_data_TV[PF.Temperatures[0], V][0:5])/5.0
        R2 = np.sum(PF.Rt_data_TV[T, V][0:5])/5.0
        R2byR1[Ti] = R2/R1

    pltt5.ax[1].plot(PF.Temperatures, R2byR1, 'o', c=cmap(0), markersize=3, markerfacecolor='None')

for Vi, V in enumerate(PF.biases[skip_biases:]):
    for Ti, T in enumerate(PF.Temperatures):
        R1 = np.sum(PF.Rt_data_TV[PF.Temperatures[0], V][250:255])/5.0
        R2 = np.sum(PF.Rt_data_TV[T, V][250:255])/5.0
        R2byR1[Ti] = R2/R1

    pltt5.ax[1].plot(PF.Temperatures, R2byR1, 's', c=cmap(1), markersize=3, markerfacecolor='None')

for Vi, V in enumerate(PF.biases[skip_biases:]):
    for Ti, T in enumerate(PF.Temperatures):
        R1 = np.sum(PF.Rt_data_TV[PF.Temperatures[0], V][-5:])/5.0
        R2 = np.sum(PF.Rt_data_TV[T, V][-5:])/5.0
        R2byR1[Ti] = R2/R1

    pltt5.ax[1].plot(PF.Temperatures, R2byR1, '^', c=cmap(2), markersize=3, markerfacecolor='None')

T_ = np.linspace(min(PF.Temperatures), max(PF.Temperatures), 100)
R2byR1_analytical = np.zeros(len(T_))
T1 = T_[0]
for Ti, T2 in enumerate(T_):
    R2byR1_analytical[Ti] = (T1/T2)**2*np.exp(0.13*(T1-T2)/(8.617e-5*T1*T2))

pltt5.ax[1].plot(T_, R2byR1_analytical, '-', c='k')

pltt5.ax[1].plot([],[],'o',c=cmap(0),label='pulse #1', markersize=3, markerfacecolor='None')
pltt5.ax[1].plot([],[],'s',c=cmap(1),label='pulse #250', markersize=3, markerfacecolor='None')
pltt5.ax[1].plot([],[],'^',c=cmap(2),label='pulse #500', markersize=3, markerfacecolor='None')
lgd=pltt1.ax[1].legend()
lgd.set_draggable(True)

for Ti, T in enumerate(PF.Temperatures):
    for Vi, V in enumerate(PF.biases[skip_biases:]):
        if Vi == 0:
            pltt5.ax[0].plot(PF.pulses_TV[T, V], PF.Rt_data_TV[T,V]/1000, 'o', c=cmap(Ti), alpha = 0.5, markersize=3, label=str(T)+' K')
        else:
            pltt5.ax[0].plot(PF.pulses_TV[T, V], PF.Rt_data_TV[T,V]/1000, 'o', c=cmap(Ti), alpha = 0.5, markersize=3)

T1 = PF.Temperatures[0]
errr_p = np.zeros((len(PF._biases), len(PF.Temperatures)))
errr_n = np.zeros((len(PF._biases), len(PF.Temperatures)))
err_dict={}
for Ti, T in enumerate(PF.Temperatures):
    T2 = T
    for Vi, V in enumerate(PF.biases[skip_biases:]):
        if V > 0.0:
            s = sp_avg_T[0]
            Rp = Rpp_A[0]*np.exp(Rpp_k[0]*V)*1000 #exp_fitter.analytical(V, Rpp_A[0], Rpp_k[0])*1000
        if V < 0.0:
            s = sn_avg_T[0]
            Rp = Rpn_A[0]*np.exp(Rpn_k[0]*(-V))*1000 #exp_fitter.analytical(V, Rpn_A[0], Rpn_k[0])*1000

        s = s*(T1/T2)**2*np.exp(0.13*(T1-T2)/(8.617e-5*T1*T2))
        print(Rp)
        Rp = Rp*(T1/T2)**2*np.exp(0.13*(T1-T2)/(8.617e-5*T1*T2))

        delta_R_fitted = ExponentialModel(PF.pulses_TV[T, PF.biases[0]], PF.delta_Rt_data_TV[T, V], tw=100e-6, NPulse=PF.NPulse).analytical(PF.pulses_TV[T, PF.biases[0]], s, Rp)
        R_fitted = delta_R_fitted + PF.R0_TV[T, V]
        pltt5.ax[0].plot(PF.pulses_TV[T, V], R_fitted/1e3, '-', c='k')
        # if V > 0:
        #     errr_p[int((Vi+skip_biases)/2), Ti] = 100*np.sqrt(np.sum(((PF.Rt_data_TV[T,V]-R_fitted)/PF.Rt_data_TV[T,V])**2)/len(PF.Rt_data_TV[T,V]))
        # if V < 0:
        #     errr_n[ int((Vi+skip_biases-1)/2), Ti] = 100*np.sqrt(np.sum(((PF.Rt_data_TV[T,V]-R_fitted)/PF.Rt_data_TV[T,V])**2)/len(PF.Rt_data_TV[T,V]))
        if V > 0:
            errr_p[int((Vi+skip_biases)/2), Ti] = 100*np.sqrt(np.sum(((PF.delta_Rt_data_TV[T,V][-5:]-delta_R_fitted[-5:])/PF.delta_Rt_data_TV[T,V][-5:])**2)/len(PF.delta_Rt_data_TV[T,V][-5:]))
            err_dict[T, V] = 100*np.sqrt(np.sum(((PF.delta_Rt_data_TV[T,V][-5:]-delta_R_fitted[-5:])/PF.delta_Rt_data_TV[T,V][-5:])**2)/len(PF.delta_Rt_data_TV[T,V][-5:]))
        if V < 0:
            errr_n[ int((Vi+skip_biases-1)/2), Ti] = 100*np.sqrt(np.sum(((PF.delta_Rt_data_TV[T,V][-5:]-delta_R_fitted[-5:])/PF.delta_Rt_data_TV[T,V][-5:])**2)/len(PF.delta_Rt_data_TV[T,V][-5:]))
            err_dict[T, V] = 100*np.sqrt(np.sum(((PF.delta_Rt_data_TV[T,V][-5:]-delta_R_fitted[-5:])/PF.delta_Rt_data_TV[T,V][-5:])**2)/len(PF.delta_Rt_data_TV[T,V][-5:]))

pickle.dump(err_dict, open('w22_paper2_err.p','wb'))
offset = 0
for Ti, T in enumerate(PF.Temperatures):
    pltt5.ax[2].bar(PF._biases+offset, errr_p[:,Ti], width=0.01, color=cmap(Ti))
    pltt5.ax[2].bar(PF._biases+offset, -errr_n[:,Ti], width=0.01, color=cmap(Ti))
    offset = offset + 0.01

pltt5.ax[0].set_ylabel('Resistance (K$\Omega$)', fontsize=12)
pltt5.ax[0].set_xlabel('Pulses (#)', fontsize=12)
pltt5.ax[1].set_ylabel('R(T)/R(300K)', fontsize=12)
pltt5.ax[1].set_xlabel('Temperatures (K)', fontsize=12)
pltt5.ax[2].set_ylabel('root mean squared % error', fontsize=12)
pltt5.ax[2].set_xlabel('switching bias (V)', fontsize=12)

#pltt5.ax[0].legend().set_draggable(True)
pltt5.ax[1].legend().set_draggable(True)



#pltt1.show()
#pltt2.show()
#pltt3.show()
#pltt4.show()
pltt5.show()

qapp.exec_()
