"""
Created on 2021

@author: Dhirendra Vaidya (dhirendra22121987@gmail.com)
"""

"""
USAGE
unzip Library.zip to Library
on linux system export this Library path in a MEM_MODEL_LIBRARY variable
for e.g.
export MEM_MODEL_LIBRARY=/home/dv1f19/Library

to run this file
ipython3
run <this file>
"""
import sys
from PyQt5 import QtWidgets
qapp = QtWidgets.QApplication(sys.argv)
import os
sys.path.append(os.environ.get('MEM_MODEL_LIBRARY'))
import numpy as np
from advanced_plot import AdvancedPlot
import pickle
from matplotlib.pyplot import cm

cmap = cm.get_cmap(name='tab10', lut=10)
pltt = AdvancedPlot(1,2)
## S1_D55
err1 = pickle.load(open('memristor_Ib_dataset/S1_D55_paper1_err.p', 'rb'))
err2 = pickle.load(open('memristor_Ib_dataset/S1_D55_paper2_err.p', 'rb'))
Temperatures = np.array([313, 323, 333, 343, 353])
biases = np.array([0.88, 0.92, 0.96, 1.0, 1.04, 1.08, 1.12, 1.16])

err_p1 = np.zeros((len(biases), len(Temperatures)))
err_n1 = np.zeros((len(biases), len(Temperatures)))
err_p2 = np.zeros((len(biases), len(Temperatures)))
err_n2 = np.zeros((len(biases), len(Temperatures)))
for Ti, T in enumerate(Temperatures):
    for Vi, V in enumerate(biases):
            err_p1[Vi, Ti] = err1[T, V]
            err_n1[Vi, Ti] = err1[T, -V]
            err_p2[Vi, Ti] = err2[T, V]
            err_n2[Vi, Ti] = err2[T, -V]
offset = 0
ticks = np.arange(0, len(biases))*1.2
for Ti, T in enumerate(Temperatures):
    pltt.ax[0].bar(ticks+offset, err_p1[:,Ti], width=0.1, color=cmap(Ti), label=str(T)+' K')
    pltt.ax[0].bar(ticks+offset+0.1, err_p2[:,Ti], width=0.1, color='None', edgecolor=cmap(Ti))
    pltt.ax[0].bar(ticks+offset, -err_n1[:,Ti], width=0.1, color=cmap(Ti))
    pltt.ax[0].bar(ticks+offset+0.1, -err_n2[:,Ti], width=0.1, color='None', edgecolor=cmap(Ti))
    #pltt.ax[0].bar(biases+offset, -err_n[:,Ti], width=0.005, color=cmap(Ti))
    offset = offset + 0.2#(biases[1]-biases[0])/(1.25*len(Temperatures))

pltt.ax[0].set_ylim([-120, 120])

lgd1 = pltt.ax[0].legend(ncol=2)
lgd1.set_draggable(True)
lgd2 = pltt.ax[0].legend(['behavioural model', 'physics-based model'])
lgd2.set_draggable(True)
pltt.ax[0].add_artist(lgd1)

pltt.ax[0].set_xticks([])
#pltt.ax[0].set_xticks(ticks)
#pltt.ax[0].set_xticklabels(biases)

## w22
err1 = pickle.load(open('memristor_II_dataset/w22_paper1_err.p', 'rb'))
err2 = pickle.load(open('memristor_II_dataset/w22_paper2_err.p', 'rb'))
Temperatures = np.array([300, 310, 320, 330, 340, 350, 360])
biases = np.array([1, 1.1, 1.2, 1.3, 1.4])

err_p1 = np.zeros((len(biases), len(Temperatures)))
err_n1 = np.zeros((len(biases), len(Temperatures)))
err_p2 = np.zeros((len(biases), len(Temperatures)))
err_n2 = np.zeros((len(biases), len(Temperatures)))
for Ti, T in enumerate(Temperatures):
    for Vi, V in enumerate(biases):
            err_p1[Vi, Ti] = err1[T, V]
            err_n1[Vi, Ti] = err1[T, -V]
            err_p2[Vi, Ti] = err2[T, V]
            err_n2[Vi, Ti] = err2[T, -V]
offset = 0
ticks = np.arange(0, len(biases))*((1+len(Temperatures))*0.2)
for Ti, T in enumerate(Temperatures):
    pltt.ax[1].bar(ticks+offset, err_p1[:,Ti], width=0.1, color=cmap(Ti), label=str(T)+' K')
    pltt.ax[1].bar(ticks+offset+0.1, err_p2[:,Ti], width=0.1, color='None', edgecolor=cmap(Ti))
    pltt.ax[1].bar(ticks+offset, -err_n1[:,Ti], width=0.1, color=cmap(Ti))
    pltt.ax[1].bar(ticks+offset+0.1, -err_n2[:,Ti], width=0.1, color='None', edgecolor=cmap(Ti))
    #pltt.ax[0].bar(biases+offset, -err_n[:,Ti], width=0.005, color=cmap(Ti))
    offset = offset + 0.2#(biases[1]-biases[0])/(1.25*len(Temperatures))

pltt.ax[1].set_ylim([-120, 120])

lgd1 = pltt.ax[1].legend(ncol=3)
lgd1.set_draggable(True)
lgd2 = pltt.ax[1].legend(['behavioural model', 'physics-based model'])
lgd2.set_draggable(True)
pltt.ax[1].add_artist(lgd1)

pltt.ax[1].set_xticks([])

pltt.ax[0].set_ylabel('root mean squared % error')
pltt.ax[0].set_xlabel('switching bias magnitude')
pltt.ax[1].set_ylabel('root mean squared % error')
pltt.ax[1].set_xlabel('switching bias magnitude')
#pltt.ax[1].set_xticks(ticks)
#pltt.ax[1].set_xticklabels(biases)
#pltt.ax[1].axvline(x=0.95)
#pltt.ax[1].axvline(x=5)


pltt.show()
