# -*- coding: utf-8 -*-
"""
Created on Wed Aug 28 16:03:54 2019

@author: Dhirendra Vaidya (dhirendra22121987@gmail.com)
"""

import numpy as np
import pandas as pd
from scipy.optimize import least_squares

class ParameterFitData:
    def __init__(self, csv_file, biases, temperatures, tw=100e-6, NPulse=500, dRdt0_window=5):
        bias_ = biases = biases #np.array([0.8, 0.9, 1.0, 1.1]) #str(pd.read_excel(fname, header=None, nrows=1, usecols = "A")[0][0]).split(',')
        temperatures_ = temperatures #np.array([300.0]) #str(pd.read_excel(fname, header=None, nrows=2, usecols = "A")[0][1]).split(',')
        self.NPulse = NPulse #int(str(pd.read_excel(fname, header=None, nrows=3, usecols = "A")[0][2]).split(',')[0])
        self.tw = tw
        #biases=np.array([float(b) for b in bias_])
        self._biases = biases
        self.biases = np.zeros(2*len(biases))
        for i in range(len(biases)):
            self.biases[2*i]=biases[i]
            self.biases[2*i+1]=-biases[i]
        self.Temperatures = temperatures_ #np.array([float(T) for T in temperatures_])
        data = np.array(pd.read_csv(csv_file, header = None, skiprows=1))
        self.pulses_TV, self.Rt_data_TV = self.sort_data(data, self.Temperatures, biases, self.NPulse)
        self.delta_Rt_data_TV, self.R0_TV, self.dRdt0_TV = self.get_deltaR_data(dRdt0_window=dRdt0_window)

    def sort_data(self, data, Temperatures, biases, N):
        data_T={}

        for Ti,T in enumerate(Temperatures):
            data_T[T] = data[:,Ti*3:Ti*3+2]

        Rt_data_TV={}
        pulses_TV={}
        for Ti,T in enumerate(Temperatures):
            d1 = data[:,Ti*3:Ti*3+2]
            for Vi, Vb in enumerate(biases):
                pulses_TV[T, Vb] = d1[Vi*2*N:Vi*2*N+N, 0]
                pulses_TV[T, -Vb] = d1[Vi*2*N+N:Vi*2*N+N+N, 0]
                Rt_data_TV[T, Vb] = d1[Vi*2*N:Vi*2*N+N, 1]
                Rt_data_TV[T, -Vb] = d1[Vi*2*N+N:Vi*2*N+N+N, 1]
        return pulses_TV, Rt_data_TV


    def get_deltaR_data(self, skip_biases=2, R0_avg_window=5, dRdt0_window=5):
        delta_Rt_data_TV = {}
        R0_TV = {}
        dRdt0_TV = {}
        for Ti, T in enumerate(self.Temperatures):
            for Vi, V in enumerate(self.biases[skip_biases:]):
                ind = Vi+skip_biases
                R0 = np.sum(self.Rt_data_TV[T, self.biases[ind-1]][-R0_avg_window:])/float(R0_avg_window)
                dRdt0 = (self.Rt_data_TV[T, self.biases[ind-1]][-dRdt0_window]-self.Rt_data_TV[T, self.biases[ind-1]][-1])/(dRdt0_window*self.tw)
                delta_Rt_data_TV[T, V] = self.Rt_data_TV[T, V]-R0
                R0_TV[T, V] = R0
                dRdt0_TV[T, V] = dRdt0
        return delta_Rt_data_TV, R0_TV, dRdt0_TV

class ParameterFitDataXlsx:
    def __init__(self, xlsx_file, skip_biases=2):
        bias_ = str(pd.read_excel(xlsx_file, header=None, nrows=1, usecols = "A")[0][0]).split(',')
        temperatures_ = str(pd.read_excel(xlsx_file, header=None, nrows=2, usecols = "A")[0][1]).split(',')
        self.NPulse = int(str(pd.read_excel(xlsx_file, header=None, nrows=3, usecols = "A")[0][2]).split(',')[0])
        biases=np.array([float(b) for b in bias_])
        self._biases = biases
        self.biases = np.zeros(2*len(biases))
        for i in range(len(biases)):
            self.biases[2*i]=biases[i]
            self.biases[2*i+1]=-biases[i]
        self.Temperatures = np.array([float(T) for T in temperatures_])
        data = np.array(pd.read_excel(xlsx_file, skiprows = 2))
        self.pulses_TV, self.Rt_data_TV = self.sort_data(data, self.Temperatures, self._biases, self.NPulse)
        self.skip_biases = skip_biases
        self.delta_Rt_data_TV, self.R0_TV = self.get_deltaR_data(skip_biases = self.skip_biases)
        self.delta_Rt_data_TV_Rf, self.R0_TV_Rf = self.get_deltaR_data_Rf()


    def sort_data(self, data, Temperatures, biases, N):
        data_T={}

        for Ti,T in enumerate(Temperatures):
            data_T[T] = data[:,Ti*3:Ti*3+2]

        Rt_data_TV={}
        pulses_TV={}
        for Ti,T in enumerate(Temperatures):
            d1 = data[:,Ti*3:Ti*3+2]
            for Vi, Vb in enumerate(biases):
                pulses_TV[T, Vb] = d1[Vi*2*N:Vi*2*N+N, 0]
                pulses_TV[T, -Vb] = d1[Vi*2*N+N:Vi*2*N+N+N, 0]
                Rt_data_TV[T, Vb] = d1[Vi*2*N:Vi*2*N+N, 1]
                Rt_data_TV[T, -Vb] = d1[Vi*2*N+N:Vi*2*N+N+N, 1]
        return pulses_TV, Rt_data_TV



    def get_deltaR_data(self, skip_biases, R0_avg_window=5):
        delta_Rt_data_TV = {}
        R0_TV = {}
        for Ti, T in enumerate(self.Temperatures):
            for Vi, V in enumerate(self.biases[skip_biases:]):
                ind = Vi+skip_biases
                R0 = np.sum(self.Rt_data_TV[T, self.biases[ind-1]][-R0_avg_window:])/float(R0_avg_window)
                R0_TV[T, V] = R0
                delta_Rt_data_TV[T, V] = self.Rt_data_TV[T, V]-R0
        return delta_Rt_data_TV, R0_TV

    def get_deltaR_data_Rf(self, R0_avg_window=5):
        delta_Rt_data_TV = {}
        R0_TV = {}
        for Ti, T in enumerate(self.Temperatures):
            for Vi, V in enumerate(self.biases):
                ind = Vi
                R0 = np.sum(self.Rt_data_TV[T, self.biases[ind]][-R0_avg_window:])/float(R0_avg_window)
                R0_TV[T, V] = R0
                delta_Rt_data_TV[T, V] = self.Rt_data_TV[T, V]-R0

        return delta_Rt_data_TV, R0_TV

class ExponentialModelAbsoluteR:
    def __init__(self, xdata, ydata, tw, NPulse):
        self.name = 'Exponential Model'
        self.xdata = xdata
        self.ydata = ydata
        self.tw = tw
        self.NPulse = NPulse

    def analytical(self, pulses, s, Rp, R0):
        tw = self.tw
        N = self.NPulse
        R = np.zeros(N)
        for i in range(self.NPulse):
            if i == 0:
                R[i] = -Rp*np.log(-s*tw/Rp+np.exp(-(R0)/Rp))
            else:
                R[i] = -Rp*np.log(-s*tw/Rp+np.exp(-(R[i-1])/Rp))
            #R[i+1] = r-Rp*np.log(-s*tw/Rp+np.exp(-(R[i]-r)/Rp)) #for Vb>0.0
            #R[i+1] = r-Rp*np.log(-s*tw+np.exp(-(R[i]-r)/Rp)) #for Vb>0.0
            #R[i+1] = r+Rp*np.log(s*tw/Rp+np.exp((R[i]-r)/Rp))
        return R

    def error(self, p):
        return self.ydata - self.analytical(self.xdata, p[0], p[1])

    def fit(self, R0, p_init=np.array([-400000.0, 1.0]), bounds = ([-np.inf, -np.inf], [np.inf, np.inf])):
        results = least_squares(self.error, p_init, bounds = bounds, args=(R0,)) #, bounds=([-np.inf, 0], [0, np.inf]))
        return results.x

class ExponentialModel:
    def __init__(self, xdata, ydata, tw, NPulse):
        self.name = 'Exponential Model'
        self.xdata = xdata
        self.ydata = ydata
        self.tw = tw
        self.NPulse = NPulse

    def analytical(self, pulses, s, Rp):
        tw = self.tw
        N = self.NPulse
        R = np.zeros(N)
        for i in range(self.NPulse):
            if i == 0:
                R[i] = -Rp*np.log(-s*tw/Rp+1.0)
            else:
                R[i] = -Rp*np.log(-s*tw/Rp+np.exp(-(R[i-1])/Rp))
            #R[i+1] = r-Rp*np.log(-s*tw/Rp+np.exp(-(R[i]-r)/Rp)) #for Vb>0.0
            #R[i+1] = r-Rp*np.log(-s*tw+np.exp(-(R[i]-r)/Rp)) #for Vb>0.0
            #R[i+1] = r+Rp*np.log(s*tw/Rp+np.exp((R[i]-r)/Rp))
        return R

    def analytical_abs_R(self, pulses, s, r, Rp):
        tw = self.tw
        N = self.NPulse
        R = np.zeros(N)
        for i in range(self.NPulse):
            if i == 0:
                R[i] = r-Rp*np.log(-s*tw/Rp+1.0)
            else:
                R[i] = r-Rp*np.log(-s*tw/Rp+np.exp(-(R[i-1]-r)/Rp))
            #R[i+1] = r-Rp*np.log(-s*tw/Rp+np.exp(-(R[i]-r)/Rp)) #for Vb>0.0
            #R[i+1] = r-Rp*np.log(-s*tw+np.exp(-(R[i]-r)/Rp)) #for Vb>0.0
            #R[i+1] = r+Rp*np.log(s*tw/Rp+np.exp((R[i]-r)/Rp))
        return R

    def error(self, p):
        return self.ydata - self.analytical(self.xdata, p[0], p[1])

    def fit(self, p_init=np.array([-400000.0, 1.0]), bounds = ([-np.inf, -np.inf], [np.inf, np.inf])):
        results = least_squares(self.error, p_init, bounds = bounds) #, bounds=([-np.inf, 0], [0, np.inf]))
        return results.x

class ExponentialModelRpOnly:
    def __init__(self, xdata, ydata, tw, NPulse, s_avg_window=1):
        self.name = 'Exponential Model'
        self.xdata = xdata
        self.ydata = ydata
        self.tw = tw
        self.NPulse = NPulse
        '''
        s = 0
        y0 = 0
        for i in range(s_avg_window):
            s = s+((ydata[i]-y0)/self.tw)/s_avg_window
            y0 = ydata[i]
        self.s = s
        '''
        self.s = ydata[s_avg_window]/(self.tw*s_avg_window)
    def analytical(self, pulses, Rp):
        tw = self.tw
        N = self.NPulse
        R = np.zeros(N)
        s = self.s
        for i in range(self.NPulse):
            if i == 0:
                R[i] = -Rp*np.log(-s*tw/Rp+1.0)
            else:
                R[i] = -Rp*np.log(-s*tw/Rp+np.exp(-(R[i-1])/Rp))
            #R[i+1] = r-Rp*np.log(-s*tw/Rp+np.exp(-(R[i]-r)/Rp)) #for Vb>0.0
            #R[i+1] = r-Rp*np.log(-s*tw+np.exp(-(R[i]-r)/Rp)) #for Vb>0.0
            #R[i+1] = r+Rp*np.log(s*tw/Rp+np.exp((R[i]-r)/Rp))
        return R

    def analytical_abs_R(self, pulses, s, r, Rp):
        tw = self.tw
        N = self.NPulse
        R = np.zeros(N)
        for i in range(self.NPulse):
            if i == 0:
                R[i] = r-Rp*np.log(-s*tw/Rp+1.0)
            else:
                R[i] = r-Rp*np.log(-s*tw/Rp+np.exp(-(R[i-1]-r)/Rp))
            #R[i+1] = r-Rp*np.log(-s*tw/Rp+np.exp(-(R[i]-r)/Rp)) #for Vb>0.0
            #R[i+1] = r-Rp*np.log(-s*tw+np.exp(-(R[i]-r)/Rp)) #for Vb>0.0
            #R[i+1] = r+Rp*np.log(s*tw/Rp+np.exp((R[i]-r)/Rp))
        return R

    def error(self, p):
        return self.ydata - self.analytical(self.xdata, p)

    def fit(self, p_init=1.0, bounds = ([-np.inf, np.inf])):
        results = least_squares(self.error, p_init, bounds = bounds) #, bounds=([-np.inf, 0], [0, np.inf]))
        return results.x

class ExponentialModelRpOnlydRdt0:
    def __init__(self, xdata, ydata, tw, NPulse, s_avg_window=1, dRdt0=1e-6):
        self.name = 'Exponential Model'
        self.xdata = xdata
        self.ydata = ydata
        self.tw = tw
        self.NPulse = NPulse
        self.s = ydata[s_avg_window]/(self.tw*s_avg_window)
        self.dRdt0 = dRdt0
    def analytical(self, pulses, Rp):
        tw = self.tw
        N = self.NPulse
        R = np.zeros(N)
        s = self.s
        c = self.dRdt0
        exp_var = np.exp(-c*tw/Rp)
        for i in range(self.NPulse):
            if i == 0:
                R[i] = -Rp*np.log((s/c)*(exp_var*(1+(c/s))-1))
            else:
                R[i] = -Rp*np.log((s/c)*(exp_var*(1+(c/s)*np.exp(-(R[i-1])/Rp))-1))
            #R[i+1] = r-Rp*np.log(-s*tw/Rp+np.exp(-(R[i]-r)/Rp)) #for Vb>0.0
            #R[i+1] = r-Rp*np.log(-s*tw+np.exp(-(R[i]-r)/Rp)) #for Vb>0.0
            #R[i+1] = r+Rp*np.log(s*tw/Rp+np.exp((R[i]-r)/Rp))
        return R

    def analytical_abs_R(self, pulses, s, r, Rp):
        tw = self.tw
        N = self.NPulse
        R = np.zeros(N)
        for i in range(self.NPulse):
            if i == 0:
                R[i] = r-Rp*np.log(-s*tw/Rp+1.0)
            else:
                R[i] = r-Rp*np.log(-s*tw/Rp+np.exp(-(R[i-1]-r)/Rp))
            #R[i+1] = r-Rp*np.log(-s*tw/Rp+np.exp(-(R[i]-r)/Rp)) #for Vb>0.0
            #R[i+1] = r-Rp*np.log(-s*tw+np.exp(-(R[i]-r)/Rp)) #for Vb>0.0
            #R[i+1] = r+Rp*np.log(s*tw/Rp+np.exp((R[i]-r)/Rp))
        return R

    def error(self, p):
        return self.ydata - self.analytical(self.xdata, p)

    def fit(self, p_init=1.0, bounds = ([-np.inf, np.inf])):
        results = least_squares(self.error, p_init, bounds = bounds) #, bounds=([-np.inf, 0], [0, np.inf]))
        return results.x
