clear all
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
b=["0403-1431-1-5-10-20-40-60-80.csv"]
for i=1
    data=[];
    temp=table2array(readtable(b(i),'headerLines', 239));
    data=[data,temp(1:1500,1:14)];
    
end
pump=max(data(:,2:2:14));
raman=max(data(1250:1500,2:2:14));
coupled=[0.6 3 6 12 24 36 48]
pump_mw=10.^(pump./10);
raman_pw=1e9*10.^(raman./10);
figure
plot(pump_mw.*54.9,raman_pw.*54.9./1000,'ro')
hold on
x=0:0.1:0.9*54.9;
y=(75.83*x-0.1536)./1000;
plot(x,y,'r-')
hold on

b=["0403-1500-1-5-10-20-40-60-80.csv"]
for i=1
    data=[];
    temp=table2array(readtable(b(i),'headerLines', 239));
    data=[data,temp(1:1500,1:14)];
    
end

pump=max(data(:,2:2:14));
raman=max(data(1250:1500,2:2:14));
coupled=[0.6 3 6 12 24 36 48]
pump_mw=10.^(pump./10);
raman_pw=1e9*10.^(raman./10);
plot(pump_mw*60,raman_pw*60/1000,'bo')
hold on
x=0:0.1:0.8*60;
y=(75.04*x-0.514)./1000;
plot(x,y,'b-')
xlabel('Pump power (mW)', 'Fontsize',18, 'Fontname','Timesnewroman');
ylabel('Raman power (nW)','Fontsize',18, 'Fontname','Timesnewroman');