classdef RadioPerformance
    %RADIOPERFORMANCE Summary of this class goes here
    %   Detailed explanation goes here
    
    properties
        series;
        device;
        voltage;
        frequency;
        datasource;
        fine;
        P_out;
        current_at_P_out;
    end
    
    methods
        function obj = RadioPerformance(series, device, voltage, datasource, filename, varargin)
            %RADIOPERFORMANCE Construct an instance of this class
            %   Detailed explanation goes here
            p = inputParser;
            checkSeries = @(x) any(validatestring(x,{'Sx126x','Si44xx','CC1xxx','CC2xxx','nRF9','AX5xxx','SPIRIT'}));
            addRequired(p, 'series',  checkSeries);
            addRequired(p, 'device',  @ischar);
            addRequired(p, 'voltage',  @isnumeric);
            addRequired(p, 'datasource',  @ischar);
            addRequired(p, 'filename',  @ischar);
            addOptional(p, 'frequency', 868, @isnumeric);
            addOptional(p, 'fine', false, @islogical);
            parse(p, series, device, voltage, datasource, filename, ...
            varargin{:});
            obj.series = p.Results.series;
            obj.device = p.Results.device;
            obj.voltage = p.Results.voltage;
            obj.datasource = p.Results.datasource;
            obj.frequency = p.Results.frequency;
            obj.fine = p.Results.fine;
            PI = csvread(filename, 1);
            obj.P_out = PI(:,1);
            obj.current_at_P_out = PI(:,2);
            
            % Now sort the imported values
            [obj.P_out, idx] = sort(obj.P_out);
            obj.current_at_P_out = obj.current_at_P_out(idx);
        end
        
        function h = plot(obj,mark,h)
            %METHOD1 Summary of this method goes here
            %   Detailed explanation goes here
            switch(obj.series)
                case 'Sx126x'
                    color = 'r';
                case 'Si44xx'
                    color = 'g';
                case 'CC1xxx'
                    color = 'k';
                case 'CC2xxx'
                    color = 'c';
                case 'nRF9'
                    color = 'm';
                otherwise
                    color = 'b';
            end
            
            
            if(obj.fine)
                plot(obj.P_out, obj.current_at_P_out, ['-' color mark]);
%                 plot(obj.P_out, obj.current_at_P_out, ['-' color mark], ...
%                     'MarkerIndices',floor(linspace(1,numel(obj.P_out),5)));
            else
                % Fancy interp to do markers on sparse plots only
                mark_idx = [1];
                P = min(obj.P_out);
                P_out_i = 2;
                P_step = 1; %dBm
                while(P(end)<max(obj.P_out))
                    P(end+1) = P(end)+P_step;
                    if(P(end)>=obj.P_out(P_out_i))
                        if(P(end)>obj.P_out(P_out_i))
                            P(end) = obj.P_out(P_out_i);
                        end
                        mark_idx(end+1) = numel(P);
                        P_out_i = P_out_i+1;
                    end
                end
                
                % Lin interp of Log of current
                I = exp(interp1(obj.P_out, log(obj.current_at_P_out), P));
%                 plot(P, I, [':' color mark], 'MarkerIndices',mark_idx)
                plot(P, I, [':' color mark])
            end
        end
        
        function h = plotpower(obj,mark,h)
            %METHOD1 Summary of this method goes here
            %   Detailed explanation goes here
            switch(obj.series)
                case 'Sx126x'
                    color = 'r';
                case 'Si44xx'
                    color = 'g';
                case 'CC1xxx'
                    color = 'k';
                case 'CC2xxx'
                    color = 'c';
                case 'nRF9'
                    color = 'm';
                otherwise
                    color = 'b';
            end
            
            
            if(obj.fine)
%                 plot(obj.P_out, obj.current_at_P_out*obj.voltage, ['-' color mark], ...
%                     'MarkerIndices',floor(linspace(1,numel(obj.P_out),5)));
                plot(obj.P_out, obj.current_at_P_out*obj.voltage, ['-' color mark]);
            else
                % Fancy interp to do markers on sparse plots only
                mark_idx = [1];
                P = min(obj.P_out);
                P_out_i = 2;
                P_step = 1; %dBm
                while(P(end)<max(obj.P_out))
                    P(end+1) = P(end)+P_step;
                    if(P(end)>=obj.P_out(P_out_i))
                        if(P(end)>obj.P_out(P_out_i))
                            P(end) = obj.P_out(P_out_i);
                        end
                        mark_idx(end+1) = numel(P);
                        P_out_i = P_out_i+1;
                    end
                end
                
                % Lin interp of Log of current
                I = exp(interp1(obj.P_out, log(obj.current_at_P_out), P));
                plot(P, I*obj.voltage, [':' color mark], 'MarkerIndices',mark_idx)
            end
        end
        function h = plotrootPout(obj, freq_sens_factor, alp, mark, h)
            %METHOD1 Summary of this method goes here
            %   Detailed explanation goes here
            switch(obj.series)
                case 'Sx126x'
                    color = 'r';
                case 'Si44xx'
                    color = 'g';
                case 'CC1xxx'
                    color = 'k';
                case 'CC2xxx'
                    color = 'c';
                case 'nRF9'
                    color = 'm';
                otherwise
                    color = 'b';
            end
            
            if(obj.fine)
%                 plot(obj.current_at_P_out*obj.voltage, freq_sens_factor*(10.^(obj.P_out/10)).^(1/alp), ['-' color mark], ...
%                     'MarkerIndices',floor(linspace(1,numel(obj.P_out),5)));
                plot(obj.current_at_P_out*obj.voltage, freq_sens_factor*(10.^(obj.P_out/10)).^(1/alp), ['-' color mark]);
            else
                % Fancy interp to do markers on sparse plots only
                mark_idx = [1];
                P = min(obj.P_out);
                P_out_i = 2;
                P_step = 1; %dBm
                while(P(end)<max(obj.P_out))
                    P(end+1) = P(end)+P_step;
                    if(P(end)>=obj.P_out(P_out_i))
                        if(P(end)>obj.P_out(P_out_i))
                            P(end) = obj.P_out(P_out_i);
                        end
                        mark_idx(end+1) = numel(P);
                        P_out_i = P_out_i+1;
                    end
                end
                
                % Lin interp of Log of current
                I = exp(interp1(obj.P_out, log(obj.current_at_P_out), P));
%                 plot(I*obj.voltage, freq_sens_factor*(10.^(P/10)).^(1/alp), [':' color mark], 'MarkerIndices',mark_idx)
                plot(I*obj.voltage, freq_sens_factor*(10.^(P/10)).^(1/alp), [':' color mark])
            end
            
        end
    end
end

