opts = detectImportOptions('devices.csv');
opts = setvartype(opts, {'Frequency'},'double');
T = readtable('devices.csv', opts);
dev_868 = T(T.Frequency<916&T.Frequency>860|isnan(T.Frequency),:);

%  Plot efficiency areas
P_lvl = -20:1:25
eff = [30;40;50]*1e-2;
P_consump = 1./eff*10.^(P_lvl/10);
figure;
area(P_lvl, P_consump');

% Plot Device Characteristics
hold on;
mark = 'osd^p><vh*x+';
for i=1:size(dev_868,1)
    D = dev_868(i,:);
    R = RadioPerformance(D.Series{:}, D.Device{:}, D.Voltage, ...
        D.Datasource{:}, D.Filename{:}, D.Frequency, (1==D.Fine));
    plotpower(R,mark(i))
end

legend({'>40%','30-40%', '20-30%', dev_868.Device{:}})
% legend({">40%","30-40%", "20-30%", dev_868.Device{:}})

% Limit axes
ylim([0, 500])