% opts = detectImportOptions('devices.csv');
% opts = setvartype(opts, {'Frequency'},'double');
% T = readtable('devices.csv', opts);
dev_868 = T(T.Frequency<916&T.Frequency>860|isnan(T.Frequency),:);

alp = 2; %path loss
sens = -50;
freq = 868e6;
freq_sens_factor = ((1/10^(sens/10)))^(1/alp)*(3e8)/(4*pi*freq);

%  Plot efficiency areas
P_consump = linspace(1,26.02059,27);
eff = [40;30;20]*1e-2;
P_lvl = eff*10.^(P_consump/10);
figure;
hold on;
range = freq_sens_factor.*(P_lvl.^(1/alp));
area(10.^(P_consump/10), range(1,:)');
area(10.^(P_consump/10), range(2,:)');
area(10.^(P_consump/10), range(3,:)');

% Plot Device Characteristics
hold on;
mark = 'osd^p><vh*x+';
for i=1:size(dev_868,1)
    D = dev_868(i,:);
    R = RadioPerformance(D.Series{:}, D.Device{:}, D.Voltage, ...
        D.Datasource{:}, D.Filename{:}, D.Frequency, (1==D.Fine));
    plotrootPout(R,freq_sens_factor,alp,mark(i))
end
xlabel('Tx Power consumption (mW)')
ylabel('Range to -50dBm (mW)')
legend({'30-40%','20-30%', '<20%', dev_868.Device{:}},'location','northwest')
% legend(["30-40%","20-30%", "<20%", dev_868.Device{:}],'location','northwest')
% ylim([0 10])