import {ExtendedStory} from "./extendedstory";
import {alternativePages, unlocks} from "./locking";
import {PageHint} from "storyplacesauthoringlib/lib/models/PageHint";
import {VariableReference} from "storyplacesauthoringlib/lib/models/VariableReference";
import {VariableScope} from "storyplacesauthoringlib/lib/schemas/multiplayer/VariableScopes";
import {LogicalOperand} from "storyplacesauthoringlib/lib/schemas/multiplayer/ConditionSchema";
import {
    StoryConditionCheck, StoryConditionIsRole,
    StoryConditionLogical
} from "storyplacesauthoringlib/lib/models/StoryCondition";
import {StoryFunctionSet, StoryFunctionSetRole} from "storyplacesauthoringlib/lib/models/StoryFunction";
import {Role} from "storyplacesauthoringlib/lib/models/Role";

export function addRoleSelectionToStory(story: ExtendedStory) {
    //set up roles and functions to check for roles
    let mentorRole = new Role("Mentor");
    story.roles.push(mentorRole);

    let rookieRole = new Role("Rookie");
    story.roles.push(rookieRole);

    let mentorChosenVariable = new VariableReference(
        VariableScope.shared,
        "roles",
        "Mentor"
    );

    let rookieChosenVariable = new VariableReference(
        VariableScope.shared,
        "roles",
        "Rookie"
    );

    let readyToChooseRoleVariable = new VariableReference(
        VariableScope.shared,
        "this",
        "ReadyToChooseRole"
    );

    let readyToChooseRoleCondition = new StoryConditionCheck("ReadyToChooseRole", readyToChooseRoleVariable);
    let readyToChooseRoleFunction = new StoryFunctionSet("ReadyToChooseRole", readyToChooseRoleVariable, "true");
    let notReadyToChooseRoleCondition = new StoryConditionLogical("NotReadyToChoosenRole", LogicalOperand.NAND, [readyToChooseRoleCondition]);
    let mentorRoleFilled = new StoryConditionCheck("MentorRoleFilled", mentorChosenVariable);
    let rookieRoleFilled = new StoryConditionCheck("RookieRoleFilled", rookieChosenVariable);
    let setMentorRoleFilled = new StoryFunctionSet("MentorRoleFilled", mentorChosenVariable, "true");
    let setRookieRoleFilled = new StoryFunctionSet("RookieRoleFilled", rookieChosenVariable, "true");
    let noMentor = new StoryConditionLogical("MentorRoleEmpty", LogicalOperand.NAND, [mentorRoleFilled]);
    let noRookie = new StoryConditionLogical("RookieRoleEmpty", LogicalOperand.NAND, [rookieRoleFilled]);
    let setMentor = new StoryFunctionSetRole("SetMentor", mentorRole.id);
    let setRookie = new StoryFunctionSetRole("SetRookie", rookieRole.id);
    let bothRolesChosenCondition = new StoryConditionLogical("BothRolesChosen", LogicalOperand.AND, [mentorRoleFilled, rookieRoleFilled])

    // ********* INTRO - AND ROLE CHOICE *********


    let chooseRoles = story.NewPage({
        name: "Please Choose Your Role",
        content: "Choose which character you'd like to play - The mentor, Sarah or the rookie, Todd",
        singleVisit: true,
        hint: new PageHint("Select your role in the story..."),
        conditions: [notReadyToChooseRoleCondition],
        functions: [readyToChooseRoleFunction]
    });

    //intro page for the mentor
    let chooseMentor = story.NewPage({
        name: "Todd",
        content: "Todd may be new to the organization, but that doesn't mean he doesn't know what he's doing. After all, he grew up on the streets. Todd was hired by \"The Organization\" a few years ago, and for the last couple has been partnered up with Sarah: one of \"The Organization\"'s oldest members.",
        singleVisit: true,
        hint: new PageHint("Choose to be Todd, an eager and relatively new member of 'The Organization', and mentee for Sarah."),
        conditions: [noMentor, readyToChooseRoleCondition],
        //ReadyToChooseRoleFunction prevents role selection popping up again when we switch roles.
        functions: [setMentorRoleFilled, setRookie, readyToChooseRoleFunction]
    });

    //intro page for the rookie
    let chooseRookie = story.NewPage({
        name: "Sarah",
        content: "Sarah's a veteran within \"The Organization\". She's been in the game for over 50 years. No mean feat, given their line of work. She's good at what she does. She has to be, to stay alive. She'd been running with her latest partner, Todd, for about a couple of years, before things take a turn.",
        singleVisit: true,
        hint: new PageHint("Choose to follow Sarah, a veteran within 'The Organization' and Todd's mentor."),
        conditions: [noRookie, readyToChooseRoleCondition],
        functions: [setRookieRoleFilled, setMentor, readyToChooseRoleFunction]
    });

    unlocks([chooseRoles], [chooseMentor, chooseRookie]);
    alternativePages([chooseMentor, chooseRookie], new VariableReference(
        VariableScope.shared, "this", "RoleChosen"));
}