import {StoryFunction, StoryFunctionSet} from "storyplacesauthoringlib/lib/models/StoryFunction";
import {StoryCondition, StoryConditionComparison} from "storyplacesauthoringlib/lib/models/StoryCondition";
import {VariableReference} from "storyplacesauthoringlib/lib/models/VariableReference";
import {Page} from "storyplacesauthoringlib/lib/models/Page";
import {VariableScope} from "storyplacesauthoringlib/lib/schemas/multiplayer/VariableScopes";
import {ComparisonOperand, ComparisonType} from "storyplacesauthoringlib/lib/schemas/multiplayer/ConditionSchema";

export interface Chunk {
    variable: VariableReference,
    isUnlockedCondition: StoryCondition,
    isLockedCondition: StoryCondition,
    unlockFunction: StoryFunction,
    lockFunction: StoryFunction
}

export interface ChunkOptions {
    pages?: Page[],
    scope?: VariableScope,
    name?: string,
    startsLocked?: boolean,
    thisNamespace?: boolean,
}

export function createChunk(options: ChunkOptions): Chunk {
    let pages = options.pages || [];
    let scope = options.scope || VariableScope.shared;
    let name = options.name || "chunk" + nextChunkId();
    let startsLocked = options.startsLocked || false;
    let thisNamespace = options.thisNamespace || false;

    let namespace = thisNamespace? "this" : "chunks";

    let variable = new VariableReference(scope, namespace, name);
    let chunk = {
        variable: variable,
        isUnlockedCondition: startsLocked?
            new StoryConditionComparison("isChunkUnlocked - " + name, ComparisonOperand.EQUAL, variable, "unlocked", ComparisonType.Variable, ComparisonType.String) :
            new StoryConditionComparison("isChunkUnlocked - " + name, ComparisonOperand.NOT_EQUAL, variable, "locked", ComparisonType.Variable, ComparisonType.String),
        isLockedCondition: startsLocked?
            new StoryConditionComparison("isChunkLocked - " + name, ComparisonOperand.NOT_EQUAL, variable, "unlocked", ComparisonType.Variable, ComparisonType.String) :
            new StoryConditionComparison("isChunkLocked - " + name, ComparisonOperand.EQUAL, variable, "locked", ComparisonType.Variable, ComparisonType.String),
        unlockFunction: new StoryFunctionSet("unlockChunk - " + name, variable, "unlocked"),
        lockFunction: new StoryFunctionSet("lockChunk - " + name, variable, "locked")
    };

    for(let page of pages) {
        page.conditions.push(chunk.isUnlockedCondition);
    }

    return chunk;
}

let chunkId = 0;
export function nextChunkId() {
    chunkId += 1;
    return chunkId;
}

