import {VariableReference} from "storyplacesauthoringlib/lib/models/VariableReference";
import {VariableScope} from "storyplacesauthoringlib/lib/schemas/multiplayer/VariableScopes";
import {StoryFunction} from "storyplacesauthoringlib/lib/models/StoryFunction";
import {PageHint} from "storyplacesauthoringlib/lib/models/PageHint";
import {unlocks, visitingAllUnlocks, visitingAnyUnlocks} from "./locking";
import {BuiltFlashback, listBuiltFlashbackPages} from "./flashback_import";
import {ExtendedStory} from "./extendedstory";
import * as fs from "fs";
import {nodesToFlashback, nodeToPageInStory, parseNodeDescriptionStringIntoGroups, RawNodeData} from "./import_content";
import {createChunk} from "./chunk";
import {Page} from "storyplacesauthoringlib/lib/models/Page";
import {Role} from "storyplacesauthoringlib/lib/models/Role";
import {StoryConditionCheck} from "storyplacesauthoringlib/lib/models/StoryCondition";
import transition_nodes from "./transition_nodes";

export function addContentToStory(story: ExtendedStory, progressStoryFunction: StoryFunction) {

    let mentorChosenVariable = new VariableReference(
        VariableScope.shared,
        "roles",
        "Mentor"
    );

    let rookieChosenVariable = new VariableReference(
        VariableScope.shared,
        "roles",
        "Rookie"
    );

    let mentorRoleFilled = new StoryConditionCheck("MentorRoleFilledContent", mentorChosenVariable);
    let rookieRoleFilled = new StoryConditionCheck("RookieRoleFilledContent", rookieChosenVariable);


    let rookieRole: Role = story.roles.find(role => role.id == "Rookie");
    let mentorRole: Role = story.roles.find(role => role.id == "Mentor");

    let heist_content = fs.readFileSync("./heist_content.txt", {encoding: 'utf8'});
    let nodeGroups = parseNodeDescriptionStringIntoGroups(heist_content);

    nodeGroups.forEach((value, key) => {
       console.error(`Group Name: ${key} has ${value.length} nodes`);
    });

    //================================
    //PHASE 1
    //================================

    let toddSoloRawNodes = nodeGroups.get("Todd Solo");
    let sarahSoloRawNodes = nodeGroups.get("Sarah Solo");

    let toddSoloPages: Map<string, RawNodeData> = new Map();
    let sarahSoloPages: Map<string, RawNodeData> = new Map();

    toddSoloRawNodes.forEach(rawNode => toddSoloPages.set(rawNode.name, rawNode));
    sarahSoloRawNodes.forEach(rawNode => sarahSoloPages.set(rawNode.name, rawNode));

    let getPageFromMapOrWarn = (map, pageName) => {
        if(map.has(pageName)) {
            return nodeToPageInStory(map.get(pageName), story);
        } else {
            console.warn("Error: Phase 1 page not found with name " + pageName);
            return null;
        }
    };
    let getToddPage: (string) => Page = pageName => getPageFromMapOrWarn(toddSoloPages, pageName);
    let getSarahPage: (string) => Page = pageName => getPageFromMapOrWarn(sarahSoloPages, pageName);

    let todd1 = getToddPage("In the beginning...");
    /*let todd2 = getToddPage("A Mysterious Stranger");
    let toddChoice1OptionA = getToddPage("Todd Declines to Deliver the Package");
    let toddChoice1OptionB = getToddPage("Todd Agrees to Deliver the Package");
    let todd3 = getToddPage("Todd Arrives at the Alley");
    let todd4 = getToddPage("A Generous Benefactor");
    let todd5 = getToddPage("The Bigger the Risk, the Bigger the Reward");
    let todd6 = getToddPage("Welcome to the Club");*/
    let toddIntroEnd = todd1;

    todd1.conditions.push(mentorRoleFilled, rookieRoleFilled);

    /*
    unlocks([todd1], [todd2]);
    unlocks([todd2], [toddChoice1OptionA, toddChoice1OptionB]);
    locks([toddChoice1OptionA], [toddChoice1OptionB]);
    locks([toddChoice1OptionB], [toddChoice1OptionA]);
    unlocks([toddChoice1OptionA, toddChoice1OptionB], [todd3]);
    unlocks([todd3], [todd4]);
    unlocks([todd4], [todd5]);
    unlocks([todd5], [todd6]);
    */

    let phase1TransitionTodd = story.NewPage({
        name: "Act Two - Scene One",
        hint: new PageHint("The first few jobs are the easiest."),
        content: transition_nodes.todd1,
        singleVisit: true,
        conditions: [rookieRole.getIsRoleCondition()]
    });

    let sarah1 = getSarahPage("The (Almost) Midnight Road");
    //This is a bodge to avoid updating the content.txt.
    sarah1.content = transition_nodes.sarah1;
    /*let sarah2 = getSarahPage("The Lingering Song");
    let sarahChoice1OptionA = getSarahPage("Let the Radio Play");
    let sarahChoice1OptionB = getSarahPage("Shut the Radio Off");
    let sarah3 = story.NewPage({name: "Placeholder 4th Sarah Node", hint: new PageHint(""), content: "Ducks", singleVisit: true, conditions: [mentorRole.getIsRoleCondition()]});*/
    let sarahIntroEnd = sarah1;

    sarah1.conditions.push(mentorRoleFilled, rookieRoleFilled);

    /*
    unlocks([sarah1], [sarah2]);
    unlocks([sarah2], [sarahChoice1OptionA, sarahChoice1OptionB]);
    locks([sarahChoice1OptionA], [sarahChoice1OptionB]);
    locks([sarahChoice1OptionB], [sarahChoice1OptionA]);
    unlocks([sarahChoice1OptionA, sarahChoice1OptionB], [sarah3]);
    */

    let phase1TransitionSarah = story.NewPage({
        name: "Act Two - Scene One",
        hint: new PageHint("The first few jobs are the easiest."),
        content: transition_nodes.sarah2,
        singleVisit: true,
        conditions: [mentorRole.getIsRoleCondition()]
    });

    //Have them independently unlock their phase transitions.
    //I.e - no forced blocking at this point.
    visitingAllUnlocks([toddIntroEnd], [phase1TransitionTodd]);
    visitingAllUnlocks([sarahIntroEnd], [phase1TransitionSarah]);

    //================================
    //PHASE 2
    //================================

    let phase2FlashbackNames = [/*"Gas Station",*/ "Concrete Truck Heist", "Home Invasion", /*"Bridge"*/];
    let phase2Flashbacks = phase2FlashbackNames.map(name => nodesToFlashback(nodeGroups.get(name)));
    let phase2MentorFlashbacks = phase2Flashbacks.filter(flashback => flashback.choosingCharacter == "Mentor");
    let phase2RookieFlashbacks = phase2Flashbacks.filter(flashback => flashback.choosingCharacter == "Rookie");

    let phase2MentorBuiltFlashbacks: BuiltFlashback[] = phase2MentorFlashbacks.map(flashback => flashback.buildPages(story.roles));
    let phase2RookieBuiltFlashbacks: BuiltFlashback[] = phase2RookieFlashbacks.map(flashback => flashback.buildPages(story.roles));

    let phase2MentorFlashbackPages: Page[] = phase2MentorBuiltFlashbacks.reduce((allPages, flashback) =>
        allPages.concat(listBuiltFlashbackPages(flashback)), []);
    let phase2RookieFlashbackPages: Page[] = phase2RookieBuiltFlashbacks.reduce((allPages, flashback) =>
        allPages.concat(listBuiltFlashbackPages(flashback)), []);

    let phase2Mentor = createChunk({name: "Mentor Phase Two", startsLocked: true, pages: phase2MentorFlashbackPages});
    story.pages.push(...phase2MentorFlashbackPages);

    let phase2Rookie = createChunk({name: "Rookie Phase Two", startsLocked: true, pages: phase2RookieFlashbackPages});
    story.pages.push(...phase2RookieFlashbackPages);

    phase1TransitionTodd.functions.push(phase2Rookie.unlockFunction);
    phase1TransitionSarah.functions.push(phase2Mentor.unlockFunction);

    let phase2To3TransitionPageMentor = story.NewPage({
        name: "Act 2 - Scene Two",
        singleVisit: true,
        hint: new PageHint("Things begin to turn south."),
        content: transition_nodes.sarah3,
        conditions: [mentorRole.getIsRoleCondition()]
    });

    let phase2To3TransitionPageRookie = story.NewPage({
        name: "Act 2 - Scene Two",
        singleVisit: true,
        hint: new PageHint("Things begin to turn south."),
        content: transition_nodes.todd2,
        conditions: [rookieRole.getIsRoleCondition()]
    });

    let phase2AllBuiltFlashbacks = phase2MentorBuiltFlashbacks.concat(phase2RookieBuiltFlashbacks);

    phase2MentorBuiltFlashbacks.forEach(builtFlashback => {
        visitingAnyUnlocks(
            builtFlashback.choicePages1,
            [phase2To3TransitionPageMentor]
        );
        /*visitingAnyUnlocks(
            builtFlashback.choicePages2,
            [phase2To3TransitionPageMentor]
        )*/
    });

    phase2RookieBuiltFlashbacks.forEach(builtFlashback => {
        visitingAnyUnlocks(
            builtFlashback.choicePages1,
            [phase2To3TransitionPageRookie]
        );
        /*visitingAnyUnlocks(
            builtFlashback.choicePages2,
            [phase2To3TransitionPageRookie]
        )*/
    });

    //==========================
    //PHASE 3
    //==========================

    let addExplicitAwarenessToPage = (page) => {
        page.content = `
            <span style="color: #0685b3;">The other player made this decision.</span>
            <br/><br/>
            ${page.content}
        `;
        return page;
    }

    let phase3FlashbackNames = ["Corporate Espionage", /*"Megachurch Extortion", "Kidnapping",*/ "Meeting the Boss"];
        let phase3Flashbacks = phase3FlashbackNames.map(name => nodesToFlashback(nodeGroups.get(name)));
    let phase3MentorFlashbacks = phase3Flashbacks.filter(flashback => flashback.choosingCharacter == "Mentor");
    let phase3RookieFlashbacks = phase3Flashbacks.filter(flashback => flashback.choosingCharacter == "Rookie");

    let phase3MentorBuiltFlashbacks: BuiltFlashback[] = phase3MentorFlashbacks.map(flashback => flashback.buildPages(story.roles));
    let phase3RookieBuiltFlashbacks: BuiltFlashback[] = phase3RookieFlashbacks.map(flashback => flashback.buildPages(story.roles));

    let phase3MentorFlashbackPages: Page[] = phase3MentorBuiltFlashbacks.reduce((allPages, flashback) =>
        allPages.concat(listBuiltFlashbackPages(flashback)), []);
    let phase3RookieFlashbackPages: Page[] = phase3RookieBuiltFlashbacks.reduce((allPages, flashback) =>
        allPages.concat(listBuiltFlashbackPages(flashback)), []);

    let phase3Mentor = createChunk({name: "Mentor Phase Three", startsLocked: true, pages: phase3MentorFlashbackPages});
    story.pages.push(...phase3MentorFlashbackPages);

    let phase3Rookie = createChunk({name: "Rookie Phase Three", startsLocked: true, pages: phase3RookieFlashbackPages});
    story.pages.push(...phase3RookieFlashbackPages);

    phase3MentorBuiltFlashbacks.concat(phase3RookieBuiltFlashbacks).forEach(flashback => {
       addExplicitAwarenessToPage(flashback.prepPage2);
       flashback.choicePages2.forEach(addExplicitAwarenessToPage);
    });

    phase2To3TransitionPageMentor.functions.push(phase3Mentor.unlockFunction);
    phase2To3TransitionPageRookie.functions.push(phase3Rookie.unlockFunction);

    let phase3To4TransitionPageMentor = story.NewPage({
        name: "Act Two - Scene Three",
        singleVisit: true,
        hint: new PageHint("The last straw."),
        content: transition_nodes.sarah4,
        conditions: [mentorRole.getIsRoleCondition()]
    });

    let phase3To4TransitionPageRookie = story.NewPage({
        name: "Act Two - Scene Three",
        singleVisit: true,
        hint: new PageHint("The last straw."),
        content: transition_nodes.todd3,
        conditions: [rookieRole.getIsRoleCondition()]
    });

    let phase3AllBuiltFlashbacks = phase3MentorBuiltFlashbacks.concat(phase3RookieBuiltFlashbacks);

    phase3MentorBuiltFlashbacks.forEach(builtFlashback => {
        visitingAnyUnlocks(
            builtFlashback.choicePages1,
            [phase3To4TransitionPageMentor]
        );
        /*visitingAnyUnlocks(
            builtFlashback.choicePages2,
            [phase3To4TransitionPageMentor]
        )*/
    });

    phase3RookieBuiltFlashbacks.forEach(builtFlashback => {
        visitingAnyUnlocks(
            builtFlashback.choicePages1,
            [phase3To4TransitionPageRookie]
        );
        /*visitingAnyUnlocks(
            builtFlashback.choicePages2,
            [phase3To4TransitionPageRookie]
        )*/
    });

    //==========================
    //PHASE 4
    //==========================

    let phase4FlashbackNames = ["The Trashed Apartment", "Post-Heist"];
        let phase4Flashbacks = phase4FlashbackNames.map(name => nodesToFlashback(nodeGroups.get(name)));
    let phase4MentorFlashbacks = phase4Flashbacks.filter(flashback => flashback.choosingCharacter == "Mentor");
    let phase4RookieFlashbacks = phase4Flashbacks.filter(flashback => flashback.choosingCharacter == "Rookie");

    let phase4MentorBuiltFlashbacks: BuiltFlashback[] = phase4MentorFlashbacks.map(flashback => flashback.buildPages(story.roles));
    let phase4RookieBuiltFlashbacks: BuiltFlashback[] = phase4RookieFlashbacks.map(flashback => flashback.buildPages(story.roles));

    let phase4MentorFlashbackPages: Page[] = phase4MentorBuiltFlashbacks.reduce((allPages, flashback) =>
        allPages.concat(listBuiltFlashbackPages(flashback)), []);
    let phase4RookieFlashbackPages: Page[] = phase4RookieBuiltFlashbacks.reduce((allPages, flashback) =>
        allPages.concat(listBuiltFlashbackPages(flashback)), []);

    let phase4Mentor = createChunk({name: "Mentor Phase Four", startsLocked: true, pages: phase4MentorFlashbackPages});
    story.pages.push(...phase4MentorFlashbackPages);

    let phase4Rookie = createChunk({name: "Rookie Phase Four", startsLocked: true, pages: phase4RookieFlashbackPages});
    story.pages.push(...phase4RookieFlashbackPages);


    phase4MentorBuiltFlashbacks.concat(phase4RookieBuiltFlashbacks).forEach(flashback => {
        addExplicitAwarenessToPage(flashback.prepPage2);
        flashback.choicePages2.forEach(addExplicitAwarenessToPage);

        let isMentor = flashback.choosingCharacter == "Mentor";

        flashback.choicePages2.forEach(readOnlyChoicePage => {
            let readPage = story.NewPage({
                name: `The other player has read a page`,
                content: `The other player has read the page \"${readOnlyChoicePage.name}\"`,
                hint: new PageHint(`\"${readOnlyChoicePage.name}\"`),
                singleVisit: true,
                conditions: [isMentor? mentorRole.getIsRoleCondition() : rookieRole.getIsRoleCondition()]
            });

            unlocks([readOnlyChoicePage], [readPage]);
        });

    });

    phase3To4TransitionPageMentor.functions.push(phase4Mentor.unlockFunction);
    phase3To4TransitionPageRookie.functions.push(phase4Rookie.unlockFunction);

    let phase4ToFinaleTransitionPageMentor = story.NewPage({
        name: "Act 3",
        singleVisit: true,
        hint: new PageHint("One last job."),
        content: transition_nodes.sarah5,
        conditions: [mentorRole.getIsRoleCondition()],
        functions: [progressStoryFunction]
    });

    let phase4ToFinaleTransitionPageRookie = story.NewPage({
        name: "Act 3",
        singleVisit: true,
        hint: new PageHint("One last job."),
        content: transition_nodes.todd4,
        conditions: [rookieRole.getIsRoleCondition()],
        functions: [progressStoryFunction]
    });

    let phase4AllBuiltFlashbacks = phase4MentorBuiltFlashbacks.concat(phase4RookieBuiltFlashbacks);

    phase4AllBuiltFlashbacks.forEach(builtFlashback => {
        visitingAnyUnlocks(
            builtFlashback.choicePages1,
            [phase4ToFinaleTransitionPageMentor]
        );
        visitingAnyUnlocks(
            builtFlashback.choicePages2,
            [phase4ToFinaleTransitionPageMentor]
        )
    });

    phase4AllBuiltFlashbacks.forEach(builtFlashback => {
        visitingAnyUnlocks(
            builtFlashback.choicePages1,
            [phase4ToFinaleTransitionPageRookie]
        );
        visitingAnyUnlocks(
            builtFlashback.choicePages2,
            [phase4ToFinaleTransitionPageRookie]
        )
    });
}