import {VariableReference} from "storyplacesauthoringlib/lib/models/VariableReference";
import {StoryFunctionSet} from "storyplacesauthoringlib/lib/models/StoryFunction";
import {
    StoryConditionCheck, StoryConditionComparison,
    StoryConditionLogical
} from "storyplacesauthoringlib/lib/models/StoryCondition";
import {ComparisonOperand, ComparisonType} from "storyplacesauthoringlib/lib/schemas/multiplayer/ConditionSchema";

let uniqueCounter = 0;

export class ExtendedVariableReference extends VariableReference {
    static FromVariableReference(ref: VariableReference) {
        return new ExtendedVariableReference(ref.scope, ref.namespace, ref.variable);
    }

    toString(): string {
        return this.scope + "->" + this.namespace + "->" + this.variable;
    }

    createSetFunction(value: string): StoryFunctionSet {
        return new StoryFunctionSet(
            "Set" + this + "To" + value + uniqueCounter++,
            this,
            value
        )
    }

    createComparisonCondition(operand: ComparisonOperand, value: string | VariableReference) {
        return new StoryConditionComparison(
            "Does" + this + operand.toString() + value + uniqueCounter++,
            operand,
            this,
            value,
            ComparisonType.Variable,
            typeof(value) == "string" ? ComparisonType.String : ComparisonType.Variable
        );
    }

    createCheckCondition() {
        return new StoryConditionCheck(
            "Check" + this + uniqueCounter++,
            this
        );
    }
}