import {PublishState} from "storyplacesauthoringlib/lib/schemas/multiplayer/PublishState";
import {Audience} from "storyplacesauthoringlib/lib/schemas/multiplayer/AudienceSchema";
import {MultiplayerBuilder} from "storyplacesauthoringlib/lib/builders/Multiplayer";
import {ExtendedStory} from "./extendedstory";
import {addFinaleToStory} from "./finale";
import {createChunk} from "./chunk";
import {addContentToStory} from "./content";
import {addRoleSelectionToStory} from "./addRoleSelection";

function main() {
    let story = new ExtendedStory("The MultiHeist Experiment");
    story.author = "Brian de Lint, Amanda Moss and Callum Spawforth";
    story.schemaVersion = "";
    story.publishDate = "2019/09/23";
    story.publishState = PublishState.published;
    story.audience = Audience.general;

    let finaleChunk = createChunk({
        name: "Finale",
        startsLocked: true
    });

    addRoleSelectionToStory(story);
    addContentToStory(story, finaleChunk.unlockFunction);
    addFinaleToStory(story, finaleChunk);

    let builder = new MultiplayerBuilder();
    let builtStory = builder.build(story);
    console.log(JSON.stringify(builtStory,null, 2));
}


main();