

// Program : 1D_efd_PS.cpp
//
// A program to simulate the dimensionless concentration profile
// and calculate dimensionless tip current at a macroelectrode.
//
// The simulation uses the Explicit Finite Difference method 
// and a one dimensional simulation domain and stops at T=1

// Last Update: 15 January 2000

#include <iostream.h>
#include <math.h>
#include <fstream.h>

#define XLIM 10.0
#define MAX_ARRAY 2000

ofstream outfile;

int main(void)
{
	int klim, ilim;				// number of steps in time and distance
	double delta_t, delta_x;	// size of time, space step
	double lamda;				// simulation parameter defined by (dT/dX*dX)

	double *pnew, *pold;		// pointers to new and old concentration arrays
	double cr1[MAX_ARRAY]; 		// concentration array 1
	double cr2[MAX_ARRAY]; 		// concentration array 2

	char banana[50];

	int i, j;					// integer counters for space, time

	// ask the user for input
	cout << "Please Input.. " << endl << " numt: ";
	cin >> klim;
	cout << " lamda: ";
	cin >> lamda;

	cout << endl <<  "Processing .." << endl;

	// calculate simulation parameters
	delta_t = 1.0 / (double)klim;
	delta_x = sqrt(delta_t/lamda);
	ilim = (int)(XLIM / delta_x); 

	// delete this
	outfile.open("current.dat");

	// assign the concentration array pointers
	pnew = cr2; pold = cr1;

	// initial boundary condition (T=0)
	for (i=0; i<=ilim; i++) pold[i] = 1.0;
	
	// simulation loop
	for (j=1; j<=klim ; j++)
	{
		// apply electrode boundary condition (X=0)
		pnew[0] = 0.0;
		// apply outer edge boundary condition (X=Xlim)
		pnew[ilim] = 1.0;

		// calculate the rest of concentrations within domain
		for (i=1; i<=(ilim-1); i++)
		{
			pnew[i] = (lamda*pold[i+1]) + ((1.0-(2.0*lamda))*pold[i]) + (lamda*pold[i-1]);
		}

		// swap the old and new concentration arrays
		if ((j%2)!=0) { pnew = cr1; pold = cr2; }
		else { pnew = cr2; pold = cr1; }

		outfile <<(double)j*delta_t << "\t" << (pold[1] - pold[0])/delta_x << endl;

	}

	// print dimensionless tip current and exit
	cout << " Dimensionless Tip Current at T=0 : " << (pold[1] - pold[0])/delta_x
		<< endl << " Bye! " << endl;

	outfile.close();

	return 1;

}

