

/* conc2.c - The Flux Line Generator 

   A Program to turn concentration maps into a list of xy points for contours
   readable by most graphics packages                          
   
   Designed for glass edge simulations
   
   J.L.Amphlett 1997

*/

/* Last Updated : Wednesday 12-11-1997 */


#include <stdio.h>
#include <math.h>

#define maxnumx 1000
#define maxnumy 1000
#define divpc 20
#define pi 3.14159265

/* -- PROTOTYPES -- */

void main(void);
int findx(double rvalue);
int findy(double zvalue);

/*  -- GLOBALS --   */

char *version[] = {"CONC-ge v1.2"};
double delta = 0.1;
double nograd = 0.00001;

double posx[maxnumx+2],testx;
double posy[maxnumy+1],testy;
double co[maxnumx][maxnumy],testc;
double seedposx[divpc+1];
double seedposy[divpc+1];

/* ---------------- */
/* - MAIN PROGRAM - */
/* ---------------- */

void main(void)

{

	char filein[20], fileout[20];
	double maxz,nsum,dlctip,testcur,oldtestcur,e_t,lookfor,tempfloat;
	double tval,uval,r1,r2,z1,z2,dt,du,rx,zx,norm,olddt,olddu,r21,z21;
	double alpha1,beta1,gamma1,delta1,coxy,xpro,ypro;
	FILE *fi, *fo;
	int i,j,numxtot,numytot,numd,numdepth,numg,ival,jval,counter;

	start:

	printf("\n\nConc Contour Line Generator \n");
	printf("For GLASS EDGE SIMULATIONS\n");
	printf("version %s\n", *(version));
	printf("*****************\n\n");

	printf("Input .smap Filename  : ");
	scanf(" %s", &filein);

	printf("\nInput Output Filename : ");
	scanf(" %s", &fileout);

	fi = fopen(filein,"r");
	fo = fopen(fileout,"wt");

	if ((fi==NULL)||(fo==NULL))
    {
		printf("\n***ERROR\nCannot Open Datafiles\nTry Again\n***\n");
		goto start;
    }

	/* Input grid parameters from input file */

	fscanf(fi,"%lf\n%d\n%d\n%d\n%d\n%d\n",&tempfloat,&numxtot,&numytot,&numd,&numdepth,&numg);

	for (j=0; j<= numytot; j++)
    {
		for (i=0; i<= numxtot+1 ; i++)
        {
			fscanf(fi,"%lf %lf %lf\n",&posx[i],&posy[j],&co[i][j]);
        }
    }

	printf("File Opened And Read\n");

	lookfor = (1.0-(1.0/((double)divpc)));
	counter=1;
	
	/* Find Starting Positions */

	j = numytot;
	for (i = numxtot+1; i>=0 ; i--)
	{
		lookagainhere:
		
		if (co[i][j] <= lookfor)
        {
			e_t = (lookfor - co[i][j]) / (co[i+1][j] - co[i][j]);
			seedposx[counter] = (e_t * (posx[i+1] - posx[i])) + posx[i]; 
			seedposy[counter] = posy[numytot];
			counter = counter + 1;
			lookfor = lookfor - (1.0/((double)divpc));
			goto lookagainhere;
        }
          
    }
     
	i = 0;
	for (j = numytot; j>=numdepth ; j--)
    {
     
		lookagainhere2:
		if (co[i][j] <= lookfor)
        {
			e_t = (lookfor - co[i][j]) / (co[i][j+1] - co[i][j]);
			seedposx[counter] = 0.0;
			seedposy[counter] = (e_t * (posy[j+1] - posy[j])) + posy[j];
			counter = counter + 1;
			lookfor = lookfor - (1.0/((double)divpc));
			goto lookagainhere2;
        }        
    }

	printf("\nSeed Calculation Done!\n");

	olddt = 1.0;
	olddu = 1.0;

	for (i = divpc-1; i>= 1 ; i--)
	{
		printf("Firing Seed %d at R = %lf and Z = %lf\n",i, seedposx[i], seedposy[i]);
		rx = seedposx[i];
		zx = seedposy[i];
		fprintf(fo,"%lf \t %lf\n",rx,zx);
     
		while ((rx < posx[numxtot+1])&&(zx <= posy[numytot]))
		{
			/* where am I??? */
			ival = findx(rx);
			jval = findy(zx);
          
			findpoints:
          
			r1 = posx[ival];
			r2 = posx[ival+1];
			z1 = posy[jval];
			z2 = posy[jval+1];
          
			r21 = r2 - r1;
			z21 = z2 - z1;

			/* BILINEAR INTERPOLATION METHOD */
			/* getting t and u values  */
			tval = (rx - r1) / r21;
			uval = (zx - z1) / z21;
          
			/* are we going to hit the glass area ? */
			if (co[ival-1][jval-1]<0) { goto run_away; }           
          
			/* calculating dt and du and length */
          
			/*original idea*/
          
			dt = (((uval-1.0)*co[ival][jval]) + ((1.0-uval)*co[ival+1][jval]) 
				- (uval*co[ival][jval+1]) + (uval*co[ival+1][jval+1]))/r21;
			du = (((tval-1.0)*co[ival][jval]) + ((1.0-tval)*co[ival][jval+1]) 
				- (tval*co[ival+1][jval]) + (tval*co[ival+1][jval+1]))/z21;
          
			/* Taylor Expansion */
			/*delta1 = co[ival][jval];
			alpha1 = (co[ival+1][jval] - co[ival][jval]);
			beta1 = (co[ival][jval+1] - co[ival][jval]);
			gamma1 = (co[ival+1][jval+1] - co[ival][jval] - (beta1) - (alpha1));
          
			dt = alpha1 + (gamma1*uval);
			du = beta1 + (gamma1*tval); */
          
			/* Minimal Concentration Flux method */
          
			/*if ((uval==0.0)&&(jval!=0)) {jval = jval-1; uval = 1.0; goto findpoints;}
          
			delta1 = co[ival][jval];
			alpha1 = (co[ival+1][jval] - co[ival][jval]);
			beta1 = (co[ival][jval+1] - co[ival][jval]);
			gamma1 = (co[ival+1][jval+1] - co[ival][jval] - (beta1) - (alpha1));
			coxy = delta1 + (gamma1*uval*tval) + (beta1*uval) + (alpha1*tval);
          
			if ((jval==0)&&(co[ival][jval]==co[ival+1][jval])) {dt = 0; du = 1;}
			else 
			{
				if (co[ival+1][jval] > coxy) {xpro=(coxy-delta1)/alpha1; ypro = 0.0;}
				if (co[ival+1][jval] < coxy) {xpro = 1.0; ypro= ((coxy - delta1 - alpha1)/(gamma1 + beta1));}
				if (co[ival+1][jval] == coxy) {xpro = 1.0; ypro = 0.0; }
               
				dt = uval - ypro; 
				du = xpro - tval;
          
			} */
          
 
          
			/*End of dy and dt Ideas */
            
			norm = sqrt((du*du)+(dt*dt));
          
			if (norm < nograd) {dt = olddt; du = olddu;} 
           
			delta = sqrt(((r2-r1)*(r1-r1))+((z2-z1)*(z2-z1))); 
                           
			/* calculating movement in rx and ry*/
			// if ((rx + (delta * du / norm))<rx) { goto run_away; }

			rx = rx + (delta * du / norm);
			zx = zx - (delta * dt / norm);

			if ((rx < 0)||(zx < 0.0)) { goto run_away; }
          
			fprintf(fo,"%lf \t %lf\n",rx,zx);
          
			olddu = du;
			olddt = dt;
		} 
                   
		run_away:
		printf("next one\n");
		fprintf(fo,"\n\n\n");
     }

	fclose(fi);
	fclose(fo);

}

int findx(double rvalue)
{
	/* find enclosing i point */

	int i;
     
    i = 0;
    while (posx[i] <= rvalue)
    {
		i = i+1;
    }
     
    return i-1;
}

int findy(double zvalue)
{
	/* find enclosing j point */

	int j;
     
    j = 0;
    while (posy[j] < zvalue)
    {
		j = j+1;
    }
     
    return j-1;
}















