

/* flux2.c - The Flux Line Generator 

   A Program to turn concentration profilesinto a list of flux xy points
   readable by most graphics packages                          
   
   Designed to work on GLASS - EDGE Simulations
   
   J.L.Amphlett 1997

*/

/* Last Updated : Wednesday 12-11-1997 */


#include <stdio.h>
#include <math.h>

#define maxnumx 1000
#define maxnumy 1000
#define divpc 10
#define pi 3.14159265

/* -- PROTOTYPES -- */

void main(void);
int findx(double rvalue);
int findy(double zvalue);

/*  -- GLOBALS --   */

char *version[] = {"FLUX-ge v1.9"};
double delta = 0.1;
double nograd = 0.00001;

double posx[maxnumx+2],testx;
double posy[maxnumy+1],testy;
double co[maxnumx][maxnumy],testc;
double seedpos[divpc+2];

/* ---------------- */
/* - MAIN PROGRAM - */
/* ---------------- */

void main(void)

{

	char filein[20], fileout[20];
	double maxz,nsum,dlctip,testcur,oldtestcur,e_t,lookfor,tempfloat;
	double tval,uval,r1,r2,z1,z2,dt,du,rx,zx,norm,olddt,olddu,r21,z21;
	double alpha1,beta1,gamma1,delta1,coxy,xpro,ypro;
	FILE *fi, *fo;
	int i,j,numxtot,numytot,numd,numdepth,numg,ival,jval,counter;
	int ij;

	start:

	printf("\n\nFlux Line Generator \n");
	printf("version %s\n", *(version));
	printf("*****************\n\n");

	printf("Input Filename  : ");
	scanf(" %s", &filein);

	printf("\nOutput Filename : ");
	scanf(" %s", &fileout);

	fi = fopen(filein,"r");
	fo = fopen(fileout,"wt");

	if ((fi==NULL)||(fo==NULL))
    {
		printf("\n***ERROR\nCannot Open Datafiles\nTry Again\n***\n");
		goto start;
    }

	/* Read the grid parameters from the start of the datafile */

	fscanf(fi,"%d\n%d\n%d\n%d\n%d\n",&numxtot,&numytot,&numd,&numdepth,&numg);

	/* Store The Concentration Grid In Memory */
	
	for (j=0; j<= numytot; j++)
    {
		for (i=0; i<= numxtot+1 ; i++)
        {
			fscanf(fi,"%lf %lf %lf\n",&posx[i],&posy[j],&co[i][j]);
        }
    }

	printf("File Opened And Read\n");

	/* Calculate Tip Current */

	nsum = 0.0;
	for (i = 1; i<=numd ; i++)
    {
		nsum = nsum + posx[i]*(posx[i]-posx[i-1])*(co[i][numdepth+1]-co[i][numdepth]);
	}

	dlctip = pi * nsum / (2.0 * (posy[numdepth+1]-posy[numdepth]));

	nsum = 0.0;
	oldtestcur = 0.0;

	/* Find divpc number of points along electrode */
	
	lookfor = dlctip / (double) divpc;
	counter = 1;

	for (i = 1; i<=numd ; i++)
    {
		nsum = nsum + posx[i]*(posx[i]-posx[i-1])*(co[i][numdepth+1]-co[i][numdepth]);
		testcur = pi * nsum / (2.0 * (posy[numdepth+1]-posy[numdepth]));
     
		lookagainhere:
		if (testcur >= ((double)counter * lookfor))
		{
			e_t = (((double)counter*lookfor) - oldtestcur) / (testcur - oldtestcur);
			seedpos[counter] = (e_t * (posx[i] - posx[i-1])) + posx[i-1]; 
			counter = counter + 1;
			goto lookagainhere;
         }
	oldtestcur = testcur;          
    }


	printf("\nDatafile Info: \n");
	printf("numxtot = %d numytot = %d numd = %d\n",numxtot,numytot,numd);
	printf("numg = %d numdepth = %d dlctip=%lf\n",numg,numdepth,dlctip);

	olddt = 1.0;
	olddu = 1.0;

	ij = 0;

	for (i = 1; i<= divpc-1 ; i++)
    {
		printf("Firing Seed %d at R = %lf\n ",i, seedpos[i]);
		rx = seedpos[i];
		zx = posy[numdepth];
		fprintf(fo,"\n\n\n");     
		fprintf(fo,"%lf \t %lf\n",rx,zx);
     
		ij = 0;
		
		while (((rx < posx[numxtot+1]) && (zx < posy[numytot]))&&(j<1000))
		{
			/* where am I??? */
			ival = findx(rx);
			jval = findy(zx);
          
			findpoints:
          
			r1 = posx[ival];
			r2 = posx[ival+1];
			z1 = posy[jval];
			z2 = posy[jval+1];
          
			r21 = r2 - r1;
			z21 = z2 - z1;
		
			/* ALL THREE METHODS ARE PRESENTED - COMMENT THE DESIRED METHOD IN */

			/* Bilinear Interpolation Method */
			/* getting t and u values  */
			tval = (rx - r1) / r21;
			uval = (zx - z1) / z21;
          
			/* calculating dt and du and length */
          
			/*original idea*/
          
			dt = (((uval-1.0)*co[ival][jval]) + ((1.0-uval)*co[ival+1][jval]) 
				- (uval*co[ival][jval+1]) + (uval*co[ival+1][jval+1]))/r21;
			du = (((tval-1.0)*co[ival][jval]) + ((1.0-tval)*co[ival][jval+1]) 
				- (tval*co[ival+1][jval]) + (tval*co[ival+1][jval+1]))/z21;
          
			/* Taylor Expansion Method */
			/*delta1 = co[ival][jval];
			alpha1 = (co[ival+1][jval] - co[ival][jval]);
			beta1 = (co[ival][jval+1] - co[ival][jval]);
			gamma1 = (co[ival+1][jval+1] - co[ival][jval] - (beta1) - (alpha1));
          
			dt = alpha1 + (gamma1*uval);
			du = beta1 + (gamma1*tval); */
          
			/* Minimal Concentration Flux method */
          
			/*if ((uval==0.0)&&(jval!=0)) {jval = jval-1; uval = 1.0; goto findpoints;}
          
			delta1 = co[ival][jval];
			alpha1 = (co[ival+1][jval] - co[ival][jval]);
			beta1 = (co[ival][jval+1] - co[ival][jval]);
			gamma1 = (co[ival+1][jval+1] - co[ival][jval] - (beta1) - (alpha1));
			coxy = delta1 + (gamma1*uval*tval) + (beta1*uval) + (alpha1*tval);
          
			if ((jval==0)&&(co[ival][jval]==co[ival+1][jval])) {dt = 0; du = 1;}
			else 
			{
				if (co[ival+1][jval] > coxy) {xpro=(coxy-delta1)/alpha1; ypro = 0.0;}
				if (co[ival+1][jval] < coxy) {xpro = 1.0; ypro= ((coxy - delta1 - alpha1)/(gamma1 + beta1));}
				if (co[ival+1][jval] == coxy) {xpro = 1.0; ypro = 0.0; }
               
				dt = uval - ypro; 
				du = xpro - tval;
          
			} */
          
   
			/*End of dy and dt Ideas */
            
			norm = sqrt((du*du)+(dt*dt));
          
			if (norm < nograd) {dt = olddt; du = olddu;} 
           
			delta = sqrt(((r2-r1)*(r1-r1))+((z2-z1)*(z2-z1))); 
                           
			/* calculating movement in rx and ry*/
		  
			rx = rx + (delta * dt / norm);
			zx = zx + (delta * du / norm);
          
			if ((rx<0)||(zx<0)) { goto run_away; }

			if ((rx < posx[numxtot+1]) && (zx < posy[numytot])) { fprintf(fo,"%lf \t %lf\n",rx,zx); }
          
			olddu = du;
			olddt = dt;
			ij++;
		}

		run_away:
		printf("\nNext Line\n\n");
	}

	fclose(fi);
	fclose(fo);

}

int findx(double rvalue)
{
	/* Find the i positions surrounding new starting point */
	
	int i;
     
	i = 0;
	while (posx[i] <= rvalue)
    {
		i = i+1;
    }
     
    return i-1;
}

int findy(double zvalue)
{
	/* Find the j positions surrounding new starting point */

	int j;
     
	j = 0;
	while (posy[j] <= zvalue)
	{
		j = j+1;
	}
     
	return j-1;
}










