

/* 2d_micro_scanEFD.c
              a two dimensional simulation of a line microelectrode
              passing two conducting strips embedded in an insulating
              substrate. This simulation will be able to determine
              qualitatively how the resolution of the SECM changes
              with RG and tip - substrate distance */
              
/* lamda should be fixed to 0.25 */
              
/* last update : 29 May 1998 */

/* version 2.0.01 */

#include <stdio.h>
#include <math.h>
#define glassflag -1
#define electrodeflag -2

#define xbound 600
#define ybound 300
#define ktmax 5000

int discradiuspoints = 20;
int island_length = 10;
int island_gap = 80;
double lamda = 0.25;
char concfile[]= "adis1.smap";

double rgvalue,da;
FILE *mapout,*elecflux;

double co[xbound+1][ybound+1];
double conw[xbound+1][ybound+1];

main()
{

int glass1x, glass2x, glassy, elec1x, elec2x, island1x, island2x, island3x, island4x;
int kt,i,j,mapcounter;
int ytop;
char filesmap[20];
double dx,dt,sum;

printf("\n2D Simulation Of Line Scan\n\n");
starthere:
printf("Input Rglass  : ");
scanf("%lf", &rgvalue);
printf("Input Zsub    : ");
scanf("%lf", &da);

/* opening data file */
elecflux = fopen("current.dat","wt");

mapcounter = 0;

/* calculating boundary points in array */

elec1x = (int)(xbound/2)-discradiuspoints;
elec2x = (int)(xbound/2)+discradiuspoints;
glass1x = (int)(xbound/2)-(int)(rgvalue*(double)discradiuspoints);
glass2x = (int)(xbound/2)+(int)(rgvalue*(double)discradiuspoints);
glassy = (int)(discradiuspoints*da);

if ((elec1x<=0)||(glass1x<0)||(glassy>ybound)||(glassy<1)) 
            { printf("\n\nERROR!\ntry again\n\n"); goto starthere; }

printf("\nelec1x:%d elec2x:%d glass1x:%d glass2x:%d glassy: %d\n",elec1x,elec2x,glass1x,glass2x,glassy);

dx = 1.0/(double)discradiuspoints;
dt = lamda*dx*dx;

/*initialise arrays*/
for (i=0; i<=xbound; i++)
{ 
     for (j=0; j<=ybound; j++)
     { 
          if (j>glassy) 
          {
               if (i<=glass1x) { conw[i][j] = 1.0; } 
               if ((i>glass1x)&&(i<elec1x)) { conw[i][j] = glassflag; } 
               if ((i>=elec1x)&&(i<=elec2x)) { conw[i][j] = electrodeflag; }
               if ((i>elec2x)&&(i<glass2x)) { conw[i][j] = glassflag; }
               if (i>=glass2x) { conw[i][j] = 1.0; }
          }
          else { conw[i][j] = 1.0; }
     }
}

/* calculate initial position of island */
island1x = xbound - (2*island_length) - island_gap;
island2x = island1x + island_length;
island3x = island2x + island_gap;
island4x = xbound;

startthetime:

printf("\ni1x:%d i2x:%d i3x:%d i4x:%d dt:%lf dx:%lf\n\n",island1x,island2x,island3x,island4x,dt,dx);

/* time loop */
for (kt=1; kt<=ktmax; kt++)
{

/*update concs */
for (i = 0; i<=xbound; i++)
{
if ((i>glass1x)&&(i<glass2x)) {ytop = glassy; } else {ytop = ybound; }
     for (j=0; j<=ytop; j++)
     {
     co[i][j] = conw[i][j];
     }
}

/* set boundary conditions */
j = 0; for (i=0; i<island1x; i++) { conw[i][j] = co[i][j+1]; }
for (i=island1x; i<=island2x; i++) { conw[i][j] = 1.0; }
for (i=island2x+1; i<island3x; i++) { conw[i][j] = co[i][j+1]; }
for (i=island3x; i<=island4x; i++) { conw[i][j] = 1.0; }
if (island4x!=xbound) { for (i=island4x+1;i<=xbound;i++) { conw[i][j] = co[i][j+1]; } }
i=0; for (j=0;j<=ybound;j++) { conw[i][j] = 1.0; }
j=ybound; for (i=1; i<=glass1x-1; i++) { conw[i][j] = 1.0; }
i=glass1x; for (j=ybound; j>=glassy+1; j--) { conw[i][j] = co[i-1][j]; }

i=glass1x; j = glassy;
conw[i][j] = (0.25*(co[i-1][j]+co[i+1][j]+co[i][j-1]+co[i][j+1]));
i=glass2x;
conw[i][j]= (0.25*(co[i-1][j]+co[i+1][j]+co[i][j-1]+co[i][j+1])); 

j=glassy; for (i=glass1x+1; i<elec1x; i++) { conw[i][j] = co[i][j-1]; }
for (i=elec1x; i<= elec2x; i++) { conw[i][j] = 0.0; }
for (i=elec2x+1; i<glass2x; i++) { conw[i][j] = co[i][j-1]; }
i=glass2x; for (j= glassy+1; j<=ybound ; j++) { conw[i][j] = co[i+1][j]; }
j = ybound; for (i=glass2x+1; i<= xbound-1; i++) { conw[i][j] = 1.0; }
i = xbound; for (j=1; j<=ybound; j++) { conw[i][j] = 1.0; }

/*diffusion here*/
for (i=1; i<=xbound-1 ; i++)
{
if ((i>=glass1x)&&(i<=glass2x)) { ytop = glassy-1; } else { ytop = ybound-1; }
     for (j=1; j<=ytop; j++)
     {
     conw[i][j] = 0.25*(co[i-1][j]+co[i+1][j]+co[i][j-1]+co[i][j+1]);
     }
}

if (kt==ktmax)
{
/*tip flux calcs from conw*/
j=glassy;
sum = 0.0;
for (i=elec1x; i<=elec2x; i++)
{
if (i!=(int)(xbound/2)) 
{
sum = sum + conw[i][j-1];
}
}
fprintf(elecflux," %lf %lf \n",kt*dt,sum);
} /* if kt mod xxx then print */

} /*time loop closure*/

/* output map */
if ((mapcounter%60)==0)
{
concfile[4] = (char)((mapcounter/60)+65);
mapout=fopen(concfile,"wt");
for (j=0; j<=ybound; j++)
     {
     for (i=0; i<=xbound; i++)
          {
          fprintf(mapout,"%lf\n",conw[i][j]);
          }
     }
fclose(mapout);
}

if (island1x>0)
   {
   mapcounter = mapcounter+1;
   island1x = island1x-1;
   island2x = island2x-1;
   island3x = island3x-1;
   island4x = island4x-1;
   goto startthetime; 
   }

/*close current output*/
fclose(elecflux);

}








