function dp = mafc_dprime(resp,gt)

    % % % % % % % % % % % %         INPUT       % % % % % % % % % % % %
    
    % resp = column vector containing human responses
    % gt = column vector containing ground-truth labels
    % ncats = scalar representing number of categories in the ground-truth
    
    % % % % % % % % % % % %         OUTPUT       % % % % % % % % % % % %
    
    % dp = estimate of d-prime
    
    % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % 
    
    % find hit and false alarm rate per category
    hittemp = 0;
    fatemp = 0;
    n = length(resp);
    cats = unique(gt); 
    nc = length(cats);
    
    for i = 1:nc
        targ = cats(i);
        
        % number of hits
        nh = sum(resp == targ & gt == targ);
        
        % number of i responses
        nht = sum(resp == targ);
        
        % number of false alarms
        nfa = sum(resp == targ & gt ~= targ);
        
        % number of not-i responses
        nfat = sum(resp ~= targ);
        
        % add a trial to each quadrant if we get a 0 (can't calculate dp)
        if ismember(0,[nh,nht,nfa,nfat])
            nh = nh+1;
            nht = nht+2;
            nfa = nfa+1;
            nfat = nfat+2;
        end
        
        % category-specific hit rate
        hittemp = hittemp + (nht/n)*(nh/nht);
        
        % category-specific false-alarm rate
        fatemp = fatemp + ((nfat/n)*(nfa/nfat))/(nc-1);
        
    end
    
    % calculate d-prime in the standard way
    dp = norminv(hittemp)-norminv(fatemp);
            
end