%% plot raw data with moving mean

colormap hot;
cmap=colormap;
figure('position',[100,100,1100,400])
velocity = (5:2.5:25);
for fl = 1:3
    subplot(1,3,fl)
    hold on
    set(gca,'FontSize',14)
 
    for j = 1:9
        angle = angle_set(j,fl,:);
        cl = cl_raw(j,fl,:);
        % original raw data
        Plot_color=cmap(j*5,:);
        h = scatter(angle,cl,25,'filled','DisplayName',num2str(velocity(j)),...
            'MarkerEdgeColor',Plot_color,'MarkerFaceColor',Plot_color);
        h.Annotation.LegendInformation.IconDisplayStyle = 'off';  
        % moving average of 2 
        angle_avg = reshape(angle_mvm(j,fl,:),[24,1]);
        cl_avg = reshape(cl_mvm(j,fl,:),[24,1]);
        plot(angle_avg,cl_avg,'--o','DisplayName',num2str(velocity(j)),...
            'Color', Plot_color);
    end

    xlim([11 18])
    ylim([0.3 1.1])
    pbaspect([4 4 1])
    xlabel('set \alpha [\circ]');
    ylabel('C_L');
    title_str = sprintf('flap angle = %d^\\circ', (fl*5-5));
    title(title_str);
    if fl>1
        h = gca;
        h.YAxis.Visible = 'off';
    end
    
    if fl==3
        lgd = legend({'1.0','1.5','2.1','2.6','3.1','3.6','4.1','4.6','5.1'},...
            'Location','NorthWest','NumColumns',1);
        title(lgd,'Re \cdot 10^5')
        newPosition = [0.95 0.55 0.0 0.0];
        newUnits = 'normalized';
        set(lgd,'Position', newPosition,'Units', newUnits);
    end
end

ha=get(gcf,'children');
set(ha(1),'position',[.93 .53 .0 .0]);
set(ha(2),'position',[.45  .175 .60 .70]);
set(ha(3),'position',[.175 .175 .60 .70]);
set(ha(4),'position',[-0.1 .175 .60 .70]);

clearvars fl j angle cl h angle_avg cl_avg a ha title_str lgd newPosition newUnits Plot_color cmap

%% plot first stall cell occurence AR 2.6

alpha0 = [13.52,14.53,15.01,15.55,16.04,16.04,16.07,15.65,15.73];
alpha5 = [12.52,13.52,13.98,14.00,13.61,14.03,14.92,14.90,14.89];
alpha10= [12.50,13.47,13.43,13.92,14.35,14.30,14.27,14.18,14.12];
alpha_sc_matrix = [alpha0;alpha5;alpha10];

Re = [1,1.5,2.1,2.6,3.1,3.6,4.1,4.6,5.1];

figure('position',[100,100,480,350])
hold on
plot(alpha0,Re ,'x','DisplayName','\beta = 0^\circ','markersize',8,'linewidth',2)
plot(alpha5,Re ,'s','DisplayName','\beta = 5^\circ','markersize',12,'linewidth',2)
plot(alpha10,Re,'o','DisplayName','\beta = 10^\circ','markersize',15,'linewidth',2)
set(gca,'FontSize',14)
legend('location','NorthWest')
pbaspect([5 4 1])
ylim([0.5 5.5])
xlim([12 17])
xlabel('\alpha [\circ]')
ylabel('Re \cdot 10^5')

% get CL at stall cell
for i = 1:9
[fitresult, ~] = fit(angle_corrected(i,5:end)',cl_corrected(i,5:end)','linearinterp');
cl_0_sc(i) = feval(fitresult,alpha0(i));
end

for i = 10:18
[fitresult, ~] = fit(angle_corrected(i,5:end)',cl_corrected(i,5:end)','linearinterp');
cl_5_sc(i-9) = feval(fitresult,alpha5(i-9));
end

for i = 19:27
[fitresult, ~] = fit(angle_corrected(i,5:end)',cl_corrected(i,5:end)','linearinterp');
cl_10_sc(i-18) = feval(fitresult,alpha10(i-18));
end

cl_sc_matrix = [cl_0_sc;cl_5_sc;cl_10_sc];

% use CLmax locations to find stall angle
[~,loc] = max(cl_corrected');
idx=sub2ind(size(angle_corrected),(1:1:27),loc);
angle_stall = angle_corrected(idx);

delta_alpha_0 = alpha0 - angle_stall(1:9);
delta_alpha_5 = alpha5 - angle_stall(10:18);
delta_alpha_10 = alpha10 - angle_stall(19:27);

clearvars alpha0 alpha5 alpha10 loc idx i fitresult gof

%% plot corrected cl with stall cell occurence

colormap hot;
cmap=colormap;
figure('position',[100,100,1100,400])

for fl = 1:3
    subplot(1,3,fl)
    set(gca,'FontSize',14)
    hold on
    for j = 1:9
        % error bars
        Plot_color=cmap(j*5,:);
        errcl=sqrt( 2 * (cl_corrected((fl-1)*9+j,:).*sqrt( (0.1/sqrt(50000))^2 + 2 * (0.005/velocity(j)^2) ) ).^2 );
        erra = 0.05 * ones([1 24]) * 1.96; % 1.96 * SE gives 95 percent conficence
        yneg = cl_corrected((fl-1)*9+j,:)-errcl;
        ypos = cl_corrected((fl-1)*9+j,:)+errcl;
        xneg = angle_corrected((fl-1)*9+j,:)-erra;
        xpos = angle_corrected((fl-1)*9+j,:)+erra;
        
        errorbar(angle_corrected((fl-1)*9+j,:), cl_corrected((fl-1)*9+j,:),...
                 errcl,errcl,erra,erra,':','Color', Plot_color);
             
        % indicate formation of stall cells  
        h = scatter(alpha_sc_matrix(fl,j),cl_sc_matrix(fl,j),...
                    40,'d','filled','LineWidth',1.5,'DisplayName',num2str(velocity(j)),...
                    'MarkerEdgeColor','k','MarkerFaceColor',Plot_color);
        h.Annotation.LegendInformation.IconDisplayStyle = 'off';
        
    end
    xlim([11 18])
    ylim([0.3 1.1])
    pbaspect([4 4 1])
    xlabel('\alpha [\circ]');
    ylabel('C_L');
    title_str = sprintf('flap angle = %d^\\circ', (fl*5-5));
    title(title_str);
    if fl>1
        h = gca;
        h.YAxis.Visible = 'off';
    end
    
    if fl==3
        lgd = legend({'1.0','1.5','2.1','2.6','3.1','3.6','4.1','4.6','5.1'},...
                 'Location','NorthWest','NumColumns',1);
        title(lgd,'Re \cdot 10^5')
        newPosition = [0.95 0.55 0.0 0.0];
        newUnits = 'normalized';
        set(lgd,'Position', newPosition,'Units', newUnits);
    end
end

ha=get(gcf,'children');
set(ha(1),'position',[.93 .53 .0 .0])
set(ha(2),'position',[.45  .175 .60 .70])
set(ha(3),'position',[.175 .175 .60 .70])
set(ha(4),'position',[-0.1 .175 .60 .70])

clearvars fl j xneg xpos yneg ypos Plot_color erra errcl cmap h ha lgd newPosition newUnits title_str

%% plot gradient

% gradients post stall relative to cl max
gradient_local = ones(27,22);
angle_at_which_gradient = ones(27,22);
for i = 1:27
    cl_temp = cl_corrected(i,3:end) - cl_corrected(i,1:end-2);
    angle_temp = angle_corrected(i,3:end) - angle_corrected(i,1:end-2);
    angle_at_which_gradient(i,:) = angle_corrected(i,2:end-1);
    gradient_local(i,:)  = cl_temp./deg2rad(angle_temp);
end
clearvars cl_temp angle_temp 

figure('position',[100,100,600,350])
colormap hot;
cmap=colormap;
set(gca,'FontSize',14);
hold on

for i = 1:9
    Plot_color=cmap(i*5,:);
    plot(angle_at_which_gradient(i,:),gradient_local(i,:),...
    'x','DisplayName','','markersize',8,'linewidth',2,'Color', Plot_color);
    h = plot(angle_at_which_gradient(i+9,:),gradient_local(i,:),...
    'x','markersize',8,'linewidth',2,'Color', Plot_color);
    h.Annotation.LegendInformation.IconDisplayStyle = 'off';
    h = plot(angle_at_which_gradient(i+18,:),gradient_local(i,:),...
    'x','markersize',8,'linewidth',2,'Color', Plot_color);
    h.Annotation.LegendInformation.IconDisplayStyle = 'off';
end
plot(angle_at_which_gradient(1,:),ones(22)*-3.31,'--','linewidth',2,'Color', 'k');
lgd = legend({'1.0','1.5','2.1','2.6','3.1','3.6','4.1','4.6','5.1'},...
             'Location','SouthWest','NumColumns',1,'AutoUpdate','off');
title(lgd,'Re \cdot 10^5');
xlabel('\alpha [\circ]');
xlim([0 20])
ylabel('\deltaC_L / \delta\alpha [r^{-1}]');

%choose alpha from this
plot(ones(2)*14.5,[-14,4],'-.','linewidth',2.5,'Color', 'k');
plot(ones(2)*14,[-14,4],'-.','linewidth',1.5,'Color', 'k');
plot(ones(2)*15,[-14,4],'-.','linewidth',1.5,'Color', 'k');

%get delta alpha
delta_angle_SC_local_grad = 14.5 - angle_stall;

clearvars Plot_color loc lgd idx i h gradient local cmap angle_at_which_gradient
%% plot delta CL (= CL max - CL sc) as a function of Re

[clmax,loc] = max(cl_corrected');
delta_cl_0 = clmax(1:9)-cl_0_sc;
delta_cl_5 = clmax(10:18)-cl_5_sc;
delta_cl_10 = clmax(19:27)-cl_10_sc;

figure('position',[100,100,480,350])
hold on

plot(Re,delta_cl_0 ,'x','DisplayName','\beta = 0^\circ','markersize',8,'linewidth',2)
plot(Re,delta_cl_5 ,'s','DisplayName','\beta = 5^\circ','markersize',8,'linewidth',2)
plot(Re,delta_cl_10,'o','DisplayName','\beta = 10^\circ','markersize',8,'linewidth',2)

[fitresult, gof] = fit( [Re,Re,Re]', [delta_cl_0,delta_cl_5,delta_cl_10]','poly1');
delta_cl_10_fit = fitresult((1:0.1:5.1));
plot((1:0.1:5.1),delta_cl_10_fit,'--','color',[0.0, 0.0, 0.0],...
    'DisplayName','linear fit','linewidth',2);

set(gca,'FontSize',14)
legend('location','southeast')
pbaspect([5 4 1])
xlim([0.75 5.5])
ylim([-0.01 0.18])
xlabel('Re \cdot 10^5')
ylabel('C_{L,max} -  C_{L,SC}')

clearvars fitresult gof
%% delta angle based on mean delta CL

temp_mean = mean([delta_cl_0,delta_cl_5,delta_cl_10]);
mean_delta_cl = ones(9,1)*temp_mean;

cl_SC_mean_cl_0 = clmax(1:9)-mean_delta_cl;
cl_SC_mean_cl_5 = clmax(10:18)-mean_delta_cl;
cl_SC_mean_cl_10 = clmax(19:27)-mean_delta_cl;
cl_SC_mean_cl = [cl_SC_mean_cl_0,cl_SC_mean_cl_5,cl_SC_mean_cl_10];

for fl = 1:3
    for j = 1:9
        angle_SC_mean_cl((fl-1)*9+j) = interp1(cl_corrected((fl-1)*9+j,4:end),angle_corrected((fl-1)*9+j,4:end),cl_SC_mean_cl(1,(fl-1)*9+j));
    end
end

delta_angle_SC_mean_cl = angle_SC_mean_cl - angle_stall;

clearvars temp_mean mean_delta_cl cl_SC_mean_cl_0 cl_SC_mean_cl_5 cl_SC_mean_cl_10 fl j loc
%% delta angle based on varying delta CL as a function of Re
p1 =     0.01674; 
p2 =     0.03621; 
var_delta_cl = p1*Re + p2;

cl_SC_var_cl(1:9)= clmax(1:9)-var_delta_cl;
cl_SC_var_cl(10:18) = clmax(10:18)-var_delta_cl;
cl_SC_var_cl(19:27) = clmax(19:27)-var_delta_cl;

for fl = 1:3
    for j = 1:9
        angle_SC_var_cl((fl-1)*9+j) = interp1(cl_corrected((fl-1)*9+j,4:end),angle_corrected((fl-1)*9+j,4:end),...
            cl_SC_var_cl(1,(fl-1)*9+j));
    end
end

delta_angle_SC_var_cl = angle_SC_var_cl - angle_stall;

clearvars p1 p2 var_delta_cl cl_SC_var_cl angle_SC_var_cl fl j
%% plot MAE for Re and flap angle
% delta_angle_SC_mean_cl: average delta CL
% delta_angle_SC_var_cl: delta CL as function of Re
% delta_angle_SC_local_grad: delta CL based on local gradient (Gross et al.)

delta_alpha_real = [delta_alpha_0,delta_alpha_5,delta_alpha_10];

RMSE_mean_cl = sqrt(mean((delta_alpha_real - delta_angle_SC_mean_cl) .^2,1));  % Root Mean Squared Error
RMSE_var_cl = sqrt(mean((delta_alpha_real - delta_angle_SC_var_cl) .^2,1));  % Root Mean Squared Error
RMSE_local_grad_cl = sqrt(mean((delta_alpha_real - delta_angle_SC_local_grad) .^2,1));  % Root Mean Squared Error

% PLOT PER REYNOLDS NUMBER
RMSE_mean_cl_Re = (RMSE_mean_cl(1:9)+RMSE_mean_cl(10:18)+RMSE_mean_cl(19:27))/3;
RMSE_var_cl_Re = (RMSE_var_cl(1:9)+RMSE_var_cl(10:18)+RMSE_var_cl(19:27))/3;
RMSE_local_grad_cl_Re = (RMSE_local_grad_cl(1:9)+RMSE_local_grad_cl(10:18)+RMSE_local_grad_cl(19:27))/3;

figure('position',[100,100,480,350])
hold on

plot(Re,RMSE_local_grad_cl_Re,'x','DisplayName','\deltaC_L/\delta\alpha (Gross et al.)','markersize',8,'linewidth',2);
plot(Re,RMSE_mean_cl_Re,'s','DisplayName','mean(\DeltaC_L)','markersize',8,'linewidth',2);
plot(Re,RMSE_var_cl_Re,'o','DisplayName','\DeltaC_L = f(Re)','markersize',8,'linewidth',2);

set(gca,'FontSize',14)
legend('location','NorthEast')
pbaspect([5 4 1])
xlim([0.5 5.5])
xlabel('Re \cdot 10^5')
ylim([0 2.1])
ylabel('Error [\circ]')

% PLOT PER FLAP
RMSE_mean_cl_b = [mean(RMSE_mean_cl(1:9)),mean(RMSE_mean_cl(10:18)),mean(RMSE_mean_cl(19:27))];
RMSE_var_cl_b = [mean(RMSE_var_cl(1:9)),mean(RMSE_var_cl(10:18)),mean(RMSE_var_cl(19:27))];
RMSE_local_grad_cl_b = [mean(RMSE_local_grad_cl(1:9)),mean(RMSE_local_grad_cl(10:18)),mean(RMSE_local_grad_cl(19:27))];

flap = [0,5,10];
figure('position',[100,100,480,350])
hold on

plot(flap,RMSE_local_grad_cl_b,'x','DisplayName','\deltaC_L/\delta\alpha (Gross et al.)','markersize',8,'linewidth',2);
plot(flap,RMSE_mean_cl_b,'s','DisplayName','mean(\DeltaC_L)','markersize',8,'linewidth',2);
plot(flap,RMSE_var_cl_b,'o','DisplayName','\DeltaC_L = f(Re)','markersize',8,'linewidth',2);

set(gca,'FontSize',14)
legend('location','North')
pbaspect([5 4 1])
xlim([-0.5 10.5])
ylim([0.25 1.5])
xticks(flap)
xlabel('Flap angle [\circ]')
ylabel('Error [\circ]')