source('R/load_exp2.R')
source('R/function_exp2.R')
source('R/cleaning_exp2.R')

attach(organised_data)
table(gender, condition)
chisq.test(gender, condition)
m_sd(age_exact)

sample_info_by_condition <- organised_data %>%
  group_by(condition)%>%
  summarise(age = m_sd(age_exact), threshold = m_sd(mean_threshold),
            handedness = m_sd(handedness_total),
            asi_social = m_sd(asi_social), asi_physical = m_sd(asi_physical),
            asi_cognitive = m_sd(asi_cognitive), asi_total = m_sd(asi_total),
            sas_total = m_sd(sas_total), fop_minor = m_sd(fop_minor),
            fop_medical = m_sd(fop_medical), fop_severe = m_sd(fop_severe),
            fop_total = m_sd(fop_total), pcs_rumination = m_sd(pcs_rumination),
            pcs_magnification = m_sd(pcs_magnification), 
            pcs_helplessness = m_sd(pcs_helplessness),
            pcs_total = m_sd(pcs_total), bdi_total = m_sd(bdi_total),
            stai_state = m_sd(stai_state), stai_trait = m_sd(stai_trait))

t.test(age_exact[condition == 1], age_exact[condition == 2])
t.test(mean_threshold[condition == 1], mean_threshold[condition == 2])

t.test(organised_data[condition == 1, 2], organised_data[condition == 2, 2])

for (i in 2:17) {
  
  print(colnames(organised_data[i]))
  print(t.test(organised_data[condition == 1, i], organised_data[condition == 2, i]))
  
}



organised_data %>%
  dplyr::select(condition, family_pain)

m_sd(handedness_total)

m_sd(training_proportion_correct*100)
m_sd(test_proportion_correct*100)

m_sd(learning_congruency_effect)

#minimum threshold when 140% is >50
#32 + 1.4(threshold - 32) = 50
#1.4(threshold - 32) = 50-32
#threshold - 32 = 18/1.4
threshold_140exc = 18/1.4 + 32
#44.86
threshold_120exc = 18/1.2 + 32
#47

#hypothesis 1

organised_data_140 <- organised_data %>%
  filter(mean_threshold < threshold_140exc)

organised_data_120 <- organised_data %>%
  filter(mean_threshold < threshold_120exc)

organised_data$condition

for(i in c(32:34, 37:39)) {

print(colnames(organised_data[i]))
print(m_sd(organised_data[condition == 1, i]))
print(m_sd(organised_data[condition == 2, i]))
print(t.test(organised_data[condition == 1, i], organised_data[condition == 2, i]))

model <- lm(organised_data[,i] ~ condition + asi_total + pcs_total + age_exact, data = organised_data)
print(summary(model))

}


for (i in c(35, 40)){
  
  print(colnames(organised_data_120[i]))
  print(m_sd(organised_data_120[condition == 1, i]))
  print(m_sd(organised_data_120[condition == 2, i]))
  print(t.test(organised_data_120[condition == 1, i], organised_data_120[condition == 2, i]))
  
  model <- lm(organised_data_120[,i] ~ condition + asi_total + pcs_total + age_exact, data = organised_data_120)
  print(summary(model))
  
}

for (i in c(36, 41)){
  
  print(colnames(organised_data_140[i]))
  print(m_sd(organised_data_140[condition == 1, i]))
  print(m_sd(organised_data_140[condition == 2, i]))
  print(t.test(organised_data_140[condition == 1, i], organised_data_140[condition == 2, i]))
  
  model <- lm(organised_data_140[,i] ~ condition + asi_total + pcs_total + age_exact, data = organised_data_140)
  print(summary(model))
  
}

#does visual imagery moderate the effect of condition on ib?
organised_data$visual_imagery <- as.numeric(organised_data$visual_imagery)

vi_mod_ast <- lm(ast_ib_score ~ condition*visual_imagery, data = organised_data)
summary(vi_mod_ast)

# vi_mod_ilt <- lm(ilt_ib_index ~ condition*visual_imagery, data = organised_data)
# summary(vi_mod_ilt)
# 
# vi_mod_sgt <- lm(sgt_proportion_pain ~ condition*visual_imagery, data = organised_data)
# summary(vi_mod_sgt)

plot_hyp1_data <- organised_data %>%
  mutate(hot120_intensity = ifelse(mean_threshold < threshold_120exc, hot120_intensity, NA),
         hot140_intensity = ifelse(mean_threshold < threshold_140exc, hot140_intensity, NA),
         hot120_unpleasantness = ifelse(mean_threshold < threshold_120exc, hot120_unpleasantness, NA),
         hot140_unpleasantness = ifelse(mean_threshold < threshold_140exc, hot140_unpleasantness, NA))%>%
  dplyr::select(subject, condition, hot60_intensity, hot80_intensity, hot100_intensity, hot120_intensity, hot140_intensity,
                hot60_unpleasantness, hot80_unpleasantness, hot100_unpleasantness, hot120_unpleasantness, hot140_unpleasantness)%>%
  gather(percentage_threshold, rating, -subject, -condition)%>%
  mutate(rating_type = ifelse(str_detect(percentage_threshold, 'intensity'), 'Intensity', 'Unpleasantness'))%>%
  mutate(percentage_threshold = str_remove_all(percentage_threshold, '[[:alpha:]]|_'))%>%
  filter(!is.na(rating))
plot_hyp1_data$percentage_threshold <- factor(plot_hyp1_data$percentage_threshold, levels = c("60", "80", "100", "120", "140"))

ggplot(plot_hyp1_data, aes(x = percentage_threshold , y = rating, fill = condition))+
  geom_boxplot()+
  facet_wrap(~rating_type)+
  labs(x = 'Percentage of Threshold', y = 'Pain Rating')+
  scale_fill_manual("IBM Condition",
    labels = c("Benign", "Pain"),
    values = c("#00BFC4", "#F8766D"))+
  theme_apa

ggsave('graphics/hyp1_boxplots.png')

#hypothesis 2a
hist(ast_ib_score)
organised_data %>%
  group_by(condition)%>%
  summarise(ast_ib_score = m_sd(ast_ib_score))
t.test(ast_ib_score[condition == 1], ast_ib_score[condition == 2])

hyp2a_model <- lm(ast_ib_score ~ condition + asi_total + pcs_total + age_exact, data = organised_data)
summary(hyp2a_model)

#hypothesis 2b
organised_data %>%
  group_by(condition)%>%
  summarise(ilt_ib_index = m_sd(ilt_ib_index))
t.test(ilt_ib_index[condition == 1], ilt_ib_index[condition == 2])

hyp2b_model <- lm(ilt_ib_index ~ condition + asi_total + pcs_total + age_exact, data = organised_data)
summary(hyp2b_model)

#hypothesis 2c
organised_data %>%
  group_by(condition)%>%
  summarise(sgt_proportion_pain = m_sd(sgt_proportion_pain))
t.test(sgt_proportion_pain[condition == 1], sgt_proportion_pain[condition == 2])

hyp2c_model <- lm(sgt_proportion_pain ~ condition + asi_total + pcs_total + age_exact, data = organised_data)
summary(hyp2c_model)

#graph for hypotheses 2a, 2b, and 2c
hyp2_plot_data <- organised_data %>%
  dplyr::select(subject, condition, ast_ib_score, ilt_ib_index, sgt_proportion_pain)%>%
  gather(ib_test, score, -subject, -condition)%>%
  mutate(condition = ifelse(condition == 1, 'Benign', 'Pain'))

hyp2_plot_data %>%
  filter(ib_test == 'ast_ib_score')%>%
  ggplot(aes(x = condition, y = score, fill = condition))+
    geom_violin(trim = FALSE, show.legend=FALSE)+
    geom_dotplot(binaxis='y', stackdir='center',
               position=position_dodge(1), show.legend = FALSE)+
    stat_summary(fun.data= mean_sdl,geom='pointrange', position = position_dodge(width = 1), show.legend = FALSE)+
    labs(x = 'IBM Condition', y = 'Ambiguous Scenarios Interpretation Bias Score') +
    theme_apa
    
ggsave('graphics/hyp2a_violinplot.png')

hyp2_plot_data %>%
  filter(ib_test == 'ilt_ib_index')%>%
  ggplot(aes(x = condition, y = score, fill = condition))+
  geom_violin(trim = FALSE, show.legend = FALSE)+
  geom_dotplot(binaxis='y', stackdir='center',
               position=position_dodge(1), show.legend = FALSE)+
  stat_summary(fun.data= mean_sdl,geom='pointrange', position = position_dodge(width = 1), show.legend = FALSE)+
  labs(x = 'IBM Condition', y = 'Incidental Learning Interpretation Bias Score') +
  theme_apa

ggsave('graphics/hyp2b_violinplot.png')

hyp2_plot_data %>%
  filter(ib_test == 'sgt_proportion_pain')%>%
  ggplot(aes(x = condition, y = score, fill = condition))+
  geom_violin(trim = FALSE, show.legend=FALSE)+
  geom_dotplot(binaxis='y', stackdir='center',
               position=position_dodge(1), show.legend = FALSE)+
  stat_summary(fun.data= mean_sdl,geom='pointrange', position = position_dodge(width = 1), show.legend = FALSE)+
  labs(x = 'IBM Condition', y = 'Sentence Generation Interpretation Bias Score') +
  theme_apa


ggsave('graphics/hyp2c_violinplot.png')

#exploratory analysis
#correlations
correlations_data <- organised_data %>%
  dplyr:: select(age_exact, asi_total, sas_total, fop_total, pcs_total, bdi_total, stai_state, stai_trait,
                 ast_ib_score, ilt_ib_index, sgt_proportion_pain, mean_threshold,
                 hot60_intensity, hot80_intensity, hot100_intensity, hot120_intensity, hot140_intensity,
                 hot60_unpleasantness, hot80_unpleasantness, hot100_unpleasantness, hot120_unpleasantness, hot140_unpleasantness)
correlations_data$age_exact[is.na(correlations_data$age_exact)] <- mean(correlations_data$age_exact, na.rm = TRUE)
colnames(correlations_data) <- c('Age','Anxiety sensitivity', 'Somatosensory amplification', 'Fear of pain', 'Pain catastrophising', 'Depression',
                                 'State anxiety', 'Trait anxiety', 'Ambiguous scenarios', 'Incidental learning',
                                 'Sentence generation', 'Threshold', 
                                 '60% intensity rating', '80% intensity rating', '100% intensity rating', 
                                 '120% intensity rating', '140% intensity rating',
                                 '60% unpleasantness rating', '80% unpleasantness rating', 
                                 '100% unpleasantness rating', '120% unpleasantness rating', '140% unpleasantness rating')

correlations <- cor(correlations_data)
correlations

p.mat <- cor.mtest(correlations_data)
p.mat$p

cor_plot <- corrplot(correlations, diag = FALSE, type = 'lower',
                     #method = 'color', 
                     tl.col="black", tl.srt=90,
                     p.mat = p.mat$p, sig.level = 0.05, insig = "label_sig", pch.col = "black",
                     family = "serif", number.font = 5)

?corrplot


#does anxiety moderate the effect of condition on ib?
#age moderated the effect of condition on unpleasantness scores but may not be meaningful due to low number of observations
# anx_mod_60 <- lm(hot60_unpleasantness ~ condition * stai_trait, data = organised_data)
# summary(anx_mod_60)
# 
# anx_mod_80 <- lm(hot80_unpleasantness ~ condition * stai_trait, data = organised_data)
# summary(anx_mod_80)
# 
# anx_mod_100 <- lm(hot100_unpleasantness ~ condition * stai_trait, data = organised_data)
# summary(anx_mod_100)
# 
# anx_mod_120 <- lm(hot120_unpleasantness ~ condition * stai_trait, data = organised_data_120)
# summary(anx_mod_120)
# 
# anx_mod_140 <- lm(hot140_unpleasantness ~ condition * stai_trait, data = organised_data_140)
# summary(anx_mod_140)
# 
# 
# anx_mod_80 <- lm(hot80_unpleasantness ~ condition * age_exact, data = organised_data)
# summary(anx_mod_80)
# 
# ggplot(organised_data, aes(x = age_exact, y = hot60_unpleasantness, color = condition))+
#   geom_point()
# 
# anx_mod_80 <- lm(hot80_unpleasantness ~ condition * stai_state, data = organised_data)
# summary(anx_mod_80)
# 
# anx_mod_100 <- lm(hot100_unpleasantness ~ condition * stai_state, data = organised_data)
# summary(anx_mod_100)
# 
# anx_mod_120 <- lm(hot120_unpleasantness ~ condition * stai_trait, data = organised_data_120)
# summary(anx_mod_120)

anx_mod_140 <- lm(hot140_unpleasantness ~ condition * stai_trait, data = organised_data_140)
summary(anx_mod_140)
