jatos_tidy <- function(data, row_identifier){
  data2 <- data%>%
    dplyr::select(subject, responses)%>%
    dplyr::filter(str_detect(responses, row_identifier))
  #data2$responses <- str_replace_all(data2$responses, ", but"," but")
  #data2$responses <- str_replace_all(data2$responses, ", occasionally"," occasionally")
  data2 <- data2 %>%
    dplyr::mutate(responses = strsplit(responses, ",\"")) %>%
    unnest(responses)%>%
    separate(col = responses, into = c('question', 'answer'), sep = ':')
  data2[] <- lapply(data2, function(x) gsub("(?!_)[[:punct:]]", "", x, perl = TRUE))
  data2 %>%
    spread(question, answer)
}

m_sd <- function(x){
  mean_x = round(mean(x, na.rm = TRUE),2)
  sd_x = round(sd(x, na.rm = TRUE),2)
  print(paste(mean_x, '(',sd_x,')'), sep = '')
  
}

add_one <- function (x) {
  x + 1
}  

theme_apa <-   theme_classic()+
  theme(text = element_text(colour = "black", family = "serif"), 
        axis.text.x.bottom = element_text(colour = "black"), axis.text.y.left = element_text(colour = "black"),
        strip.background = element_rect(linetype = "blank"))
