(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 11.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     30465,        769]
NotebookOptionsPosition[     29011,        714]
NotebookOutlinePosition[     29385,        731]
CellTagsIndexPosition[     29342,        728]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"yourpath", "=", "\"\<~/\>\""}], ";"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]", 
  RowBox[{
  "(*", " ", 
   "%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%", " ", 
   "*)"}], "\[IndentingNewLine]", 
  RowBox[{
  "(*", "                                                                 ", 
   "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", "            ", 
   RowBox[{
   "your", " ", "path", " ", "to", " ", "the", " ", "ANCILLARY", " ", 
    "folder"}], "                    ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", "      ", 
   RowBox[{
    RowBox[{
     RowBox[{"EXAMPLE", " ", "yourpath"}], "=", 
     "\"\<~/Download/THISPAPER/ANCILLARY/\>\""}], ";"}], "        ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
  "(*", "                                                                 ", 
   "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", "   ", 
   RowBox[{
   "the", " ", "amplitudes", " ", "do", " ", "not", " ", "include", " ", 
    "the", " ", "pochhammers", " ", "per", " ", "stratum"}], "     ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", "         ", 
   RowBox[{
   "solve", " ", "the", " ", "rank", " ", "constraints", " ", "as", " ", 
    "you", " ", "wish"}], "                  ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
  "(*", "                                                                 ", 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
  "(*", " ", 
   "%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%", " ", 
   "*)"}]}]}], "Input",
 CellChangeTimes->{{3.81677982921548*^9, 3.816779884630175*^9}, {
  3.816780363143127*^9, 3.8167803936940002`*^9}, {3.81687137028749*^9, 
  3.8168713708553343`*^9}, {3.8169343397591867`*^9, 3.8169343697166758`*^9}, {
  3.8169347606756153`*^9, 3.8169347960407343`*^9}, {3.816948486100423*^9, 
  3.816948645301301*^9}},
 ExpressionUUID -> "649f24a9-5d1c-4f0b-8a33-bb3c211e43a7"],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 FormBox[
  SuperscriptBox["\[Alpha]", "7"], TraditionalForm]],
 FormatType->
  "TraditionalForm",ExpressionUUID->"1827c17b-60be-43ba-8f8e-6af9a0c6171e"]], \
"Section",
 CellChangeTimes->{{3.816779901829678*^9, 
  3.816779906882683*^9}},ExpressionUUID->"89c3b999-913a-4476-aeb4-\
9c9c2a66ac82"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Block", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
     "top", ",", "letters", ",", "stratum", ",", "STRATUM", ",", 
      "calMbasis"}], "}"}], ",", "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"Get", "[", 
      RowBox[{"yourpath", "<>", "\"\</calH_basis\>\""}], "]"}], ";", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"top", "=", "4"}], ";", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"letters", "=", 
      RowBox[{"{", 
       RowBox[{
       "bb3", ",", "bb4", ",", "bb5", ",", "bb6", ",", "bb7", ",", "bb8", ",",
         "bb9"}], "}"}]}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
     
     RowBox[{"For", "[", 
      RowBox[{
       RowBox[{"stratum", "=", "1"}], ",", 
       RowBox[{"stratum", "\[LessEqual]", " ", 
        RowBox[{"top", "+", "1"}]}], ",", 
       RowBox[{"stratum", "++"}], ",", "\[IndentingNewLine]", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"calMbasis", "=", 
         RowBox[{
          RowBox[{"Table", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"calHbasis", "[", "index", "]"}], "\[LeftDoubleBracket]",
              "stratum", "\[RightDoubleBracket]"}], ",", 
            RowBox[{"{", 
             RowBox[{"index", ",", "top", ",", "1", ",", 
              RowBox[{"-", "1"}]}], "}"}]}], "]"}], "//", "Flatten"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"STRATUM", "[", "stratum", "]"}], "=", 
         RowBox[{
          RowBox[{"Array", "[", 
           RowBox[{
            RowBox[{
            "letters", "\[LeftDoubleBracket]", "stratum", 
             "\[RightDoubleBracket]"}], ",", 
            RowBox[{"Length", "[", "calMbasis", "]"}]}], "]"}], ".", 
          "calMbasis"}]}], ";"}]}], "\[IndentingNewLine]", 
      "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"listcalV", "[", "top", "]"}], "=", 
      RowBox[{"Array", "[", 
       RowBox[{"STRATUM", ",", 
        RowBox[{"top", "+", "1"}]}], "]"}]}], ";"}]}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", "]"}], ";"}]], "Input",
 CellChangeTimes->{{3.813123855995347*^9, 3.813124321548731*^9}, {
   3.8131252730737333`*^9, 3.8131252948965187`*^9}, {3.813125349584902*^9, 
   3.813125376744091*^9}, {3.813125409144256*^9, 3.813125413197823*^9}, {
   3.813125450032033*^9, 3.813125452069024*^9}, {3.8131284169887466`*^9, 
   3.8131284179140472`*^9}, {3.813128494808033*^9, 3.813128525223096*^9}, {
   3.8131285571694927`*^9, 3.81312858434956*^9}, {3.813128652694058*^9, 
   3.813128659227963*^9}, {3.8131293238927*^9, 3.81312932532203*^9}, {
   3.8167567970482283`*^9, 3.816756881896093*^9}, {3.8167570853139467`*^9, 
   3.8167570866405563`*^9}, {3.816757197383964*^9, 3.816757458083252*^9}, {
   3.8167575098967237`*^9, 3.816757511063704*^9}, {3.816765321745694*^9, 
   3.816765362360929*^9}, {3.8167654493709383`*^9, 3.8167654551840763`*^9}, {
   3.816765512601308*^9, 3.8167655129198933`*^9}, {3.816765592505533*^9, 
   3.8167656227998962`*^9}, {3.8167656541548233`*^9, 3.816765658712201*^9}, {
   3.8167783285062513`*^9, 3.8167783370404673`*^9}, {3.8167799108303623`*^9, 
   3.816779951231696*^9}, {3.816779984822859*^9, 3.816780005774476*^9}, {
   3.816871587065619*^9, 3.81687158754529*^9}, {3.816934371437203*^9, 
   3.816934371781538*^9}, {3.816934438525943*^9, 3.81693444035435*^9}, 
   3.816934534217432*^9},
 ExpressionUUID -> "38ea8ca4-d5ab-4e3c-965d-b2f0a897dd50"],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"Get", "[", 
     RowBox[{"yourpath", "<>", "\"\</rankconstraints_alpha7\>\""}], "]"}], 
    ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"rankconstraintsalpha7", "=", 
     RowBox[{"rankconstraintsalpha7", "&&", 
      RowBox[{
       RowBox[{"bb7", "[", "1", "]"}], "\[Equal]", " ", "1"}]}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"extraconstraintalpha7", "=", 
     RowBox[{
      RowBox[{"bb3", "[", "1", "]"}], "\[Equal]", 
      RowBox[{
       RowBox[{"-", 
        FractionBox["256", "221"]}], "-", 
       FractionBox[
        RowBox[{"42", " ", 
         RowBox[{"bb3", "[", "3", "]"}]}], "425"], "-", 
       FractionBox[
        RowBox[{"23", " ", 
         RowBox[{"bb3", "[", "4", "]"}]}], "85"], "-", 
       FractionBox[
        RowBox[{"11", " ", 
         RowBox[{"bb3", "[", "5", "]"}]}], "17"], "+", 
       FractionBox[
        RowBox[{"3", " ", 
         RowBox[{"bb3", "[", "6", "]"}]}], "85"]}]}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"allconstraintsalpha7", "=", 
     RowBox[{"rankconstraintsalpha7", "&&", "extraconstraintalpha7"}]}], 
    ";"}], "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.816780114586607*^9, 3.816780141670187*^9}, {
   3.816780194327301*^9, 3.81678024971804*^9}, {3.8167802991593103`*^9, 
   3.8167803461658897`*^9}, {3.816780409894017*^9, 3.8167804469193296`*^9}, {
   3.8167864680421658`*^9, 3.816786481336206*^9}, 3.8167951386639557`*^9, {
   3.816865987318885*^9, 3.8168659876503153`*^9}, 3.816867640517664*^9},
 ExpressionUUID -> "aeadc4be-1998-4783-ba33-11ec49c3f296"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"allconstraintsalpha7", "//", "Length"}]], "Input",
 CellChangeTimes->{{3.8168718907872334`*^9, 3.816871892791564*^9}}],

Cell[BoxData["36"], "Output",
 CellChangeTimes->{3.8168718931797237`*^9, 3.816930202597498*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 FormBox[
  SuperscriptBox["\[Alpha]", "8"], TraditionalForm]],
 ExpressionUUID -> "5fb4c919-4496-44b7-855c-672a0f65786a"]], "Section",
 CellChangeTimes->{{3.816779901829678*^9, 3.816779906882683*^9}, {
  3.816779965167862*^9, 3.81677996553395*^9}},
 ExpressionUUID -> "3f64b59e-7c6e-43f8-a1a8-c6ea540b782c"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Block", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
     "top", ",", "letters", ",", "stratum", ",", "STRATUM", ",", 
      "calMbasis"}], "}"}], ",", "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"Get", "[", 
      RowBox[{"yourpath", "<>", "\"\</calH_basis\>\""}], "]"}], ";", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"top", "=", "5"}], ";", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"letters", "=", 
      RowBox[{"{", 
       RowBox[{
       "bb3", ",", "bb4", ",", "bb5", ",", "bb6", ",", "bb7", ",", "bb8", ",",
         "bb9"}], "}"}]}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
     
     RowBox[{"For", "[", 
      RowBox[{
       RowBox[{"stratum", "=", "1"}], ",", 
       RowBox[{"stratum", "\[LessEqual]", " ", 
        RowBox[{"top", "+", "1"}]}], ",", 
       RowBox[{"stratum", "++"}], ",", "\[IndentingNewLine]", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"calMbasis", "=", 
         RowBox[{
          RowBox[{"Table", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"calHbasis", "[", "index", "]"}], "\[LeftDoubleBracket]",
              "stratum", "\[RightDoubleBracket]"}], ",", 
            RowBox[{"{", 
             RowBox[{"index", ",", "top", ",", "1", ",", 
              RowBox[{"-", "1"}]}], "}"}]}], "]"}], "//", "Flatten"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"STRATUM", "[", "stratum", "]"}], "=", 
         RowBox[{
          RowBox[{"Array", "[", 
           RowBox[{
            RowBox[{
            "letters", "\[LeftDoubleBracket]", "stratum", 
             "\[RightDoubleBracket]"}], ",", 
            RowBox[{"Length", "[", "calMbasis", "]"}]}], "]"}], ".", 
          "calMbasis"}]}], ";"}]}], "\[IndentingNewLine]", 
      "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"listcalV", "[", "top", "]"}], "=", 
      RowBox[{"Array", "[", 
       RowBox[{"STRATUM", ",", 
        RowBox[{"top", "+", "1"}]}], "]"}]}], ";"}]}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", "]"}], ";"}]], "Input",
 CellChangeTimes->{{3.813123855995347*^9, 3.813124321548731*^9}, {
   3.8131252730737333`*^9, 3.8131252948965187`*^9}, {3.813125349584902*^9, 
   3.813125376744091*^9}, {3.813125409144256*^9, 3.813125413197823*^9}, {
   3.813125450032033*^9, 3.813125452069024*^9}, {3.8131284169887466`*^9, 
   3.8131284179140472`*^9}, {3.813128494808033*^9, 3.813128525223096*^9}, {
   3.8131285571694927`*^9, 3.81312858434956*^9}, {3.813128652694058*^9, 
   3.813128659227963*^9}, {3.8131293238927*^9, 3.81312932532203*^9}, {
   3.8167567970482283`*^9, 3.816756881896093*^9}, {3.8167570853139467`*^9, 
   3.8167570866405563`*^9}, {3.816757197383964*^9, 3.816757458083252*^9}, {
   3.8167575098967237`*^9, 3.816757511063704*^9}, {3.816765321745694*^9, 
   3.816765362360929*^9}, {3.8167654493709383`*^9, 3.8167654551840763`*^9}, {
   3.816765512601308*^9, 3.8167655129198933`*^9}, {3.816765592505533*^9, 
   3.8167656227998962`*^9}, {3.8167656541548233`*^9, 3.816765658712201*^9}, {
   3.8167783285062513`*^9, 3.8167783370404673`*^9}, {3.8167799108303623`*^9, 
   3.816779971894517*^9}, {3.81678004054431*^9, 3.816780041134492*^9}, {
   3.816871575188805*^9, 3.816871582625396*^9}, 3.81693437573738*^9, {
   3.8169344080230503`*^9, 3.8169344155187807`*^9}},
 ExpressionUUID -> "4f14d10e-d378-4234-a4f1-33312c509b7e"],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"Get", "[", 
     RowBox[{"yourpath", "<>", "\"\</rankconstraints_alpha8\>\""}], "]"}], 
    ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"rankconstraintsalpha8", "=", 
     RowBox[{"rankconstraintsalpha8", "&&", 
      RowBox[{
       RowBox[{"bb8", "[", "1", "]"}], "\[Equal]", " ", 
       FractionBox["4", "5"]}]}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"extraconstraintalpha8", "=", 
     RowBox[{
      RowBox[{
       RowBox[{"bb3", "[", "19", "]"}], "\[Equal]", 
       RowBox[{
        RowBox[{"-", 
         FractionBox[
          RowBox[{"32", " ", 
           RowBox[{"bb3", "[", "20", "]"}]}], "23205"]}], "-", 
        FractionBox[
         RowBox[{"42", " ", 
          RowBox[{"bb3", "[", "21", "]"}]}], "425"], "-", 
        FractionBox[
         RowBox[{"23", " ", 
          RowBox[{"bb3", "[", "22", "]"}]}], "85"], "-", 
        FractionBox[
         RowBox[{"11", " ", 
          RowBox[{"bb3", "[", "23", "]"}]}], "17"], "+", 
        FractionBox[
         RowBox[{"3", " ", 
          RowBox[{"bb3", "[", "24", "]"}]}], "85"]}]}], "&&", 
      RowBox[{
       RowBox[{"bb3", "[", "2", "]"}], "\[Equal]", 
       RowBox[{
        RowBox[{"-", 
         FractionBox["12064640", "4217"]}], "+", 
        FractionBox[
         RowBox[{"1105", " ", 
          RowBox[{"bb3", "[", "3", "]"}]}], "12651"], "-", 
        FractionBox[
         RowBox[{"299", " ", 
          RowBox[{"bb3", "[", "5", "]"}]}], "12651"], "-", 
        FractionBox[
         RowBox[{"650", " ", 
          RowBox[{"bb3", "[", "6", "]"}]}], "4217"], "-", 
        FractionBox[
         RowBox[{"1430", " ", 
          RowBox[{"bb3", "[", "7", "]"}]}], "12651"]}]}]}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"allconstraintsalpha8", "=", 
     RowBox[{"rankconstraintsalpha8", "&&", "extraconstraintalpha8"}]}], 
    ";"}], "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.816780224807273*^9, 3.8167802251899767`*^9}, {
   3.8167804604872007`*^9, 3.816780484750174*^9}, {3.816786488578148*^9, 
   3.816786504486124*^9}, 3.8168659719273*^9, 3.816867587249559*^9},
 ExpressionUUID -> "149419ae-27f7-4fbe-8587-50c08711d13a"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"allconstraintsalpha8", "//", "Length"}]], "Input",
 CellChangeTimes->{{3.816871913120818*^9, 3.816871913399557*^9}}],

Cell[BoxData["85"], "Output",
 CellChangeTimes->{3.816871913907804*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Alpha]", "9"], TraditionalForm]],
  ExpressionUUID -> "5fb4c919-4496-44b7-855c-672a0f65786a"],
 " spin  6"
}], "Section",
 CellChangeTimes->{{3.816865707426765*^9, 3.816865712564064*^9}, {
  3.817018892387825*^9, 3.817018893528212*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Block", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
     "top", ",", "using", ",", "howmany", ",", "letters", ",", "stratum", ",",
       "STRATUM", ",", "calMbasis"}], "}"}], ",", "\[IndentingNewLine]", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"Get", "[", 
      RowBox[{"yourpath", "<>", "\"\</calH_basis\>\""}], "]"}], ";", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"top", "=", "6"}], ";", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"using", "[", "1", "]"}], "=", 
      RowBox[{"calHbasis", "[", "top", "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"using", "[", "2", "]"}], "=", 
      RowBox[{"calHbasis", "[", 
       RowBox[{"top", "-", "1"}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"using", "[", "3", "]"}], "=", 
      RowBox[{"Coefficient", "[", 
       RowBox[{
        RowBox[{"calHbasis", "[", 
         RowBox[{"top", "-", "2"}], "]"}], ",", "\[CapitalSigma]", ",", "0"}],
        "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"using", "[", "4", "]"}], "=", 
      RowBox[{
       RowBox[{"Coefficient", "[", 
        RowBox[{
         RowBox[{"calHbasis", "[", 
          RowBox[{"top", "-", "2"}], "]"}], ",", "\[CapitalSigma]", ",", 
         "1"}], "]"}], "\[CapitalSigma]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"using", "[", "5", "]"}], "=", 
      RowBox[{"Coefficient", "[", 
       RowBox[{
        RowBox[{"calHbasis", "[", 
         RowBox[{"top", "-", "3"}], "]"}], ",", "\[CapitalSigma]", ",", "0"}],
        "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"howmany", "=", "5"}], ";", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"letters", "=", 
      RowBox[{"{", 
       RowBox[{
       "bb3", ",", "bb4", ",", "bb5", ",", "bb6", ",", "bb7", ",", "bb8", ",",
         "bb9"}], "}"}]}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"For", "[", 
      RowBox[{
       RowBox[{"stratum", "=", "1"}], ",", 
       RowBox[{"stratum", "\[LessEqual]", " ", 
        RowBox[{"top", "+", "1"}]}], ",", 
       RowBox[{"stratum", "++"}], ",", "\[IndentingNewLine]", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"calMbasis", "=", 
         RowBox[{
          RowBox[{"Table", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"using", "[", "index", "]"}], "\[LeftDoubleBracket]", 
             "stratum", "\[RightDoubleBracket]"}], ",", 
            RowBox[{"{", 
             RowBox[{"index", ",", "1", ",", "howmany"}], "}"}]}], "]"}], "//",
           "Flatten"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"STRATUM", "[", "stratum", "]"}], "=", 
         RowBox[{
          RowBox[{"Array", "[", 
           RowBox[{
            RowBox[{
            "letters", "\[LeftDoubleBracket]", "stratum", 
             "\[RightDoubleBracket]"}], ",", 
            RowBox[{"Length", "[", "calMbasis", "]"}]}], "]"}], ".", 
          "calMbasis"}]}], ";"}]}], "\[IndentingNewLine]", 
      "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"listcalVspin6", "[", "top", "]"}], "=", 
      RowBox[{"Array", "[", 
       RowBox[{"STRATUM", ",", 
        RowBox[{"top", "+", "1"}]}], "]"}]}], ";"}]}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", "]"}], ";"}]], "Input",
 CellChangeTimes->{{3.813123855995347*^9, 3.813124321548731*^9}, {
   3.8131252730737333`*^9, 3.8131252948965187`*^9}, {3.813125349584902*^9, 
   3.813125376744091*^9}, {3.813125409144256*^9, 3.813125413197823*^9}, {
   3.813125450032033*^9, 3.813125452069024*^9}, {3.8131284169887466`*^9, 
   3.8131284179140472`*^9}, {3.813128494808033*^9, 3.813128525223096*^9}, {
   3.8131285571694927`*^9, 3.81312858434956*^9}, {3.813128652694058*^9, 
   3.813128659227963*^9}, {3.8131293238927*^9, 3.81312932532203*^9}, {
   3.8167567970482283`*^9, 3.816756881896093*^9}, {3.8167570853139467`*^9, 
   3.8167570866405563`*^9}, {3.816757197383964*^9, 3.816757458083252*^9}, {
   3.8167575098967237`*^9, 3.816757511063704*^9}, {3.816765321745694*^9, 
   3.816765362360929*^9}, {3.8167654493709383`*^9, 3.8167654551840763`*^9}, {
   3.816765512601308*^9, 3.8167655129198933`*^9}, {3.816765592505533*^9, 
   3.8167656227998962`*^9}, {3.8167656541548233`*^9, 3.816765658712201*^9}, {
   3.8167783285062513`*^9, 3.8167783370404673`*^9}, {3.8167799108303623`*^9, 
   3.816779971894517*^9}, {3.81678004054431*^9, 3.816780041134492*^9}, {
   3.816865743323069*^9, 3.8168658234888372`*^9}, {3.8168658625890207`*^9, 
   3.816865869233486*^9}, 3.816867609358289*^9, {3.816871594586492*^9, 
   3.8168716098840933`*^9}, {3.816934378960515*^9, 3.816934419646772*^9}, {
   3.817019243414055*^9, 3.817019244506888*^9}},
 ExpressionUUID -> "4f14d10e-d378-4234-a4f1-33312c509b7e"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"listcalV", "[", "6", "]"}], "\[LeftDoubleBracket]", "7", 
  "\[RightDoubleBracket]"}]], "Input",
 CellChangeTimes->{{3.8170189830158052`*^9, 3.817018991157733*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     SuperscriptBox["bfS", "6"], "+", 
     SuperscriptBox["bfT", "6"], "+", 
     SuperscriptBox["bfU", "6"]}], ")"}], " ", 
   RowBox[{"bb9", "[", "1", "]"}]}], "+", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["bfS", "3"], "+", 
      SuperscriptBox["bfT", "3"], "+", 
      SuperscriptBox["bfU", "3"]}], ")"}], "2"], " ", 
   RowBox[{"bb9", "[", "2", "]"}]}]}]], "Output",
 CellChangeTimes->{{3.817018986370957*^9, 3.8170189913278923`*^9}}]
}, Open  ]],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"Get", "[", 
     RowBox[{"yourpath", "<>", "\"\</rankconstraints_alpha9_spin6\>\""}], 
     "]"}], ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"rankconstraintsalpha9spin6", "=", 
     RowBox[{"rankconstraintsalpha9spin6", "&&", 
      RowBox[{
       RowBox[{"bb9", "[", "1", "]"}], "\[Equal]", "1"}], "&&", 
      RowBox[{
       RowBox[{"bb9", "[", "2", "]"}], "\[Equal]", " ", 
       RowBox[{"-", "EE"}]}]}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.816780224807273*^9, 3.8167802251899767`*^9}, {
   3.8167804604872007`*^9, 3.816780484750174*^9}, {3.816786488578148*^9, 
   3.816786504486124*^9}, 3.8168659719273*^9, 3.816867587249559*^9, {
   3.81687491132475*^9, 3.816874922154546*^9}, {3.8170190005432577`*^9, 
   3.817019046661756*^9}, {3.817019160820476*^9, 3.8170191813140287`*^9}},
 ExpressionUUID -> "149419ae-27f7-4fbe-8587-50c08711d13a"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"rankconstraintsalpha9spin6", "//", "Length"}]], "Input",
 CellChangeTimes->{{3.8168749602755737`*^9, 3.816874963130698*^9}, 
   3.8170191875172653`*^9}],

Cell[BoxData["178"], "Output",
 CellChangeTimes->{
  3.816874963535672*^9, {3.817019185227756*^9, 3.817019187891905*^9}}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Alpha]", "9"], TraditionalForm]],
  ExpressionUUID -> "5fb4c919-4496-44b7-855c-672a0f65786a"],
 " spin  4 "
}], "Section",
 CellChangeTimes->{{3.816865707426765*^9, 3.816865712564064*^9}, {
  3.817018892387825*^9, 3.8170189004156513`*^9}, {3.8170332282001247`*^9, 
  3.817033235684959*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Block", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
     "top", ",", "using", ",", "howmany", ",", "letters", ",", "stratum", ",",
       "STRATUM", ",", "calMbasis"}], "}"}], ",", "\[IndentingNewLine]", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"Get", "[", 
      RowBox[{"yourpath", "<>", "\"\</calH_basis\>\""}], "]"}], ";", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"top", "=", "6"}], ";", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"using", "[", "1", "]"}], "=", 
      RowBox[{"calHbasis", "[", "top", "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"using", "[", "2", "]"}], "=", 
      RowBox[{"calHbasis", "[", 
       RowBox[{"top", "-", "1"}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"using", "[", "3", "]"}], "=", 
      RowBox[{"Coefficient", "[", 
       RowBox[{
        RowBox[{"calHbasis", "[", 
         RowBox[{"top", "-", "2"}], "]"}], ",", "\[CapitalSigma]", ",", "0"}],
        "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"using", "[", "4", "]"}], "=", 
      RowBox[{
       RowBox[{"Coefficient", "[", 
        RowBox[{
         RowBox[{"calHbasis", "[", 
          RowBox[{"top", "-", "2"}], "]"}], ",", "\[CapitalSigma]", ",", 
         "1"}], "]"}], "\[CapitalSigma]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"using", "[", "5", "]"}], "=", 
      RowBox[{"Coefficient", "[", 
       RowBox[{
        RowBox[{"calHbasis", "[", 
         RowBox[{"top", "-", "3"}], "]"}], ",", "\[CapitalSigma]", ",", "0"}],
        "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"howmany", "=", "5"}], ";", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"letters", "=", 
      RowBox[{"{", 
       RowBox[{
       "bb3", ",", "bb4", ",", "bb5", ",", "bb6", ",", "bb7", ",", "bb8", ",",
         "bb9"}], "}"}]}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"For", "[", 
      RowBox[{
       RowBox[{"stratum", "=", "1"}], ",", 
       RowBox[{"stratum", "\[LessEqual]", " ", 
        RowBox[{"top", "+", "1"}]}], ",", 
       RowBox[{"stratum", "++"}], ",", "\[IndentingNewLine]", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"calMbasis", "=", 
         RowBox[{
          RowBox[{"Table", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"using", "[", "index", "]"}], "\[LeftDoubleBracket]", 
             "stratum", "\[RightDoubleBracket]"}], ",", 
            RowBox[{"{", 
             RowBox[{"index", ",", "1", ",", "howmany"}], "}"}]}], "]"}], "//",
           "Flatten"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"STRATUM", "[", "stratum", "]"}], "=", 
         RowBox[{
          RowBox[{"Array", "[", 
           RowBox[{
            RowBox[{
            "letters", "\[LeftDoubleBracket]", "stratum", 
             "\[RightDoubleBracket]"}], ",", 
            RowBox[{"Length", "[", "calMbasis", "]"}]}], "]"}], ".", 
          "calMbasis"}]}], ";"}]}], "\[IndentingNewLine]", 
      "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"listcalVspin4", "[", "top", "]"}], "=", 
      RowBox[{"Array", "[", 
       RowBox[{"STRATUM", ",", 
        RowBox[{"top", "+", "1"}]}], "]"}]}], ";"}]}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", "]"}], ";"}]], "Input",
 CellChangeTimes->{{3.813123855995347*^9, 3.813124321548731*^9}, {
   3.8131252730737333`*^9, 3.8131252948965187`*^9}, {3.813125349584902*^9, 
   3.813125376744091*^9}, {3.813125409144256*^9, 3.813125413197823*^9}, {
   3.813125450032033*^9, 3.813125452069024*^9}, {3.8131284169887466`*^9, 
   3.8131284179140472`*^9}, {3.813128494808033*^9, 3.813128525223096*^9}, {
   3.8131285571694927`*^9, 3.81312858434956*^9}, {3.813128652694058*^9, 
   3.813128659227963*^9}, {3.8131293238927*^9, 3.81312932532203*^9}, {
   3.8167567970482283`*^9, 3.816756881896093*^9}, {3.8167570853139467`*^9, 
   3.8167570866405563`*^9}, {3.816757197383964*^9, 3.816757458083252*^9}, {
   3.8167575098967237`*^9, 3.816757511063704*^9}, {3.816765321745694*^9, 
   3.816765362360929*^9}, {3.8167654493709383`*^9, 3.8167654551840763`*^9}, {
   3.816765512601308*^9, 3.8167655129198933`*^9}, {3.816765592505533*^9, 
   3.8167656227998962`*^9}, {3.8167656541548233`*^9, 3.816765658712201*^9}, {
   3.8167783285062513`*^9, 3.8167783370404673`*^9}, {3.8167799108303623`*^9, 
   3.816779971894517*^9}, {3.81678004054431*^9, 3.816780041134492*^9}, {
   3.816865743323069*^9, 3.8168658234888372`*^9}, {3.8168658625890207`*^9, 
   3.816865869233486*^9}, 3.816867609358289*^9, {3.816871594586492*^9, 
   3.8168716098840933`*^9}, {3.816934378960515*^9, 3.816934419646772*^9}, {
   3.8170192499546347`*^9, 3.817019251538615*^9}},
 ExpressionUUID -> "4f14d10e-d378-4234-a4f1-33312c509b7e"],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"Get", "[", 
     RowBox[{"yourpath", "<>", "\"\</rankconstraints_alpha9_spin4\>\""}], 
     "]"}], ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"rankconstraintsalpha9spin4", "=", 
     RowBox[{"rankconstraintsalpha9spin4", "&&", 
      RowBox[{
       RowBox[{"bb9", "[", "1", "]"}], "\[Equal]", "0"}], "&&", 
      RowBox[{
       RowBox[{"bb9", "[", "2", "]"}], "\[Equal]", "1"}]}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.816780224807273*^9, 3.8167802251899767`*^9}, {
   3.8167804604872007`*^9, 3.816780484750174*^9}, {3.816786488578148*^9, 
   3.816786504486124*^9}, 3.8168659719273*^9, 3.816867587249559*^9, {
   3.81687491132475*^9, 3.816874922154546*^9}, {3.8170190164087152`*^9, 
   3.817019031112327*^9}, {3.817019195962781*^9, 3.817019217362941*^9}},
 ExpressionUUID -> "149419ae-27f7-4fbe-8587-50c08711d13a"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"rankconstraintsalpha9spin4", "//", "Length"}]], "Input",
 CellChangeTimes->{{3.8168749602755737`*^9, 3.816874963130698*^9}, 
   3.8170192225497303`*^9}],

Cell[BoxData["178"], "Output",
 CellChangeTimes->{3.816874963535672*^9, 3.817019223164748*^9}]
}, Open  ]]
}, Open  ]]
},
Evaluator->"Local",
WindowSize->{940, 631},
WindowMargins->{{75, Automatic}, {Automatic, 0}},
FrontEndVersion->"10.4 for Mac OS X x86 (32-bit, 64-bit Kernel) (April 11, \
2016)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 1962, 47, 199, "Input"],
Cell[CellGroupData[{
Cell[2545, 71, 322, 8, 64, "Section"],
Cell[2870, 81, 3561, 75, 318, "Input"],
Cell[6434, 158, 1743, 42, 187, "Input"],
Cell[CellGroupData[{
Cell[8202, 204, 142, 2, 28, "Input"],
Cell[8347, 208, 95, 1, 28, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8491, 215, 336, 6, 64, "Section"],
Cell[8830, 223, 3515, 74, 318, "Input"],
Cell[12348, 299, 2329, 61, 248, "Input"],
Cell[CellGroupData[{
Cell[14702, 364, 140, 2, 28, "Input"],
Cell[14845, 368, 71, 1, 28, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[14965, 375, 299, 8, 64, "Section"],
Cell[15267, 385, 4940, 107, 454, "Input"],
Cell[CellGroupData[{
Cell[20232, 496, 199, 4, 28, "Input"],
Cell[20434, 502, 548, 17, 36, "Output"]
}, Open  ]],
Cell[20997, 522, 1022, 21, 114, "Input"],
Cell[CellGroupData[{
Cell[22044, 547, 176, 3, 28, "Input"],
Cell[22223, 552, 121, 2, 28, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[22393, 560, 353, 9, 64, "Section"],
Cell[22749, 571, 4942, 107, 454, "Input"],
Cell[27694, 680, 991, 20, 114, "Input"],
Cell[CellGroupData[{
Cell[28710, 704, 176, 3, 28, "Input"],
Cell[28889, 709, 94, 1, 28, "Output"]
}, Open  ]]
}, Open  ]]
}
]
*)

