#!/usr/bin/env Rscript

if ( 0 == length( commandArgs( TRUE ) ) |
		"-bw" != commandArgs( TRUE )[1] ) {
	colours = c(
		"#D64127", "#F3C910", "#2BA259", "#2182C1", "#975FD1" );
} else {
	colours = c(
		"#404040", "#A0A0A0", "#808080", "#505050", "#909090" );
}

avgs <- data.frame();

for ( size in c( "s", "b" ) ) for ( dia in c( 9 ) )
		for ( f in seq( 1, 5 ) ) for ( pin in seq( 1, 5 ) ) {

	fname <- paste( 
		"./data/", pin, "_", f, "_", size, "_9_f_3.csv", sep = "" );

	if ( file.exists( fname ) ) {

		data <- read.csv( fname, header = FALSE, 
			row.names = NULL )[,1:2];

		data <- data[seq( length( data[,1] ) ) > 
			which( data[,1] == "second" )[1],];

		if ( length( data[,1] ) > 10000 ) {
			mod <- length( data[,1] ) / 10000
			data <- data[seq( length( data[,1] ) ) %% mod == 0,];
		}

		data <- cbind( size, dia, f, pin, data );

		avgs <- rbind( avgs, data.frame( size = size, dia = dia, f = f, 
			pin = pin, conn = mean( as.numeric( data$V2 ) ) ) );

	} else {

		write( paste( fname, "doesn't exist" ), stderr() );

	}

}

cairo_pdf( "/dev/fd/1", onefile = TRUE, height = 2.4,
	width = 0.8 + 0.28 * length( avgs$conn[avgs$pin == 1]) );

par( mar = c( 4.0, 5.0, 0.5, 0.5 ), ps = 8, mex = 0.75, xaxs = "i" );

plot( c( 0.5, length( avgs$conn[avgs$pin == 1] ) + 0.5 ), c( 0, 1 ), 
	type = "n", 
	xlab = "", ylab = "", 
	axes = FALSE, 
	main = "" );

box();
mtext( side = 1, line = 2.5, "Connector Configuration" );
mtext( side = 2, line = 3, "Reliability" );

x = seq( length( avgs$conn[avgs$pin == 1] ) - 1 );
abline( v = x[avgs$size[avgs$pin == 1][x] == 
		avgs$size[avgs$pin == 1][x + 1]] + 0.5, 
	lwd = 0.5, lty = "dotted", col = "#444444" );
abline( v = x[avgs$size[avgs$pin == 1][x] != 
		avgs$size[avgs$pin == 1][x + 1]] + 0.5, 
	lwd = 0.5, lty = "dashed", col = "#444444" );

for ( pin in seq( 1, 5 ) ) {

	points( 
		seq( length( avgs$conn[avgs$pin == pin] ) ) + 
			0.10 * ( pin - 3 ), 
		1 - avgs$conn[avgs$pin == pin], 
		col = colours[pin], pch = 16, cex = 1.3 );
	points( 
		seq( length( avgs$conn[avgs$pin == pin] ) ) + 
			0.10 * ( pin - 3 ), 
		1 - avgs$conn[avgs$pin == pin], 
		col = "#FFFFFF", pch = as.character( pin ) );

}

axis( side = 2 );

par( xpd = TRUE );

par( cex.axis = 0.7 );

mtext( side = 1, line = 0, at = 0.5, adj = 1, "Spring:" );
axis( side = 1, line = -1, tick = FALSE, 
	at = seq( length( avgs$conn[avgs$pin == 1] ) ), 
	labels = sapply( avgs$size[avgs$pin == 1], function( x ) {
		if ( "s" == x ) "Small" else "Big" } ) );

par( cex.axis = 1 );

mtext( side = 1, line = 1, at = 0.5, adj = 1, "Backing Foam:" );
axis( side = 1, line = 0, tick = FALSE, 
	at = seq( length( avgs$f[avgs$pin == 1] ) ), 
	labels = avgs$f[avgs$pin == 1] );
