(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.3' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    263115,       5345]
NotebookOptionsPosition[    253405,       5179]
NotebookOutlinePosition[    253838,       5196]
CellTagsIndexPosition[    253795,       5193]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[{
 RowBox[{
  RowBox[{"AppendTo", "[", 
   RowBox[{"$Path", ",", 
    RowBox[{"path", "<>", "\"\<SpinDynamica\\\\\>\""}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Needs", "[", "\"\<SpinDynamica`\>\"", "]"}]}], "Input",
 CellChangeTimes->{
  3.844504575372939*^9, 3.8449293237172832`*^9, {3.8450110817661085`*^9, 
   3.8450111156465054`*^9}, {3.8520950840608845`*^9, 3.852095084561018*^9}},
 CellLabel->"In[2]:=",ExpressionUUID->"a0d473da-4964-4b26-b583-9154b196392d"],

Cell[BoxData[
 TagBox[
  FrameBox["\<\"SpinDynamica version 3.7.8m loaded by \\!\\(\\*\\nStyleBox[\\\
\"Mathematica\\\",\\nFontSlant->\\\"Italic\\\"]\\) 12.3 running on Microsoft \
Windows (64-bit).\"\>"],
  DisplayForm]], "Print",
 CellChangeTimes->{3.883425175366008*^9, 3.8834732004581175`*^9, 
  3.8834890768529234`*^9, 3.8835722202363014`*^9},
 CellLabel->
  "During evaluation of \
In[2]:=",ExpressionUUID->"70b2dd58-e8aa-4f77-8f3c-e6b6d07b18a8"],

Cell[BoxData[
 TemplateBox[{
  "SetUserLevel", "ini", 
   "\"The user level is being initialized to \\!\\(\\*RowBox[{\\\"2\\\"}]\\). \
The user level may be set to an integer between 1 and \
\\!\\(\\*RowBox[{\\\"3\\\"}]\\) by using SetUserLevel[level]. Low user levels \
provide strong syntax trapping at the expense of slow execution for some \
routines. High user levels relax the syntax trapping in order to provide \
better execution speeds.\"", 2, 3, 1, 27111788058319060082, "Local", 
   "General`UserLevel`SetUserLevel"},
  "MessageTemplate2"]], "Message", "MSG",
 CellChangeTimes->{3.883425177382375*^9, 3.8834732035516467`*^9, 
  3.8834890783779774`*^9, 3.8835722218121996`*^9},
 CellLabel->
  "During evaluation of \
In[2]:=",ExpressionUUID->"27964d99-92b2-4cf5-8d25-99c33a315c3b"],

Cell[BoxData[
 TemplateBox[{
  "SetUserLevel", "ul", 
   "\"The user level has been set to \\!\\(\\*RowBox[{\\\"2\\\"}]\\).\"", 2, 
   3, 2, 27111788058319060082, "Local", "General`UserLevel`SetUserLevel"},
  "MessageTemplate2"]], "Message", "MSG",
 CellChangeTimes->{3.883425177382375*^9, 3.8834732035516467`*^9, 
  3.8834890783779774`*^9, 3.8835722219588194`*^9},
 CellLabel->
  "During evaluation of \
In[2]:=",ExpressionUUID->"d8924af8-d597-4835-a276-adb7e8690dd6"],

Cell[BoxData[
 TemplateBox[{
  "SetUserLevel", "modsymbs", 
   "\"Additional definitions have been given to the following symbols: \\!\\(\
\\*RowBox[{\\\"{\\\", RowBox[{\\\"Dot\\\", \\\",\\\", \\\"Duration\\\", \\\",\
\\\", \\\"Exp\\\", \\\",\\\", \\\"Expand\\\", \\\",\\\", \\\"Plus\\\", \
\\\",\\\", \\\"Power\\\", \\\",\\\", \\\"Simplify\\\", \\\",\\\", \
\\\"SolidAngle\\\", \\\",\\\", \\\"Times\\\", \\\",\\\", \\\"WignerD\\\"}], \
\\\"}\\\"}]\\)\"", 2, 3, 3, 27111788058319060082, "Local", 
   "General`UserLevel`SetUserLevel"},
  "MessageTemplate2"]], "Message", "MSG",
 CellChangeTimes->{3.883425177382375*^9, 3.8834732035516467`*^9, 
  3.8834890783779774`*^9, 3.88357222196979*^9},
 CellLabel->
  "During evaluation of \
In[2]:=",ExpressionUUID->"cb370844-8ab7-4a90-93ab-01dabae6af89"],

Cell[BoxData[
 TemplateBox[{
  "SpinDynamica", "badinfo", 
   "\"In some cases, requesting information by executing \\\"?<symbol>\\\") \
generates an infinite loop. I have not been able to identify why this \
happens. In these cases, readable information on a symbol may be generated by \
executing \\\"<symbol>::usage\\\". Apologies from MHL.\"", 2, 3, 4, 
   27111788058319060082, "Local", "Global`SpinDynamica"},
  "MessageTemplate2"]], "Message", "MSG",
 CellChangeTimes->{3.883425177382375*^9, 3.8834732035516467`*^9, 
  3.8834890783779774`*^9, 3.883572221980771*^9},
 CellLabel->
  "During evaluation of \
In[2]:=",ExpressionUUID->"0eec61d1-d998-4f8e-8cc4-dd34909b2fa3"]
}, Open  ]],

Cell[CellGroupData[{

Cell["setup spin system", "Subsection",
 CellChangeTimes->{{3.882622104181368*^9, 3.882622114902437*^9}, {
  3.8832236458871455`*^9, 3.8832236603732576`*^9}, {3.883223768738858*^9, 
  3.8832237691970997`*^9}, {3.883235235911169*^9, 
  3.8832352391592426`*^9}},ExpressionUUID->"d4ea4a8e-02d9-42e6-a310-\
62e8037f190c"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SetSpinSystem", "[", "2", "]"}]], "Input",
 CellChangeTimes->{{3.881343391785619*^9, 3.881343394596198*^9}, {
  3.8816556654229774`*^9, 3.881655665541998*^9}, {3.882620565634503*^9, 
  3.882620565684691*^9}, {3.8826221165043077`*^9, 3.882622116545268*^9}},
 CellLabel->"In[4]:=",ExpressionUUID->"dbb785ba-4979-46c1-8248-0985c24bb3dc"],

Cell[BoxData[
 TemplateBox[{
  "SetSpinSystem", "set", 
   "\"the spin system has been set to \\!\\(\\*RowBox[{\\\"{\\\", \
RowBox[{RowBox[{\\\"{\\\", RowBox[{\\\"1\\\", \\\",\\\", \
FractionBox[\\\"1\\\", \\\"2\\\"]}], \\\"}\\\"}], \\\",\\\", \
RowBox[{\\\"{\\\", RowBox[{\\\"2\\\", \\\",\\\", FractionBox[\\\"1\\\", \\\"2\
\\\"]}], \\\"}\\\"}]}], \\\"}\\\"}]\\)\"", 2, 4, 5, 27111788058319060082, 
   "Local", "QM`Hilbert`SetSpinSystem"},
  "MessageTemplate2"]], "Message", "MSG",
 CellChangeTimes->{
  3.881616350512207*^9, 3.881650136804005*^9, 3.8816545078371954`*^9, 
   3.881761725706588*^9, 3.8817618560476093`*^9, 3.881927723121171*^9, 
   3.8819518002994165`*^9, 3.882044491507547*^9, 3.882044808203208*^9, 
   3.8820449138188353`*^9, 3.8820449486403713`*^9, 3.8820451023116136`*^9, 
   3.8820455932001677`*^9, 3.8822715043089185`*^9, 3.8822715644985614`*^9, 
   3.8822737013501987`*^9, 3.8822780207051134`*^9, 3.882280443667049*^9, 
   3.882283859975524*^9, 3.8823503558140645`*^9, 3.88243609461749*^9, 
   3.8824566463293233`*^9, 3.8825905193494263`*^9, 3.882618709948704*^9, 
   3.882619533654902*^9, 3.882619775549708*^9, 3.8826205660065804`*^9, 
   3.8826221168589697`*^9, 3.882622890115638*^9, 3.882628696767626*^9, 
   3.8826302899169426`*^9, 3.8828758279377213`*^9, 3.8828771510065403`*^9, 
   3.8828777506892567`*^9, 3.8828789151513586`*^9, 3.882878997235009*^9, {
   3.8828795604742236`*^9, 3.882879578235921*^9}, 3.882879888836635*^9, 
   3.882969701129862*^9, 3.882977311852741*^9, 3.88303335273238*^9, 
   3.8830681644455256`*^9, 3.88313204587016*^9, 3.883141958842466*^9, 
   3.8832102051232157`*^9, 3.883222989481885*^9, 3.883227254669981*^9, 
   3.8832346804785805`*^9, 3.8832365705906878`*^9, 3.8832521612765846`*^9, 
   3.8833901165786524`*^9, 3.883392930404748*^9, 3.883404945142415*^9, 
   3.883425177900517*^9, 3.8834732040206747`*^9, 3.883489078651902*^9, 
   3.883572222157405*^9},
 CellLabel->
  "During evaluation of \
In[4]:=",ExpressionUUID->"77e0dd22-4089-44c8-8423-1ad849725c1a"],

Cell[BoxData[
 TemplateBox[{
  "SetBasis", "set", 
   "\"the state basis has been set to \\!\\(\\*RowBox[{\\\"ZeemanBasis\\\", \
\\\"[\\\", RowBox[{RowBox[{\\\"{\\\", RowBox[{RowBox[{\\\"{\\\", \
RowBox[{\\\"1\\\", \\\",\\\", FractionBox[\\\"1\\\", \\\"2\\\"]}], \
\\\"}\\\"}], \\\",\\\", RowBox[{\\\"{\\\", RowBox[{\\\"2\\\", \\\",\\\", \
FractionBox[\\\"1\\\", \\\"2\\\"]}], \\\"}\\\"}]}], \\\"}\\\"}], \\\",\\\", \
RowBox[{\\\"BasisLabels\\\", \\\"\[Rule]\\\", \\\"Automatic\\\"}]}], \
\\\"]\\\"}]\\).\"", 2, 4, 6, 27111788058319060082, "Local", 
   "QM`Hilbert`SetBasis"},
  "MessageTemplate2"]], "Message", "MSG",
 CellChangeTimes->{
  3.881616350512207*^9, 3.881650136804005*^9, 3.8816545078371954`*^9, 
   3.881761725706588*^9, 3.8817618560476093`*^9, 3.881927723121171*^9, 
   3.8819518002994165`*^9, 3.882044491507547*^9, 3.882044808203208*^9, 
   3.8820449138188353`*^9, 3.8820449486403713`*^9, 3.8820451023116136`*^9, 
   3.8820455932001677`*^9, 3.8822715043089185`*^9, 3.8822715644985614`*^9, 
   3.8822737013501987`*^9, 3.8822780207051134`*^9, 3.882280443667049*^9, 
   3.882283859975524*^9, 3.8823503558140645`*^9, 3.88243609461749*^9, 
   3.8824566463293233`*^9, 3.8825905193494263`*^9, 3.882618709948704*^9, 
   3.882619533654902*^9, 3.882619775549708*^9, 3.8826205660065804`*^9, 
   3.8826221168589697`*^9, 3.882622890115638*^9, 3.882628696767626*^9, 
   3.8826302899169426`*^9, 3.8828758279377213`*^9, 3.8828771510065403`*^9, 
   3.8828777506892567`*^9, 3.8828789151513586`*^9, 3.882878997235009*^9, {
   3.8828795604742236`*^9, 3.882879578235921*^9}, 3.882879888836635*^9, 
   3.882969701129862*^9, 3.882977311852741*^9, 3.88303335273238*^9, 
   3.8830681644455256`*^9, 3.88313204587016*^9, 3.883141958842466*^9, 
   3.8832102051232157`*^9, 3.883222989481885*^9, 3.883227254669981*^9, 
   3.8832346804785805`*^9, 3.8832365705906878`*^9, 3.8832521612765846`*^9, 
   3.8833901165786524`*^9, 3.883392930404748*^9, 3.883404945142415*^9, 
   3.883425177900517*^9, 3.8834732040206747`*^9, 3.883489078651902*^9, 
   3.883572222169367*^9},
 CellLabel->
  "During evaluation of \
In[4]:=",ExpressionUUID->"1214d5e4-ddc6-4f5b-a1d2-407823e5bd6c"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"SetBasis", "[", 
   RowBox[{"SingletTripletBasis", "[", "]"}], "]"}], ";"}]], "Input",
 CellLabel->"In[5]:=",ExpressionUUID->"d674d9c6-84cf-4130-b49a-f059944a78de"],

Cell[BoxData[
 TemplateBox[{
  "SetBasis", "set", 
   "\"the state basis has been set to \
\\!\\(\\*RowBox[{\\\"SingletTripletBasis\\\", \\\"[\\\", \
RowBox[{RowBox[{\\\"{\\\", RowBox[{RowBox[{\\\"{\\\", RowBox[{\\\"1\\\", \
\\\",\\\", FractionBox[\\\"1\\\", \\\"2\\\"]}], \\\"}\\\"}], \\\",\\\", \
RowBox[{\\\"{\\\", RowBox[{\\\"2\\\", \\\",\\\", FractionBox[\\\"1\\\", \\\"2\
\\\"]}], \\\"}\\\"}]}], \\\"}\\\"}], \\\",\\\", RowBox[{\\\"BasisLabels\\\", \
\\\"\[Rule]\\\", \\\"Automatic\\\"}]}], \\\"]\\\"}]\\).\"", 2, 5, 7, 
   27111788058319060082, "Local", "QM`Hilbert`SetBasis"},
  "MessageTemplate2"]], "Message", "MSG",
 CellChangeTimes->{
  3.883236570641224*^9, 3.8832521613723316`*^9, 3.8833901172325273`*^9, 
   3.883392930456917*^9, {3.883404932907076*^9, 3.88340494518108*^9}, 
   3.8834251779961567`*^9, 3.8834732041124325`*^9, 3.883489078710702*^9, 
   3.8835722222250757`*^9},
 CellLabel->
  "During evaluation of \
In[5]:=",ExpressionUUID->"e7fab3a3-265c-4164-9460-c49d3fd818e0"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Hamiltonian and energy-shifted Hamiltonian", "Subsection",
 CellChangeTimes->{{3.882622104181368*^9, 3.882622114902437*^9}, {
  3.8832236458871455`*^9, 3.8832236603732576`*^9}, {3.883223768738858*^9, 
  3.8832237691970997`*^9}, {3.883235235911169*^9, 
  3.8832352705490685`*^9}},ExpressionUUID->"783e4a29-0f2c-4be9-b98b-\
a5ee56261469"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Htot", "=", 
   RowBox[{"\[CapitalOmega]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"Sin", "[", "\[Theta]ST", "]"}], "/", "2"}], 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"opI", "[", 
          RowBox[{"1", ",", "\"\<z\>\""}], "]"}], "-", 
         RowBox[{"opI", "[", 
          RowBox[{"2", ",", "\"\<z\>\""}], "]"}]}], ")"}]}], "+", 
      RowBox[{
       RowBox[{"Cos", "[", "\[Theta]ST", "]"}], " ", 
       RowBox[{
        RowBox[{"opI", "[", "1", "]"}], ".", 
        RowBox[{"opI", "[", "2", "]"}]}]}]}], ")"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"H0", "=", 
   RowBox[{"Htot", "+", 
    RowBox[{
     RowBox[{"\[CapitalOmega]", "/", "4"}], " ", 
     RowBox[{"Cos", "[", "\[Theta]ST", "]"}], 
     RowBox[{"UnityOperator", "[", "]"}]}]}]}], ";"}]}], "Input",
 CellLabel->"In[6]:=",ExpressionUUID->"2b2ffab2-11eb-496c-bc21-4410d658bded"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   SubscriptBox["S", "0"], TraditionalForm]],ExpressionUUID->
  "7b9d3149-7dab-4022-ab82-4b458a8ceb9d"],
 " - ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["T", "0"], TraditionalForm]],ExpressionUUID->
  "6690918f-09b0-4a56-833a-d53a0978faa9"],
 " single-transition operators"
}], "Subsection",
 CellChangeTimes->{{3.882622104181368*^9, 3.882622114902437*^9}, {
  3.8832236458871455`*^9, 3.8832236603732576`*^9}, {3.883223768738858*^9, 
  3.8832237691970997`*^9}, {3.883235290112376*^9, 
  3.883235308499851*^9}},ExpressionUUID->"f78d71cb-e3ff-46f4-ab75-\
938b98b896a5"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Qvec", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"SingleTransitionOperator", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "3"}], "}"}], ",", "\"\<x\>\""}], "]"}], ",", 
     RowBox[{"SingleTransitionOperator", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "3"}], "}"}], ",", "\"\<y\>\""}], "]"}], ",", 
     RowBox[{"SingleTransitionOperator", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "3"}], "}"}], ",", "\"\<z\>\""}], "]"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"Sx", ",", "Sy", ",", "Sz"}], "}"}], "=", 
   RowBox[{"MatrixRepresentation", "/@", "Qvec"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.8832272775130596`*^9, 3.8832272779819794`*^9}, 
   3.8832352293006363`*^9, 3.8832352888332973`*^9},
 CellLabel->"In[8]:=",ExpressionUUID->"6ca98357-52b3-4dcc-8306-61de97ecb03b"]
}, Open  ]],

Cell[CellGroupData[{

Cell["interaction frame propagators", "Subsection",
 CellChangeTimes->{{3.882622104181368*^9, 3.882622114902437*^9}, {
  3.8832236458871455`*^9, 3.8832236603732576`*^9}, {3.883223768738858*^9, 
  3.8832237691970997`*^9}, {3.8832353223432503`*^9, 3.8832353307614293`*^9}, {
  3.88323576898199*^9, 
  3.8832357703729258`*^9}},ExpressionUUID->"6122646e-c83f-42d4-94a2-\
0b77c0e8f97b"],

Cell["\<\
Below I define some parameters for a nearly-equivalent system. I force the \
echo number to be even though!\
\>", "Text",
 CellChangeTimes->{{3.8832353391409926`*^9, 3.883235358591131*^9}, {
  3.8832360110974007`*^9, 3.883236019578633*^9}},
 Background->RGBColor[
  0.87, 0.94, 1],ExpressionUUID->"21c122a7-bb7d-41df-9897-e6d567b6c3ec"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"params", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"\[CapitalOmega]", "->", " ", 
      RowBox[{"2", "\[Pi]"}]}], ",", 
     RowBox[{"\[Theta]ST", "->", " ", 
      RowBox[{
       RowBox[{"3", "/", "180"}], "*", "\[Pi]"}]}], ",", 
     RowBox[{"\[Phi]", "->", 
      RowBox[{
       RowBox[{"\[Pi]", "/", "4"}], "-", 
       RowBox[{"\[Pi]", "/", "2"}]}]}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"nval", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"\[Pi]", "/", 
      RowBox[{"(", 
       RowBox[{"2", "\[Theta]ST"}], " ", ")"}]}], "/.", "params"}], "//", 
    "Round"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"nval", "=", 
  RowBox[{"If", "[", 
   RowBox[{
    RowBox[{"OddQ", "[", "nval", "]"}], ",", 
    RowBox[{"nval", "+", "1"}], ",", "nval"}], "]"}]}]}], "Input",
 CellChangeTimes->{
  3.8832230306355405`*^9, {3.88322332746945*^9, 3.8832233367062106`*^9}, {
   3.883223512552101*^9, 3.88322354628769*^9}, {3.883223773248129*^9, 
   3.883223773940957*^9}, {3.8832238441156273`*^9, 3.8832238468650618`*^9}, {
   3.883224004658972*^9, 3.8832240059930267`*^9}, {3.883224126440191*^9, 
   3.883224126948739*^9}, {3.8832248818634653`*^9, 3.883224884101147*^9}, {
   3.8832250113920097`*^9, 3.8832250118188667`*^9}, {3.8832250607546406`*^9, 
   3.8832250615422707`*^9}, 3.8832251480058603`*^9, {3.883225451116742*^9, 
   3.8832254609466157`*^9}, {3.8832272462409916`*^9, 3.88322724807963*^9}, {
   3.883227579211753*^9, 3.8832275793670177`*^9}, {3.8832276271906443`*^9, 
   3.883227629802743*^9}, {3.883227907592264*^9, 3.8832279076700516`*^9}, {
   3.883228190804143*^9, 3.8832281917079616`*^9}, {3.8832286123333406`*^9, 
   3.883228621900654*^9}, {3.883234941328146*^9, 3.883234941383477*^9}, {
   3.883235041310174*^9, 3.8832350415156336`*^9}, {3.883235158650471*^9, 
   3.8832351606888433`*^9}, {3.8832353144162908`*^9, 3.883235318031393*^9}, {
   3.8832355044473314`*^9, 3.883235505158058*^9}, {3.883235998126733*^9, 
   3.88323600878059*^9}, {3.8832361115835533`*^9, 3.8832361123916073`*^9}, {
   3.883236568762989*^9, 3.8832365688192883`*^9}, {3.8834731976776447`*^9, 
   3.883473198195877*^9}, {3.8834735289545712`*^9, 3.883473529161595*^9}, {
   3.88347971771012*^9, 3.8834797178274*^9}, {3.883489418747892*^9, 
   3.8834894190839367`*^9}, {3.8834896739002833`*^9, 3.8834896757316265`*^9}},
 CellLabel->"In[10]:=",ExpressionUUID->"5211fd57-571a-4f16-9191-2eea1703bf07"],

Cell[BoxData["30"], "Output",
 CellChangeTimes->{{3.883489675987584*^9, 3.8834896782660775`*^9}, 
   3.8835722224848595`*^9},
 CellLabel->"Out[12]=",ExpressionUUID->"6259f9d8-15ae-4f12-a81a-bc0d5cdf2402"]
}, Open  ]],

Cell[TextData[{
 "Propagator generating a spherical lune (including ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["H", "0"], TraditionalForm]],ExpressionUUID->
  "3a8af2b5-db90-4452-a8fa-7b28af0a8164"],
 " and pulses) in the rotating frame"
}], "Text",
 CellChangeTimes->{{3.8832353391409926`*^9, 3.8832353842521367`*^9}, {
  3.8832355200652285`*^9, 3.8832355308289013`*^9}, {3.8835716790078545`*^9, 
  3.8835716971319103`*^9}},
 Background->RGBColor[
  0.87, 0.94, 1],ExpressionUUID->"52c397c2-9456-4e9a-a781-7fab86ceb3ac"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Utraj", "=", 
   RowBox[{"NPropagationOperator", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"{", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"Repeat", "[", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"{", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"None", ",", 
             RowBox[{
              RowBox[{
               RowBox[{"(", "\[Pi]", ")"}], "/", "\[CapitalOmega]"}], "/.", 
              "params"}]}], "}"}], ",", "\[IndentingNewLine]", 
           RowBox[{"RotationSuperoperator", "[", 
            RowBox[{"{", 
             RowBox[{"\[Pi]", ",", "\"\<x\>\""}], "}"}], "]"}]}], "}"}], ",", 
         "nval"}], "]"}], ",", "\[IndentingNewLine]", 
       RowBox[{"Repeat", "[", 
        RowBox[{
         RowBox[{"{", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"None", ",", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"\[Pi]", "/", "2"}], "+", "\[Phi]"}], ")"}], "/", 
               "\[CapitalOmega]"}], "/.", "params"}]}], "}"}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{"RotationSuperoperator", "[", 
            RowBox[{"{", 
             RowBox[{"\[Pi]", ",", "\"\<x\>\""}], "}"}], "]"}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{"{", 
            RowBox[{"None", ",", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"\[Pi]", "/", "2"}], "-", "\[Phi]"}], ")"}], "/", 
               "\[CapitalOmega]"}], "/.", "params"}]}], "}"}]}], 
          "\[IndentingNewLine]", "}"}], ",", "nval"}], "]"}]}], 
      "\[IndentingNewLine]", "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{"BackgroundGenerator", "->", 
      RowBox[{"(", 
       RowBox[{"H0", "/.", "params"}], ")"}]}], ",", "\[IndentingNewLine]", 
     RowBox[{"Continuous", "->", " ", "True"}], ",", "\[IndentingNewLine]", 
     RowBox[{"Basis", "->", 
      RowBox[{"SingletTripletBasis", "[", "]"}]}]}], "\[IndentingNewLine]", 
    "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.883235386762169*^9, 3.883235396872467*^9}, {
   3.8832355363682384`*^9, 3.8832355837875924`*^9}, {3.883235620920933*^9, 
   3.8832356259081583`*^9}, 3.883235674860412*^9, {3.883236486867798*^9, 
   3.883236487147051*^9}},
 CellLabel->"In[13]:=",ExpressionUUID->"73d0d8c4-8d23-4517-b0a7-4656f1da37cc"],

Cell["\<\
Trajectory corresponding to pure coherent evolution (all flip angles of the \
pulses have been set to 0)\
\>", "Text",
 CellChangeTimes->{{3.8832353391409926`*^9, 3.8832353842521367`*^9}, {
  3.8832356506501446`*^9, 3.8832356619478846`*^9}, {3.8835717543248496`*^9, 
  3.883571762432707*^9}},
 Background->RGBColor[
  0.87, 0.94, 1],ExpressionUUID->"941166c7-9bc7-4cda-96e6-01876580816a"],

Cell[BoxData[
 RowBox[{
  RowBox[{"U0traj", "=", 
   RowBox[{"NPropagationOperator", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"{", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"Repeat", "[", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"{", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"None", ",", 
             RowBox[{
              RowBox[{
               RowBox[{"(", "\[Pi]", ")"}], "/", "\[CapitalOmega]"}], "/.", 
              "params"}]}], "}"}], ",", "\[IndentingNewLine]", 
           RowBox[{"RotationSuperoperator", "[", 
            RowBox[{"{", 
             RowBox[{"0", ",", "\"\<x\>\""}], "}"}], "]"}]}], "}"}], ",", 
         "nval"}], "]"}], ",", "\[IndentingNewLine]", 
       RowBox[{"Repeat", "[", 
        RowBox[{
         RowBox[{"{", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"None", ",", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"\[Pi]", "/", "2"}], "+", "\[Phi]"}], ")"}], "/", 
               "\[CapitalOmega]"}], "/.", "params"}]}], "}"}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{"RotationSuperoperator", "[", 
            RowBox[{"{", 
             RowBox[{"0", ",", "\"\<x\>\""}], "}"}], "]"}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{"{", 
            RowBox[{"None", ",", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"\[Pi]", "/", "2"}], "-", "\[Phi]"}], ")"}], "/", 
               "\[CapitalOmega]"}], "/.", "params"}]}], "}"}]}], 
          "\[IndentingNewLine]", "}"}], ",", "nval"}], "]"}]}], 
      "\[IndentingNewLine]", "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{"BackgroundGenerator", "->", 
      RowBox[{"(", 
       RowBox[{"H0", "/.", "params"}], ")"}]}], ",", "\[IndentingNewLine]", 
     RowBox[{"Continuous", "->", " ", "True"}], ",", "\[IndentingNewLine]", 
     RowBox[{"Basis", "->", 
      RowBox[{"SingletTripletBasis", "[", "]"}]}]}], "\[IndentingNewLine]", 
    "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.8832230523336177`*^9, 3.8832230590359774`*^9}, {
  3.8832234578548145`*^9, 3.883223458069062*^9}, {3.883223548301753*^9, 
  3.883223550690945*^9}, {3.883223812379097*^9, 3.8832238334818583`*^9}, {
  3.883224392792584*^9, 3.8832243929502335`*^9}, {3.8832244672329025`*^9, 
  3.8832244688432136`*^9}, {3.8832249735043116`*^9, 3.883224986203348*^9}, {
  3.8832348564120035`*^9, 3.883234871390184*^9}, {3.883235592278434*^9, 
  3.883235594048075*^9}, {3.883235634109351*^9, 3.8832356723118553`*^9}, {
  3.8832364835979123`*^9, 3.8832364838671923`*^9}},
 CellLabel->"In[14]:=",ExpressionUUID->"ace2a057-e7ef-44b0-854c-72a81d5bf315"],

Cell["\<\
Propagator corresponding to the RF-Hamiltonian  only (the background \
generator has been set to None)\
\>", "Text",
 CellChangeTimes->{{3.8832353391409926`*^9, 3.8832353842521367`*^9}, {
  3.8832356506501446`*^9, 3.8832356619478846`*^9}, {3.8832356978890867`*^9, 
  3.8832357383998623`*^9}, {3.8835717032030587`*^9, 3.8835717325323477`*^9}},
 Background->RGBColor[
  0.87, 0.94, 1],ExpressionUUID->"46f96712-0ada-4972-834b-5e862d5bbe0e"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Urftraj", "=", 
   RowBox[{"NPropagationOperator", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"{", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"Repeat", "[", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"{", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"None", ",", 
             RowBox[{
              RowBox[{
               RowBox[{"(", "\[Pi]", ")"}], "/", "\[CapitalOmega]"}], "/.", 
              "params"}]}], "}"}], ",", "\[IndentingNewLine]", 
           RowBox[{"RotationSuperoperator", "[", 
            RowBox[{"{", 
             RowBox[{"\[Pi]", ",", "\"\<x\>\""}], "}"}], "]"}]}], "}"}], ",", 
         "nval"}], "]"}], ",", "\[IndentingNewLine]", 
       RowBox[{"Repeat", "[", 
        RowBox[{
         RowBox[{"{", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"None", ",", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"\[Pi]", "/", "2"}], "+", "\[Phi]"}], ")"}], "/", 
               "\[CapitalOmega]"}], "/.", "params"}]}], "}"}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{"RotationSuperoperator", "[", 
            RowBox[{"{", 
             RowBox[{"\[Pi]", ",", "\"\<x\>\""}], "}"}], "]"}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{"{", 
            RowBox[{"None", ",", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"\[Pi]", "/", "2"}], "-", "\[Phi]"}], ")"}], "/", 
               "\[CapitalOmega]"}], "/.", "params"}]}], "}"}]}], 
          "\[IndentingNewLine]", "}"}], ",", "nval"}], "]"}]}], 
      "\[IndentingNewLine]", "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{"BackgroundGenerator", "->", "None"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Continuous", "->", " ", "True"}], ",", "\[IndentingNewLine]", 
     RowBox[{"Basis", "->", 
      RowBox[{"SingletTripletBasis", "[", "]"}]}]}], "\[IndentingNewLine]", 
    "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.8832356784585915`*^9, 3.8832356866892023`*^9}, {
  3.883235729521854*^9, 3.883235741031458*^9}, {3.8832364805821943`*^9, 
  3.883236480862088*^9}},
 CellLabel->"In[15]:=",ExpressionUUID->"404d1f34-e3f6-44b4-a4a8-095d8ecddc6c"]
}, Open  ]],

Cell[CellGroupData[{

Cell["interaction frame trajectory (numerical)", "Subsection",
 CellChangeTimes->{{3.882622104181368*^9, 3.882622114902437*^9}, {
  3.8832236458871455`*^9, 3.8832236603732576`*^9}, {3.883223768738858*^9, 
  3.8832237691970997`*^9}, {3.8832353223432503`*^9, 3.8832353307614293`*^9}, {
  3.88323576898199*^9, 
  3.883235780494172*^9}},ExpressionUUID->"297644b1-42b0-427a-a5fe-\
34e0e89c34b1"],

Cell["spin state trajectory in the interaction-frame:", "Text",
 CellChangeTimes->{{3.8832353391409926`*^9, 3.883235358591131*^9}, {
  3.883235786471593*^9, 3.88323583509097*^9}, {3.8835717793746986`*^9, 
  3.8835718440254664`*^9}},
 Background->RGBColor[
  0.87, 0.94, 1],ExpressionUUID->"a9863869-d2db-49f5-adbb-0767c3ce3f7f"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"\[Delta]t", "=", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"1", "/", "2"}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"\[Pi]", "/", "2"}], "-", "\[Phi]"}], ")"}], "/", 
       "\[CapitalOmega]"}]}], "/.", "params"}], "//", "N"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Psi]traj", "=", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"ConjugateTranspose", "[", 
       RowBox[{"MatrixRepresentation", "[", 
        RowBox[{"Urftraj", "[", "#", "]"}], "]"}], "]"}], ".", 
      RowBox[{"ConjugateTranspose", "[", 
       RowBox[{"MatrixRepresentation", "[", 
        RowBox[{"U0traj", "[", "#", "]"}], "]"}], "]"}], ".", 
      RowBox[{"MatrixRepresentation", "[", 
       RowBox[{"Utraj", "[", "#", "]"}], "]"}], ".", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", "1", ",", "0"}], "}"}]}], "&"}], "/@", 
    RowBox[{"Range", "[", 
     RowBox[{"0", ",", "nval", ",", "\[Delta]t"}], "]"}]}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.883236438466338*^9, 3.883236438718388*^9}, {
  3.8833929357900724`*^9, 3.8833929383492036`*^9}, {3.8833939124611225`*^9, 
  3.883393915147272*^9}, {3.8833949568738036`*^9, 3.883394970655737*^9}, {
  3.88339510277664*^9, 3.883395114205609*^9}, {3.8834732361246815`*^9, 
  3.8834732391926394`*^9}, {3.8835717725553694`*^9, 3.8835717735437527`*^9}},
 CellLabel->"In[16]:=",ExpressionUUID->"882d7964-b58c-4414-ac56-72ae1eab8404"],

Cell["density matrix trajectory in the interaction-frame: ", "Text",
 CellChangeTimes->{{3.8832353391409926`*^9, 3.883235358591131*^9}, {
  3.883235786471593*^9, 3.8832358331209984`*^9}, {3.8835717911930847`*^9, 
  3.883571845625165*^9}},
 Background->RGBColor[
  0.87, 0.94, 1],ExpressionUUID->"313f55c3-4d38-40f1-bed2-bf459b3e6d02"],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Rho]traj", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"KroneckerProduct", "[", 
      RowBox[{"#", ",", 
       RowBox[{"Conjugate", "[", "#", "]"}]}], "]"}], "&"}], "/@", 
    "\[Psi]traj"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.8832231709365435`*^9, 3.883223181077228*^9}},
 CellLabel->"In[18]:=",ExpressionUUID->"461aa31b-48e6-469e-9090-438050568959"],

Cell["Bloch vector trajectory in the interaction-frame:", "Text",
 CellChangeTimes->{{3.8832353391409926`*^9, 3.883235358591131*^9}, {
  3.883235786471593*^9, 3.8832358650320745`*^9}, {3.883571794495301*^9, 
  3.8835718001141405`*^9}, {3.883571831815506*^9, 3.883571847925584*^9}},
 Background->RGBColor[
  0.87, 0.94, 1],ExpressionUUID->"5b7ffbcd-a672-48b5-9d3a-4f421def4fcc"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"blochtraj", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"2", 
       RowBox[{"Tr", "/@", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Sx", ".", "#"}], ",", 
          RowBox[{"Sy", ".", "#"}], ",", 
          RowBox[{"Sz", ".", "#"}]}], "}"}]}]}], ")"}], "&"}], "/@", 
    "\[Rho]traj"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"blochfunc", "=", 
  RowBox[{
   RowBox[{"Transpose", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"Range", "[", 
        RowBox[{"0", ",", 
         RowBox[{
          RowBox[{"Length", "[", "blochtraj", "]"}], "-", "1"}]}], "]"}], "/", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"Length", "[", "blochtraj", "]"}], "-", "1"}], ")"}]}], ",", 
      "blochtraj"}], "}"}], "]"}], "//", "Interpolation"}]}]}], "Input",
 CellChangeTimes->{{3.8832231875801187`*^9, 3.8832232354697676`*^9}, {
  3.8832358544329653`*^9, 3.883235854555521*^9}},
 CellLabel->"In[19]:=",ExpressionUUID->"912f4bde-7a40-4587-9ef8-97b12202297f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox["InterpolatingFunction",
    "SummaryHead"], "[", 
   DynamicModuleBox[{Typeset`open$$ = False, Typeset`embedState$$ = "Ready"}, 
    TemplateBox[{
      PaneSelectorBox[{False -> GridBox[{{
            PaneBox[
             ButtonBox[
              DynamicBox[
               FEPrivate`FrontEndResource["FEBitmaps", "SummaryBoxOpener"]], 
              ButtonFunction :> (Typeset`open$$ = True), Appearance -> None, 
              BaseStyle -> {}, Evaluator -> Automatic, Method -> 
              "Preemptive"], Alignment -> {Center, Center}, ImageSize -> 
             Dynamic[{
               Automatic, 
                3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}]], 
            GraphicsBox[{{
               GrayLevel[0.6], 
               AbsolutePointSize[5], 
               PointBox[{1, 1}], 
               PointBox[{2, 4}], 
               PointBox[{3, 2}], 
               PointBox[{4, 3}]}, {{}, {}, {
                AbsoluteThickness[1], 
                Opacity[1.], 
                LineBox[CompressedData["
1:eJwBMQPO/CFib1JlAgAAADIAAAACAAAA4ScLwZmZ6T/ACPskWpOYv4AjHgZ5
3Os/cnpQh5xu1j/qWn1XCVDuP5K7ih5ptuc/r+pongFN8D/CUK87BHLxP46d
cUQ/bPE/ujUa8/qu9j9TbqBw1aPyP/TWyyAhFfw/neDJZqDG8z+QAqdF9GsA
QM1wGePDAfU/VsVD/9nXAkCidscSKDf2P6Bp73exDQVA/B1wDMFX9z+TpM3k
wfUGQDzjPoyykPg/7M3Z+O7ZCEABSgjW2LT5P3pl9LwNcgpAbCYw0z/T+j86
ypori9cLQL0gflb/Cfw/lpOs9xIqDUCTvMaj8yv9Pw4alcoYNg5AT3Y1d0Bm
/j+pB2LLtyIPQLClAv7Nmv8/NnA5bbjSD0BLO2UnSF0AQFrcILXmpw9AsTLc
klX5AED+sDHBQukOQNp6UGP9igFAbZ+lR/sLDkD10dd20SgCQNHi3Mj38wxA
42MO5MXDAkAZdr6AZb8LQJRGQrZUVANArv7zEMKHCkA4OInLD/EDQLBlMO3M
IglAnnrNRWWDBEA3d8OX6skHQNf3wBnbEgVAD3D3ndNyBkADhMcwfa4FQHOK
7Wak/wRA8WDLrLk/BkC/MhCgYawDQNJM4msi3QZAwss/TmVLAkCGc6iEq3cH
QIsIg92+BgFA/OprAs8HCECrPCvgePD/P2VxQsMepAhAKXVLE0Xg/j+RSBbp
CDYJQPRz0a7WJ/4/kFqZaBPFCUDN4sX5uLj9P4J7LytKYApAvh1MbRmT/T82
7cJSG/EKQHzT1YZwwv0/3W1pvRiOC0B2LZ/10lT+P0c/DY2wIAxAVrX8MJA7
/z+DS2C2aLAMQElWzbMzPQBAsmbGIk1MDUCi9bAadCABQKTSKfTL3Q1AYexd
q+EpAkCJTaAId3sOQFyS/ndEhgNAQAPGdkIWD0BHWcLdahwFQLoJ6Umopg9A
vd1CiejSBkCTjw8wnSEQQPiVkXD08QhAq0KpbbNqEEBsk2Azxi4LQCyTGthZ
shBAYCBYjj+gDUAnaxVkFgARQMwfdA9ySBBAg+uOIqBIEUBj/5rHgMsRQNFn
q5SZmRFAL++xNeOlE0Dwt3AR
                 "]]}}}, AspectRatio -> 1, Axes -> False, Background -> 
             GrayLevel[0.93], Frame -> True, FrameStyle -> Directive[
               GrayLevel[0.7], 
               Thickness[Tiny]], FrameTicks -> None, ImageSize -> 
             Dynamic[{
               Automatic, 
                3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}], PlotRange -> {{0, 5}, {0, 5}}, LabelStyle -> 
             Directive[FontFamily -> "Helvetica", FontSize -> 14]], 
            GridBox[{{
               RowBox[{
                 TagBox["\"Domain: \"", "SummaryItemAnnotation"], 
                 "\[InvisibleSpace]", 
                 TagBox[
                  RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{"0.`", ",", "1.`"}], "}"}], "}"}], 
                  "SummaryItem"]}]}, {
               RowBox[{
                 TagBox["\"Output dimensions: \"", "SummaryItemAnnotation"], 
                 "\[InvisibleSpace]", 
                 TagBox[
                  RowBox[{"{", "3", "}"}], "SummaryItem"]}]}}, 
             GridBoxAlignment -> {
              "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, AutoDelete -> 
             False, GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {"Columns" -> {{2}}, "Rows" -> {{Automatic}}},
              BaseStyle -> {
              ShowStringCharacters -> False, NumberMarks -> False, 
               PrintPrecision -> 3, ShowSyntaxStyles -> False}]}}, 
          GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
          AutoDelete -> False, 
          GridBoxItemSize -> {
           "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
          BaselinePosition -> {1, 1}], True -> GridBox[{{
            PaneBox[
             ButtonBox[
              DynamicBox[
               FEPrivate`FrontEndResource["FEBitmaps", "SummaryBoxCloser"]], 
              ButtonFunction :> (Typeset`open$$ = False), Appearance -> None, 
              BaseStyle -> {}, Evaluator -> Automatic, Method -> 
              "Preemptive"], Alignment -> {Center, Center}, ImageSize -> 
             Dynamic[{
               Automatic, 
                3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}]], 
            GraphicsBox[{{
               GrayLevel[0.6], 
               AbsolutePointSize[5], 
               PointBox[{1, 1}], 
               PointBox[{2, 4}], 
               PointBox[{3, 2}], 
               PointBox[{4, 3}]}, {{}, {}, {
                AbsoluteThickness[1], 
                Opacity[1.], 
                LineBox[CompressedData["
1:eJwBMQPO/CFib1JlAgAAADIAAAACAAAA4ScLwZmZ6T/ACPskWpOYv4AjHgZ5
3Os/cnpQh5xu1j/qWn1XCVDuP5K7ih5ptuc/r+pongFN8D/CUK87BHLxP46d
cUQ/bPE/ujUa8/qu9j9TbqBw1aPyP/TWyyAhFfw/neDJZqDG8z+QAqdF9GsA
QM1wGePDAfU/VsVD/9nXAkCidscSKDf2P6Bp73exDQVA/B1wDMFX9z+TpM3k
wfUGQDzjPoyykPg/7M3Z+O7ZCEABSgjW2LT5P3pl9LwNcgpAbCYw0z/T+j86
ypori9cLQL0gflb/Cfw/lpOs9xIqDUCTvMaj8yv9Pw4alcoYNg5AT3Y1d0Bm
/j+pB2LLtyIPQLClAv7Nmv8/NnA5bbjSD0BLO2UnSF0AQFrcILXmpw9AsTLc
klX5AED+sDHBQukOQNp6UGP9igFAbZ+lR/sLDkD10dd20SgCQNHi3Mj38wxA
42MO5MXDAkAZdr6AZb8LQJRGQrZUVANArv7zEMKHCkA4OInLD/EDQLBlMO3M
IglAnnrNRWWDBEA3d8OX6skHQNf3wBnbEgVAD3D3ndNyBkADhMcwfa4FQHOK
7Wak/wRA8WDLrLk/BkC/MhCgYawDQNJM4msi3QZAwss/TmVLAkCGc6iEq3cH
QIsIg92+BgFA/OprAs8HCECrPCvgePD/P2VxQsMepAhAKXVLE0Xg/j+RSBbp
CDYJQPRz0a7WJ/4/kFqZaBPFCUDN4sX5uLj9P4J7LytKYApAvh1MbRmT/T82
7cJSG/EKQHzT1YZwwv0/3W1pvRiOC0B2LZ/10lT+P0c/DY2wIAxAVrX8MJA7
/z+DS2C2aLAMQElWzbMzPQBAsmbGIk1MDUCi9bAadCABQKTSKfTL3Q1AYexd
q+EpAkCJTaAId3sOQFyS/ndEhgNAQAPGdkIWD0BHWcLdahwFQLoJ6Umopg9A
vd1CiejSBkCTjw8wnSEQQPiVkXD08QhAq0KpbbNqEEBsk2Azxi4LQCyTGthZ
shBAYCBYjj+gDUAnaxVkFgARQMwfdA9ySBBAg+uOIqBIEUBj/5rHgMsRQNFn
q5SZmRFAL++xNeOlE0Dwt3AR
                 "]]}}}, AspectRatio -> 1, Axes -> False, Background -> 
             GrayLevel[0.93], Frame -> True, FrameStyle -> Directive[
               GrayLevel[0.7], 
               Thickness[Tiny]], FrameTicks -> None, ImageSize -> 
             Dynamic[{
               Automatic, 
                3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}], PlotRange -> {{0, 5}, {0, 5}}, LabelStyle -> 
             Directive[FontFamily -> "Helvetica", FontSize -> 14]], 
            GridBox[{{
               RowBox[{
                 TagBox["\"Domain: \"", "SummaryItemAnnotation"], 
                 "\[InvisibleSpace]", 
                 TagBox[
                  RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{"0.`", ",", "1.`"}], "}"}], "}"}], 
                  "SummaryItem"]}]}, {
               RowBox[{
                 TagBox["\"Output dimensions: \"", "SummaryItemAnnotation"], 
                 "\[InvisibleSpace]", 
                 TagBox[
                  RowBox[{"{", "3", "}"}], "SummaryItem"]}]}, {
               RowBox[{
                 TagBox["\"Order: \"", "SummaryItemAnnotation"], 
                 "\[InvisibleSpace]", 
                 TagBox["3", "SummaryItem"]}]}, {
               RowBox[{
                 TagBox["\"Method: \"", "SummaryItemAnnotation"], 
                 "\[InvisibleSpace]", 
                 TagBox["\"Hermite\"", "SummaryItem"]}]}, {
               RowBox[{
                 TagBox["\"Periodic: \"", "SummaryItemAnnotation"], 
                 "\[InvisibleSpace]", 
                 TagBox["False", "SummaryItem"]}]}}, 
             GridBoxAlignment -> {
              "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, AutoDelete -> 
             False, GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {"Columns" -> {{2}}, "Rows" -> {{Automatic}}},
              BaseStyle -> {
              ShowStringCharacters -> False, NumberMarks -> False, 
               PrintPrecision -> 3, ShowSyntaxStyles -> False}]}}, 
          GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
          AutoDelete -> False, 
          GridBoxItemSize -> {
           "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
          BaselinePosition -> {1, 1}]}, 
       Dynamic[Typeset`open$$], ImageSize -> Automatic]},
     "SummaryPanel"],
    DynamicModuleValues:>{}], "]"}],
  InterpolatingFunction[{{0., 1.}}, {
   5, 3, 0, {161}, {4}, 0, 0, 0, 0, Automatic, {}, {}, False}, CompressedData["
1:eJxFy0tqU3EcBeDoTroGF3D34BIEnTp2CY4d1ZEiFAQHiiKKIlWrrZpqmqZp
mqbpfb8fLsE+PvDA5fI/5/tt3Ll/++7N0Wh04+J7Ovqfx5uXeRBc/x8Gt67y
yHszuFZP9M+Ce1fZsj8P9seXecG91L/iX9vfuHvLvePecx+4j9wnblu/zX+2
f3H3ldvhdrhv3Hdul9vj9rgf3E/uFzfmxtw+95v7w030E35iP3B3wE25KTfl
DrlDbsbNuBl3xB1xc27Ozblj7phbcAtuwZ1wJ9ySW3JL7pQ75VbciltxZ9wZ
t+bW3Jo75865UB/yoT10F3IRF3ERF3ERF3MxF3MxF3MJl3AJl3AJl3Ipl3Ip
l3IZl3EZl3EZl3M5l3M5l3MFV3AFV3AFV3IlV3IlV3IVV3EVV3EVV3M1V3M1
V3MN13AN13AN13It13It13Id13Ed13Ed13M913M913MDN3ADN3AD9zf4B9BN
L50=
   "], {{{0., 
      Complex[0., 0.], -0.9999999999999982}}, {{
      Complex[-1.3877787807814446`*^-17, 0.], 
      Complex[-4.3410175220943695`*^-34, 0.], 
      Complex[-0.9999999999999984, 0.]}}, {{
      Complex[0., 0.], 
      Complex[0., 0.], 
      Complex[-0.9999999999999987, 0.]}}, {{
      Complex[-0.20791169081775893`, 0.], 
      Complex[-5.736736302150985*^-17, 0.], 
      Complex[-0.9781476007338034, 0.]}}, {{
      Complex[-0.2079116908177589, 0.], 
      Complex[-3.902408595516517*^-17, 0.], 
      Complex[-0.978147600733804, 0.]}}, {{
      Complex[-0.20791169081775893`, 0.], 
      Complex[6.684640652972858*^-18, 0.], 
      Complex[-0.9781476007338034, 0.]}}, {{
      Complex[-0.2079116908177586, 0.], 
      Complex[-3.228314184092313*^-17, 0.], 
      Complex[-0.9781476007338018, 0.]}}, {{
      Complex[-0.20791169081775837`, 0.], 
      Complex[2.274934707085154*^-17, 0.], 
      Complex[-0.9781476007338018, 0.]}}, {{
      Complex[-0.40673664307579827`, 0.], 
      Complex[0., 0.], 
      Complex[-0.9135454576425963, 0.]}}, {{
      Complex[-0.40673664307579815`, 0.], 
      Complex[-3.321497353728315*^-17, 0.], 
      Complex[-0.9135454576425966, 0.]}}, {{
      Complex[-0.4067366430757986, 0.], 
      Complex[1.33121710569081*^-16, 0.], 
      Complex[-0.913545457642597, 0.]}}, {{
      Complex[-0.40673664307579754`, 0.], 
      Complex[1.1323547312902138`*^-16, 0.], 
      Complex[-0.9135454576425956, 0.]}}, {{
      Complex[-0.4067366430757979, 0.], 
      Complex[-5.701914674272858*^-17, 0.], 
      Complex[-0.9135454576425959, 0.]}}, {{
      Complex[-0.4067366430757976, 0.], 
      Complex[-6.600315196502495*^-17, 0.], 
      Complex[-0.9135454576425954, 0.]}}, {{
      Complex[-0.587785252292469, 0.], 
      Complex[6.863675431371528*^-17, 0.], 
      Complex[-0.8090169943749426, 0.]}}, {{
      Complex[-0.5877852522924691, 0.], 
      Complex[1.1693960880323752`*^-16, 0.], 
      Complex[-0.8090169943749423, 0.]}}, {{
      Complex[-0.5877852522924681, 0.], 
      Complex[0., 0.], 
      Complex[-0.8090169943749408, 0.]}}, {{
      Complex[-0.5877852522924687, 0.], 
      Complex[9.422221401021392*^-17, 0.], 
      Complex[-0.8090169943749412, 0.]}}, {{
      Complex[-0.5877852522924686, 0.], 
      Complex[8.016959636234339*^-17, 0.], 
      Complex[-0.8090169943749409, 0.]}}, {{
      Complex[-0.7431448254773869, 0.], 
      Complex[-5.4687701965764926`*^-17, 0.], 
      Complex[-0.6691306063588516, 0.]}}, {{
      Complex[-0.7431448254773879, 0.], 
      Complex[-1.774471185050982*^-16, 0.], 
      Complex[-0.6691306063588522, 0.]}}, {{
      Complex[-0.7431448254773871, 0.], 
      Complex[3.592842865459328*^-17, 0.], 
      Complex[-0.6691306063588518, 0.]}}, {{
      Complex[-0.7431448254773867, 0.], 
      Complex[-1.1565847182563855`*^-16, 0.], 
      Complex[-0.6691306063588511, 0.]}}, {{
      Complex[-0.7431448254773869, 0.], 
      Complex[8.737952058142546*^-17, 0.], 
      Complex[-0.6691306063588515, 0.]}}, {{
      Complex[-0.8660254037844285, 0.], 
      Complex[0., 0.], 
      Complex[-0.499999999999994, 0.]}}, {{
      Complex[-0.866025403784429, 0.], 
      Complex[1.007873697527822*^-16, 0.], 
      Complex[-0.4999999999999946, 0.]}}, {{
      Complex[-0.8660254037844289, 0.], 
      Complex[-2.949029909160556*^-17, 0.], 
      Complex[-0.49999999999999395`, 0.]}}, {{
      Complex[-0.8660254037844275, 0.], 
      Complex[1.8090048955815982`*^-17, 0.], 
      Complex[-0.4999999999999933, 0.]}}, {{
      Complex[-0.8660254037844279, 0.], 
      Complex[-4.1972739424863187`*^-16, 0.], 
      Complex[-0.49999999999999406`, 0.]}}, {{
      Complex[-0.8660254037844278, 0.], 
      Complex[-4.092184661655472*^-18, 0.], 
      Complex[-0.49999999999999356`, 0.]}}, {{
      Complex[-0.9510565162951405, 0.], 
      Complex[-6.455735553989477*^-17, 0.], 
      Complex[-0.309016994374943, 0.]}}, {{
      Complex[-0.9510565162951401, 0.], 
      Complex[1.5812386359276514`*^-16, 0.], 
      Complex[-0.3090169943749433, 0.]}}, {{
      Complex[-0.951056516295139, 0.], 
      Complex[0., 0.], 
      Complex[-0.3090169943749428, 0.]}}, {{
      Complex[-0.9510565162951392, 0.], 
      Complex[4.056034413899576*^-18, 0.], 
      Complex[-0.3090169943749428, 0.]}}, {{
      Complex[-0.9510565162951387, 0.], 
      Complex[1.1317546541008066`*^-17, 0.], 
      Complex[-0.30901699437494234`, 0.]}}, {{
      Complex[-0.994521895368257, 0.], 
      Complex[-2.5423876586724014`*^-17, 0.], 
      Complex[-0.10452846326765214`, 0.]}}, {{
      Complex[-0.9945218953682579, 0.], 
      Complex[9.02301367560496*^-17, 0.], 
      Complex[-0.10452846326765214`, 0.]}}, {{
      Complex[-0.9945218953682577, 0.], 
      Complex[1.1977122103247526`*^-17, 0.], 
      Complex[-0.1045284632676517, 0.]}}, {{
      Complex[-0.9945218953682565, 0.], 
      Complex[1.426394553318144*^-16, 0.], 
      Complex[-0.10452846326765158`, 0.]}}, {{
      Complex[-0.9945218953682562, 0.], 
      Complex[4.589585107918317*^-17, 0.], 
      Complex[-0.10452846326765192`, 0.]}}, {{
      Complex[-0.9945218953682551, 0.], 
      Complex[0., 0.], 
      Complex[0.1045284632676517, 0.]}}, {{
      Complex[-0.9945218953682553, 0.], 
      Complex[-8.868940631451727*^-17, 0.], 
      Complex[0.10452846326765125`, 0.]}}, {{
      Complex[-0.9945218953682554, 0.], 
      Complex[2.088320080382301*^-17, 0.], 
      Complex[0.10452846326765136`, 0.]}}, {{
      Complex[-0.994521895368254, 0.], 
      Complex[-7.00305768911008*^-17, 0.], 
      Complex[0.10452846326765147`, 0.]}}, {{
      Complex[-0.9945218953682546, 0.], 
      Complex[5.2676524463079214`*^-17, 0.], 
      Complex[0.10452846326765125`, 0.]}}, {{
      Complex[-0.9945218953682543, 0.], 
      Complex[-8.068208703816885*^-17, 0.], 
      Complex[0.10452846326765153`, 0.]}}, {{
      Complex[-0.9510565162951342, 0.], 
      Complex[6.336144703590636*^-18, 0.], 
      Complex[0.3090169943749407, 0.]}}, {{
      Complex[-0.951056516295134, 0.], 
      Complex[-8.065339810796718*^-17, 0.], 
      Complex[0.30901699437494085`, 0.]}}, {{
      Complex[-0.9510565162951332, 0.], 
      Complex[0., 0.], 
      Complex[0.3090169943749405, 0.]}}, {{
      Complex[-0.9510565162951335, 0.], 
      Complex[5.089718812916557*^-16, 0.], 
      Complex[0.3090169943749406, 0.]}}, {{
      Complex[-0.951056516295133, 0.], 
      Complex[-2.879610362857186*^-16, 0.], 
      Complex[0.309016994374941, 0.]}}, {{
      Complex[-0.8660254037844192, 0.], 
      Complex[-6.967795261595128*^-18, 0.], 
      Complex[0.4999999999999886, 0.]}}, {{
      Complex[-0.8660254037844197, 0.], 
      Complex[-4.057918037254396*^-17, 0.], 
      Complex[0.49999999999998856`, 0.]}}, {{
      Complex[-0.8660254037844193, 0.], 
      Complex[2.100350302463202*^-17, 0.], 
      Complex[0.4999999999999885, 0.]}}, {{
      Complex[-0.866025403784419, 0.], 
      Complex[-3.010409469011875*^-17, 0.], 
      Complex[0.49999999999998795`, 0.]}}, {{
      Complex[-0.8660254037844188, 0.], 
      Complex[3.315103841206381*^-17, 0.], 
      Complex[0.499999999999988, 0.]}}, {{
      Complex[-0.7431448254773759, 0.], 
      Complex[0., 0.], 
      Complex[0.6691306063588413, 0.]}}, {{
      Complex[-0.7431448254773761, 0.], 
      Complex[1.1195162704803691`*^-16, 0.], 
      Complex[0.6691306063588411, 0.]}}, {{
      Complex[-0.743144825477376, 0.], 
      Complex[4.594071217145032*^-17, 0.], 
      Complex[0.6691306063588415, 0.]}}, {{
      Complex[-0.743144825477375, 0.], 
      Complex[7.933810639039411*^-17, 0.], 
      Complex[0.6691306063588405, 0.]}}, {{
      Complex[-0.7431448254773757, 0.], 
      Complex[1.7498274961432818`*^-16, 0.], 
      Complex[0.6691306063588411, 0.]}}, {{
      Complex[-0.7431448254773754, 0.], 
      Complex[-1.1468623404283218`*^-17, 0.], 
      Complex[0.6691306063588413, 0.]}}, {{
      Complex[-0.5877852522924579, 0.], 
      Complex[-1.1972893445020075`*^-16, 0.], 
      Complex[0.8090169943749254, 0.]}}, {{
      Complex[-0.5877852522924574, 0.], 
      Complex[-7.3643003081734*^-17, 0.], 
      Complex[0.8090169943749247, 0.]}}, {{
      Complex[-0.5877852522924567, 0.], 
      Complex[0., 0.], 
      Complex[0.8090169943749241, 0.]}}, {{
      Complex[-0.5877852522924568, 0.], 
      Complex[3.918985090101559*^-17, 0.], 
      Complex[0.8090169943749244, 0.]}}, {{
      Complex[-0.5877852522924573, 0.], 
      Complex[-3.116411099042737*^-17, 0.], 
      Complex[0.809016994374925, 0.]}}, {{
      Complex[-0.40673664307578894`, 0.], 
      Complex[2.4787999920939338`*^-17, 0.], 
      Complex[0.9135454576425741, 0.]}}, {{
      Complex[-0.4067366430757892, 0.], 
      Complex[-1.4899115937270954`*^-16, 0.], 
      Complex[0.913545457642574, 0.]}}, {{
      Complex[-0.4067366430757892, 0.], 
      Complex[3.442856133379427*^-17, 0.], 
      Complex[0.9135454576425742, 0.]}}, {{
      Complex[-0.40673664307578833`, 0.], 
      Complex[1.2777712530919246`*^-16, 0.], 
      Complex[0.9135454576425728, 0.]}}, {{
      Complex[-0.40673664307578855`, 0.], 
      Complex[8.311824390409688*^-17, 0.], 
      Complex[0.9135454576425728, 0.]}}, {{
      Complex[-0.20791169081775357`, 0.], 
      Complex[0., 0.], 
      Complex[0.9781476007337744, 0.]}}, {{
      Complex[-0.20791169081775346`, 0.], 
      Complex[-3.664908920555625*^-17, 0.], 
      Complex[0.9781476007337746, 0.]}}, {{
      Complex[-0.2079116908177536, 0.], 
      Complex[6.006799748835311*^-17, 0.], 
      Complex[0.9781476007337744, 0.]}}, {{
      Complex[-0.20791169081775315`, 0.], 
      Complex[-5.3468811470038225`*^-17, 0.], 
      Complex[0.9781476007337734, 0.]}}, {{
      Complex[-0.20791169081775324`, 0.], 
      Complex[-6.84471022125038*^-17, 0.], 
      Complex[0.9781476007337742, 0.]}}, {{
      Complex[-0.2079116908177533, 0.], 
      Complex[-9.713017793131006*^-18, 0.], 
      Complex[0.9781476007337738, 0.]}}, {{
      Complex[-4.3021142204224106`*^-16, 0.], 
      Complex[-1.7347234759767785`*^-16, 0.], 
      Complex[0.9999999999999669, 0.]}}, {{
      Complex[-1.942890293093992*^-16, 0.], 
      Complex[-2.7061686225237727`*^-16, 0.], 
      Complex[0.9999999999999662, 0.]}}, {{
      Complex[0., 0.], 
      Complex[0., 0.], 
      Complex[0.9999999999999656, 0.]}}, {{
      Complex[0.030591116640972846`, 0.], 
      Complex[-0.07395484122240008, 0.], 
      Complex[0.9967922878124391, 0.]}}, {{
      Complex[0.030591116640973005`, 0.], 
      Complex[-0.0739548412224002, 0.], 
      Complex[0.9967922878124404, 0.]}}, {{
      Complex[0.030591116640972405`, 0.], 
      Complex[-0.07395484122240015, 0.], 
      Complex[0.9967922878124393, 0.]}}, {{
      Complex[-0.14644471703669157`, 0.], 
      Complex[-0.14738611957262238`, 0.], 
      Complex[0.9781775281661786, 0.]}}, {{
      Complex[-0.14644471703669146`, 0.], 
      Complex[-0.14738611957262235`, 0.], 
      Complex[0.9781775281661789, 0.]}}, {{
      Complex[-0.11661952955689116`, 0.], 
      Complex[-0.21948930659857835`, 0.], 
      Complex[0.9686198065364596, 0.]}}, {{
      Complex[-0.11661952955689113`, 0.], 
      Complex[-0.21948930659857854`, 0.], 
      Complex[0.9686198065364601, 0.]}}, {{
      Complex[-0.11661952955689125`, 0.], 
      Complex[-0.2194893065985784, 0.], 
      Complex[0.9686198065364592, 0.]}}, {{
      Complex[-0.28534699836215754`, 0.], 
      Complex[-0.2894744246946508, 0.], 
      Complex[0.9136638593997956, 0.]}}, {{
      Complex[-0.28534699836215754`, 0.], 
      Complex[-0.28947442469465096`, 0.], 
      Complex[0.9136638593997958, 0.]}}, {{
      Complex[-0.2853469983621571, 0.], 
      Complex[-0.2894744246946506, 0.], 
      Complex[0.9136638593997952, 0.]}}, {{
      Complex[-0.25759124385352555`, 0.], 
      Complex[-0.35657470226165056`, 0.], 
      Complex[0.8980541368965055, 0.]}}, {{
      Complex[-0.25759124385352544`, 0.], 
      Complex[-0.3565747022616505, 0.], 
      Complex[0.8980541368965059, 0.]}}, {{
      Complex[-0.4106361477553795, 0.], 
      Complex[-0.42005497461691826`, 0.], 
      Complex[0.8092785505968374, 0.]}}, {{
      Complex[-0.41063614775537954`, 0.], 
      Complex[-0.42005497461691815`, 0.], 
      Complex[0.8092785505968374, 0.]}}, {{
      Complex[-0.41063614775537877`, 0.], 
      Complex[-0.42005497461691815`, 0.], 
      Complex[0.8092785505968371, 0.]}}, {{
      Complex[-0.3861628858768296, 0.], 
      Complex[-0.4792197386124283, 0.], 
      Complex[0.7881793372674945, 0.]}}, {{
      Complex[-0.38616288587682995`, 0.], 
      Complex[-0.47921973861242895`, 0.], 
      Complex[0.7881793372674956, 0.]}}, {{
      Complex[-0.38616288587682934`, 0.], 
      Complex[-0.4792197386124288, 0.], 
      Complex[0.7881793372674947, 0.]}}, {{
      Complex[-0.5168364281838329, 0.], 
      Complex[-0.5334207727128241, 0.], 
      Complex[0.6695837406482786, 0.]}}, {{
      Complex[-0.5168364281838324, 0.], 
      Complex[-0.5334207727128243, 0.], 
      Complex[0.6695837406482792, 0.]}}, {{
      Complex[-0.49671525791519744`, 0.], 
      Complex[-0.5820642390462052, 0.], 
      Complex[0.6437974636309995, 0.]}}, {{
      Complex[-0.49671525791519755`, 0.], 
      Complex[-0.5820642390462054, 0.], 
      Complex[0.6437974636309998, 0.]}}, {{
      Complex[-0.4967152579151971, 0.], 
      Complex[-0.5820642390462054, 0.], 
      Complex[0.6437974636310002, 0.]}}, {{
      Complex[-0.5993063777873081, 0.], 
      Complex[-0.6246171896161231, 0.], 
      Complex[0.5006847630789435, 0.]}}, {{
      Complex[-0.5993063777873082, 0.], 
      Complex[-0.6246171896161238, 0.], 
      Complex[0.5006847630789429, 0.]}}, {{
      Complex[-0.5993063777873078, 0.], 
      Complex[-0.6246171896161234, 0.], 
      Complex[0.5006847630789427, 0.]}}, {{
      Complex[-0.584416690821415, 0.], 
      Complex[-0.6606134053913573, 0.], 
      Complex[0.47121869668603256`, 0.]}}, {{
      Complex[-0.5844166908214145, 0.], 
      Complex[-0.6606134053913582, 0.], 
      Complex[0.47121869668603356`, 0.]}}, {{
      Complex[-0.6544416640334105, 0.], 
      Complex[-0.6896585042991821, 0.], 
      Complex[0.3099633136758234, 0.]}}, {{
      Complex[-0.6544416640334108, 0.], 
      Complex[-0.6896585042991821, 0.], 
      Complex[0.3099633136758231, 0.]}}, {{
      Complex[-0.65444166403341, 0.], 
      Complex[-0.689658504299182, 0.], 
      Complex[0.3099633136758227, 0.]}}, {{
      Complex[-0.6454342111393123, 0.], 
      Complex[-0.7114342621578836, 0.], 
      Complex[0.277985556672892, 0.]}}, {{
      Complex[-0.6454342111393128, 0.], 
      Complex[-0.711434262157885, 0.], 
      Complex[0.2779855566728925, 0.]}}, {{
      Complex[-0.6454342111393121, 0.], 
      Complex[-0.7114342621578841, 0.], 
      Complex[0.27798555667289315`, 0.]}}, {{
      Complex[-0.6798326103447272, 0.], 
      Complex[-0.7257020992074935, 0.], 
      Complex[0.105754834960887, 0.]}}, {{
      Complex[-0.679832610344728, 0.], 
      Complex[-0.7257020992074952, 0.], 
      Complex[0.10575483496088733`, 0.]}}, {{
      Complex[-0.6771010604364524, 0.], 
      Complex[-0.7323056940395606, 0.], 
      Complex[0.07254325904563275, 0.]}}, {{
      Complex[-0.6771010604364526, 0.], 
      Complex[-0.7323056940395611, 0.], 
      Complex[0.07254325904563341, 0.]}}, {{
      Complex[-0.6771010604364516, 0.], 
      Complex[-0.7323056940395609, 0.], 
      Complex[0.07254325904563363, 0.]}}, {{
      Complex[-0.6743695105281781, 0.], 
      Complex[-0.7311726962872119, 0.], 
      Complex[-0.10301578264502032`, 0.]}}, {{
      Complex[-0.6743695105281778, 0.], 
      Complex[-0.731172696287212, 0.], 
      Complex[-0.10301578264502081`, 0.]}}, {{
      Complex[-0.6743695105281772, 0.], 
      Complex[-0.7311726962872118, 0.], 
      Complex[-0.10301578264502081`, 0.]}}, {{
      Complex[-0.6780332454441468, 0.], 
      Complex[-0.7223155193109156, 0.], 
      Complex[-0.13612938196791619`, 0.]}}, {{
      Complex[-0.6780332454441473, 0.], 
      Complex[-0.722315519310917, 0.], 
      Complex[-0.13612938196791435`, 0.]}}, {{
      Complex[-0.6382911282606047, 0.], 
      Complex[-0.7058312041951116, 0.], 
      Complex[-0.3072242613599526, 0.]}}, {{
      Complex[-0.6382911282606052, 0.], 
      Complex[-0.7058312041951122, 0.], 
      Complex[-0.30722426135995434`, 0.]}}, {{
      Complex[-0.6382911282606041, 0.], 
      Complex[-0.7058312041951116, 0.], 
      Complex[-0.3072242613599542, 0.]}}, {{
      Complex[-0.6481900252044402, 0.], 
      Complex[-0.68190035654577, 0.], 
      Complex[-0.33891237063303364`, 0.]}}, {{
      Complex[-0.6481900252044414, 0.], 
      Complex[-0.6819003565457712, 0.], 
      Complex[-0.3389123706330329, 0.]}}, {{
      Complex[-0.6481900252044397, 0.], 
      Complex[-0.6819003565457704, 0.], 
      Complex[-0.3389123706330325, 0.]}}, {{
      Complex[-0.5731742619703872, 0.], 
      Complex[-0.6507851677375887, 0.], 
      Complex[-0.49794571076307176`, 0.]}}, {{
      Complex[-0.5731742619703877, 0.], 
      Complex[-0.6507851677375901, 0.], 
      Complex[-0.49794571076307137`, 0.]}}, {{
      Complex[-0.5888756916454663, 0.], 
      Complex[-0.6128265422904257, 0.], 
      Complex[-0.5269431172843173, 0.]}}, {{
      Complex[-0.5888756916454665, 0.], 
      Complex[-0.6128265422904262, 0.], 
      Complex[-0.5269431172843172, 0.]}}, {{
      Complex[-0.5888756916454657, 0.], 
      Complex[-0.6128265422904259, 0.], 
      Complex[-0.5269431172843156, 0.]}}, {{
      Complex[-0.4818648311798018, 0.], 
      Complex[-0.5684403628480292, 0.], 
      Complex[-0.6668446883324012, 0.]}}, {{
      Complex[-0.4818648311798017, 0.], 
      Complex[-0.5684403628480295, 0.], 
      Complex[-0.6668446883324024, 0.]}}, {{
      Complex[-0.4818648311798009, 0.], 
      Complex[-0.5684403628480291, 0.], 
      Complex[-0.6668446883324021, 0.]}}, {{
      Complex[-0.5026825657655027, 0.], 
      Complex[-0.5181129336807757, 0.], 
      Complex[-0.6920037760214773, 0.]}}, {{
      Complex[-0.5026825657655031, 0.], 
      Complex[-0.5181129336807768, 0.], 
      Complex[-0.6920037760214754, 0.]}}, {{
      Complex[-0.3683534961656558, 0.], 
      Complex[-0.4623956526343168, 0.], 
      Complex[-0.8065394982809527, 0.]}}, {{
      Complex[-0.3683534961656558, 0.], 
      Complex[-0.46239565263431687`, 0.], 
      Complex[-0.8065394982809543, 0.]}}, {{
      Complex[-0.3683534961656555, 0.], 
      Complex[-0.46239565263431676`, 0.], 
      Complex[-0.8065394982809542, 0.]}}, {{
      Complex[-0.3933777007660113, 0.], 
      Complex[-0.4018989698993848, 0.], 
      Complex[-0.8268804040087818, 0.]}}, {{
      Complex[-0.39337770076601203`, 0.], 
      Complex[-0.40189896989938445`, 0.], 
      Complex[-0.8268804040087812, 0.]}}, {{
      Complex[-0.39337770076601136`, 0.], 
      Complex[-0.40189896989938445`, 0.], 
      Complex[-0.82688040400878, 0.]}}, {{
      Complex[-0.23760124695588605`, 0.], 
      Complex[-0.33728569979176776`, 0.], 
      Complex[-0.9109248070839051, 0.]}}, {{
      Complex[-0.2376012469558863, 0.], 
      Complex[-0.33728569979176914`, 0.], 
      Complex[-0.9109248070839066, 0.]}}, {{
      Complex[-0.2657382437504048, 0.], 
      Complex[-0.2692637588199643, 0.], 
      Complex[-0.9256782453933212, 0.]}}, {{
      Complex[-0.2657382437504048, 0.], 
      Complex[-0.26926375881996467`, 0.], 
      Complex[-0.92567824539332, 0.]}}, {{
      Complex[-0.26573824375040467`, 0.], 
      Complex[-0.26926375881996456`, 0.], 
      Complex[-0.9256782453933189, 0.]}}, {{
      Complex[-0.09532258425986345, 0.], 
      Complex[-0.19857840960376524`, 0.], 
      Complex[-0.9754384758502802, 0.]}}, {{
      Complex[-0.09532258425986334, 0.], 
      Complex[-0.19857840960376522`, 0.], 
      Complex[-0.975438475850283, 0.]}}, {{
      Complex[-0.09532258425986326, 0.], 
      Complex[-0.19857840960376522`, 0.], 
      Complex[-0.9754384758502813, 0.]}}, {{
      Complex[-0.1253426514723326, 0.], 
      Complex[-0.12600409562104345`, 0.], 
      Complex[-0.9840793604219449, 0.]}}, {{
      Complex[-0.12534265147233328`, 0.], 
      Complex[-0.12600409562104362`, 0.], 
      Complex[-0.9840793604219424, 0.]}}, {{
      Complex[0.05226423163382101, 0.], 
      Complex[-0.05233595624294449, 0.], 
      Complex[-0.9972609476840595, 0.]}}, {{
      Complex[0.05226423163382389, 0.], 
      Complex[-0.052335956242944195`, 0.], 
      Complex[-0.9972609476840656, 0.]}}, {{
      Complex[0.052264231633824654`, 0.], 
      Complex[-0.05233595624294154, 0.], 
      Complex[-0.9972609476840677, 0.]}}}, {Automatic}],
  Editable->False,
  SelectWithContents->True,
  Selectable->False]], "Output",
 CellChangeTimes->{{3.883235854947363*^9, 3.8832358809666057`*^9}, 
   3.8832360789401083`*^9, 3.883236160265651*^9, 3.8832365275979443`*^9, 
   3.8832366207650948`*^9, 3.8832522130126514`*^9, 3.88339297755591*^9, 
   3.8833939379669447`*^9, 3.8833951378810153`*^9, 3.883404996935145*^9, {
   3.8834732280623627`*^9, 3.8834732519588227`*^9}, 3.8834735584410343`*^9, 
   3.883479809334108*^9, 3.8834891309222994`*^9, 3.8834894474262147`*^9, 
   3.883489710671291*^9, 3.8835722539398427`*^9},
 CellLabel->"Out[20]=",ExpressionUUID->"d78285d3-4e5f-47d6-b02a-acd5896299f9"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Graphical representation of the trajectory", "Subsection",
 CellChangeTimes->{{3.882622104181368*^9, 3.882622114902437*^9}, {
  3.8832236458871455`*^9, 3.8832236603732576`*^9}, {3.883223768738858*^9, 
  3.8832237691970997`*^9}, {3.8832353223432503`*^9, 3.8832353307614293`*^9}, {
  3.88323576898199*^9, 3.883235780494172*^9}, {3.8835718603787947`*^9, 
  3.8835718650260963`*^9}},ExpressionUUID->"739d992f-6626-47eb-a5ea-\
012ab706f92a"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"SphereAndAxes", "[", "]"}], ",", "\[IndentingNewLine]", 
   RowBox[{"ParametricPlot3D", "[", 
    RowBox[{
     RowBox[{"blochfunc", "[", "t", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", 
       RowBox[{"1", "/", "2"}]}], "}"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", "Black"}]}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"ParametricPlot3D", "[", 
    RowBox[{
     RowBox[{"blochfunc", "[", "t", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", 
       RowBox[{"1", "/", "2"}], ",", "1"}], "}"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", "Red"}]}], "]"}]}], 
  "\[IndentingNewLine]", "]"}]], "Input",
 CellChangeTimes->{{3.8832232719504943`*^9, 3.883223305629486*^9}, {
  3.883223381314438*^9, 3.883223381806923*^9}, {3.883223442672087*^9, 
  3.8832234431596093`*^9}, {3.8832238993251615`*^9, 3.883223988733548*^9}, {
  3.883224223888286*^9, 3.883224228487333*^9}, {3.883224541906819*^9, 
  3.8832245422838845`*^9}, {3.8832250971633434`*^9, 3.8832251081718607`*^9}, {
  3.8832358679432735`*^9, 3.8832358725034757`*^9}, {3.883479416728977*^9, 
  3.8834794491157346`*^9}, {3.883479834356019*^9, 3.8834798813360815`*^9}},
 CellLabel->"In[21]:=",ExpressionUUID->"b177b0f7-726e-44ba-aba2-7df6d40f6cea"],

Cell[BoxData[
 Graphics3DBox[{
   {Opacity[0.1], EdgeForm[None], 
    Polygon3DBox[
     NCache[{{0, 1, 0}, {
       0, Cos[Rational[1, 50] Pi], Sin[Rational[1, 50] Pi]}, {
       0, Cos[Rational[1, 25] Pi], Sin[Rational[1, 25] Pi]}, {
       0, Cos[Rational[3, 50] Pi], Sin[Rational[3, 50] Pi]}, {
       0, Cos[Rational[2, 25] Pi], Sin[Rational[2, 25] Pi]}, {
       0, (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
        Rational[1, 4] (-1 + 5^Rational[1, 2])}, {
       0, Cos[Rational[3, 25] Pi], Sin[Rational[3, 25] Pi]}, {
       0, Cos[Rational[7, 50] Pi], Sin[Rational[7, 50] Pi]}, {
       0, Cos[Rational[4, 25] Pi], Sin[Rational[4, 25] Pi]}, {
       0, Cos[Rational[9, 50] Pi], Sin[Rational[9, 50] Pi]}, {
       0, Rational[1, 4] (1 + 5^Rational[1, 2]), (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2]}, {
       0, Cos[Rational[11, 50] Pi], Sin[Rational[11, 50] Pi]}, {
       0, Cos[Rational[6, 25] Pi], Sin[Rational[6, 25] Pi]}, {
       0, Sin[Rational[6, 25] Pi], Cos[Rational[6, 25] Pi]}, {
       0, Sin[Rational[11, 50] Pi], Cos[Rational[11, 50] Pi]}, {
       0, (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
        Rational[1, 4] (1 + 5^Rational[1, 2])}, {
       0, Sin[Rational[9, 50] Pi], Cos[Rational[9, 50] Pi]}, {
       0, Sin[Rational[4, 25] Pi], Cos[Rational[4, 25] Pi]}, {
       0, Sin[Rational[7, 50] Pi], Cos[Rational[7, 50] Pi]}, {
       0, Sin[Rational[3, 25] Pi], Cos[Rational[3, 25] Pi]}, {
       0, Rational[1, 4] (-1 + 5^Rational[1, 2]), (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2]}, {
       0, Sin[Rational[2, 25] Pi], Cos[Rational[2, 25] Pi]}, {
       0, Sin[Rational[3, 50] Pi], Cos[Rational[3, 50] Pi]}, {
       0, Sin[Rational[1, 25] Pi], Cos[Rational[1, 25] Pi]}, {
       0, Sin[Rational[1, 50] Pi], Cos[Rational[1, 50] Pi]}, {0, 0, 1}, {
       0, -Sin[Rational[1, 50] Pi], Cos[Rational[1, 50] Pi]}, {
       0, -Sin[Rational[1, 25] Pi], Cos[Rational[1, 25] Pi]}, {
       0, -Sin[Rational[3, 50] Pi], Cos[Rational[3, 50] Pi]}, {
       0, -Sin[Rational[2, 25] Pi], Cos[Rational[2, 25] Pi]}, {
       0, 
        Rational[1, 4] (1 - 5^Rational[1, 2]), (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2]}, {
       0, -Sin[Rational[3, 25] Pi], Cos[Rational[3, 25] Pi]}, {
       0, -Sin[Rational[7, 50] Pi], Cos[Rational[7, 50] Pi]}, {
       0, -Sin[Rational[4, 25] Pi], Cos[Rational[4, 25] Pi]}, {
       0, -Sin[Rational[9, 50] Pi], Cos[Rational[9, 50] Pi]}, {
       0, -(Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2],
         Rational[1, 4] (1 + 5^Rational[1, 2])}, {
       0, -Sin[Rational[11, 50] Pi], Cos[Rational[11, 50] Pi]}, {
       0, -Sin[Rational[6, 25] Pi], Cos[Rational[6, 25] Pi]}, {
       0, -Cos[Rational[6, 25] Pi], Sin[Rational[6, 25] Pi]}, {
       0, -Cos[Rational[11, 50] Pi], Sin[Rational[11, 50] Pi]}, {
       0, Rational[1, 4] (-1 - 5^Rational[1, 2]), (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2]}, {
       0, -Cos[Rational[9, 50] Pi], Sin[Rational[9, 50] Pi]}, {
       0, -Cos[Rational[4, 25] Pi], Sin[Rational[4, 25] Pi]}, {
       0, -Cos[Rational[7, 50] Pi], Sin[Rational[7, 50] Pi]}, {
       0, -Cos[Rational[3, 25] Pi], Sin[Rational[3, 25] Pi]}, {
       0, -(Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
        Rational[1, 4] (-1 + 5^Rational[1, 2])}, {
       0, -Cos[Rational[2, 25] Pi], Sin[Rational[2, 25] Pi]}, {
       0, -Cos[Rational[3, 50] Pi], Sin[Rational[3, 50] Pi]}, {
       0, -Cos[Rational[1, 25] Pi], Sin[Rational[1, 25] Pi]}, {
       0, -Cos[Rational[1, 50] Pi], Sin[Rational[1, 50] Pi]}, {0, -1, 0}, {
       0, -Cos[Rational[1, 50] Pi], -Sin[Rational[1, 50] Pi]}, {
       0, -Cos[Rational[1, 25] Pi], -Sin[Rational[1, 25] Pi]}, {
       0, -Cos[Rational[3, 50] Pi], -Sin[Rational[3, 50] Pi]}, {
       0, -Cos[Rational[2, 25] Pi], -Sin[Rational[2, 25] Pi]}, {
       0, -(Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
        Rational[1, 4] (1 - 5^Rational[1, 2])}, {
       0, -Cos[Rational[3, 25] Pi], -Sin[Rational[3, 25] Pi]}, {
       0, -Cos[Rational[7, 50] Pi], -Sin[Rational[7, 50] Pi]}, {
       0, -Cos[Rational[4, 25] Pi], -Sin[Rational[4, 25] Pi]}, {
       0, -Cos[Rational[9, 50] Pi], -Sin[Rational[9, 50] Pi]}, {
       0, Rational[1, 4] (-1 - 5^
         Rational[1, 2]), -(Rational[5, 8] + 
          Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2]}, {
       0, -Cos[Rational[11, 50] Pi], -Sin[Rational[11, 50] Pi]}, {
       0, -Cos[Rational[6, 25] Pi], -Sin[Rational[6, 25] Pi]}, {
       0, -Sin[Rational[6, 25] Pi], -Cos[Rational[6, 25] Pi]}, {
       0, -Sin[Rational[11, 50] Pi], -Cos[Rational[11, 50] Pi]}, {
       0, -(Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2],
         Rational[1, 4] (-1 - 5^Rational[1, 2])}, {
       0, -Sin[Rational[9, 50] Pi], -Cos[Rational[9, 50] Pi]}, {
       0, -Sin[Rational[4, 25] Pi], -Cos[Rational[4, 25] Pi]}, {
       0, -Sin[Rational[7, 50] Pi], -Cos[Rational[7, 50] Pi]}, {
       0, -Sin[Rational[3, 25] Pi], -Cos[Rational[3, 25] Pi]}, {
       0, Rational[1, 4] (1 - 5^
         Rational[1, 2]), -(Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
         Rational[1, 2]}, {
       0, -Sin[Rational[2, 25] Pi], -Cos[Rational[2, 25] Pi]}, {
       0, -Sin[Rational[3, 50] Pi], -Cos[Rational[3, 50] Pi]}, {
       0, -Sin[Rational[1, 25] Pi], -Cos[Rational[1, 25] Pi]}, {
       0, -Sin[Rational[1, 50] Pi], -Cos[Rational[1, 50] Pi]}, {0, 0, -1}, {
       0, Sin[Rational[1, 50] Pi], -Cos[Rational[1, 50] Pi]}, {
       0, Sin[Rational[1, 25] Pi], -Cos[Rational[1, 25] Pi]}, {
       0, Sin[Rational[3, 50] Pi], -Cos[Rational[3, 50] Pi]}, {
       0, Sin[Rational[2, 25] Pi], -Cos[Rational[2, 25] Pi]}, {
       0, Rational[1, 4] (-1 + 
         5^Rational[1, 2]), -(Rational[5, 8] + 
          Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2]}, {
       0, Sin[Rational[3, 25] Pi], -Cos[Rational[3, 25] Pi]}, {
       0, Sin[Rational[7, 50] Pi], -Cos[Rational[7, 50] Pi]}, {
       0, Sin[Rational[4, 25] Pi], -Cos[Rational[4, 25] Pi]}, {
       0, Sin[Rational[9, 50] Pi], -Cos[Rational[9, 50] Pi]}, {
       0, (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
        Rational[1, 4] (-1 - 5^Rational[1, 2])}, {
       0, Sin[Rational[11, 50] Pi], -Cos[Rational[11, 50] Pi]}, {
       0, Sin[Rational[6, 25] Pi], -Cos[Rational[6, 25] Pi]}, {
       0, Cos[Rational[6, 25] Pi], -Sin[Rational[6, 25] Pi]}, {
       0, Cos[Rational[11, 50] Pi], -Sin[Rational[11, 50] Pi]}, {
       0, Rational[1, 4] (1 + 
         5^Rational[1, 2]), -(Rational[5, 8] + 
          Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2]}, {
       0, Cos[Rational[9, 50] Pi], -Sin[Rational[9, 50] Pi]}, {
       0, Cos[Rational[4, 25] Pi], -Sin[Rational[4, 25] Pi]}, {
       0, Cos[Rational[7, 50] Pi], -Sin[Rational[7, 50] Pi]}, {
       0, Cos[Rational[3, 25] Pi], -Sin[Rational[3, 25] Pi]}, {
       0, (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
        Rational[1, 4] (1 - 5^Rational[1, 2])}, {
       0, Cos[Rational[2, 25] Pi], -Sin[Rational[2, 25] Pi]}, {
       0, Cos[Rational[3, 50] Pi], -Sin[Rational[3, 50] Pi]}, {
       0, Cos[Rational[1, 25] Pi], -Sin[Rational[1, 25] Pi]}, {
       0, Cos[Rational[1, 50] Pi], -Sin[Rational[1, 50] Pi]}, {0, 1, 0}}, {{0,
        1, 0}, {0, 0.9980267284282716, 0.06279051952931337}, {
       0, 0.9921147013144779, 0.12533323356430426`}, {
       0, 0.9822872507286887, 0.1873813145857246}, {
       0, 0.9685831611286311, 0.2486898871648548}, {
       0, 0.9510565162951535, 0.30901699437494745`}, {
       0, 0.9297764858882515, 0.3681245526846779}, {
       0, 0.9048270524660195, 0.4257792915650727}, {
       0, 0.8763066800438636, 0.4817536741017153}, {
       0, 0.8443279255020151, 0.5358267949789967}, {
       0, 0.8090169943749475, 0.5877852522924731}, {
       0, 0.7705132427757893, 0.6374239897486896}, {
       0, 0.7289686274214116, 0.6845471059286886}, {
       0, 0.6845471059286886, 0.7289686274214116}, {
       0, 0.6374239897486896, 0.7705132427757893}, {
       0, 0.5877852522924731, 0.8090169943749475}, {
       0, 0.5358267949789967, 0.8443279255020151}, {
       0, 0.4817536741017153, 0.8763066800438636}, {
       0, 0.4257792915650727, 0.9048270524660195}, {
       0, 0.3681245526846779, 0.9297764858882515}, {
       0, 0.30901699437494745`, 0.9510565162951535}, {
       0, 0.2486898871648548, 0.9685831611286311}, {
       0, 0.1873813145857246, 0.9822872507286887}, {
       0, 0.12533323356430426`, 0.9921147013144779}, {
       0, 0.06279051952931337, 0.9980267284282716}, {0, 0, 1}, {
       0, -0.06279051952931337, 0.9980267284282716}, {
       0, -0.12533323356430426`, 0.9921147013144779}, {
       0, -0.1873813145857246, 0.9822872507286887}, {
       0, -0.2486898871648548, 0.9685831611286311}, {
       0, -0.30901699437494745`, 0.9510565162951535}, {
       0, -0.3681245526846779, 0.9297764858882515}, {
       0, -0.4257792915650727, 0.9048270524660195}, {
       0, -0.4817536741017153, 0.8763066800438636}, {
       0, -0.5358267949789967, 0.8443279255020151}, {
       0, -0.5877852522924731, 0.8090169943749475}, {
       0, -0.6374239897486896, 0.7705132427757893}, {
       0, -0.6845471059286886, 0.7289686274214116}, {
       0, -0.7289686274214116, 0.6845471059286886}, {
       0, -0.7705132427757893, 0.6374239897486896}, {
       0, -0.8090169943749475, 0.5877852522924731}, {
       0, -0.8443279255020151, 0.5358267949789967}, {
       0, -0.8763066800438636, 0.4817536741017153}, {
       0, -0.9048270524660195, 0.4257792915650727}, {
       0, -0.9297764858882515, 0.3681245526846779}, {
       0, -0.9510565162951535, 0.30901699437494745`}, {
       0, -0.9685831611286311, 0.2486898871648548}, {
       0, -0.9822872507286887, 0.1873813145857246}, {
       0, -0.9921147013144779, 0.12533323356430426`}, {
       0, -0.9980267284282716, 0.06279051952931337}, {0, -1, 0}, {
       0, -0.9980267284282716, -0.06279051952931337}, {
       0, -0.9921147013144779, -0.12533323356430426`}, {
       0, -0.9822872507286887, -0.1873813145857246}, {
       0, -0.9685831611286311, -0.2486898871648548}, {
       0, -0.9510565162951535, -0.30901699437494745`}, {
       0, -0.9297764858882515, -0.3681245526846779}, {
       0, -0.9048270524660195, -0.4257792915650727}, {
       0, -0.8763066800438636, -0.4817536741017153}, {
       0, -0.8443279255020151, -0.5358267949789967}, {
       0, -0.8090169943749475, -0.5877852522924731}, {
       0, -0.7705132427757893, -0.6374239897486896}, {
       0, -0.7289686274214116, -0.6845471059286886}, {
       0, -0.6845471059286886, -0.7289686274214116}, {
       0, -0.6374239897486896, -0.7705132427757893}, {
       0, -0.5877852522924731, -0.8090169943749475}, {
       0, -0.5358267949789967, -0.8443279255020151}, {
       0, -0.4817536741017153, -0.8763066800438636}, {
       0, -0.4257792915650727, -0.9048270524660195}, {
       0, -0.3681245526846779, -0.9297764858882515}, {
       0, -0.30901699437494745`, -0.9510565162951535}, {
       0, -0.2486898871648548, -0.9685831611286311}, {
       0, -0.1873813145857246, -0.9822872507286887}, {
       0, -0.12533323356430426`, -0.9921147013144779}, {
       0, -0.06279051952931337, -0.9980267284282716}, {0, 0, -1}, {
       0, 0.06279051952931337, -0.9980267284282716}, {
       0, 0.12533323356430426`, -0.9921147013144779}, {
       0, 0.1873813145857246, -0.9822872507286887}, {
       0, 0.2486898871648548, -0.9685831611286311}, {
       0, 0.30901699437494745`, -0.9510565162951535}, {
       0, 0.3681245526846779, -0.9297764858882515}, {
       0, 0.4257792915650727, -0.9048270524660195}, {
       0, 0.4817536741017153, -0.8763066800438636}, {
       0, 0.5358267949789967, -0.8443279255020151}, {
       0, 0.5877852522924731, -0.8090169943749475}, {
       0, 0.6374239897486896, -0.7705132427757893}, {
       0, 0.6845471059286886, -0.7289686274214116}, {
       0, 0.7289686274214116, -0.6845471059286886}, {
       0, 0.7705132427757893, -0.6374239897486896}, {
       0, 0.8090169943749475, -0.5877852522924731}, {
       0, 0.8443279255020151, -0.5358267949789967}, {
       0, 0.8763066800438636, -0.4817536741017153}, {
       0, 0.9048270524660195, -0.4257792915650727}, {
       0, 0.9297764858882515, -0.3681245526846779}, {
       0, 0.9510565162951535, -0.30901699437494745`}, {
       0, 0.9685831611286311, -0.2486898871648548}, {
       0, 0.9822872507286887, -0.1873813145857246}, {
       0, 0.9921147013144779, -0.12533323356430426`}, {
       0, 0.9980267284282716, -0.06279051952931337}, {0, 1, 0}}]], 
    Polygon3DBox[
     NCache[{{1, 0, 0}, {
       Cos[Rational[1, 50] Pi], Sin[Rational[1, 50] Pi], 0}, {
       Cos[Rational[1, 25] Pi], Sin[Rational[1, 25] Pi], 0}, {
       Cos[Rational[3, 50] Pi], Sin[Rational[3, 50] Pi], 0}, {
       Cos[Rational[2, 25] Pi], Sin[Rational[2, 25] Pi], 
        0}, {(Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], Rational[1, 4] (-1 + 5^Rational[1, 2]), 0}, {
       Cos[Rational[3, 25] Pi], Sin[Rational[3, 25] Pi], 0}, {
       Cos[Rational[7, 50] Pi], Sin[Rational[7, 50] Pi], 0}, {
       Cos[Rational[4, 25] Pi], Sin[Rational[4, 25] Pi], 0}, {
       Cos[Rational[9, 50] Pi], Sin[Rational[9, 50] Pi], 0}, {
       Rational[1, 4] (1 + 5^Rational[1, 2]), (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 0}, {
       Cos[Rational[11, 50] Pi], Sin[Rational[11, 50] Pi], 0}, {
       Cos[Rational[6, 25] Pi], Sin[Rational[6, 25] Pi], 0}, {
       Sin[Rational[6, 25] Pi], Cos[Rational[6, 25] Pi], 0}, {
       Sin[Rational[11, 50] Pi], Cos[Rational[11, 50] Pi], 
        0}, {(Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], Rational[1, 4] (1 + 5^Rational[1, 2]), 0}, {
       Sin[Rational[9, 50] Pi], Cos[Rational[9, 50] Pi], 0}, {
       Sin[Rational[4, 25] Pi], Cos[Rational[4, 25] Pi], 0}, {
       Sin[Rational[7, 50] Pi], Cos[Rational[7, 50] Pi], 0}, {
       Sin[Rational[3, 25] Pi], Cos[Rational[3, 25] Pi], 0}, {
       Rational[1, 4] (-1 + 5^Rational[1, 2]), (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 0}, {
       Sin[Rational[2, 25] Pi], Cos[Rational[2, 25] Pi], 0}, {
       Sin[Rational[3, 50] Pi], Cos[Rational[3, 50] Pi], 0}, {
       Sin[Rational[1, 25] Pi], Cos[Rational[1, 25] Pi], 0}, {
       Sin[Rational[1, 50] Pi], Cos[Rational[1, 50] Pi], 0}, {0, 1, 
       0}, {-Sin[Rational[1, 50] Pi], Cos[Rational[1, 50] Pi], 0}, {-
        Sin[Rational[1, 25] Pi], Cos[Rational[1, 25] Pi], 0}, {-
        Sin[Rational[3, 50] Pi], Cos[Rational[3, 50] Pi], 0}, {-
        Sin[Rational[2, 25] Pi], Cos[Rational[2, 25] Pi], 0}, {
       Rational[1, 4] (1 - 5^Rational[1, 2]), (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 0}, {-
        Sin[Rational[3, 25] Pi], Cos[Rational[3, 25] Pi], 0}, {-
        Sin[Rational[7, 50] Pi], Cos[Rational[7, 50] Pi], 0}, {-
        Sin[Rational[4, 25] Pi], Cos[Rational[4, 25] Pi], 0}, {-
        Sin[Rational[9, 50] Pi], Cos[Rational[9, 50] Pi], 
        0}, {-(Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
         Rational[1, 2], Rational[1, 4] (1 + 5^Rational[1, 2]), 0}, {-
        Sin[Rational[11, 50] Pi], Cos[Rational[11, 50] Pi], 0}, {-
        Sin[Rational[6, 25] Pi], Cos[Rational[6, 25] Pi], 0}, {-
        Cos[Rational[6, 25] Pi], Sin[Rational[6, 25] Pi], 0}, {-
        Cos[Rational[11, 50] Pi], Sin[Rational[11, 50] Pi], 0}, {
       Rational[1, 4] (-1 - 5^Rational[1, 2]), (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 0}, {-
        Cos[Rational[9, 50] Pi], Sin[Rational[9, 50] Pi], 0}, {-
        Cos[Rational[4, 25] Pi], Sin[Rational[4, 25] Pi], 0}, {-
        Cos[Rational[7, 50] Pi], Sin[Rational[7, 50] Pi], 0}, {-
        Cos[Rational[3, 25] Pi], Sin[Rational[3, 25] Pi], 
        0}, {-(Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
         Rational[1, 2], Rational[1, 4] (-1 + 5^Rational[1, 2]), 0}, {-
        Cos[Rational[2, 25] Pi], Sin[Rational[2, 25] Pi], 0}, {-
        Cos[Rational[3, 50] Pi], Sin[Rational[3, 50] Pi], 0}, {-
        Cos[Rational[1, 25] Pi], Sin[Rational[1, 25] Pi], 0}, {-
        Cos[Rational[1, 50] Pi], Sin[Rational[1, 50] Pi], 0}, {-1, 0, 
       0}, {-Cos[Rational[1, 50] Pi], -Sin[Rational[1, 50] Pi], 0}, {-
        Cos[Rational[1, 25] Pi], -Sin[Rational[1, 25] Pi], 0}, {-
        Cos[Rational[3, 50] Pi], -Sin[Rational[3, 50] Pi], 0}, {-
        Cos[Rational[2, 25] Pi], -Sin[Rational[2, 25] Pi], 
        0}, {-(Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
         Rational[1, 2], Rational[1, 4] (1 - 5^Rational[1, 2]), 0}, {-
        Cos[Rational[3, 25] Pi], -Sin[Rational[3, 25] Pi], 0}, {-
        Cos[Rational[7, 50] Pi], -Sin[Rational[7, 50] Pi], 0}, {-
        Cos[Rational[4, 25] Pi], -Sin[Rational[4, 25] Pi], 0}, {-
        Cos[Rational[9, 50] Pi], -Sin[Rational[9, 50] Pi], 0}, {
       Rational[1, 4] (-1 - 5^
         Rational[1, 2]), -(Rational[5, 8] + 
          Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 0}, {-
        Cos[Rational[11, 50] Pi], -Sin[Rational[11, 50] Pi], 0}, {-
        Cos[Rational[6, 25] Pi], -Sin[Rational[6, 25] Pi], 0}, {-
        Sin[Rational[6, 25] Pi], -Cos[Rational[6, 25] Pi], 0}, {-
        Sin[Rational[11, 50] Pi], -Cos[Rational[11, 50] Pi], 
        0}, {-(Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
         Rational[1, 2], Rational[1, 4] (-1 - 5^Rational[1, 2]), 0}, {-
        Sin[Rational[9, 50] Pi], -Cos[Rational[9, 50] Pi], 0}, {-
        Sin[Rational[4, 25] Pi], -Cos[Rational[4, 25] Pi], 0}, {-
        Sin[Rational[7, 50] Pi], -Cos[Rational[7, 50] Pi], 0}, {-
        Sin[Rational[3, 25] Pi], -Cos[Rational[3, 25] Pi], 0}, {
       Rational[1, 4] (1 - 5^
         Rational[1, 2]), -(Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
         Rational[1, 2], 0}, {-Sin[Rational[2, 25] Pi], -
        Cos[Rational[2, 25] Pi], 0}, {-Sin[Rational[3, 50] Pi], -
        Cos[Rational[3, 50] Pi], 0}, {-Sin[Rational[1, 25] Pi], -
        Cos[Rational[1, 25] Pi], 0}, {-Sin[Rational[1, 50] Pi], -
        Cos[Rational[1, 50] Pi], 0}, {0, -1, 0}, {
       Sin[Rational[1, 50] Pi], -Cos[Rational[1, 50] Pi], 0}, {
       Sin[Rational[1, 25] Pi], -Cos[Rational[1, 25] Pi], 0}, {
       Sin[Rational[3, 50] Pi], -Cos[Rational[3, 50] Pi], 0}, {
       Sin[Rational[2, 25] Pi], -Cos[Rational[2, 25] Pi], 0}, {
       Rational[1, 4] (-1 + 
         5^Rational[1, 2]), -(Rational[5, 8] + 
          Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 0}, {
       Sin[Rational[3, 25] Pi], -Cos[Rational[3, 25] Pi], 0}, {
       Sin[Rational[7, 50] Pi], -Cos[Rational[7, 50] Pi], 0}, {
       Sin[Rational[4, 25] Pi], -Cos[Rational[4, 25] Pi], 0}, {
       Sin[Rational[9, 50] Pi], -Cos[Rational[9, 50] Pi], 
        0}, {(Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], Rational[1, 4] (-1 - 5^Rational[1, 2]), 0}, {
       Sin[Rational[11, 50] Pi], -Cos[Rational[11, 50] Pi], 0}, {
       Sin[Rational[6, 25] Pi], -Cos[Rational[6, 25] Pi], 0}, {
       Cos[Rational[6, 25] Pi], -Sin[Rational[6, 25] Pi], 0}, {
       Cos[Rational[11, 50] Pi], -Sin[Rational[11, 50] Pi], 0}, {
       Rational[1, 4] (1 + 
         5^Rational[1, 2]), -(Rational[5, 8] + 
          Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 0}, {
       Cos[Rational[9, 50] Pi], -Sin[Rational[9, 50] Pi], 0}, {
       Cos[Rational[4, 25] Pi], -Sin[Rational[4, 25] Pi], 0}, {
       Cos[Rational[7, 50] Pi], -Sin[Rational[7, 50] Pi], 0}, {
       Cos[Rational[3, 25] Pi], -Sin[Rational[3, 25] Pi], 
        0}, {(Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], Rational[1, 4] (1 - 5^Rational[1, 2]), 0}, {
       Cos[Rational[2, 25] Pi], -Sin[Rational[2, 25] Pi], 0}, {
       Cos[Rational[3, 50] Pi], -Sin[Rational[3, 50] Pi], 0}, {
       Cos[Rational[1, 25] Pi], -Sin[Rational[1, 25] Pi], 0}, {
       Cos[Rational[1, 50] Pi], -Sin[Rational[1, 50] Pi], 0}, {1, 0, 0}}, {{1,
        0, 0}, {0.9980267284282716, 0.06279051952931337, 0}, {
       0.9921147013144779, 0.12533323356430426`, 0}, {
       0.9822872507286887, 0.1873813145857246, 0}, {
       0.9685831611286311, 0.2486898871648548, 0}, {
       0.9510565162951535, 0.30901699437494745`, 0}, {
       0.9297764858882515, 0.3681245526846779, 0}, {
       0.9048270524660195, 0.4257792915650727, 0}, {
       0.8763066800438636, 0.4817536741017153, 0}, {
       0.8443279255020151, 0.5358267949789967, 0}, {
       0.8090169943749475, 0.5877852522924731, 0}, {
       0.7705132427757893, 0.6374239897486896, 0}, {
       0.7289686274214116, 0.6845471059286886, 0}, {
       0.6845471059286886, 0.7289686274214116, 0}, {
       0.6374239897486896, 0.7705132427757893, 0}, {
       0.5877852522924731, 0.8090169943749475, 0}, {
       0.5358267949789967, 0.8443279255020151, 0}, {
       0.4817536741017153, 0.8763066800438636, 0}, {
       0.4257792915650727, 0.9048270524660195, 0}, {
       0.3681245526846779, 0.9297764858882515, 0}, {
       0.30901699437494745`, 0.9510565162951535, 0}, {
       0.2486898871648548, 0.9685831611286311, 0}, {
       0.1873813145857246, 0.9822872507286887, 0}, {
       0.12533323356430426`, 0.9921147013144779, 0}, {
       0.06279051952931337, 0.9980267284282716, 0}, {0, 1, 
       0}, {-0.06279051952931337, 0.9980267284282716, 
        0}, {-0.12533323356430426`, 0.9921147013144779, 
        0}, {-0.1873813145857246, 0.9822872507286887, 
        0}, {-0.2486898871648548, 0.9685831611286311, 
        0}, {-0.30901699437494745`, 0.9510565162951535, 
        0}, {-0.3681245526846779, 0.9297764858882515, 
        0}, {-0.4257792915650727, 0.9048270524660195, 
        0}, {-0.4817536741017153, 0.8763066800438636, 
        0}, {-0.5358267949789967, 0.8443279255020151, 
        0}, {-0.5877852522924731, 0.8090169943749475, 
        0}, {-0.6374239897486896, 0.7705132427757893, 
        0}, {-0.6845471059286886, 0.7289686274214116, 
        0}, {-0.7289686274214116, 0.6845471059286886, 
        0}, {-0.7705132427757893, 0.6374239897486896, 
        0}, {-0.8090169943749475, 0.5877852522924731, 
        0}, {-0.8443279255020151, 0.5358267949789967, 
        0}, {-0.8763066800438636, 0.4817536741017153, 
        0}, {-0.9048270524660195, 0.4257792915650727, 
        0}, {-0.9297764858882515, 0.3681245526846779, 
        0}, {-0.9510565162951535, 0.30901699437494745`, 
        0}, {-0.9685831611286311, 0.2486898871648548, 
        0}, {-0.9822872507286887, 0.1873813145857246, 
        0}, {-0.9921147013144779, 0.12533323356430426`, 
        0}, {-0.9980267284282716, 0.06279051952931337, 0}, {-1, 0, 
       0}, {-0.9980267284282716, -0.06279051952931337, 
        0}, {-0.9921147013144779, -0.12533323356430426`, 
        0}, {-0.9822872507286887, -0.1873813145857246, 
        0}, {-0.9685831611286311, -0.2486898871648548, 
        0}, {-0.9510565162951535, -0.30901699437494745`, 
        0}, {-0.9297764858882515, -0.3681245526846779, 
        0}, {-0.9048270524660195, -0.4257792915650727, 
        0}, {-0.8763066800438636, -0.4817536741017153, 
        0}, {-0.8443279255020151, -0.5358267949789967, 
        0}, {-0.8090169943749475, -0.5877852522924731, 
        0}, {-0.7705132427757893, -0.6374239897486896, 
        0}, {-0.7289686274214116, -0.6845471059286886, 
        0}, {-0.6845471059286886, -0.7289686274214116, 
        0}, {-0.6374239897486896, -0.7705132427757893, 
        0}, {-0.5877852522924731, -0.8090169943749475, 
        0}, {-0.5358267949789967, -0.8443279255020151, 
        0}, {-0.4817536741017153, -0.8763066800438636, 
        0}, {-0.4257792915650727, -0.9048270524660195, 
        0}, {-0.3681245526846779, -0.9297764858882515, 
        0}, {-0.30901699437494745`, -0.9510565162951535, 
        0}, {-0.2486898871648548, -0.9685831611286311, 
        0}, {-0.1873813145857246, -0.9822872507286887, 
        0}, {-0.12533323356430426`, -0.9921147013144779, 
        0}, {-0.06279051952931337, -0.9980267284282716, 0}, {0, -1, 0}, {
       0.06279051952931337, -0.9980267284282716, 0}, {
       0.12533323356430426`, -0.9921147013144779, 0}, {
       0.1873813145857246, -0.9822872507286887, 0}, {
       0.2486898871648548, -0.9685831611286311, 0}, {
       0.30901699437494745`, -0.9510565162951535, 0}, {
       0.3681245526846779, -0.9297764858882515, 0}, {
       0.4257792915650727, -0.9048270524660195, 0}, {
       0.4817536741017153, -0.8763066800438636, 0}, {
       0.5358267949789967, -0.8443279255020151, 0}, {
       0.5877852522924731, -0.8090169943749475, 0}, {
       0.6374239897486896, -0.7705132427757893, 0}, {
       0.6845471059286886, -0.7289686274214116, 0}, {
       0.7289686274214116, -0.6845471059286886, 0}, {
       0.7705132427757893, -0.6374239897486896, 0}, {
       0.8090169943749475, -0.5877852522924731, 0}, {
       0.8443279255020151, -0.5358267949789967, 0}, {
       0.8763066800438636, -0.4817536741017153, 0}, {
       0.9048270524660195, -0.4257792915650727, 0}, {
       0.9297764858882515, -0.3681245526846779, 0}, {
       0.9510565162951535, -0.30901699437494745`, 0}, {
       0.9685831611286311, -0.2486898871648548, 0}, {
       0.9822872507286887, -0.1873813145857246, 0}, {
       0.9921147013144779, -0.12533323356430426`, 0}, {
       0.9980267284282716, -0.06279051952931337, 0}, {1, 0, 0}}]], 
    Polygon3DBox[
     NCache[{{1, 0, 0}, {
       Cos[Rational[1, 50] Pi], 0, Sin[Rational[1, 50] Pi]}, {
       Cos[Rational[1, 25] Pi], 0, Sin[Rational[1, 25] Pi]}, {
       Cos[Rational[3, 50] Pi], 0, Sin[Rational[3, 50] Pi]}, {
       Cos[Rational[2, 25] Pi], 0, Sin[
        Rational[2, 25] Pi]}, {(Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 0, 
        Rational[1, 4] (-1 + 5^Rational[1, 2])}, {
       Cos[Rational[3, 25] Pi], 0, Sin[Rational[3, 25] Pi]}, {
       Cos[Rational[7, 50] Pi], 0, Sin[Rational[7, 50] Pi]}, {
       Cos[Rational[4, 25] Pi], 0, Sin[Rational[4, 25] Pi]}, {
       Cos[Rational[9, 50] Pi], 0, Sin[Rational[9, 50] Pi]}, {
       Rational[1, 4] (1 + 5^Rational[1, 2]), 
        0, (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2]}, {
       Cos[Rational[11, 50] Pi], 0, Sin[Rational[11, 50] Pi]}, {
       Cos[Rational[6, 25] Pi], 0, Sin[Rational[6, 25] Pi]}, {
       Sin[Rational[6, 25] Pi], 0, Cos[Rational[6, 25] Pi]}, {
       Sin[Rational[11, 50] Pi], 0, Cos[
        Rational[11, 50] Pi]}, {(Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 0, 
        Rational[1, 4] (1 + 5^Rational[1, 2])}, {
       Sin[Rational[9, 50] Pi], 0, Cos[Rational[9, 50] Pi]}, {
       Sin[Rational[4, 25] Pi], 0, Cos[Rational[4, 25] Pi]}, {
       Sin[Rational[7, 50] Pi], 0, Cos[Rational[7, 50] Pi]}, {
       Sin[Rational[3, 25] Pi], 0, Cos[Rational[3, 25] Pi]}, {
       Rational[1, 4] (-1 + 5^Rational[1, 2]), 
        0, (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2]}, {
       Sin[Rational[2, 25] Pi], 0, Cos[Rational[2, 25] Pi]}, {
       Sin[Rational[3, 50] Pi], 0, Cos[Rational[3, 50] Pi]}, {
       Sin[Rational[1, 25] Pi], 0, Cos[Rational[1, 25] Pi]}, {
       Sin[Rational[1, 50] Pi], 0, Cos[Rational[1, 50] Pi]}, {0, 0, 
       1}, {-Sin[Rational[1, 50] Pi], 0, Cos[Rational[1, 50] Pi]}, {-
        Sin[Rational[1, 25] Pi], 0, Cos[Rational[1, 25] Pi]}, {-
        Sin[Rational[3, 50] Pi], 0, Cos[Rational[3, 50] Pi]}, {-
        Sin[Rational[2, 25] Pi], 0, Cos[Rational[2, 25] Pi]}, {
       Rational[1, 4] (1 - 5^Rational[1, 2]), 
        0, (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2]}, {-Sin[Rational[3, 25] Pi], 0, Cos[
        Rational[3, 25] Pi]}, {-Sin[Rational[7, 50] Pi], 0, Cos[
        Rational[7, 50] Pi]}, {-Sin[Rational[4, 25] Pi], 0, Cos[
        Rational[4, 25] Pi]}, {-Sin[Rational[9, 50] Pi], 0, Cos[
        Rational[9, 50] 
         Pi]}, {-(Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
         Rational[1, 2], 0, Rational[1, 4] (1 + 5^Rational[1, 2])}, {-
        Sin[Rational[11, 50] Pi], 0, Cos[Rational[11, 50] Pi]}, {-
        Sin[Rational[6, 25] Pi], 0, Cos[Rational[6, 25] Pi]}, {-
        Cos[Rational[6, 25] Pi], 0, Sin[Rational[6, 25] Pi]}, {-
        Cos[Rational[11, 50] Pi], 0, Sin[Rational[11, 50] Pi]}, {
       Rational[1, 4] (-1 - 5^Rational[1, 2]), 
        0, (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2]}, {-Cos[Rational[9, 50] Pi], 0, Sin[
        Rational[9, 50] Pi]}, {-Cos[Rational[4, 25] Pi], 0, Sin[
        Rational[4, 25] Pi]}, {-Cos[Rational[7, 50] Pi], 0, Sin[
        Rational[7, 50] Pi]}, {-Cos[Rational[3, 25] Pi], 0, Sin[
        Rational[3, 25] 
         Pi]}, {-(Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
         Rational[1, 2], 0, Rational[1, 4] (-1 + 5^Rational[1, 2])}, {-
        Cos[Rational[2, 25] Pi], 0, Sin[Rational[2, 25] Pi]}, {-
        Cos[Rational[3, 50] Pi], 0, Sin[Rational[3, 50] Pi]}, {-
        Cos[Rational[1, 25] Pi], 0, Sin[Rational[1, 25] Pi]}, {-
        Cos[Rational[1, 50] Pi], 0, Sin[Rational[1, 50] Pi]}, {-1, 0, 
       0}, {-Cos[Rational[1, 50] Pi], 0, -Sin[Rational[1, 50] Pi]}, {-
        Cos[Rational[1, 25] Pi], 0, -Sin[Rational[1, 25] Pi]}, {-
        Cos[Rational[3, 50] Pi], 0, -Sin[Rational[3, 50] Pi]}, {-
        Cos[Rational[2, 25] Pi], 0, -
        Sin[Rational[2, 25] Pi]}, {-(Rational[5, 8] + 
          Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 0, 
        Rational[1, 4] (1 - 5^Rational[1, 2])}, {-Cos[Rational[3, 25] Pi], 
        0, -Sin[Rational[3, 25] Pi]}, {-Cos[Rational[7, 50] Pi], 0, -
        Sin[Rational[7, 50] Pi]}, {-Cos[Rational[4, 25] Pi], 0, -
        Sin[Rational[4, 25] Pi]}, {-Cos[Rational[9, 50] Pi], 0, -
        Sin[Rational[9, 50] Pi]}, {
       Rational[1, 4] (-1 - 5^Rational[1, 2]), 
        0, -(Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
         Rational[1, 2]}, {-Cos[Rational[11, 50] Pi], 0, -
        Sin[Rational[11, 50] Pi]}, {-Cos[Rational[6, 25] Pi], 0, -
        Sin[Rational[6, 25] Pi]}, {-Sin[Rational[6, 25] Pi], 0, -
        Cos[Rational[6, 25] Pi]}, {-Sin[Rational[11, 50] Pi], 0, -
        Cos[Rational[11, 50] Pi]}, {-(Rational[5, 8] + 
          Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 0, 
        Rational[1, 4] (-1 - 5^Rational[1, 2])}, {-Sin[Rational[9, 50] Pi], 
        0, -Cos[Rational[9, 50] Pi]}, {-Sin[Rational[4, 25] Pi], 0, -
        Cos[Rational[4, 25] Pi]}, {-Sin[Rational[7, 50] Pi], 0, -
        Cos[Rational[7, 50] Pi]}, {-Sin[Rational[3, 25] Pi], 0, -
        Cos[Rational[3, 25] Pi]}, {
       Rational[1, 4] (1 - 5^Rational[1, 2]), 
        0, -(Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
         Rational[1, 2]}, {-Sin[Rational[2, 25] Pi], 0, -
        Cos[Rational[2, 25] Pi]}, {-Sin[Rational[3, 50] Pi], 0, -
        Cos[Rational[3, 50] Pi]}, {-Sin[Rational[1, 25] Pi], 0, -
        Cos[Rational[1, 25] Pi]}, {-Sin[Rational[1, 50] Pi], 0, -
        Cos[Rational[1, 50] Pi]}, {0, 0, -1}, {
       Sin[Rational[1, 50] Pi], 0, -Cos[Rational[1, 50] Pi]}, {
       Sin[Rational[1, 25] Pi], 0, -Cos[Rational[1, 25] Pi]}, {
       Sin[Rational[3, 50] Pi], 0, -Cos[Rational[3, 50] Pi]}, {
       Sin[Rational[2, 25] Pi], 0, -Cos[Rational[2, 25] Pi]}, {
       Rational[1, 4] (-1 + 5^Rational[1, 2]), 
        0, -(Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
         Rational[1, 2]}, {
       Sin[Rational[3, 25] Pi], 0, -Cos[Rational[3, 25] Pi]}, {
       Sin[Rational[7, 50] Pi], 0, -Cos[Rational[7, 50] Pi]}, {
       Sin[Rational[4, 25] Pi], 0, -Cos[Rational[4, 25] Pi]}, {
       Sin[Rational[9, 50] Pi], 0, -
        Cos[Rational[9, 50] Pi]}, {(Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 0, 
        Rational[1, 4] (-1 - 5^Rational[1, 2])}, {
       Sin[Rational[11, 50] Pi], 0, -Cos[Rational[11, 50] Pi]}, {
       Sin[Rational[6, 25] Pi], 0, -Cos[Rational[6, 25] Pi]}, {
       Cos[Rational[6, 25] Pi], 0, -Sin[Rational[6, 25] Pi]}, {
       Cos[Rational[11, 50] Pi], 0, -Sin[Rational[11, 50] Pi]}, {
       Rational[1, 4] (1 + 5^Rational[1, 2]), 
        0, -(Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
         Rational[1, 2]}, {
       Cos[Rational[9, 50] Pi], 0, -Sin[Rational[9, 50] Pi]}, {
       Cos[Rational[4, 25] Pi], 0, -Sin[Rational[4, 25] Pi]}, {
       Cos[Rational[7, 50] Pi], 0, -Sin[Rational[7, 50] Pi]}, {
       Cos[Rational[3, 25] Pi], 0, -
        Sin[Rational[3, 25] Pi]}, {(Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 0, 
        Rational[1, 4] (1 - 5^Rational[1, 2])}, {
       Cos[Rational[2, 25] Pi], 0, -Sin[Rational[2, 25] Pi]}, {
       Cos[Rational[3, 50] Pi], 0, -Sin[Rational[3, 50] Pi]}, {
       Cos[Rational[1, 25] Pi], 0, -Sin[Rational[1, 25] Pi]}, {
       Cos[Rational[1, 50] Pi], 0, -Sin[Rational[1, 50] Pi]}, {1, 0, 0}}, {{1,
        0, 0}, {0.9980267284282716, 0, 0.06279051952931337}, {
       0.9921147013144779, 0, 0.12533323356430426`}, {
       0.9822872507286887, 0, 0.1873813145857246}, {
       0.9685831611286311, 0, 0.2486898871648548}, {
       0.9510565162951535, 0, 0.30901699437494745`}, {
       0.9297764858882515, 0, 0.3681245526846779}, {
       0.9048270524660195, 0, 0.4257792915650727}, {
       0.8763066800438636, 0, 0.4817536741017153}, {
       0.8443279255020151, 0, 0.5358267949789967}, {
       0.8090169943749475, 0, 0.5877852522924731}, {
       0.7705132427757893, 0, 0.6374239897486896}, {
       0.7289686274214116, 0, 0.6845471059286886}, {
       0.6845471059286886, 0, 0.7289686274214116}, {
       0.6374239897486896, 0, 0.7705132427757893}, {
       0.5877852522924731, 0, 0.8090169943749475}, {
       0.5358267949789967, 0, 0.8443279255020151}, {
       0.4817536741017153, 0, 0.8763066800438636}, {
       0.4257792915650727, 0, 0.9048270524660195}, {
       0.3681245526846779, 0, 0.9297764858882515}, {
       0.30901699437494745`, 0, 0.9510565162951535}, {
       0.2486898871648548, 0, 0.9685831611286311}, {
       0.1873813145857246, 0, 0.9822872507286887}, {
       0.12533323356430426`, 0, 0.9921147013144779}, {
       0.06279051952931337, 0, 0.9980267284282716}, {0, 0, 
       1}, {-0.06279051952931337, 0, 
        0.9980267284282716}, {-0.12533323356430426`, 0, 
        0.9921147013144779}, {-0.1873813145857246, 0, 
        0.9822872507286887}, {-0.2486898871648548, 0, 
        0.9685831611286311}, {-0.30901699437494745`, 0, 
        0.9510565162951535}, {-0.3681245526846779, 0, 
        0.9297764858882515}, {-0.4257792915650727, 0, 
        0.9048270524660195}, {-0.4817536741017153, 0, 
        0.8763066800438636}, {-0.5358267949789967, 0, 
        0.8443279255020151}, {-0.5877852522924731, 0, 
        0.8090169943749475}, {-0.6374239897486896, 0, 
        0.7705132427757893}, {-0.6845471059286886, 0, 
        0.7289686274214116}, {-0.7289686274214116, 0, 
        0.6845471059286886}, {-0.7705132427757893, 0, 
        0.6374239897486896}, {-0.8090169943749475, 0, 
        0.5877852522924731}, {-0.8443279255020151, 0, 
        0.5358267949789967}, {-0.8763066800438636, 0, 
        0.4817536741017153}, {-0.9048270524660195, 0, 
        0.4257792915650727}, {-0.9297764858882515, 0, 
        0.3681245526846779}, {-0.9510565162951535, 0, 
        0.30901699437494745`}, {-0.9685831611286311, 0, 
        0.2486898871648548}, {-0.9822872507286887, 0, 
        0.1873813145857246}, {-0.9921147013144779, 0, 
        0.12533323356430426`}, {-0.9980267284282716, 0, 
        0.06279051952931337}, {-1, 0, 
       0}, {-0.9980267284282716, 
        0, -0.06279051952931337}, {-0.9921147013144779, 
        0, -0.12533323356430426`}, {-0.9822872507286887, 
        0, -0.1873813145857246}, {-0.9685831611286311, 
        0, -0.2486898871648548}, {-0.9510565162951535, 
        0, -0.30901699437494745`}, {-0.9297764858882515, 
        0, -0.3681245526846779}, {-0.9048270524660195, 
        0, -0.4257792915650727}, {-0.8763066800438636, 
        0, -0.4817536741017153}, {-0.8443279255020151, 
        0, -0.5358267949789967}, {-0.8090169943749475, 
        0, -0.5877852522924731}, {-0.7705132427757893, 
        0, -0.6374239897486896}, {-0.7289686274214116, 
        0, -0.6845471059286886}, {-0.6845471059286886, 
        0, -0.7289686274214116}, {-0.6374239897486896, 
        0, -0.7705132427757893}, {-0.5877852522924731, 
        0, -0.8090169943749475}, {-0.5358267949789967, 
        0, -0.8443279255020151}, {-0.4817536741017153, 
        0, -0.8763066800438636}, {-0.4257792915650727, 
        0, -0.9048270524660195}, {-0.3681245526846779, 
        0, -0.9297764858882515}, {-0.30901699437494745`, 
        0, -0.9510565162951535}, {-0.2486898871648548, 
        0, -0.9685831611286311}, {-0.1873813145857246, 
        0, -0.9822872507286887}, {-0.12533323356430426`, 
        0, -0.9921147013144779}, {-0.06279051952931337, 
        0, -0.9980267284282716}, {0, 0, -1}, {
       0.06279051952931337, 0, -0.9980267284282716}, {
       0.12533323356430426`, 0, -0.9921147013144779}, {
       0.1873813145857246, 0, -0.9822872507286887}, {
       0.2486898871648548, 0, -0.9685831611286311}, {
       0.30901699437494745`, 0, -0.9510565162951535}, {
       0.3681245526846779, 0, -0.9297764858882515}, {
       0.4257792915650727, 0, -0.9048270524660195}, {
       0.4817536741017153, 0, -0.8763066800438636}, {
       0.5358267949789967, 0, -0.8443279255020151}, {
       0.5877852522924731, 0, -0.8090169943749475}, {
       0.6374239897486896, 0, -0.7705132427757893}, {
       0.6845471059286886, 0, -0.7289686274214116}, {
       0.7289686274214116, 0, -0.6845471059286886}, {
       0.7705132427757893, 0, -0.6374239897486896}, {
       0.8090169943749475, 0, -0.5877852522924731}, {
       0.8443279255020151, 0, -0.5358267949789967}, {
       0.8763066800438636, 0, -0.4817536741017153}, {
       0.9048270524660195, 0, -0.4257792915650727}, {
       0.9297764858882515, 0, -0.3681245526846779}, {
       0.9510565162951535, 0, -0.30901699437494745`}, {
       0.9685831611286311, 0, -0.2486898871648548}, {
       0.9822872507286887, 0, -0.1873813145857246}, {
       0.9921147013144779, 0, -0.12533323356430426`}, {
       0.9980267284282716, 0, -0.06279051952931337}, {1, 0, 0}}]], 
    SphereBox[{0, 0, 0}, 1], 
    {Opacity[1], Arrow3DBox[TubeBox[{{0, 0, 0}, {1, 0, 0}}]], 
     Arrow3DBox[TubeBox[{{0, 0, 0}, {0, 1, 0}}]], 
     Arrow3DBox[TubeBox[{{0, 0, 0}, {0, 0, 1}}]], Text3DBox[
      StyleBox["\<\"x\"\>",
       StripOnInput->False,
       FontSize->Large], {1.1, 0, 0}], Text3DBox[
      StyleBox["\<\"y\"\>",
       StripOnInput->False,
       FontSize->Large], {0, 1.1, 0}], Text3DBox[
      StyleBox["\<\"z\"\>",
       StripOnInput->False,
       FontSize->Large], {0, 0, 1.1}]}}, {{{}, {}, 
     TagBox[
      {GrayLevel[0], AbsoluteThickness[2], Line3DBox[CompressedData["
1:eJxk23c41t8fMHBJJZrIVkQpJaSinPoouzIjMlPKHiV7ZG8ie++9szk5Rckq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        "]]},
      Annotation[#, "Charting`Private`Tag$118278#1"]& ]}, {}}, {{{}, {}, 
     TagBox[
      {RGBColor[1, 0, 0], AbsoluteThickness[2], Line3DBox[CompressedData["
1:eJwU13c8ld8fAPCKiKSsqIxIJVmVkpKDFFKh8E0oRdIUotBQGpSRWSQrO0Jk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        "]]},
      Annotation[#, "Charting`Private`Tag$118363#1"]& ]}, {}}},
  LabelStyle->Directive[FontFamily -> "Helvetica", FontSize -> 14]]], "Output",
 CellChangeTimes->{{3.883223902819885*^9, 3.883223929153778*^9}, {
   3.883223967264488*^9, 3.883223989332374*^9}, 3.8832240478116875`*^9, 
   3.8832242420251117`*^9, 3.8832242851180115`*^9, 3.8832244467167296`*^9, 
   3.8832245116908875`*^9, 3.8832245428115892`*^9, 3.883224935256954*^9, 
   3.883225051100494*^9, 3.8832251346156282`*^9, 3.883225302294819*^9, 
   3.883225537815239*^9, 3.883227347386574*^9, 3.883227620054825*^9, 
   3.8832281005746555`*^9, 3.883228164472231*^9, 3.883228336481886*^9, 
   3.8832286441424303`*^9, 3.8832347193565006`*^9, 3.883234884257161*^9, 
   3.8832349927486525`*^9, 3.8832350871431265`*^9, 3.8832352079047165`*^9, 
   3.883235881321658*^9, 3.883236079184498*^9, 3.8832361605060077`*^9, 
   3.8832365278313603`*^9, 3.8832366210094843`*^9, 3.883252214339971*^9, 
   3.883392978232027*^9, 3.883395138304787*^9, 3.8834049977263107`*^9, {
   3.8834732293141727`*^9, 3.8834732523025074`*^9}, 3.883473558712307*^9, {
   3.8834794318039055`*^9, 3.883479450421059*^9}, 3.883479809610712*^9, {
   3.883479843763795*^9, 3.8834798819436564`*^9}, 3.8834891317174163`*^9, 
   3.8834894476506166`*^9, 3.8834897109166703`*^9, 3.8835722548331966`*^9},
 CellLabel->"Out[21]=",ExpressionUUID->"98aad03e-2192-49d0-be73-f237215cc74e"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Comparison between final phase in the rotating an interaction frame\
\>", "Subsection",
 CellChangeTimes->{{3.882622104181368*^9, 3.882622114902437*^9}, {
  3.8832236458871455`*^9, 3.8832236603732576`*^9}, {3.883223768738858*^9, 
  3.8832237691970997`*^9}, {3.8832353223432503`*^9, 3.8832353307614293`*^9}, {
  3.88323576898199*^9, 3.883235780494172*^9}, {3.8835718603787947`*^9, 
  3.8835718863261747`*^9}},ExpressionUUID->"921b36bc-4009-4c3a-b0c8-\
4dc1ef13f561"],

Cell["final phase in the interaction frame", "Text",
 CellChangeTimes->{{3.8832353391409926`*^9, 3.883235358591131*^9}, {
  3.883235786471593*^9, 3.883235986968625*^9}, {3.8832361334381647`*^9, 
  3.8832361833608184`*^9}, {3.8832364537358513`*^9, 3.8832364588258266`*^9}, {
  3.8835719169086514`*^9, 3.8835719227970915`*^9}},
 Background->RGBColor[
  0.87, 0.94, 1],ExpressionUUID->"201eb848-786b-4802-a90a-4288a098d878"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "1", ",", "0"}], "}"}], ".", 
    RowBox[{"Last", "[", "\[Psi]traj", "]"}]}], "//", "Chop"}], "//", 
  "Arg"}]], "Input",
 CellChangeTimes->{{3.8832277199080467`*^9, 3.8832277221748962`*^9}, {
  3.883228353958698*^9, 3.8832283554730496`*^9}, {3.883234736641116*^9, 
  3.88323473822093*^9}, {3.883571934891011*^9, 3.883571936280916*^9}},
 CellLabel->"In[22]:=",ExpressionUUID->"cf36d97e-14b1-426d-8e45-0a59e200c8fd"],

Cell[BoxData["0.7847124610164924`"], "Output",
 CellChangeTimes->{
  3.883228100881934*^9, 3.883228170470019*^9, {3.8832283368807726`*^9, 
   3.883228355697568*^9}, 3.883228644188307*^9, {3.883234719870493*^9, 
   3.883234738545573*^9}, 3.8832348845746555`*^9, {3.88323499300794*^9, 
   3.8832350018668995`*^9}, 3.8832350873983555`*^9, 3.883235207970542*^9, 
   3.8832359688498273`*^9, 3.8832360793852882`*^9, 3.88323616054443*^9, 
   3.8832365278702197`*^9, 3.8832366212049685`*^9, 3.8832522149158864`*^9, 
   3.8833929784256907`*^9, 3.883404997904512*^9, 3.8834732297027893`*^9, 
   3.8834735589395204`*^9, 3.883479809836644*^9, 3.883489447692289*^9, 
   3.883489711125434*^9, 3.883572255046938*^9},
 CellLabel->"Out[22]=",ExpressionUUID->"fa12eb5c-d791-457b-adb8-08dbd9548c07"]
}, Open  ]],

Cell["final phase in the rotating frame", "Text",
 CellChangeTimes->{{3.8832353391409926`*^9, 3.883235358591131*^9}, {
  3.883235786471593*^9, 3.883235986968625*^9}, {3.8832361334381647`*^9, 
  3.8832361833608184`*^9}, {3.8832364537358513`*^9, 3.8832364588258266`*^9}, {
  3.8835719169086514`*^9, 3.883571931726592*^9}},
 Background->RGBColor[
  0.87, 0.94, 1],ExpressionUUID->"155bf6a2-87ff-417d-be6c-d2e485a5fed3"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "1", ",", "0"}], "}"}], ".", 
   RowBox[{"MatrixRepresentation", "[", 
    RowBox[{"Utraj", "[", "nval", "]"}], "]"}], ".", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "1", ",", "0"}], "}"}]}], "//", 
  "Arg"}]], "Input",
 CellChangeTimes->{{3.883235950062704*^9, 3.883235966294538*^9}, {
  3.8832365202689176`*^9, 3.8832365216173086`*^9}, {3.8835719386944604`*^9, 
  3.883571939687109*^9}},
 CellLabel->"In[23]:=",ExpressionUUID->"2bba307b-38aa-4983-85a3-bbcd99d7a420"],

Cell[BoxData["0.7847124610164924`"], "Output",
 CellChangeTimes->{{3.883235953197654*^9, 3.8832359669954796`*^9}, 
   3.8832360794401407`*^9, 3.8832361606102495`*^9, {3.8832365279353724`*^9, 
   3.8832365284222984`*^9}, 3.8832366212658043`*^9, 3.883252214999634*^9, 
   3.8833929786535797`*^9, 3.883404997958549*^9, 3.8834732298075795`*^9, 
   3.8834735590701647`*^9, 3.883479809957342*^9, 3.88348944775703*^9, 
   3.883489711242756*^9, 3.88357225510467*^9},
 CellLabel->"Out[23]=",ExpressionUUID->"56162dcb-8ed3-4e7f-9e60-f8c6702616c8"]
}, Open  ]],

Cell["\<\
This is the same result as the surface area expression, which is given by:

exp( i 1/2 (2\[Gamma])) = exp( i  \[Gamma]) = exp( i (\[Phi]+\[Pi]/2)),

see equations 43 and 45\
\>", "Text",
 CellChangeTimes->{{3.8832353391409926`*^9, 3.883235358591131*^9}, {
  3.883235786471593*^9, 3.883235986968625*^9}, {3.8832361334381647`*^9, 
  3.8832361833608184`*^9}, {3.8832364537358513`*^9, 3.8832364588258266`*^9}, {
  3.8832365988085165`*^9, 3.883236701113158*^9}, {3.883571951270794*^9, 
  3.8835719783398023`*^9}},
 Background->RGBColor[
  0.87, 0.94, 1],ExpressionUUID->"e6e0a9f8-be7f-406e-892a-55b991a5599d"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"\[Phi]", "+", 
    RowBox[{"\[Pi]", "/", "2"}]}], "/.", "params"}], "//", "N"}]], "Input",
 CellChangeTimes->{{3.8832365868511295`*^9, 3.8832365941395197`*^9}, {
  3.8832366442751474`*^9, 3.8832366473449736`*^9}, {3.883571985011963*^9, 
  3.883571986410207*^9}},
 CellLabel->"In[24]:=",ExpressionUUID->"69ef5dd9-b8ed-4cc5-88ef-5c375d33b5a2"],

Cell[BoxData["0.7853981633974483`"], "Output",
 CellChangeTimes->{{3.8832366214682665`*^9, 3.883236647601957*^9}, 
   3.883252215041514*^9, 3.883392978682514*^9, 3.8834049980023956`*^9, 
   3.883473229847475*^9, 3.8834735591519456`*^9, 3.883479810016861*^9, 
   3.883489447806864*^9, 3.8834897113265376`*^9, 3.883572255156499*^9},
 CellLabel->"Out[24]=",ExpressionUUID->"d66c01a4-9117-47d7-b828-ed9900f0e5d7"]
}, Open  ]],

Cell["\<\
This can easily be explained by looking at the coherent and pulse propagator \
at the end of the sequence. For an even echo number these will be given by \
the identity. \
\>", "Text",
 CellChangeTimes->{{3.8832353391409926`*^9, 3.883235358591131*^9}, {
  3.883235786471593*^9, 3.883235986968625*^9}, {3.8832362314624577`*^9, 
  3.883236266781556*^9}, {3.88323646653767*^9, 3.8832364672663383`*^9}, {
  3.883572001820834*^9, 3.883572009919928*^9}},
 Background->RGBColor[
  0.87, 0.94, 1],ExpressionUUID->"b90298d4-9609-4761-b537-816d73a97457"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"U0traj", "[", "nval", "]"}], "//", "MatrixRepresentation"}], "//",
   "MatrixForm"}]], "Input",
 CellChangeTimes->{{3.883234756768657*^9, 3.8832347818504834`*^9}, {
  3.8832348333511333`*^9, 3.883234833478154*^9}, {3.883236198923368*^9, 
  3.883236200994593*^9}, {3.883236430029332*^9, 3.8832364302780666`*^9}},
 CellLabel->"In[25]:=",ExpressionUUID->"598ee1f6-18bd-4fc1-bc33-79051daae4b9"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"0.999999999999996`", "0", "0", "0"},
     {"0", 
      RowBox[{"0.9916700106836974`", "\[VeryThinSpace]", "+", 
       RowBox[{"0.12880446386127684`", " ", "\[ImaginaryI]"}]}], "0", "0"},
     {"0", "0", "0.999999999999996`", "0"},
     {"0", "0", "0", 
      RowBox[{"0.9916700106836974`", "\[VeryThinSpace]", "+", 
       RowBox[{"0.12880446386127684`", " ", "\[ImaginaryI]"}]}]}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[
   SparseArray[
    Automatic, {4, 4}, 0, {
     1, {{0, 1, 2, 3, 4}, {{1}, {2}, {3}, {4}}}, {
      0.999999999999996, Complex[0.9916700106836974, 0.12880446386127684`], 
       0.999999999999996, Complex[
       0.9916700106836974, 0.12880446386127684`]}}]]]]], "Output",
 CellChangeTimes->{{3.883234764104469*^9, 3.883234782149603*^9}, {
   3.8832349931161823`*^9, 3.883235017336409*^9}, 3.8832350874928045`*^9, 
   3.8832352083652782`*^9, 3.8832360795558324`*^9, 3.8832361606611147`*^9, {
   3.8832361993279276`*^9, 3.8832362013318*^9}, 3.8832364305915785`*^9, {
   3.883236527983257*^9, 3.8832365326519327`*^9}, 3.883236621319661*^9, 
   3.8832522151146727`*^9, 3.8833929787243977`*^9, 3.883404998074391*^9, 
   3.8834732299262586`*^9, 3.8834735592447023`*^9, 3.883479810098569*^9, 
   3.8834894478637094`*^9, 3.8834897113843803`*^9, 3.8835722552243214`*^9},
 CellLabel->
  "Out[25]//MatrixForm=",ExpressionUUID->"bc61cb82-bb51-41bc-9eb1-\
be447bb35c30"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Urftraj", "[", "nval", "]"}], "//", "MatrixRepresentation"}], "//",
   "MatrixForm"}]], "Input",
 CellChangeTimes->{{3.8832347944159327`*^9, 3.883234812152153*^9}, {
  3.883234847862175*^9, 3.8832348481303096`*^9}, {3.88323488650453*^9, 
  3.883234920394659*^9}, {3.883236216542205*^9, 3.8832362263757124`*^9}, {
  3.8832365351423903`*^9, 3.8832365353913994`*^9}},
 CellLabel->"In[26]:=",ExpressionUUID->"1dcde28d-4150-48de-a3e5-116717062b65"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"0.9999999999999865`", "0", "0", "0"},
     {"0", "1.`", "0", "0"},
     {"0", "0", "0.9999999999999865`", "0"},
     {"0", "0", "0", "1.`"}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[
   SparseArray[
    Automatic, {4, 4}, 0, {
     1, {{0, 1, 2, 3, 4}, {{1}, {2}, {3}, {4}}}, {0.9999999999999865, 1., 
      0.9999999999999865, 1.}}]]]]], "Output",
 CellChangeTimes->{{3.8832348022048535`*^9, 3.8832348124688454`*^9}, 
   3.8832348484007826`*^9, {3.883234890865284*^9, 3.883234920863035*^9}, {
   3.8832349932191844`*^9, 3.8832350186066895`*^9}, 3.8832350875416775`*^9, 
   3.8832352085218573`*^9, 3.883236079616666*^9, 3.883236160708987*^9, {
   3.88323621968027*^9, 3.883236226612196*^9}, {3.883236528033112*^9, 
   3.8832365357061195`*^9}, 3.883236621369527*^9, 3.883252215165537*^9, 
   3.883392978766281*^9, 3.883404998119236*^9, 3.8834732299900904`*^9, 
   3.8834735593005447`*^9, 3.8834798101475587`*^9, 3.8834894479255433`*^9, 
   3.883489711438238*^9, 3.883572255287141*^9},
 CellLabel->
  "Out[26]//MatrixForm=",ExpressionUUID->"f2e69de4-af36-486f-9d0c-\
314dfa188ad8"]
}, Open  ]],

Cell["\<\
The vanishing dynamic phase in the interaction frame may be checked \
numerically:\
\>", "Text",
 CellChangeTimes->{{3.8832353391409926`*^9, 3.883235358591131*^9}, {
  3.883235786471593*^9, 3.883235986968625*^9}, {3.8832362314624577`*^9, 
  3.883236266781556*^9}, {3.88323646653767*^9, 3.8832364672663383`*^9}, {
  3.8832523390744677`*^9, 3.8832523412626123`*^9}, {3.883252781712857*^9, 
  3.883252783022479*^9}, {3.883572014609153*^9, 3.8835720681920843`*^9}},
 Background->RGBColor[
  0.87, 0.94, 1],ExpressionUUID->"9cbe3a32-9045-4e7f-817f-89b5a8458074"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Psi]func", "=", 
  RowBox[{"Interpolation", "[", 
   RowBox[{"Transpose", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"nval", "*", 
       RowBox[{"Range", "[", 
        RowBox[{"0", ",", "1", ",", 
         RowBox[{"1", "/", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"Length", "[", "\[Psi]traj", "]"}], "-", "1"}], ")"}]}]}],
         "]"}]}], ",", "\[Psi]traj"}], "}"}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.883252252643468*^9, 3.8832522646312304`*^9}, {
  3.8832522966152697`*^9, 3.8832523290848713`*^9}},
 CellLabel->"In[27]:=",ExpressionUUID->"42f09f6d-82da-4680-bf8e-a312c2c76923"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox["InterpolatingFunction",
    "SummaryHead"], "[", 
   DynamicModuleBox[{Typeset`open$$ = False, Typeset`embedState$$ = "Ready"}, 
    TemplateBox[{
      PaneSelectorBox[{False -> GridBox[{{
            PaneBox[
             ButtonBox[
              DynamicBox[
               FEPrivate`FrontEndResource["FEBitmaps", "SummaryBoxOpener"]], 
              ButtonFunction :> (Typeset`open$$ = True), Appearance -> None, 
              BaseStyle -> {}, Evaluator -> Automatic, Method -> 
              "Preemptive"], Alignment -> {Center, Center}, ImageSize -> 
             Dynamic[{
               Automatic, 
                3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}]], 
            GraphicsBox[{{
               GrayLevel[0.6], 
               AbsolutePointSize[5], 
               PointBox[{1, 1}], 
               PointBox[{2, 4}], 
               PointBox[{3, 2}], 
               PointBox[{4, 3}]}, {{}, {}, {
                AbsoluteThickness[1], 
                Opacity[1.], 
                LineBox[CompressedData["
1:eJwBMQPO/CFib1JlAgAAADIAAAACAAAA4ScLwZmZ6T/ACPskWpOYv4AjHgZ5
3Os/cnpQh5xu1j/qWn1XCVDuP5K7ih5ptuc/r+pongFN8D/CUK87BHLxP46d
cUQ/bPE/ujUa8/qu9j9TbqBw1aPyP/TWyyAhFfw/neDJZqDG8z+QAqdF9GsA
QM1wGePDAfU/VsVD/9nXAkCidscSKDf2P6Bp73exDQVA/B1wDMFX9z+TpM3k
wfUGQDzjPoyykPg/7M3Z+O7ZCEABSgjW2LT5P3pl9LwNcgpAbCYw0z/T+j86
ypori9cLQL0gflb/Cfw/lpOs9xIqDUCTvMaj8yv9Pw4alcoYNg5AT3Y1d0Bm
/j+pB2LLtyIPQLClAv7Nmv8/NnA5bbjSD0BLO2UnSF0AQFrcILXmpw9AsTLc
klX5AED+sDHBQukOQNp6UGP9igFAbZ+lR/sLDkD10dd20SgCQNHi3Mj38wxA
42MO5MXDAkAZdr6AZb8LQJRGQrZUVANArv7zEMKHCkA4OInLD/EDQLBlMO3M
IglAnnrNRWWDBEA3d8OX6skHQNf3wBnbEgVAD3D3ndNyBkADhMcwfa4FQHOK
7Wak/wRA8WDLrLk/BkC/MhCgYawDQNJM4msi3QZAwss/TmVLAkCGc6iEq3cH
QIsIg92+BgFA/OprAs8HCECrPCvgePD/P2VxQsMepAhAKXVLE0Xg/j+RSBbp
CDYJQPRz0a7WJ/4/kFqZaBPFCUDN4sX5uLj9P4J7LytKYApAvh1MbRmT/T82
7cJSG/EKQHzT1YZwwv0/3W1pvRiOC0B2LZ/10lT+P0c/DY2wIAxAVrX8MJA7
/z+DS2C2aLAMQElWzbMzPQBAsmbGIk1MDUCi9bAadCABQKTSKfTL3Q1AYexd
q+EpAkCJTaAId3sOQFyS/ndEhgNAQAPGdkIWD0BHWcLdahwFQLoJ6Umopg9A
vd1CiejSBkCTjw8wnSEQQPiVkXD08QhAq0KpbbNqEEBsk2Azxi4LQCyTGthZ
shBAYCBYjj+gDUAnaxVkFgARQMwfdA9ySBBAg+uOIqBIEUBj/5rHgMsRQNFn
q5SZmRFAL++xNeOlE0Dwt3AR
                 "]]}}}, AspectRatio -> 1, Axes -> False, Background -> 
             GrayLevel[0.93], Frame -> True, FrameStyle -> Directive[
               GrayLevel[0.7], 
               Thickness[Tiny]], FrameTicks -> None, ImageSize -> 
             Dynamic[{
               Automatic, 
                3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}], PlotRange -> {{0, 5}, {0, 5}}, LabelStyle -> 
             Directive[FontFamily -> "Helvetica", FontSize -> 14]], 
            GridBox[{{
               RowBox[{
                 TagBox["\"Domain: \"", "SummaryItemAnnotation"], 
                 "\[InvisibleSpace]", 
                 TagBox[
                  RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{"0.`", ",", "30.`"}], "}"}], "}"}], 
                  "SummaryItem"]}]}, {
               RowBox[{
                 TagBox["\"Output dimensions: \"", "SummaryItemAnnotation"], 
                 "\[InvisibleSpace]", 
                 TagBox[
                  RowBox[{"{", "4", "}"}], "SummaryItem"]}]}}, 
             GridBoxAlignment -> {
              "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, AutoDelete -> 
             False, GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {"Columns" -> {{2}}, "Rows" -> {{Automatic}}},
              BaseStyle -> {
              ShowStringCharacters -> False, NumberMarks -> False, 
               PrintPrecision -> 3, ShowSyntaxStyles -> False}]}}, 
          GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
          AutoDelete -> False, 
          GridBoxItemSize -> {
           "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
          BaselinePosition -> {1, 1}], True -> GridBox[{{
            PaneBox[
             ButtonBox[
              DynamicBox[
               FEPrivate`FrontEndResource["FEBitmaps", "SummaryBoxCloser"]], 
              ButtonFunction :> (Typeset`open$$ = False), Appearance -> None, 
              BaseStyle -> {}, Evaluator -> Automatic, Method -> 
              "Preemptive"], Alignment -> {Center, Center}, ImageSize -> 
             Dynamic[{
               Automatic, 
                3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}]], 
            GraphicsBox[{{
               GrayLevel[0.6], 
               AbsolutePointSize[5], 
               PointBox[{1, 1}], 
               PointBox[{2, 4}], 
               PointBox[{3, 2}], 
               PointBox[{4, 3}]}, {{}, {}, {
                AbsoluteThickness[1], 
                Opacity[1.], 
                LineBox[CompressedData["
1:eJwBMQPO/CFib1JlAgAAADIAAAACAAAA4ScLwZmZ6T/ACPskWpOYv4AjHgZ5
3Os/cnpQh5xu1j/qWn1XCVDuP5K7ih5ptuc/r+pongFN8D/CUK87BHLxP46d
cUQ/bPE/ujUa8/qu9j9TbqBw1aPyP/TWyyAhFfw/neDJZqDG8z+QAqdF9GsA
QM1wGePDAfU/VsVD/9nXAkCidscSKDf2P6Bp73exDQVA/B1wDMFX9z+TpM3k
wfUGQDzjPoyykPg/7M3Z+O7ZCEABSgjW2LT5P3pl9LwNcgpAbCYw0z/T+j86
ypori9cLQL0gflb/Cfw/lpOs9xIqDUCTvMaj8yv9Pw4alcoYNg5AT3Y1d0Bm
/j+pB2LLtyIPQLClAv7Nmv8/NnA5bbjSD0BLO2UnSF0AQFrcILXmpw9AsTLc
klX5AED+sDHBQukOQNp6UGP9igFAbZ+lR/sLDkD10dd20SgCQNHi3Mj38wxA
42MO5MXDAkAZdr6AZb8LQJRGQrZUVANArv7zEMKHCkA4OInLD/EDQLBlMO3M
IglAnnrNRWWDBEA3d8OX6skHQNf3wBnbEgVAD3D3ndNyBkADhMcwfa4FQHOK
7Wak/wRA8WDLrLk/BkC/MhCgYawDQNJM4msi3QZAwss/TmVLAkCGc6iEq3cH
QIsIg92+BgFA/OprAs8HCECrPCvgePD/P2VxQsMepAhAKXVLE0Xg/j+RSBbp
CDYJQPRz0a7WJ/4/kFqZaBPFCUDN4sX5uLj9P4J7LytKYApAvh1MbRmT/T82
7cJSG/EKQHzT1YZwwv0/3W1pvRiOC0B2LZ/10lT+P0c/DY2wIAxAVrX8MJA7
/z+DS2C2aLAMQElWzbMzPQBAsmbGIk1MDUCi9bAadCABQKTSKfTL3Q1AYexd
q+EpAkCJTaAId3sOQFyS/ndEhgNAQAPGdkIWD0BHWcLdahwFQLoJ6Umopg9A
vd1CiejSBkCTjw8wnSEQQPiVkXD08QhAq0KpbbNqEEBsk2Azxi4LQCyTGthZ
shBAYCBYjj+gDUAnaxVkFgARQMwfdA9ySBBAg+uOIqBIEUBj/5rHgMsRQNFn
q5SZmRFAL++xNeOlE0Dwt3AR
                 "]]}}}, AspectRatio -> 1, Axes -> False, Background -> 
             GrayLevel[0.93], Frame -> True, FrameStyle -> Directive[
               GrayLevel[0.7], 
               Thickness[Tiny]], FrameTicks -> None, ImageSize -> 
             Dynamic[{
               Automatic, 
                3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}], PlotRange -> {{0, 5}, {0, 5}}, LabelStyle -> 
             Directive[FontFamily -> "Helvetica", FontSize -> 14]], 
            GridBox[{{
               RowBox[{
                 TagBox["\"Domain: \"", "SummaryItemAnnotation"], 
                 "\[InvisibleSpace]", 
                 TagBox[
                  RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{"0.`", ",", "30.`"}], "}"}], "}"}], 
                  "SummaryItem"]}]}, {
               RowBox[{
                 TagBox["\"Output dimensions: \"", "SummaryItemAnnotation"], 
                 "\[InvisibleSpace]", 
                 TagBox[
                  RowBox[{"{", "4", "}"}], "SummaryItem"]}]}, {
               RowBox[{
                 TagBox["\"Order: \"", "SummaryItemAnnotation"], 
                 "\[InvisibleSpace]", 
                 TagBox["3", "SummaryItem"]}]}, {
               RowBox[{
                 TagBox["\"Method: \"", "SummaryItemAnnotation"], 
                 "\[InvisibleSpace]", 
                 TagBox["\"Hermite\"", "SummaryItem"]}]}, {
               RowBox[{
                 TagBox["\"Periodic: \"", "SummaryItemAnnotation"], 
                 "\[InvisibleSpace]", 
                 TagBox["False", "SummaryItem"]}]}}, 
             GridBoxAlignment -> {
              "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, AutoDelete -> 
             False, GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {"Columns" -> {{2}}, "Rows" -> {{Automatic}}},
              BaseStyle -> {
              ShowStringCharacters -> False, NumberMarks -> False, 
               PrintPrecision -> 3, ShowSyntaxStyles -> False}]}}, 
          GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
          AutoDelete -> False, 
          GridBoxItemSize -> {
           "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
          BaselinePosition -> {1, 1}]}, 
       Dynamic[Typeset`open$$], ImageSize -> Automatic]},
     "SummaryPanel"],
    DynamicModuleValues:>{}], "]"}],
  InterpolatingFunction[{{0., 30.}}, {
   5, 3, 0, {161}, {4}, 0, 0, 0, 0, Automatic, {}, {}, False}, CompressedData["
1:eJxdzUtqFkEYBdAyYjAo2sbEt0kl8RWf8W3UxF6CuIJGcGwvoZbwL6HdQS+h
hg576LBwlJH8CEIgEBTqjCwoDh+Xy934/PXTl4UQwol//1v4/33/UP3Bnzzg
L/7mHx7yiMfVFNp6L1TTSfcp96L7tHvJfcZ91n3OfZ5Ntb0gX65mpovyFfmq
nOmS/LL8ipzpqvya/Lqc6Yb8pnxNzrRejdHNwnajOjBsVjtmxi19Fra39Blu
6zMz3tFnYXtXn+GePjPjtj4L2/v6DA/0mRkf6rOwfaTP8FifmfGJPgvjTvUj
E0cWNk/tsefAieFZdYcdZ8ycMz63z8SRhc0L++w5cGJ4aZ8dZ8ycM76yz8SR
hc1r++w5cGJ4Y58dZ8ycM+7aZ+LIwuatffYcODG8s8+OM2bOGd/bZ+LIwmbP
PnsOnBj227/eXI0N
   "], {{{0., 0., 0.9999999999999991, 0.}}, {{
      Complex[-6.938893903907228*^-18, 0.], 
      Complex[0., 0.], 
      Complex[0.9999999999999992, 3.1280327831860794`*^-17], 
      Complex[0., 0.]}}, {{
      Complex[0., 0.], 
      Complex[0., 0.], 
      Complex[0.9999999999999993, 1.7133611867112954`*^-17], 
      Complex[0., 0.]}}, {{
      Complex[-0.10452846326765339`, 2.2551405187698492`*^-17], 
      Complex[0., 0.], 
      Complex[0.9945218953682722, 5.984795992119984*^-17], 
      Complex[0., 0.]}}, {{
      Complex[-0.10452846326765333`, -1.734723475976807*^-17], 
      Complex[0., 0.], 
      Complex[0.9945218953682725, 3.5171518475429764`*^-16], 
      Complex[0., 0.]}}, {{
      Complex[-0.10452846326765339`, -6.938893903907228*^-18], 
      Complex[0., 0.], 
      Complex[0.9945218953682722, 3.404394821604484*^-17], 
      Complex[0., 0.]}}, {{
      Complex[-0.1045284632676533, 1.734723475976807*^-17], 
      Complex[0., 0.], 
      Complex[0.9945218953682714, -1.0625181290357943`*^-17], 
      Complex[0., 0.]}}, {{
      Complex[-0.1045284632676532, -2.7755575615628914`*^-17], 
      Complex[0., 0.], 
      Complex[0.9945218953682714, 1.5525775109992423`*^-16], 
      Complex[0., 0.]}}, {{
      Complex[-0.20791169081775884`, 0.], 
      Complex[0., 0.], 
      Complex[0.9781476007338032, 0.], 
      Complex[0., 0.]}}, {{
      Complex[-0.20791169081775876`, 1.734723475976807*^-17], 
      Complex[0., 0.], 
      Complex[0.9781476007338034, -1.734723475976807*^-18], 
      Complex[0., 0.]}}, {{
      Complex[-0.20791169081775895`, -5.551115123125783*^-17], 
      Complex[0., 0.], 
      Complex[0.9781476007338036, -5.898059818321144*^-17], 
      Complex[0., 0.]}}, {{
      Complex[-0.20791169081775857`, -4.85722573273506*^-17], 
      Complex[0., 0.], 
      Complex[0.9781476007338028, -4.380176776841438*^-17], 
      Complex[0., 0.]}}, {{
      Complex[-0.20791169081775873`, 1.734723475976807*^-17], 
      Complex[0., 0.], 
      Complex[0.9781476007338029, 5.551115123125783*^-17], 
      Complex[0., 0.]}}, {{
      Complex[-0.20791169081775862`, 1.9081958235744878`*^-17], 
      Complex[0., 0.], 
      Complex[0.9781476007338027, 6.895525817007808*^-17], 
      Complex[0., 0.]}}, {{
      Complex[-0.30901699437494623`, -4.5102810375396984`*^-17], 
      Complex[0., 0.], 
      Complex[0.9510565162951506, 2.7755575615628914`*^-17], 
      Complex[0., 0.]}}, {{
      Complex[-0.30901699437494634`, -7.979727989493313*^-17], 
      Complex[0., 0.], 
      Complex[0.9510565162951505, 5.637851296924623*^-17], 
      Complex[0., 0.]}}, {{
      Complex[-0.30901699437494606`, 0.], 
      Complex[0., 0.], 
      Complex[0.9510565162951496, 0.], 
      Complex[0., 0.]}}, {{
      Complex[-0.3090169943749463, -8.673617379884035*^-17], 
      Complex[0., 0.], 
      Complex[0.95105651629515, 1.1449174941446927`*^-16], 
      Complex[0., 0.]}}, {{
      Complex[-0.3090169943749463, -1.734723475976807*^-17], 
      Complex[0., 0.], 
      Complex[0.9510565162951498, -7.632783294297951*^-17], 
      Complex[0., 0.]}}, {{
      Complex[-0.4067366430757982, -1.734723475976807*^-18], 
      Complex[0., 0.], 
      Complex[0.9135454576425964, 7.112366251504909*^-17], 
      Complex[0., 0.]}}, {{
      Complex[-0.40673664307579854`, 1.1102230246251565`*^-16], 
      Complex[0., 0.], 
      Complex[0.9135454576425969, -3.122502256758253*^-17], 
      Complex[0., 0.]}}, {{
      Complex[-0.40673664307579827`, -1.734723475976807*^-17], 
      Complex[0., 0.], 
      Complex[0.9135454576425965, -5.204170427930421*^-18], 
      Complex[0., 0.]}}, {{
      Complex[-0.4067366430757982, 1.734723475976807*^-17], 
      Complex[0., 0.], 
      Complex[0.9135454576425961, 1.0321604682062002`*^-16], 
      Complex[0., 0.]}}, {{
      Complex[-0.40673664307579827`, -3.469446951953614*^-17], 
      Complex[0., 0.], 
      Complex[0.9135454576425963, -2.949029909160572*^-17], 
      Complex[0., 0.]}}, {{
      Complex[-0.4999999999999971, 0.], 
      Complex[0., 0.], 
      Complex[0.8660254037844335, 0.], 
      Complex[0., 0.]}}, {{
      Complex[-0.49999999999999717`, -1.3530843112619095`*^-16], 
      Complex[0., 0.], 
      Complex[0.8660254037844339, 1.3357370765021415`*^-16], 
      Complex[0., 0.]}}, {{
      Complex[-0.4999999999999973, 0.], 
      Complex[0., 0.], 
      Complex[0.8660254037844336, 2.949029909160572*^-17], 
      Complex[0., 0.]}}, {{
      Complex[-0.49999999999999684`, -6.938893903907228*^-18], 
      Complex[0., 0.], 
      Complex[0.8660254037844329, -6.071532165918825*^-18], 
      Complex[0., 0.]}}, {{
      Complex[-0.49999999999999684`, 1.491862189340054*^-16], 
      Complex[0., 0.], 
      Complex[0.8660254037844334, 1.6132928326584306`*^-16], 
      Complex[0., 0.]}}, {{
      Complex[-0.4999999999999969, -3.469446951953614*^-17], 
      Complex[0., 0.], 
      Complex[0.8660254037844332, 6.418476861114186*^-17], 
      Complex[0., 0.]}}, {{
      Complex[-0.5877852522924691, 3.9898639947466563`*^-17], 
      Complex[0., 0.], 
      Complex[0.8090169943749418, 0.], 
      Complex[0., 0.]}}, {{
      Complex[-0.5877852522924689, -4.85722573273506*^-17], 
      Complex[0., 0.], 
      Complex[0.8090169943749418, -6.765421556309548*^-17], 
      Complex[0., 0.]}}, {{
      Complex[-0.5877852522924686, 0.], 
      Complex[0., 0.], 
      Complex[0.8090169943749412, 0.], 
      Complex[0., 0.]}}, {{
      Complex[-0.5877852522924687, 1.3877787807814457`*^-17], 
      Complex[0., 0.], 
      Complex[0.8090169943749413, -2.2551405187698492`*^-17], 
      Complex[0., 0.]}}, {{
      Complex[-0.5877852522924686, -6.245004513516506*^-17], 
      Complex[0., 0.], 
      Complex[0.809016994374941, 7.632783294297951*^-17], 
      Complex[0., 0.]}}, {{
      Complex[-0.6691306063588526, -2.42861286636753*^-17], 
      Complex[0., 0.], 
      Complex[0.7431448254773882, 4.597017211338539*^-17], 
      Complex[0., 0.]}}, {{
      Complex[-0.6691306063588529, -7.632783294297951*^-17], 
      Complex[0., 0.], 
      Complex[0.7431448254773886, 1.734723475976807*^-17], 
      Complex[0., 0.]}}, {{
      Complex[-0.669130606358853, -2.6020852139652106`*^-17], 
      Complex[0., 0.], 
      Complex[0.7431448254773884, 1.9949319973733282`*^-17], 
      Complex[0., 0.]}}, {{
      Complex[-0.6691306063588526, -6.938893903907228*^-18], 
      Complex[0., 0.], 
      Complex[0.7431448254773879, -9.8879238130678*^-17], 
      Complex[0., 0.]}}, {{
      Complex[-0.6691306063588524, -2.7755575615628914`*^-17], 
      Complex[0., 0.], 
      Complex[0.7431448254773879, -3.469446951953614*^-18], 
      Complex[0., 0.]}}, {{
      Complex[-0.7431448254773875, 0.], 
      Complex[0., 0.], 
      Complex[0.669130606358852, 0.], 
      Complex[0., 0.]}}, {{
      Complex[-0.7431448254773874, -6.938893903907228*^-18], 
      Complex[0., 0.], 
      Complex[0.6691306063588522, 6.591949208711867*^-17], 
      Complex[0., 0.]}}, {{
      Complex[-0.7431448254773875, 1.734723475976807*^-18], 
      Complex[0., 0.], 
      Complex[0.6691306063588522, -1.5612511283791264`*^-17], 
      Complex[0., 0.]}}, {{
      Complex[-0.743144825477387, 4.9439619065339*^-17], 
      Complex[0., 0.], 
      Complex[0.6691306063588517, 2.6020852139652106`*^-18], 
      Complex[0., 0.]}}, {{
      Complex[-0.7431448254773871, -1.3183898417423734`*^-16], 
      Complex[0., 0.], 
      Complex[0.669130606358852, 8.326672684688674*^-17], 
      Complex[0., 0.]}}, {{
      Complex[-0.7431448254773871, -3.122502256758253*^-17], 
      Complex[0., 0.], 
      Complex[0.6691306063588518, 8.239936510889834*^-17], 
      Complex[0., 0.]}}, {{
      Complex[-0.809016994374939, -3.642919299551295*^-17], 
      Complex[0., 0.], 
      Complex[0.5877852522924673, 2.2551405187698492`*^-17], 
      Complex[0., 0.]}}, {{
      Complex[-0.809016994374939, -1.734723475976807*^-17], 
      Complex[0., 0.], 
      Complex[0.5877852522924671, 6.245004513516506*^-17], 
      Complex[0., 0.]}}, {{
      Complex[-0.8090169943749387, 0.], 
      Complex[0., 0.], 
      Complex[0.5877852522924669, 0.], 
      Complex[0., 0.]}}, {{
      Complex[-0.8090169943749388, -2.896988204881268*^-16], 
      Complex[0., 0.], 
      Complex[0.587785252292467, -1.0408340855860843`*^-16], 
      Complex[0., 0.]}}, {{
      Complex[-0.8090169943749388, 1.0408340855860843`*^-16], 
      Complex[0., 0.], 
      Complex[0.5877852522924667, 1.0234868508263162`*^-16], 
      Complex[0., 0.]}}, {{
      Complex[-0.8660254037844288, -3.209238430557093*^-17], 
      Complex[0., 0.], 
      Complex[0.4999999999999944, 2.2551405187698492`*^-17], 
      Complex[0., 0.]}}, {{
      Complex[-0.8660254037844289, 2.2551405187698492`*^-17], 
      Complex[0., 0.], 
      Complex[0.49999999999999467`, 1.0408340855860843`*^-17], 
      Complex[0., 0.]}}, {{
      Complex[-0.8660254037844288, -3.903127820947816*^-17], 
      Complex[0., 0.], 
      Complex[0.4999999999999945, 1.0408340855860843`*^-17], 
      Complex[0., 0.]}}, {{
      Complex[-0.8660254037844285, -7.806255641895632*^-17], 
      Complex[0., 0.], 
      Complex[0.4999999999999945, 6.245004513516506*^-17], 
      Complex[0., 0.]}}, {{
      Complex[-0.8660254037844285, -1.3530843112619095`*^-16], 
      Complex[0., 0.], 
      Complex[0.49999999999999445`, 5.898059818321144*^-17], 
      Complex[0., 0.]}}, {{
      Complex[-0.9135454576425894, 0.], 
      Complex[0., 0.], 
      Complex[0.40673664307579527`, 0.], 
      Complex[0., 0.]}}, {{
      Complex[-0.9135454576425894, 2.6020852139652106`*^-17], 
      Complex[0., 0.], 
      Complex[0.40673664307579543`, -7.28583859910259*^-17], 
      Complex[0., 0.]}}, {{
      Complex[-0.9135454576425895, -1.1102230246251565`*^-16], 
      Complex[0., 0.], 
      Complex[0.4067366430757953, 2.42861286636753*^-17], 
      Complex[0., 0.]}}, {{
      Complex[-0.9135454576425889, -7.025630077706069*^-17], 
      Complex[0., 0.], 
      Complex[0.40673664307579505`, -1.214306433183765*^-17], 
      Complex[0., 0.]}}, {{
      Complex[-0.9135454576425893, -2.1510571102112408`*^-16], 
      Complex[0., 0.], 
      Complex[0.4067366430757952, 0.], 
      Complex[0., 0.]}}, {{
      Complex[-0.9135454576425893, -1.0668549377257364`*^-16], 
      Complex[0., 0.], 
      Complex[0.40673664307579505`, 5.377642775528102*^-17], 
      Complex[0., 0.]}}, {{
      Complex[-0.9510565162951408, 4.423544863740858*^-17], 
      Complex[0., 0.], 
      Complex[0.30901699437494357`, 4.85722573273506*^-17], 
      Complex[0., 0.]}}, {{
      Complex[-0.9510565162951403, 1.4051260155412137`*^-16], 
      Complex[0., 0.], 
      Complex[0.30901699437494345`, -6.938893903907228*^-18], 
      Complex[0., 0.]}}, {{
      Complex[-0.95105651629514, 0.], 
      Complex[0., 0.], 
      Complex[0.30901699437494323`, 0.], 
      Complex[0., 0.]}}, {{
      Complex[-0.9510565162951401, 4.336808689942018*^-17], 
      Complex[0., 0.], 
      Complex[0.30901699437494323`, -3.469446951953614*^-17], 
      Complex[0., 0.]}}, {{
      Complex[-0.9510565162951404, 1.1449174941446927`*^-16], 
      Complex[0., 0.], 
      Complex[0.30901699437494334`, -2.0816681711721685`*^-17], 
      Complex[0., 0.]}}, {{
      Complex[-0.9781476007337914, -3.5128150388530344`*^-17], 
      Complex[0., 0.], 
      Complex[0.20791169081775662`, -5.204170427930421*^-18], 
      Complex[0., 0.]}}, {{
      Complex[-0.9781476007337914, 9.71445146547012*^-17], 
      Complex[0., 0.], 
      Complex[0.20791169081775676`, 5.551115123125783*^-17], 
      Complex[0., 0.]}}, {{
      Complex[-0.9781476007337915, 5.594483210025203*^-17], 
      Complex[0., 0.], 
      Complex[0.20791169081775673`, -2.949029909160572*^-17], 
      Complex[0., 0.]}}, {{
      Complex[-0.9781476007337907, -6.245004513516506*^-17], 
      Complex[0., 0.], 
      Complex[0.20791169081775643`, -5.204170427930421*^-17], 
      Complex[0., 0.]}}, {{
      Complex[-0.9781476007337907, -1.5092094240998222`*^-16], 
      Complex[0., 0.], 
      Complex[0.20791169081775657`, -1.0408340855860843`*^-17], 
      Complex[0., 0.]}}, {{
      Complex[-0.9945218953682575, 0.], 
      Complex[0., 0.], 
      Complex[0.10452846326765224`, 0.], 
      Complex[0., 0.]}}, {{
      Complex[-0.9945218953682576, 1.0928757898653885`*^-16], 
      Complex[0., 0.], 
      Complex[0.10452846326765217`, 6.938893903907228*^-18], 
      Complex[0., 0.]}}, {{
      Complex[-0.9945218953682575, 9.75781955236954*^-18], 
      Complex[0., 0.], 
      Complex[0.10452846326765225`, -3.122502256758253*^-17], 
      Complex[0., 0.]}}, {{
      Complex[-0.994521895368257, 4.119968255444917*^-17], 
      Complex[0., 0.], 
      Complex[0.10452846326765208`, 2.2551405187698492`*^-17], 
      Complex[0., 0.]}}, {{
      Complex[-0.9945218953682574, -2.3375398838787476`*^-16], 
      Complex[0., 0.], 
      Complex[0.10452846326765208`, 5.898059818321144*^-17], 
      Complex[0., 0.]}}, {{
      Complex[-0.9945218953682572, -1.3509159069169385`*^-16], 
      Complex[0., 0.], 
      Complex[0.10452846326765212`, 1.9081958235744878`*^-17], 
      Complex[0., 0.]}}, {{
      Complex[-0.9999999999999835, -2.677248245353073*^-18], 
      Complex[0., 0.], 
      Complex[2.1510571102112408`*^-16, 8.673617379884035*^-17], 
      Complex[0., 0.]}}, {{
      Complex[-0.9999999999999831, -2.352811505914882*^-16], 
      Complex[0., 0.], 
      Complex[9.71445146547012*^-17, 1.3530843112619095`*^-16], 
      Complex[0., 0.]}}, {{
      Complex[-0.9999999999999828, 0.], 
      Complex[0., 0.], 
      Complex[0., 0.], 
      Complex[0., 0.]}}, {{
      Complex[-0.9991977501506905, -8.25891004890833*^-17], 
      Complex[0., 0.], 
      Complex[-0.015307839032043137`, 0.037007109559267344`], 
      Complex[0., 0.]}}, {{
      Complex[-0.9991977501506911, -3.5778671692021646`*^-17], 
      Complex[0., 0.], 
      Complex[-0.015307839032043205`, 0.03700710955926738], 
      Complex[0., 0.]}}, {{
      Complex[-0.9991977501506906, -2.47198095326695*^-17], 
      Complex[0., 0.], 
      Complex[-0.015307839032042914`, 0.03700710955926737], 
      Complex[0., 0.]}}, {{
      Complex[-0.9945218953682552, 0.003868296292208149], 
      Complex[0., 0.], 
      Complex[0.07391278520356541, 0.07381149030025126], 
      Complex[0., 0.]}}, {{
      Complex[-0.9945218953682553, 0.003868296292207902], 
      Complex[0., 0.], 
      Complex[0.07391278520356534, 0.07381149030025125], 
      Complex[0., 0.]}}, {{
      Complex[-0.9921239354376099, 6.136584296267955*^-17], 
      Complex[0., 0.], 
      Complex[0.05877266205932839, 0.11061587104123496`], 
      Complex[0., 0.]}}, {{
      Complex[-0.9921239354376101, 1.6566609195578508`*^-16], 
      Complex[0., 0.], 
      Complex[0.05877266205932838, 0.11061587104123502`], 
      Complex[0., 0.]}}, {{
      Complex[-0.9921239354376097, 1.7867651802561113`*^-16], 
      Complex[0., 0.], 
      Complex[0.05877266205932847, 0.11061587104123499`], 
      Complex[0., 0.]}}, {{
      Complex[-0.9781476007337865, 0.007694210720745499], 
      Complex[0., 0.], 
      Complex[0.1470157664651955, 0.1468142864667254], 
      Complex[0., 0.]}}, {{
      Complex[-0.9781476007337866, 0.007694210720745587], 
      Complex[0., 0.], 
      Complex[0.1470157664651955, 0.14681428646672548`], 
      Complex[0., 0.]}}, {{
      Complex[-0.9781476007337863, 0.007694210720745704], 
      Complex[0., 0.], 
      Complex[0.14701576646519535`, 0.1468142864667253], 
      Complex[0., 0.]}}, {{
      Complex[-0.9741802032725939, 6.574601973952099*^-16], 
      Complex[0., 0.], 
      Complex[0.1322092375662077, 0.18301270189221558`], 
      Complex[0., 0.]}}, {{
      Complex[-0.9741802032725941, 2.185751579730777*^-16], 
      Complex[0., 0.], 
      Complex[0.13220923756620753`, 0.18301270189221555`], 
      Complex[0., 0.]}}, {{
      Complex[-0.9510565162951335, 0.011435825766509398`], 
      Complex[0., 0.], 
      Complex[0.2185080122244057, 0.21820855458780522`], 
      Complex[0., 0.]}}, {{
      Complex[-0.9510565162951335, 0.011435825766509285`], 
      Complex[0., 0.], 
      Complex[0.2185080122244057, 0.2182085545878052], 
      Complex[0., 0.]}}, {{
      Complex[-0.9510565162951333, 0.011435825766509523`], 
      Complex[0., 0.], 
      Complex[0.2185080122244054, 0.2182085545878052], 
      Complex[0., 0.]}}, {{
      Complex[-0.9455631489402098, 1.9081958235744878`*^-16], 
      Complex[0., 0.], 
      Complex[0.20419730099974936`, 0.2534044072833947], 
      Complex[0., 0.]}}, {{
      Complex[-0.9455631489402104, 1.7694179454963432`*^-16], 
      Complex[0., 0.], 
      Complex[0.20419730099974942`, 0.25340440728339486`], 
      Complex[0., 0.]}}, {{
      Complex[-0.9455631489402099, 3.608224830031759*^-16], 
      Complex[0., 0.], 
      Complex[0.20419730099974923`, 0.25340440728339486`], 
      Complex[0., 0.]}}, {{
      Complex[-0.9135454576425803, 0.015052147512075367`], 
      Complex[0., 0.], 
      Complex[0.2876062384759442, 0.28721208412174515`], 
      Complex[0., 0.]}}, {{
      Complex[-0.9135454576425805, 0.01505214751207501], 
      Complex[0., 0.], 
      Complex[0.2876062384759438, 0.28721208412174537`], 
      Complex[0., 0.]}}, {{
      Complex[-0.9065863068762271, 4.744468706796567*^-16], 
      Complex[0., 0.], 
      Complex[0.27394813607250545`, 0.3210197609600958], 
      Complex[0., 0.]}}, {{
      Complex[-0.9065863068762272, 5.898059818321144*^-16], 
      Complex[0., 0.], 
      Complex[0.27394813607250557`, 0.3210197609600958], 
      Complex[0., 0.]}}, {{
      Complex[-0.9065863068762273, 5.204170427930421*^-16], 
      Complex[0., 0.], 
      Complex[0.27394813607250523`, 0.32101976096009577`], 
      Complex[0., 0.]}}, {{
      Complex[-0.8660254037844185, 0.018503554779633714`], 
      Complex[0., 0.], 
      Complex[0.3535533905932645, 0.35306885795905474`], 
      Complex[0., 0.]}}, {{
      Complex[-0.8660254037844184, 0.018503554779633922`], 
      Complex[0., 0.], 
      Complex[0.3535533905932647, 0.353068857959055], 
      Complex[0., 0.]}}, {{
      Complex[-0.8660254037844182, 0.018503554779634206`], 
      Complex[0., 0.], 
      Complex[0.3535533905932647, 0.35306885795905485`], 
      Complex[0., 0.]}}, {{
      Complex[-0.8576767155187273, 1.3634926521177704`*^-15], 
      Complex[0., 0.], 
      Complex[0.34069753803911873`, 0.38511795495801354`], 
      Complex[0., 0.]}}, {{
      Complex[-0.8576767155187278, 5.551115123125783*^-16], 
      Complex[0., 0.], 
      Complex[0.3406975380391179, 0.3851179549580141], 
      Complex[0., 0.]}}, {{
      Complex[-0.8090169943749279, 0.021752233228909453`], 
      Complex[0., 0.], 
      Complex[0.4156269377774421, 0.4150573355041564], 
      Complex[0., 0.]}}, {{
      Complex[-0.8090169943749278, 0.021752233228909543`], 
      Complex[0., 0.], 
      Complex[0.4156269377774423, 0.41505733550415647`], 
      Complex[0., 0.]}}, {{
      Complex[-0.8090169943749275, 0.021752233228909717`], 
      Complex[0., 0.], 
      Complex[0.4156269377774421, 0.41505733550415647`], 
      Complex[0., 0.]}}, {{
      Complex[-0.7993702385856132, 7.494005416219807*^-16], 
      Complex[0., 0.], 
      Complex[0.4037141864834304, 0.4449967160502986], 
      Complex[0., 0.]}}, {{
      Complex[-0.7993702385856137, 9.020562075079397*^-16], 
      Complex[0., 0.], 
      Complex[0.4037141864834305, 0.44499671605029895`], 
      Complex[0., 0.]}}, {{
      Complex[-0.7993702385856136, 6.557254739192331*^-16], 
      Complex[0., 0.], 
      Complex[0.40371418648342994`, 0.4449967160502986], 
      Complex[0., 0.]}}, {{
      Complex[-0.7431448254773746, 0.02476258965898241], 
      Complex[0., 0.], 
      Complex[0.47314678925580206`, 0.4724983580251421], 
      Complex[0., 0.]}}, {{
      Complex[-0.7431448254773754, 0.024762589658981947`], 
      Complex[0., 0.], 
      Complex[0.4731467892558018, 0.47249835802514306`], 
      Complex[0., 0.]}}, {{
      Complex[-0.732305694039579, 1.115427195053087*^-15], 
      Complex[0., 0.], 
      Complex[0.4623076578180055, 0.49999999999998673`], 
      Complex[0., 0.]}}, {{
      Complex[-0.7323056940395795, 1.1310397063368782`*^-15], 
      Complex[0., 0.], 
      Complex[0.46230765781800537`, 0.49999999999998684`], 
      Complex[0., 0.]}}, {{
      Complex[-0.7323056940395792, 1.0373646386341306`*^-15], 
      Complex[0., 0.], 
      Complex[0.46230765781800476`, 0.4999999999999868], 
      Complex[0., 0.]}}, {{
      Complex[-0.669130606358841, 0.027501641974845115`], 
      Complex[0., 0.], 
      Complex[0.5254827454987431, 0.5247625896589679], 
      Complex[0., 0.]}}, {{
      Complex[-0.6691306063588408, 0.02750164197484519], 
      Complex[0., 0.], 
      Complex[0.5254827454987432, 0.524762589658968], 
      Complex[0., 0.]}}, {{
      Complex[-0.6691306063588406, 0.027501641974845573`], 
      Complex[0., 0.], 
      Complex[0.5254827454987432, 0.5247625896589678], 
      Complex[0., 0.]}}, {{
      Complex[-0.6572178550648283, 2.2863655413374318`*^-15], 
      Complex[0., 0.], 
      Complex[0.5158359897094303, 0.5495251793179475], 
      Complex[0., 0.]}}, {{
      Complex[-0.6572178550648294, 1.2906342661267445`*^-15], 
      Complex[0., 0.], 
      Complex[0.515835989709429, 0.5495251793179484], 
      Complex[0., 0.]}}, {{
      Complex[-0.5877852522924578, 0.029939380546143785`], 
      Complex[0., 0.], 
      Complex[0.5720614028176659, 0.571277412546857], 
      Complex[0., 0.]}}, {{
      Complex[-0.5877852522924576, 0.02993938054614386], 
      Complex[0., 0.], 
      Complex[0.5720614028176666, 0.5712774125468576], 
      Complex[0., 0.]}}, {{
      Complex[-0.5877852522924571, 0.029939380546144107`], 
      Complex[0., 0.], 
      Complex[0.5720614028176664, 0.5712774125468573], 
      Complex[0., 0.]}}, {{
      Complex[-0.5749293997383106, 1.8006429680639258`*^-15], 
      Complex[0., 0.], 
      Complex[0.563712714551976, 0.5930296457757658], 
      Complex[0., 0.]}}, {{
      Complex[-0.5749293997383115, 1.6653345369377348`*^-15], 
      Complex[0., 0.], 
      Complex[0.563712714551976, 0.593029645775766], 
      Complex[0., 0.]}}, {{
      Complex[-0.5749293997383109, 1.5716594692349872`*^-15], 
      Complex[0., 0.], 
      Complex[0.563712714551975, 0.593029645775766], 
      Complex[0., 0.]}}, {{
      Complex[-0.49999999999998535`, 0.03204909699896144], 
      Complex[0., 0.], 
      Complex[0.6123724356957758, 0.6115332005553982], 
      Complex[0., 0.]}}, {{
      Complex[-0.49999999999998607`, 0.03204909699896087], 
      Complex[0., 0.], 
      Complex[0.6123724356957747, 0.6115332005553995], 
      Complex[0., 0.]}}, {{
      Complex[-0.48634189759654783`, 2.0643209364124004`*^-15], 
      Complex[0., 0.], 
      Complex[0.6054132849294216, 0.6300367553350323], 
      Complex[0., 0.]}}, {{
      Complex[-0.48634189759654817`, 2.0747292772682613`*^-15], 
      Complex[0., 0.], 
      Complex[0.6054132849294216, 0.6300367553350325], 
      Complex[0., 0.]}}, {{
      Complex[-0.48634189759654817`, 1.9914625504213745`*^-15], 
      Complex[0., 0.], 
      Complex[0.6054132849294206, 0.6300367553350322], 
      Complex[0., 0.]}}, {{
      Complex[-0.406736643075789, 0.033807676838352174`], 
      Complex[0., 0.], 
      Complex[0.6459741880212285, 0.6450889028471067], 
      Complex[0., 0.]}}, {{
      Complex[-0.40673664307578883`, 0.03380767683835228], 
      Complex[0., 0.], 
      Complex[0.645974188021229, 0.6450889028471072], 
      Complex[0., 0.]}}, {{
      Complex[-0.4067366430757885, 0.03380767683835252], 
      Complex[0., 0.], 
      Complex[0.6459741880212289, 0.6450889028471068], 
      Complex[0., 0.]}}, {{
      Complex[-0.392425931851132, 3.2127078775090467`*^-15], 
      Complex[0., 0.], 
      Complex[0.6404808206663075, 0.6601410503591788], 
      Complex[0., 0.]}}, {{
      Complex[-0.39242593185113284`, 2.2412627309620348`*^-15], 
      Complex[0., 0.], 
      Complex[0.640480820666305, 0.6601410503591804], 
      Complex[0., 0.]}}, {{
      Complex[-0.30901699437493885`, 0.03519585269559177], 
      Complex[0., 0.], 
      Complex[0.6724985119639327, 0.6715768761256895], 
      Complex[0., 0.]}}, {{
      Complex[-0.3090169943749386, 0.03519585269559163], 
      Complex[0., 0.], 
      Complex[0.6724985119639331, 0.6715768761256902], 
      Complex[0., 0.]}}, {{
      Complex[-0.30901699437493846`, 0.03519585269559183], 
      Complex[0., 0.], 
      Complex[0.6724985119639333, 0.67157687612569], 
      Complex[0., 0.]}}, {{
      Complex[-0.29421046547595087`, 2.9073965457371287`*^-15], 
      Complex[0., 0.], 
      Complex[0.668531114502741, 0.683012701892198], 
      Complex[0., 0.]}}, {{
      Complex[-0.2942104654759511, 2.4980018054066022`*^-15], 
      Complex[0., 0.], 
      Complex[0.6685311145027407, 0.6830127018921979], 
      Complex[0., 0.]}}, {{
      Complex[-0.29421046547595103`, 2.435551760271437*^-15], 
      Complex[0., 0.], 
      Complex[0.6685311145027396, 0.6830127018921981], 
      Complex[0., 0.]}}, {{
      Complex[-0.20791169081775301`, 0.03619841542549307], 
      Complex[0., 0.], 
      Complex[0.6916548014802016, 0.6907069126129414], 
      Complex[0., 0.]}}, {{
      Complex[-0.20791169081775351`, 0.036198415425492785`], 
      Complex[0., 0.], 
      Complex[0.6916548014802001, 0.6907069126129441], 
      Complex[0., 0.]}}, {{
      Complex[-0.19277156767351664`, 2.9698465908722937`*^-15], 
      Complex[0., 0.], 
      Complex[0.6892568415495555, 0.6984011233336881], 
      Complex[0., 0.]}}, {{
      Complex[-0.19277156767351689`, 3.1086244689504383`*^-15], 
      Complex[0., 0.], 
      Complex[0.689256841549555, 0.6984011233336878], 
      Complex[0., 0.]}}, {{
      Complex[-0.1927715676735169, 2.942091015256665*^-15], 
      Complex[0., 0.], 
      Complex[0.6892568415495541, 0.6984011233336879], 
      Complex[0., 0.]}}, {{
      Complex[-0.10452846326765122`, 0.03680438074098639], 
      Complex[0., 0.], 
      Complex[0.7032331762533762, 0.7022694196258956], 
      Complex[0., 0.]}}, {{
      Complex[-0.10452846326765101`, 0.03680438074098639], 
      Complex[0., 0.], 
      Complex[0.7032331762533773, 0.7022694196258965], 
      Complex[0., 0.]}}, {{
      Complex[-0.10452846326765106`, 0.03680438074098649], 
      Complex[0., 0.], 
      Complex[0.703233176253377, 0.7022694196258956], 
      Complex[0., 0.]}}, {{
      Complex[-0.08922062423560771, 3.7192471324942744`*^-15], 
      Complex[0., 0.], 
      Complex[0.7024309264040877, 0.7061377159181002], 
      Complex[0., 0.]}}, {{
      Complex[-0.08922062423560811, 3.1780134079895106`*^-15], 
      Complex[0., 0.], 
      Complex[0.7024309264040841, 0.706137715918102], 
      Complex[0., 0.]}}, {{
      Complex[-2.3037127760972*^-15, 0.03700710955926765], 
      Complex[0., 0.], 
      Complex[0.7071067811865193, 0.7061377159180998], 
      Complex[0., 0.]}}, {{
      Complex[-1.1726730697603216`*^-15, 0.03700710955926845], 
      Complex[0., 0.], 
      Complex[0.7071067811865217, 0.7061377159181018], 
      Complex[0., 0.]}}, {{
      Complex[0., 0.03700710955926774], 
      Complex[0., 0.], 
      Complex[0.7071067811865217, 0.7061377159181033], 
      Complex[0., 0.]}}}, {Automatic}],
  Editable->False,
  SelectWithContents->True,
  Selectable->False]], "Output",
 CellChangeTimes->{
  3.8832522650114727`*^9, {3.8832523237660065`*^9, 3.8832523295221167`*^9}, 
   3.883392978843073*^9, 3.8833951384459496`*^9, 3.883404998190046*^9, 
   3.88347323005691*^9, 3.883473559358392*^9, 3.8834741359803405`*^9, 
   3.883479810219899*^9, 3.88348944800134*^9, 3.8834897115130353`*^9, 
   3.883572255372947*^9},
 CellLabel->"Out[27]=",ExpressionUUID->"12788b49-1b1b-4139-9013-eaeb2a89ed70"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"I", "*", 
  RowBox[{"Chop", "@", 
   RowBox[{"NIntegrate", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Conjugate", "[", 
       RowBox[{"\[Psi]func", "[", "t", "]"}], "]"}], ".", 
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"\[Psi]func", "[", "t", "]"}], ",", "t"}], "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "nval"}], "}"}]}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.883252344206196*^9, 3.8832523479327517`*^9}, {
  3.8832524024890428`*^9, 3.883252460177764*^9}},
 CellLabel->"In[28]:=",ExpressionUUID->"0f591f08-85b6-4c4b-afb9-6e2831049d99"],

Cell[BoxData[
 RowBox[{"0.05940673540359955`", "\[VeryThinSpace]", "+", 
  RowBox[{"0.`", " ", "\[ImaginaryI]"}]}]], "Output",
 CellChangeTimes->{
  3.88325234834765*^9, {3.8832524082137575`*^9, 3.883252461108356*^9}, 
   3.883392979653406*^9, 3.883404998984908*^9, 3.8834732308407555`*^9, 
   3.883473559856061*^9, 3.8834798114368253`*^9, 3.8834894485566597`*^9, 
   3.8834897120046577`*^9, 3.8835722559238577`*^9},
 CellLabel->"Out[28]=",ExpressionUUID->"a7f47651-4f05-4ff8-9754-bba86f10c2c6"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Analytic propagators", "Subsection",
 CellChangeTimes->{{3.882622104181368*^9, 3.882622114902437*^9}, {
  3.8832236458871455`*^9, 3.8832236603732576`*^9}, {3.883223768738858*^9, 
  3.8832237691970997`*^9}, {3.8832353223432503`*^9, 3.8832353307614293`*^9}, {
  3.88323576898199*^9, 3.883235780494172*^9}, {3.8835718603787947`*^9, 
  3.8835718863261747`*^9}, {3.883572040462882*^9, 
  3.8835720431301384`*^9}},ExpressionUUID->"a948f89c-ef54-4141-930e-\
1a782f187b02"],

Cell[CellGroupData[{

Cell["first arc", "Subsubsection",
 CellChangeTimes->{{3.882622104181368*^9, 3.882622114902437*^9}, {
  3.8832236458871455`*^9, 3.8832236603732576`*^9}, {3.883223768738858*^9, 
  3.8832237691970997`*^9}, {3.8832353223432503`*^9, 3.8832353307614293`*^9}, {
  3.88323576898199*^9, 3.883235780494172*^9}, {3.8835718603787947`*^9, 
  3.8835718863261747`*^9}, {3.883572040462882*^9, 3.8835720431301384`*^9}, {
  3.883572105084036*^9, 
  3.883572106042498*^9}},ExpressionUUID->"e7cbdf45-9871-4b0b-ac87-\
39bf68630323"],

Cell["effective propagator: 1st arc (equation 95)", "Text",
 CellChangeTimes->{{3.8834738631010942`*^9, 3.8834738680700426`*^9}, {
  3.883475324207327*^9, 3.8834753262452383`*^9}, {3.8835720723220153`*^9, 
  3.883572087043088*^9}},
 Background->RGBColor[
  0.87, 0.94, 1],ExpressionUUID->"9b7d7cc2-d37a-43a3-82bd-1e7a7ce6d6a0"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"MatrixRepresentation", "[", 
    RowBox[{"Utraj", "[", 
     RowBox[{"3", "*", 
      RowBox[{"1", "/", "2"}]}], "]"}], "]"}], ".", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "1", ",", "0"}], "}"}]}], "//", 
  "Chop"}]], "Input",
 CellChangeTimes->{{3.883473727655305*^9, 3.8834737424600596`*^9}, {
  3.8834738151532497`*^9, 3.8834738152415485`*^9}, {3.883473847293421*^9, 
  3.883473855963423*^9}, {3.883474027338979*^9, 3.883474027994991*^9}},
 CellLabel->"In[29]:=",ExpressionUUID->"391527f5-6699-4455-96cf-80036240bb16"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"0.`", "\[VeryThinSpace]", "+", 
    RowBox[{"0.15643446504023067`", " ", "\[ImaginaryI]"}]}], ",", "0", ",", 
   RowBox[{"0.`", "\[VeryThinSpace]", "-", 
    RowBox[{"0.9876883405951364`", " ", "\[ImaginaryI]"}]}], ",", "0"}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.883473732080906*^9, 3.8834737427507143`*^9}, 
   3.883473815644536*^9, {3.883473847766711*^9, 3.8834738562864704`*^9}, 
   3.8834740283176727`*^9, 3.883479811623576*^9, 3.8834894486893897`*^9, 
   3.883489712053528*^9, 3.883572256064603*^9},
 CellLabel->"Out[29]=",ExpressionUUID->"59ce32e9-3271-49c8-abc6-cde2c308ee13"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"P1", "=", 
   RowBox[{
    RowBox[{"MatrixRepresentation", "[", 
     RowBox[{"RotationOperator", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"n", "*", "\[Pi]"}], ",", "\"\<y\>\""}], "}"}], "]"}], "]"}], 
    ".", 
    RowBox[{"MatrixRepresentation", "[", 
     RowBox[{"Exp", "[", 
      RowBox[{
       RowBox[{"+", "I"}], " ", "n", "*", "\[Pi]", " ", 
       RowBox[{"SingleTransitionOperator", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"1", ",", "3"}], "}"}], ",", "\"\<z\>\""}], "]"}]}], "]"}], 
     "]"}], ".", 
    RowBox[{"MatrixRepresentation", "[", 
     RowBox[{"Exp", "[", 
      RowBox[{
       RowBox[{"-", "I"}], " ", "2", "*", "n", "*", "\[Theta]ST", " ", 
       RowBox[{"SingleTransitionOperator", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"1", ",", "3"}], "}"}], ",", "\"\<y\>\""}], "]"}]}], "]"}], 
     "]"}]}]}], ";"}]], "Input",
 CellChangeTimes->{{3.8833948384652653`*^9, 3.883394848180271*^9}, {
   3.8833948798357744`*^9, 3.88339488481571*^9}, {3.883394986933117*^9, 
   3.883394998123926*^9}, {3.8833950514286566`*^9, 3.8833950858355656`*^9}, {
   3.8833951444886637`*^9, 3.883395211620579*^9}, 3.883395376173252*^9, {
   3.883395546239186*^9, 3.8833955492890434`*^9}, {3.883396332915636*^9, 
   3.883396334375843*^9}, {3.883396513878909*^9, 3.883396564446141*^9}, {
   3.8834032502601633`*^9, 3.8834032669381676`*^9}, {3.883473410752761*^9, 
   3.883473413758451*^9}, {3.88347349460822*^9, 3.8834735078459005`*^9}, {
   3.883473618281*^9, 3.883473671003504*^9}, {3.8834737230720253`*^9, 
   3.883473759530133*^9}, {3.8834737983320055`*^9, 3.8834738538565865`*^9}, {
   3.883475421813594*^9, 3.8834754322992525`*^9}},
 CellLabel->"In[30]:=",ExpressionUUID->"6253273d-a597-4060-bc1d-634d4b92c680"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"P1", ".", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", "1", ",", "0"}], "}"}]}], "/.", "params"}],
     "/.", 
    RowBox[{"{", 
     RowBox[{"n", "->", "3"}], "}"}]}], "//", "N"}], "//", "Chop"}]], "Input",
 CellLabel->"In[31]:=",ExpressionUUID->"dc84f140-e8e9-4698-8b33-d22c2491c37e"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"0.`", "\[VeryThinSpace]", "+", 
    RowBox[{"0.15643446504023087`", " ", "\[ImaginaryI]"}]}], ",", "0", ",", 
   RowBox[{"0.`", "\[VeryThinSpace]", "-", 
    RowBox[{"0.9876883405951378`", " ", "\[ImaginaryI]"}]}], ",", "0"}], 
  "}"}]], "Output",
 CellChangeTimes->{3.8834754339640455`*^9, 3.883479811846921*^9, 
  3.883489448790119*^9, 3.8834897121572523`*^9, 3.883572256166296*^9},
 CellLabel->"Out[31]=",ExpressionUUID->"3309fdcc-961e-470a-aaee-7593b317e7cf"]
}, Open  ]],

Cell["interaction frame propagator: 1st arc (equation 98-100)", "Text",
 CellChangeTimes->{{3.8834738631010942`*^9, 3.8834738680700426`*^9}, {
   3.8834741816078234`*^9, 3.8834741848929157`*^9}, 3.8834753303869343`*^9, {
   3.883572092431408*^9, 3.883572092762789*^9}, {3.883572144233057*^9, 
   3.883572146682167*^9}},
 Background->RGBColor[
  0.87, 0.94, 1],ExpressionUUID->"d40f0013-f039-48c8-b316-38d8209101f4"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"MatrixRepresentation", "[", 
       RowBox[{"RotationOperator", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "n"}], "*", "\[Pi]"}], ",", "\"\<y\>\""}], "}"}], 
        "]"}], "]"}], ".", 
      RowBox[{"MatrixRepresentation", "[", 
       RowBox[{"Exp", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"+", "I"}], " ", "n", "*", 
          RowBox[{"\[Pi]", "/", "\[CapitalOmega]"}], " ", "H0"}], "/.", 
         "params"}], "]"}], "]"}], ".", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"MatrixRepresentation", "[", 
         RowBox[{"RotationOperator", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"n", "*", "\[Pi]"}], ",", "\"\<y\>\""}], "}"}], "]"}], 
         "]"}], ".", 
        RowBox[{"MatrixRepresentation", "[", 
         RowBox[{"Exp", "[", 
          RowBox[{
           RowBox[{"+", "I"}], " ", "n", "*", "\[Pi]", " ", 
           RowBox[{"SingleTransitionOperator", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"1", ",", "3"}], "}"}], ",", "\"\<z\>\""}], "]"}]}], 
          "]"}], "]"}], ".", 
        RowBox[{"MatrixRepresentation", "[", 
         RowBox[{"Exp", "[", 
          RowBox[{
           RowBox[{"-", "I"}], " ", "2", "*", "n", "*", "\[Theta]ST", " ", 
           RowBox[{"SingleTransitionOperator", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"1", ",", "3"}], "}"}], ",", "\"\<y\>\""}], "]"}]}], 
          "]"}], "]"}]}], ")"}], ".", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", "1", ",", "0"}], "}"}]}], "/.", 
     RowBox[{"{", 
      RowBox[{"n", "->", "3"}], "}"}]}], "/.", "params"}], "//", "N"}], "//", 
  "Chop"}]], "Input",
 CellChangeTimes->{{3.8834743080940933`*^9, 3.8834744033494935`*^9}, {
  3.883474457500746*^9, 3.8834745176092405`*^9}, {3.883475310242787*^9, 
  3.8834753116814156`*^9}},
 CellLabel->"In[32]:=",ExpressionUUID->"f5ccc907-b88b-4449-afa6-5df818ed4816"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "0.20791169081775931`"}], ",", "0", ",", 
   "0.9781476007338056`", ",", "0"}], "}"}]], "Output",
 CellChangeTimes->{{3.883474357685439*^9, 3.8834744039061174`*^9}, {
   3.8834744580025406`*^9, 3.8834745180778017`*^9}, 3.8834753121126404`*^9, 
   3.8834798121557503`*^9, 3.8834894489653387`*^9, 3.883489712318818*^9, 
   3.883572256363823*^9},
 CellLabel->"Out[32]=",ExpressionUUID->"875c69fc-23bb-4bb7-afd5-13cf08abf12c"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"Normal", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"-", "1"}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"2", "n"}], ")"}]}], "*", 
      RowBox[{
       RowBox[{"MatrixRepresentation", "[", 
        RowBox[{"Exp", "[", 
         RowBox[{
          RowBox[{"-", "I"}], " ", "\[Theta]ST", " ", 
          RowBox[{"(", 
           RowBox[{"1", "-", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"-", "1"}], ")"}], "^", "n"}]}], ")"}], " ", 
          RowBox[{"SingleTransitionOperator", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"1", ",", "3"}], "}"}], ",", "\"\<y\>\""}], "]"}]}], 
         "]"}], "]"}], ".", 
       RowBox[{"MatrixRepresentation", "[", 
        RowBox[{"Exp", "[", 
         RowBox[{
          RowBox[{"-", "I"}], " ", "2", "*", 
          RowBox[{"(", "n", ")"}], "*", "\[Theta]ST", " ", 
          RowBox[{"SingleTransitionOperator", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"1", ",", "3"}], "}"}], ",", "\"\<y\>\""}], "]"}]}], 
         "]"}], "]"}], ".", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "1", ",", "0"}], "}"}]}]}], "]"}], "/.", 
    RowBox[{"{", 
     RowBox[{"n", "->", "3"}], "}"}]}], "/.", "params"}], "//", 
  "N"}]], "Input",
 CellChangeTimes->{{3.883397906435639*^9, 3.8833980031265297`*^9}, 
   3.8833980401450896`*^9, {3.8833989915135136`*^9, 3.883399020832108*^9}, {
   3.883399071326271*^9, 3.8833990830635395`*^9}, {3.883399153734629*^9, 
   3.883399176994633*^9}, {3.883399297060049*^9, 3.883399297137554*^9}, {
   3.8834733578997693`*^9, 3.883473379285405*^9}, {3.8834734621324315`*^9, 
   3.8834734726250815`*^9}, {3.883474066206611*^9, 3.883474163180217*^9}, {
   3.8834742119236393`*^9, 3.8834742782010517`*^9}, {3.883474445658359*^9, 
   3.8834745199321213`*^9}, {3.883474690816347*^9, 3.883474691533968*^9}, {
   3.8834747467378693`*^9, 3.8834747502552624`*^9}, 3.883475305658684*^9},
 CellLabel->"In[33]:=",ExpressionUUID->"95f0a05e-bb90-4d1e-b32d-823bcfb0e325"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "0.20791169081775934`"}], ",", "0.`", ",", 
   "0.9781476007338057`", ",", "0.`"}], "}"}]], "Output",
 CellChangeTimes->{{3.8833979124572935`*^9, 3.8833980034462223`*^9}, {
   3.883399080302122*^9, 3.8833990834538345`*^9}, {3.883399154101715*^9, 
   3.883399177343011*^9}, 3.883399297441309*^9, 3.8834050066582727`*^9, 
   3.8834732421930833`*^9, {3.8834733603881464`*^9, 3.883473380003585*^9}, {
   3.8834734634492197`*^9, 3.8834734730730324`*^9}, 3.8834735600964165`*^9, 
   3.883474034708528*^9, {3.883474066653143*^9, 3.883474156428871*^9}, 
   3.88347420729819*^9, {3.883474242250721*^9, 3.8834742786205053`*^9}, {
   3.883474446191743*^9, 3.8834745202958508`*^9}, {3.883474748117968*^9, 
   3.8834747506707697`*^9}, 3.8834753061001525`*^9, 3.883479812337891*^9, 
   3.8834894490441284`*^9, 3.883489712429638*^9, 3.88357225645464*^9},
 CellLabel->"Out[33]=",ExpressionUUID->"721e9c5f-97e7-4625-8ae7-7baec04567e3"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["second arc", "Subsubsection",
 CellChangeTimes->{{3.882622104181368*^9, 3.882622114902437*^9}, {
  3.8832236458871455`*^9, 3.8832236603732576`*^9}, {3.883223768738858*^9, 
  3.8832237691970997`*^9}, {3.8832353223432503`*^9, 3.8832353307614293`*^9}, {
  3.88323576898199*^9, 3.883235780494172*^9}, {3.8835718603787947`*^9, 
  3.8835718863261747`*^9}, {3.883572040462882*^9, 3.8835720431301384`*^9}, {
  3.883572105084036*^9, 
  3.883572112082082*^9}},ExpressionUUID->"60b58012-db57-45d3-a778-\
494c58ebb240"],

Cell["effective propagator: 2nd arc (equation 101)", "Text",
 CellChangeTimes->{{3.8834738631010942`*^9, 3.8834738680700426`*^9}, {
  3.8834741816078234`*^9, 3.8834741848929157`*^9}, {3.883475332125614*^9, 
  3.883475334805376*^9}, {3.883476060156101*^9, 3.883476062116194*^9}, {
  3.8835721583528786`*^9, 3.883572159902132*^9}},
 Background->RGBColor[
  0.87, 0.94, 1],ExpressionUUID->"708c6bf5-2170-45e1-9bfc-d339e8e5202b"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"MatrixRepresentation", "[", 
    RowBox[{"Utraj", "[", 
     RowBox[{
      RowBox[{"nval", "*", 
       RowBox[{"1", "/", "2"}]}], "+", 
      RowBox[{"2", "*", 
       RowBox[{"1", "/", "2"}]}]}], "]"}], "]"}], ".", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "1", ",", "0"}], "}"}]}], "//", 
  "Chop"}]], "Input",
 CellChangeTimes->{{3.883473727655305*^9, 3.8834737424600596`*^9}, {
  3.8834738151532497`*^9, 3.8834738152415485`*^9}, {3.883473847293421*^9, 
  3.883473855963423*^9}, {3.883474027338979*^9, 3.883474027994991*^9}, {
  3.8834754685414467`*^9, 3.883475482590395*^9}},
 CellLabel->"In[34]:=",ExpressionUUID->"c6bfa430-e0ea-4e4a-94e6-7157837c8dab"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "0.9945218953682642`"}], "+", 
    RowBox[{"0.003868296292208001`", " ", "\[ImaginaryI]"}]}], ",", "0", ",", 
   RowBox[{"0.07391278520356592`", "\[VeryThinSpace]", "+", 
    RowBox[{"0.07381149030025189`", " ", "\[ImaginaryI]"}]}], ",", "0"}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.883473732080906*^9, 3.8834737427507143`*^9}, 
   3.883473815644536*^9, {3.883473847766711*^9, 3.8834738562864704`*^9}, 
   3.8834740283176727`*^9, {3.883475472948162*^9, 3.883475482952511*^9}, 
   3.8834798124726515`*^9, 3.88348944910198*^9, 3.883489712480501*^9, 
   3.883572256506503*^9},
 CellLabel->"Out[34]=",ExpressionUUID->"9c374b9e-9c11-4111-a437-fb5dd535e1d6"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"P2", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"MatrixRepresentation", "[", 
      RowBox[{"RotationOperator", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"n", "*", "\[Pi]"}], ",", "\"\<y\>\""}], "}"}], "]"}], "]"}],
      ".", 
     RowBox[{"MatrixExp", "[", 
      RowBox[{
       RowBox[{"+", "I"}], " ", "\[Pi]", " ", "n", "*", "Sz"}], "]"}], ".", 
     RowBox[{"MatrixExp", "[", 
      RowBox[{
       RowBox[{"+", "I"}], " ", "\[Theta]ST", " ", "Sy"}], "]"}], ".", 
     RowBox[{"MatrixExp", "[", 
      RowBox[{
       RowBox[{"-", "I"}], " ", "2", "n", "*", "\[Theta]ST", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"Cos", "[", "\[Phi]", "]"}], " ", "Sx"}], "+", 
         RowBox[{
          RowBox[{"Sin", "[", "\[Phi]", "]"}], "Sy"}]}], ")"}]}], "]"}], ".", 
     RowBox[{"MatrixExp", "[", 
      RowBox[{
       RowBox[{"-", "I"}], " ", "\[Theta]ST", " ", "Sy"}], "]"}]}], "//", 
    "FullSimplify"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.88340496369062*^9, 3.883405076291543*^9}, {
  3.883475450722644*^9, 3.883475456960494*^9}, {3.883475490900492*^9, 
  3.8834754973625507`*^9}},
 CellLabel->"In[35]:=",ExpressionUUID->"a1000cfa-af51-4f7a-9a97-dff7d42a9d1c"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"P2", ".", 
      RowBox[{"{", 
       RowBox[{"1", ",", "0", ",", "0", ",", "0"}], "}"}]}], "/.", "params"}],
     "/.", 
    RowBox[{"{", 
     RowBox[{"n", "->", "2"}], "}"}]}], "//", "N"}], "//", "Chop"}]], "Input",
 CellChangeTimes->{{3.883405080611445*^9, 3.8834050824145246`*^9}, {
  3.8834054213454337`*^9, 3.88340542346002*^9}, {3.883475440584652*^9, 
  3.883475441948738*^9}, {3.883475476343504*^9, 3.883475485535493*^9}},
 CellLabel->"In[36]:=",ExpressionUUID->"ad81575a-72d0-4c19-8502-d2a83ffafc90"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "0.9945218953682733`"}], "+", 
    RowBox[{"0.003868296292208251`", " ", "\[ImaginaryI]"}]}], ",", "0", ",", 
   RowBox[{"0.0739127852035667`", "\[VeryThinSpace]", "+", 
    RowBox[{"0.07381149030025255`", " ", "\[ImaginaryI]"}]}], ",", "0"}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.8834050826775265`*^9, 3.88347324359365*^9, 3.8834735604927535`*^9, {
   3.8834754425017977`*^9, 3.883475505806777*^9}, 3.883479815829977*^9, 
   3.8834894544748235`*^9, 3.88348971479012*^9, 3.883572261842532*^9},
 CellLabel->"Out[36]=",ExpressionUUID->"3f5dedd4-3329-499e-818f-7dc697580cf1"]
}, Open  ]],

Cell["interaction frame propagator: 2nd arc (equations 104-105)", "Text",
 CellChangeTimes->{{3.8834738631010942`*^9, 3.8834738680700426`*^9}, {
   3.8834741816078234`*^9, 3.8834741848929157`*^9}, 3.8834753303869343`*^9, {
   3.8834765570745487`*^9, 3.8834765573483553`*^9}, {3.8835721883640385`*^9, 
   3.8835722051128263`*^9}},
 Background->RGBColor[
  0.87, 0.94, 1],ExpressionUUID->"6006fdfe-6455-40ab-b2f0-733b8e4e5b5d"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Psi]func", "[", 
   RowBox[{
    RowBox[{"nval", "/", "2"}], "+", 
    RowBox[{"4", "*", 
     RowBox[{"1", "/", "2"}]}]}], "]"}], "//", "Chop"}]], "Input",
 CellChangeTimes->{{3.883476263740855*^9, 3.88347634354134*^9}, {
  3.8834764288834505`*^9, 3.8834764450212193`*^9}, {3.883476520566098*^9, 
  3.8834765474899178`*^9}, {3.883480787269185*^9, 3.8834807908837814`*^9}, {
  3.883572245704276*^9, 3.8835722457840595`*^9}, {3.8835722769700108`*^9, 
  3.8835722943243313`*^9}},
 CellLabel->"In[44]:=",ExpressionUUID->"41f1f56d-9a58-46c7-ba52-497dacc93ee3"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "0.9783925018116377`"}], "+", 
    RowBox[{"0.008169161999804008`", " ", "\[ImaginaryI]"}]}], ",", "0", ",", 
   RowBox[{"0.147929749730565`", "\[VeryThinSpace]", "+", 
    RowBox[{"0.14457981637873216`", " ", "\[ImaginaryI]"}]}], ",", "0"}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.8834762827083664`*^9, 3.8834763439843245`*^9}, {
   3.88347642976696*^9, 3.883476447673273*^9}, {3.8834765209396114`*^9, 
   3.88347654774382*^9}, 3.8834798158944707`*^9, {3.8834807881458564`*^9, 
   3.883480791364848*^9}, 3.883489454530698*^9, 3.8834897148326263`*^9, {
   3.883572261894302*^9, 3.8835722946021*^9}},
 CellLabel->"Out[44]=",ExpressionUUID->"3e92a8ae-6a1b-41fe-9ee8-b2a3f1aeeada"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"MatrixRepresentation", "[", 
       RowBox[{"RotationOperator", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"n", "+", "1"}], ")"}], "*", "\[Pi]"}], ",", 
          "\"\<y\>\""}], "}"}], "]"}], "]"}], ".", 
      RowBox[{"MatrixRepresentation", "[", 
       RowBox[{"Exp", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"+", "I"}], " ", "n", "*", 
          RowBox[{"\[Pi]", "/", "\[CapitalOmega]"}], " ", "H0"}], "/.", 
         "params"}], "]"}], "]"}], ".", 
      RowBox[{"MatrixRepresentation", "[", 
       RowBox[{"Exp", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"+", "I"}], " ", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"\[Pi]", "/", "2"}], "+", "\[Phi]"}], ")"}], "/", 
           "\[CapitalOmega]"}], " ", "H0"}], "/.", "params"}], "]"}], "]"}], 
      ".", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"MatrixRepresentation", "[", 
         RowBox[{"RotationOperator", "[", 
          RowBox[{"{", 
           RowBox[{"\[Pi]", ",", "\"\<y\>\""}], "}"}], "]"}], "]"}], ".", 
        RowBox[{"MatrixRepresentation", "[", 
         RowBox[{"Exp", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "I"}], " ", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"\[Pi]", "/", "2"}], "+", "\[Phi]"}], ")"}], "/", 
             "\[CapitalOmega]"}], " ", "H0"}], "/.", "params"}], "]"}], "]"}],
         ".", "P2"}], ")"}], ".", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0"}], "}"}]}], "/.", 
     RowBox[{"{", 
      RowBox[{"n", "->", "3"}], "}"}]}], "/.", "params"}], "//", "N"}], "//", 
  "Chop"}]], "Input",
 CellChangeTimes->{{3.8834743080940933`*^9, 3.8834744033494935`*^9}, {
  3.883474457500746*^9, 3.8834745176092405`*^9}, {3.883475310242787*^9, 
  3.8834753116814156`*^9}, {3.8834761027800817`*^9, 3.8834761414885216`*^9}, {
  3.883476235672964*^9, 3.883476274130084*^9}, {3.883476319028672*^9, 
  3.883476319177106*^9}, {3.8834763705821767`*^9, 3.8834764347426014`*^9}, {
  3.8834765237842617`*^9, 3.8834765497476015`*^9}, {3.883480798466551*^9, 
  3.883480798546049*^9}, {3.8835722488959956`*^9, 3.8835722489757833`*^9}, {
  3.883572311187262*^9, 3.8835723112471733`*^9}},
 CellLabel->"In[47]:=",ExpressionUUID->"c19466c0-09e4-41d4-a5c6-f11830a37584"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "0.9781476007338054`"}], "+", 
    RowBox[{"0.0076942107207457625`", " ", "\[ImaginaryI]"}]}], ",", "0", ",", 
   RowBox[{"0.14701576646519843`", "\[VeryThinSpace]", "+", 
    RowBox[{"0.14681428646672817`", " ", "\[ImaginaryI]"}]}], ",", "0"}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.883474357685439*^9, 3.8834744039061174`*^9}, {
   3.8834744580025406`*^9, 3.8834745180778017`*^9}, 3.8834753121126404`*^9, {
   3.8834762583569555`*^9, 3.883476275089184*^9}, 3.883476320228443*^9, 
   3.883476371985665*^9, {3.883476426617347*^9, 3.883476437072284*^9}, {
   3.8834765248731365`*^9, 3.883476551440349*^9}, 3.88347981710001*^9, 
   3.8834807997839613`*^9, 3.8834894550629344`*^9, 3.8834897153149595`*^9, 
   3.883572262415057*^9, 3.883572312226028*^9},
 CellLabel->"Out[47]=",ExpressionUUID->"f258f34b-9201-4449-8756-b841d70727e3"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"MatrixRepresentation", "[", 
       RowBox[{"RotationOperator", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"n", "+", "2"}], ")"}], "*", "\[Pi]"}], ",", 
          "\"\<y\>\""}], "}"}], "]"}], "]"}], ".", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"MatrixExp", "[", 
         RowBox[{
          RowBox[{"-", "I"}], " ", 
          RowBox[{"(", 
           RowBox[{"n", "*", "\[Pi]"}], " ", ")"}], "Sz"}], "]"}], ".", 
        RowBox[{"MatrixExp", "[", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"-", "1"}], ")"}], "^", 
             RowBox[{"(", 
              RowBox[{"n", "+", "1"}], ")"}]}]}], ")"}], " ", "I", " ", 
          "\[Theta]ST", " ", "Sy"}], "]"}], ".", 
        RowBox[{"MatrixExp", "[", 
         RowBox[{
          RowBox[{"+", "I"}], " ", "\[Theta]ST", " ", "Sy"}], "]"}], ".", 
        RowBox[{"MatrixExp", "[", 
         RowBox[{
          RowBox[{"-", "I"}], " ", "2", "\[Theta]ST", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"Cos", "[", "\[Phi]", "]"}], "Sx"}], "+", 
            RowBox[{
             RowBox[{"Sin", "[", "\[Phi]", "]"}], "Sy"}]}], " ", ")"}]}], 
         "]"}]}], ")"}], ".", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"MatrixExp", "[", 
         RowBox[{
          RowBox[{"-", "I"}], " ", "\[Theta]ST", " ", "Sy"}], "]"}], ".", 
        "P2"}], ")"}], ".", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0"}], "}"}]}], "/.", 
     RowBox[{"{", 
      RowBox[{"n", "->", "3"}], "}"}]}], "/.", "params"}], "//", "N"}], "//", 
  "Chop"}]], "Input",
 CellChangeTimes->{{3.8834765776059504`*^9, 3.883476608568432*^9}, {
  3.8834767145026426`*^9, 3.883476722828555*^9}, {3.883476767906833*^9, 
  3.8834767726702504`*^9}, {3.8834769021010823`*^9, 3.883476945209307*^9}, {
  3.8834770000359187`*^9, 3.883477077252414*^9}, {3.8834771269483967`*^9, 
  3.883477288878235*^9}, {3.88347739740998*^9, 3.883477416532188*^9}, {
  3.8834775407547092`*^9, 3.883477551695484*^9}, {3.88347779764383*^9, 
  3.8834778025446005`*^9}, {3.883477990200245*^9, 3.8834780202436433`*^9}, {
  3.883478111391509*^9, 3.8834781124523516`*^9}, {3.883478149323947*^9, 
  3.8834781494384546`*^9}, {3.8835722511557703`*^9, 3.883572251225586*^9}, {
  3.8835723070270824`*^9, 3.88357230710625*^9}},
 CellLabel->"In[46]:=",ExpressionUUID->"0257ed1b-3562-4a58-8bb0-abd08620c544"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "0.9781476007338056`"}], "+", 
    RowBox[{"0.007694210720745637`", " ", "\[ImaginaryI]"}]}], ",", "0", ",", 
   RowBox[{"0.14701576646519846`", "\[VeryThinSpace]", "+", 
    RowBox[{"0.1468142864667282`", " ", "\[ImaginaryI]"}]}], ",", "0"}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.883477157993885*^9, 3.883477255145855*^9}, 
   3.883477289946368*^9, {3.88347739846546*^9, 3.8834774180030665`*^9}, 
   3.883477552758644*^9, {3.8834777944745636`*^9, 3.8834778035885363`*^9}, {
   3.8834779912992425`*^9, 3.8834780212171335`*^9}, 3.883478075384172*^9, 
   3.8834781133691683`*^9, 3.883478150530286*^9, 3.883479818390416*^9, 
   3.883489455566402*^9, 3.883489715856976*^9, 3.8835722629059696`*^9, 
   3.883572307810972*^9},
 CellLabel->"Out[46]=",ExpressionUUID->"ec2018fa-625d-4e2e-b99f-080c868c040d"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"-", "I"}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "+", "1"}], ")"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"MatrixExp", "[", 
          RowBox[{
           RowBox[{"-", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"-", "1"}], ")"}], "^", 
               RowBox[{"(", 
                RowBox[{"n", "+", "1"}], ")"}]}], "-", "1"}], ")"}]}], " ", 
           "I", " ", "\[Theta]ST", " ", "Sy"}], "]"}], ".", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"P2", "/.", 
            RowBox[{"{", 
             RowBox[{"n", "->", "1"}], "}"}]}], "/.", "params"}], ")"}], ".", 
         "P2"}], ")"}], ".", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0"}], "}"}]}]}], "/.", 
     RowBox[{"{", 
      RowBox[{"n", "->", "3"}], "}"}]}], "/.", "params"}], "//", "N"}], "//", 
  "Chop"}]], "Input",
 CellChangeTimes->{{3.8834777485016437`*^9, 3.883477784628421*^9}, {
  3.883477816359486*^9, 3.883477831032857*^9}, {3.883477908488638*^9, 
  3.8834780785092106`*^9}, {3.883478122013668*^9, 3.8834781385290174`*^9}, {
  3.8834782229135075`*^9, 3.8834782230303698`*^9}, {3.8834808138364816`*^9, 
  3.8834808139434566`*^9}, {3.883481282149021*^9, 3.8834812861305957`*^9}, {
  3.8834817513702493`*^9, 3.883481751498356*^9}, {3.8835722540355854`*^9, 
  3.883572254095561*^9}, {3.883572289788421*^9, 3.8835723009162054`*^9}},
 CellLabel->"In[45]:=",ExpressionUUID->"b1649d24-a681-436b-80cb-b269159d86e2"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "0.9781476007338056`"}], "+", 
    RowBox[{"0.007694210720745442`", " ", "\[ImaginaryI]"}]}], ",", "0", ",", 
   RowBox[{"0.14701576646519846`", "\[VeryThinSpace]", "+", 
    RowBox[{"0.14681428646672817`", " ", "\[ImaginaryI]"}]}], ",", "0"}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.883477984703514*^9, 3.8834780167579575`*^9}, 
   3.8834780788514557`*^9, {3.883478122704181*^9, 3.8834781390532403`*^9}, 
   3.8834782235638666`*^9, 3.883479818553342*^9, 3.8834808149741106`*^9, 
   3.88348174192382*^9, 3.883489455663105*^9, 3.88348971593439*^9, {
   3.8835722629878807`*^9, 3.883572301253584*^9}},
 CellLabel->"Out[45]=",ExpressionUUID->"0f588e58-680c-45fb-a242-fc39bd123e66"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1016.25, 617.625},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
Magnification:>0.9 Inherited,
FrontEndVersion->"12.3 for Microsoft Windows (64-bit) (May 11, 2021)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"32d9e5a6-fc22-4ebe-9ffc-13b1cfe7ffcd"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 492, 10, 43, "Input",ExpressionUUID->"a0d473da-4964-4b26-b583-9154b196392d"],
Cell[1075, 34, 452, 10, 31, "Print",ExpressionUUID->"70b2dd58-e8aa-4f77-8f3c-e6b6d07b18a8"],
Cell[1530, 46, 791, 15, 38, "Message",ExpressionUUID->"27964d99-92b2-4cf5-8d25-99c33a315c3b"],
Cell[2324, 63, 469, 10, 20, "Message",ExpressionUUID->"d8924af8-d597-4835-a276-adb7e8690dd6"],
Cell[2796, 75, 794, 15, 22, "Message",ExpressionUUID->"cb370844-8ab7-4a90-93ab-01dabae6af89"],
Cell[3593, 92, 676, 13, 38, "Message",ExpressionUUID->"0eec61d1-d998-4f8e-8cc4-dd34909b2fa3"]
}, Open  ]],
Cell[CellGroupData[{
Cell[4306, 110, 317, 5, 48, "Subsection",ExpressionUUID->"d4ea4a8e-02d9-42e6-a310-62e8037f190c"],
Cell[CellGroupData[{
Cell[4648, 119, 358, 5, 26, "Input",ExpressionUUID->"dbb785ba-4979-46c1-8248-0985c24bb3dc"],
Cell[5009, 126, 2018, 33, 35, "Message",ExpressionUUID->"77e0dd22-4089-44c8-8423-1ad849725c1a"],
Cell[7030, 161, 2154, 35, 35, "Message",ExpressionUUID->"1214d5e4-ddc6-4f5b-a1d2-407823e5bd6c"]
}, Open  ]],
Cell[CellGroupData[{
Cell[9221, 201, 199, 4, 26, "Input",ExpressionUUID->"d674d9c6-84cf-4130-b49a-f059944a78de"],
Cell[9423, 207, 996, 19, 35, "Message",ExpressionUUID->"e7fab3a3-265c-4164-9460-c49d3fd818e0"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[10468, 232, 342, 5, 48, "Subsection",ExpressionUUID->"783e4a29-0f2c-4be9-b98b-a5ee56261469"],
Cell[10813, 239, 958, 28, 43, "Input",ExpressionUUID->"2b2ffab2-11eb-496c-bc21-4410d658bded"]
}, Open  ]],
Cell[CellGroupData[{
Cell[11808, 272, 611, 16, 48, "Subsection",ExpressionUUID->"f78d71cb-e3ff-46f4-ab75-938b98b896a5"],
Cell[12422, 290, 949, 25, 43, "Input",ExpressionUUID->"6ca98357-52b3-4dcc-8306-61de97ecb03b"]
}, Open  ]],
Cell[CellGroupData[{
Cell[13408, 320, 381, 6, 48, "Subsection",ExpressionUUID->"6122646e-c83f-42d4-94a2-0b77c0e8f97b"],
Cell[13792, 328, 346, 7, 45, "Text",ExpressionUUID->"21c122a7-bb7d-41df-9897-e6d567b6c3ec"],
Cell[CellGroupData[{
Cell[14163, 339, 2455, 49, 60, "Input",ExpressionUUID->"5211fd57-571a-4f16-9191-2eea1703bf07"],
Cell[16621, 390, 204, 3, 28, "Output",ExpressionUUID->"6259f9d8-15ae-4f12-a81a-bc0d5cdf2402"]
}, Open  ]],
Cell[16840, 396, 523, 12, 45, "Text",ExpressionUUID->"52c397c2-9456-4e9a-a781-7fab86ceb3ac"],
Cell[17366, 410, 2511, 59, 284, "Input",ExpressionUUID->"73d0d8c4-8d23-4517-b0a7-4656f1da37cc"],
Cell[19880, 471, 398, 8, 45, "Text",ExpressionUUID->"941166c7-9bc7-4cda-96e6-01876580816a"],
Cell[20281, 481, 2831, 63, 284, "Input",ExpressionUUID->"ace2a057-e7ef-44b0-854c-72a81d5bf315"],
Cell[23115, 546, 448, 8, 45, "Text",ExpressionUUID->"46f96712-0ada-4972-834b-5e862d5bbe0e"],
Cell[23566, 556, 2386, 57, 284, "Input",ExpressionUUID->"404d1f34-e3f6-44b4-a4a8-095d8ecddc6c"]
}, Open  ]],
Cell[CellGroupData[{
Cell[25989, 618, 390, 6, 48, "Subsection",ExpressionUUID->"297644b1-42b0-427a-a5fe-34e0e89c34b1"],
Cell[26382, 626, 328, 5, 45, "Text",ExpressionUUID->"a9863869-d2db-49f5-adbb-0767c3ce3f7f"],
Cell[26713, 633, 1470, 35, 78, "Input",ExpressionUUID->"882d7964-b58c-4414-ac56-72ae1eab8404"],
Cell[28186, 670, 334, 5, 45, "Text",ExpressionUUID->"313f55c3-4d38-40f1-bed2-bf459b3e6d02"],
Cell[28523, 677, 396, 10, 26, "Input",ExpressionUUID->"461aa31b-48e6-469e-9090-438050568959"],
Cell[28922, 689, 377, 5, 45, "Text",ExpressionUUID->"5b7ffbcd-a672-48b5-9d3a-4f421def4fcc"],
Cell[CellGroupData[{
Cell[29324, 698, 1053, 30, 43, "Input",ExpressionUUID->"912f4bde-7a40-4587-9ef8-97b12202297f"],
Cell[30380, 730, 30367, 678, 58, "Output",ExpressionUUID->"d78285d3-4e5f-47d6-b02a-acd5896299f9"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[60796, 1414, 442, 6, 48, "Subsection",ExpressionUUID->"739d992f-6626-47eb-a5ea-012ab706f92a"],
Cell[CellGroupData[{
Cell[61263, 1424, 1326, 27, 95, "Input",ExpressionUUID->"b177b0f7-726e-44ba-aba2-7df6d40f6cea"],
Cell[62592, 1453, 113628, 1896, 367, "Output",ExpressionUUID->"98aad03e-2192-49d0-be73-f237215cc74e"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[176269, 3355, 475, 8, 48, "Subsection",ExpressionUUID->"921b36bc-4009-4c3a-b0c8-4dc1ef13f561"],
Cell[176747, 3365, 421, 6, 45, "Text",ExpressionUUID->"201eb848-786b-4802-a90a-4288a098d878"],
Cell[CellGroupData[{
Cell[177193, 3375, 513, 11, 26, "Input",ExpressionUUID->"cf36d97e-14b1-426d-8e45-0a59e200c8fd"],
Cell[177709, 3388, 780, 11, 28, "Output",ExpressionUUID->"fa12eb5c-d791-457b-adb8-08dbd9548c07"]
}, Open  ]],
Cell[178504, 3402, 416, 6, 45, "Text",ExpressionUUID->"155bf6a2-87ff-417d-be6c-d2e485a5fed3"],
Cell[CellGroupData[{
Cell[178945, 3412, 560, 13, 26, "Input",ExpressionUUID->"2bba307b-38aa-4983-85a3-bbcd99d7a420"],
Cell[179508, 3427, 537, 7, 28, "Output",ExpressionUUID->"56162dcb-8ed3-4e7f-9e60-f8c6702616c8"]
}, Open  ]],
Cell[180060, 3437, 614, 13, 128, "Text",ExpressionUUID->"e6e0a9f8-be7f-406e-892a-55b991a5599d"],
Cell[CellGroupData[{
Cell[180699, 3454, 388, 8, 26, "Input",ExpressionUUID->"69ef5dd9-b8ed-4cc5-88ef-5c375d33b5a2"],
Cell[181090, 3464, 409, 5, 28, "Output",ExpressionUUID->"d66c01a4-9117-47d7-b828-ed9900f0e5d7"]
}, Open  ]],
Cell[181514, 3472, 554, 10, 66, "Text",ExpressionUUID->"b90298d4-9609-4761-b537-816d73a97457"],
Cell[CellGroupData[{
Cell[182093, 3486, 437, 8, 26, "Input",ExpressionUUID->"598ee1f6-18bd-4fc1-bc33-79051daae4b9"],
Cell[182533, 3496, 1773, 38, 86, "Output",ExpressionUUID->"bc61cb82-bb51-41bc-9eb1-be447bb35c30"]
}, Open  ]],
Cell[CellGroupData[{
Cell[184343, 3539, 490, 9, 26, "Input",ExpressionUUID->"1dcde28d-4150-48de-a3e5-116717062b65"],
Cell[184836, 3550, 1468, 33, 86, "Output",ExpressionUUID->"f2e69de4-af36-486f-9d0c-314dfa188ad8"]
}, Open  ]],
Cell[186319, 3586, 567, 10, 45, "Text",ExpressionUUID->"9cbe3a32-9045-4e7f-817f-89b5a8458074"],
Cell[CellGroupData[{
Cell[186911, 3600, 655, 16, 26, "Input",ExpressionUUID->"42f09f6d-82da-4680-bf8e-a312c2c76923"],
Cell[187569, 3618, 36811, 835, 58, "Output",ExpressionUUID->"12788b49-1b1b-4139-9013-eaeb2a89ed70"]
}, Open  ]],
Cell[CellGroupData[{
Cell[224417, 4458, 613, 15, 26, "Input",ExpressionUUID->"0f591f08-85b6-4c4b-afb9-6e2831049d99"],
Cell[225033, 4475, 495, 8, 28, "Output",ExpressionUUID->"a7f47651-4f05-4ff8-9754-bba86f10c2c6"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[225577, 4489, 471, 7, 48, "Subsection",ExpressionUUID->"a948f89c-ef54-4141-930e-1a782f187b02"],
Cell[CellGroupData[{
Cell[226073, 4500, 512, 8, 40, "Subsubsection",ExpressionUUID->"e7cbdf45-9871-4b0b-ac87-39bf68630323"],
Cell[226588, 4510, 327, 5, 45, "Text",ExpressionUUID->"9b7d7cc2-d37a-43a3-82bd-1e7a7ce6d6a0"],
Cell[CellGroupData[{
Cell[226940, 4519, 578, 13, 26, "Input",ExpressionUUID->"391527f5-6699-4455-96cf-80036240bb16"],
Cell[227521, 4534, 642, 12, 28, "Output",ExpressionUUID->"59ce32e9-3271-49c8-abc6-cde2c308ee13"]
}, Open  ]],
Cell[228178, 4549, 1817, 39, 43, "Input",ExpressionUUID->"6253273d-a597-4060-bc1d-634d4b92c680"],
Cell[CellGroupData[{
Cell[230020, 4592, 371, 11, 26, "Input",ExpressionUUID->"dc84f140-e8e9-4698-8b33-d22c2491c37e"],
Cell[230394, 4605, 515, 10, 28, "Output",ExpressionUUID->"3309fdcc-961e-470a-aaee-7593b317e7cf"]
}, Open  ]],
Cell[230924, 4618, 415, 6, 45, "Text",ExpressionUUID->"d40f0013-f039-48c8-b316-38d8209101f4"],
Cell[CellGroupData[{
Cell[231364, 4628, 2063, 54, 78, "Input",ExpressionUUID->"f5ccc907-b88b-4449-afa6-5df818ed4816"],
Cell[233430, 4684, 478, 9, 28, "Output",ExpressionUUID->"875c69fc-23bb-4bb7-afd5-13cf08abf12c"]
}, Open  ]],
Cell[CellGroupData[{
Cell[233945, 4698, 2115, 50, 43, "Input",ExpressionUUID->"95f0a05e-bb90-4d1e-b32d-823bcfb0e325"],
Cell[236063, 4750, 974, 15, 28, "Output",ExpressionUUID->"721e9c5f-97e7-4625-8ae7-7baec04567e3"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[237086, 4771, 513, 8, 40, "Subsubsection",ExpressionUUID->"60b58012-db57-45d3-a778-494c58ebb240"],
Cell[237602, 4781, 425, 6, 45, "Text",ExpressionUUID->"708c6bf5-2170-45e1-9bfc-d339e8e5202b"],
Cell[CellGroupData[{
Cell[238052, 4791, 715, 17, 26, "Input",ExpressionUUID->"c6bfa430-e0ea-4e4a-94e6-7157837c8dab"],
Cell[238770, 4810, 726, 14, 28, "Output",ExpressionUUID->"9c374b9e-9c11-4111-a437-fb5dd535e1d6"]
}, Open  ]],
Cell[239511, 4827, 1260, 33, 43, "Input",ExpressionUUID->"a1000cfa-af51-4f7a-9a97-dff7d42a9d1c"],
Cell[CellGroupData[{
Cell[240796, 4864, 584, 14, 26, "Input",ExpressionUUID->"ad81575a-72d0-4c19-8502-d2a83ffafc90"],
Cell[241383, 4880, 649, 13, 28, "Output",ExpressionUUID->"3f5dedd4-3329-499e-818f-7dc697580cf1"]
}, Open  ]],
Cell[242047, 4896, 425, 6, 45, "Text",ExpressionUUID->"6006fdfe-6455-40ab-b2f0-733b8e4e5b5d"],
Cell[CellGroupData[{
Cell[242497, 4906, 593, 12, 26, "Input",ExpressionUUID->"41f1f56d-9a58-46c7-ba52-497dacc93ee3"],
Cell[243093, 4920, 751, 14, 28, "Output",ExpressionUUID->"3e92a8ae-6a1b-41fe-9ee8-b2a3f1aeeada"]
}, Open  ]],
Cell[CellGroupData[{
Cell[243881, 4939, 2517, 63, 78, "Input",ExpressionUUID->"c19466c0-09e4-41d4-a5c6-f11830a37584"],
Cell[246401, 5004, 903, 16, 28, "Output",ExpressionUUID->"f258f34b-9201-4449-8756-b841d70727e3"]
}, Open  ]],
Cell[CellGroupData[{
Cell[247341, 5025, 2649, 66, 60, "Input",ExpressionUUID->"0257ed1b-3562-4a58-8bb0-abd08620c544"],
Cell[249993, 5093, 873, 16, 28, "Output",ExpressionUUID->"ec2018fa-625d-4e2e-b99f-080c868c040d"]
}, Open  ]],
Cell[CellGroupData[{
Cell[250903, 5114, 1708, 44, 26, "Input",ExpressionUUID->"b1649d24-a681-436b-80cb-b269159d86e2"],
Cell[252614, 5160, 751, 14, 28, "Output",ExpressionUUID->"0f588e58-680c-45fb-a242-fc39bd123e66"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

